/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.cluster;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.cluster.Receiver;
import org.cachebench.cluster.TcpTransport;
import org.cachebench.config.ClusterConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterBarrier
implements Receiver {
    private static Log log = LogFactory.getLog(ClusterBarrier.class);
    private ClusterConfig config;
    public final Map<SocketAddress, Object> receivedMessages = new HashMap<SocketAddress, Object>();
    private TcpTransport transport;
    private Object message;
    private int numMembers;
    private boolean acknowledge;
    private static final String ACK = "_ACK";
    private boolean failOnWrongMessaages;
    private String errorMessage;

    public Map<SocketAddress, Object> getReceivedMessages() {
        return this.receivedMessages;
    }

    public void setAcknowledge(boolean acknowledge) {
        this.acknowledge = acknowledge;
        this.failOnWrongMessaages = acknowledge;
    }

    public void barrier(Object message) throws Exception {
        log.trace((Object)("Started processing a message cluster, message='" + message + "'"));
        this.receivedMessages.clear();
        this.message = message;
        this.transport = new TcpTransport();
        this.numMembers = this.config.getClusterSize();
        this.transport.create(this.config);
        this.transport.setReceiver(this);
        this.transport.start();
        log.trace((Object)("Transport started, local address is: " + this.transport.getLocalAddress()));
        log.trace((Object)("Waiting for " + this.numMembers + " member(s) to join"));
        this.waitForAllMemebers();
        this.transport.stop();
        Thread.sleep(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAllMemebers() throws Exception {
        boolean receivedAllMessages = false;
        while (!receivedAllMessages) {
            Map<SocketAddress, Object> map = this.receivedMessages;
            synchronized (map) {
                boolean bl = receivedAllMessages = this.receivedMessages.size() >= this.numMembers;
                if (!receivedAllMessages) {
                    if (this.errorMessage != null) {
                        this.transport.send(this.message);
                        this.transport.stop();
                        Thread.sleep(2000L);
                        throw new IllegalStateException(this.errorMessage);
                    }
                    this.receivedMessages.wait(2000L);
                }
            }
            log.trace((Object)("sending message " + this.message + ", expecting " + this.getMissingMembersCount() + " member(s)"));
            this.transport.send(this.message);
            if (!this.acknowledge) continue;
            log.trace((Object)"Send ack also");
            this.transport.send(this.getAcknowledgeMessage(this.message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(SocketAddress sender, Object payload) throws Exception {
        log.trace((Object)("Received '" + payload + "' from " + this.formatName(sender) + " still expecting " + this.getMissingMembersCount() + " member(s)"));
        if (payload == null) {
            log.warn((Object)("payload is incorrect (sender=" + sender + "): " + payload));
            return;
        }
        if (this.acknowledge && !this.isAcknowledgeMessage(payload)) {
            log.trace((Object)("Sending ack, still expecting " + this.getMissingMembersCount() + " members."));
            this.transport.send(this.getAcknowledgeMessage(this.message));
            return;
        }
        if (this.failOnWrongMessaages && !this.message.equals(payload) && !this.getAcknowledgeMessage(this.message).equals(payload)) {
            this.errorMessage = "We recieved an message from a differenet barrier. This normally means that there is an stale barrier running somewhere.The source of the message is '" + sender + "', message is:'" + payload + "', " + "and we were expecting '" + this.message + "'";
            log.error((Object)this.errorMessage);
            this.receivedMessages.notifyAll();
        }
        Map<SocketAddress, Object> map = this.receivedMessages;
        synchronized (map) {
            if (!this.receivedMessages.containsKey(sender)) {
                this.receivedMessages.put(sender, this.getMessage(payload));
                int expected = this.getMissingMembersCount();
                log.trace((Object)("Sender " + sender + " registered, still waiting for " + expected + " member(s)"));
                this.receivedMessages.notifyAll();
            } else {
                log.trace((Object)("Sender '" + this.formatName(sender) + "' is already registered in the list of known senders!"));
            }
            log.trace((Object)("Current list of senders is: " + this.receivedMessages.keySet()));
        }
    }

    private String formatName(SocketAddress sender) {
        return this.transport.isLocal(sender) ? "<local(" + sender + ")>" : String.valueOf(sender);
    }

    private int getMissingMembersCount() {
        return this.numMembers - this.receivedMessages.size();
    }

    private Object getMessage(Object payload) {
        if (!this.acknowledge) {
            return payload;
        }
        String payloadStr = payload.toString();
        int endIndex = payloadStr.length() - ACK.length();
        return payloadStr.substring(0, endIndex);
    }

    private String getAcknowledgeMessage(Object message) {
        return message.toString() + ACK;
    }

    private boolean isAcknowledgeMessage(Object payload) {
        return payload == null ? false : payload.toString().indexOf(ACK) >= 0;
    }

    public void setConfig(ClusterConfig config) {
        this.config = config;
    }
}

