// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-api. DO NOT EDIT.

package registryv1alpha1api

import (
	context "context"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

// TokenService is the Token service.
type TokenService interface {
	// CreateToken creates a new token suitable for machine-to-machine authentication.
	CreateToken(
		ctx context.Context,
		note string,
		expireTime *timestamppb.Timestamp,
	) (token string, err error)
	// GetToken gets the specific token for the user
	//
	// This method requires authentication.
	GetToken(ctx context.Context, tokenId string) (token *v1alpha1.Token, err error)
	// ListTokens lists the users active tokens
	//
	// This method requires authentication.
	ListTokens(
		ctx context.Context,
		pageSize uint32,
		pageToken string,
		reverse bool,
	) (tokens []*v1alpha1.Token, nextPageToken string, err error)
	// DeleteToken deletes an existing token.
	//
	// This method requires authentication.
	DeleteToken(ctx context.Context, tokenId string) (err error)
}
