typedef struct {
  unsigned int lineno;
  unsigned int keycode;
  unsigned int modifier;
  int   type;		   // C - command type
  short type_modifier;	   // Key: 0 - keysym, 1 - scan code
  short target_selection;  // Select target window by:
                           //    0 - WM_CLASS, 1 - by Title, 2 - ID
  const char *command;     // Command or window
} CmdDescr; 

enum CommandType {
  CT_INTERNAL,
  CT_EXTAPP,
#ifdef PLUGIN_SUPPORT  
  CT_PLUGIN,
#endif  
  CT_KEYEVENT,
  CT_BTNEVENT,
  CT_DELETED=99
};


#define CommandTypeCount 4

enum SpecCodes {
    SPEC_WNDROTATE, 
    SPEC_WNDCLOSE, 
#ifdef PLUGIN_SUPPORT    
    SPEC_KILLPLUGIN,
#endif    
#ifdef OSD_SUPPORT
    SPEC_VERSION,
#endif
    SPEC_QUIT
};

#ifdef PLUGIN_SUPPORT  

// Returns 0-success, !=0 - error code
typedef void *PLUGIN_HANDLE;

typedef struct 
{
    unsigned int lineno;
    const char *name;
    const char *fullPath;
    const char *shortName;
    const char *initString;
    PLUGIN_HANDLE   handle;
    void	*buffer;
} PluginData;

#endif

void terminate();

// Spec func
//Bool InitSpecFunctions(char **errMsg);
//void DeinitSpecFunctions(void);
Bool ProcessExtApp(const char * command, int type_modifier);
int ProcessSpecFunction(int cmdIndex);

// Resources
Bool ProcessResources(const char *fileName, Bool getGlobal, int getFlags, char **errMsg);
Bool ProcessLogMode(const char *logString);
Bool UpdateResource(const char *fileName, int pos, char **errMsg);
void FreeResources(void);


// Key and button events
Bool ProcessWndKey(const char * command, short target_sel, short type_modif);
Bool ProcessWndButton(const char * command, short target_sel);


#ifdef PLUGIN_SUPPORT
// plugin_call.c
void InitPluginSupport(void);
Bool ProcessPlugin(int commandIndex);
Bool DiscontinuePlugin(Bool force);
void DeinitPluginSupport(void);
Bool CallPluginByName(int cmdIndex, char *pluginName,
     const char *cmdName,  char *cmdParm, int behaviour);

// resources.c
Bool UpdatePlugin(const char *fileName, int pos, char **errMsg);
#endif

#ifdef OSD_SUPPORT
// osd.c
// void InitOSD(void);
// Pixmap  GetOSDPluginPixmap();
void PrepareOSD(void);
Bool ShowOSDText(const char *text);
void InitOSD(int argc, char * argv[]);
void ProcessOSDExposeEvent(const XExposeEvent *evnt);
Bool ShowOSD(const char *text, int txtLen);
void DeinitOSD(void);
void HideOSD(void);
#endif

// xhkconf.c
void xhkc_terminate(void);

// xhkccodes.c
Bool showScanCodes(char **errMsg);
Bool showMouseEventInfos(char **errMsg);
short getScanCodeEvent(XEvent *xevPtr, unsigned int timeout, char **errMsg);
short getMouseEvent(XEvent *xevPtr, unsigned int timeout, char **errMsg);
short getMouseOrKeyEvent(XEvent *xevPtr, unsigned int timeout,
                        const char *keysAllowed, char *keyPressed,  char **errMsg);

// xhkccmds.c
Bool displayCommandByCode(unsigned int scanCode, unsigned int modif, char **errMsg);
Bool displayAllCommands(char **errMsg);
Bool displayCommand(char **errMsg);

Bool editCommandByCode(unsigned int scanCode, unsigned int modif, char **errMsg);
Bool editCommand(char **errMsg);
Bool deleteCommandByCode(unsigned int scanCode, unsigned int modif, char **errMsg);
Bool deleteCommand(char **errMsg);

void enterText(const char *prompt, char *answer, int len);
Bool YesNo(const char *question, Bool def_answer);

#ifdef PLUGIN_SUPPORT
Bool GetPluginInfoText(const PluginData *plData, char *text, int txtLength);

// xhkcplugins.c
Bool configurePlugins(char **errMsg);
Bool editPluginByName(const char *plName, char **errMsg);
#endif

// common.c

void log_message(Bool error, const char *msg);
typedef Bool (*LookupWindowHandler)(Window wnd, const void *par);
Window lookupWindow(Window cur, int dir, LookupWindowHandler handler, const void *par);
Window findWindowByWMClass(Window main_wnd, const char *app_name, const char *class_name);
Window findWindowByWMState(Window main_wnd, int dir, long state);
Window findVisibleWindow(Window main_wnd, int dir);
Window findClientWindow(Window main_wnd, int dir);
Window findWindowByTitle(Window main_wnd,  const char *title);
Window findWindowById(Window main_wnd, Window id);
int   countWindowsByWMClass(Window main_wnd, const char *app_name, const char *class_name);
Bool  GetWindowState(Window window, long *state);

short getMouseEvent(XEvent *xevPtr, unsigned int timeout, char **errMsg);

#ifndef HAVE_STRSEP
char *strsep(char **stringp, const char *delim);
#endif

#ifdef PLUGIN_SUPPORT
int FindPluginByLineNo(unsigned int lineNo);
int FindPluginByName(const char *pluginName);
Bool validatePlugin(const char *fileName, PLUGIN_HANDLE handle, char *msg, int msgLen);
Bool GetPluginOpnameInfo(const PluginData *plData,
                      const char *opName, int *opCodePtr, int *opFlagsPtr);
#endif
