#include <X11/Xlib.h>

#include "xhkeys_conf.h"

#ifdef PLUGIN_SUPPORT
#include <stdio.h>		// sprintf
#include <unistd.h>		// fork
#include <stdlib.h>		// strtol
#include <string.h>		// strcasecmp, etc
#include <signal.h>		// signal, SIGUSR1, etc
#include <dlfcn.h>		// dlsym
#include "xhkeys_plugin.h"
#include "xhkeys.h"


// xhkeys.c
extern void ClearTickTime(int index);
extern void SetTickTime(int index, unsigned long usecs_plus);

// resources.c
extern CmdDescr *Commands;
extern PluginData *Plugins;
extern int PluginCount;
extern unsigned long pluginTimeout;
extern int logMode;		// 0 - none, 1 - error, 2 - all
extern int logConsole;		// 1 force logging to console

#ifdef OSD_SUPPORT
extern void FillOSDPluginData(XHKEYS_PLUGIN_OSD_DATA *osdData);
extern Display *dpy;
extern int screenNo;
extern int osdEnabled;
extern unsigned long osdColour;
extern XRectangle osdRect;	
extern XFontStruct *osdFont;
extern GC osdGC;	
extern Pixmap osdBackupPix;
extern int osdAlignment;      // 0 - left, 1 - right, 2 - centre
#endif

static int continuousCmdIndex, continuousOpcode, continuousFlags;	
XHKEYS_PLUGIN_PROCESS *continuousProcessor;
static char *continuousParm;
static void *continuousBuffer;
static Bool pluginRunning;

void InitPluginSupport(void)
{
    int i;
    void *handle;
    void *buffer;

    XHKEYS_PLUGIN_PROPERTYEXCHANGER  *propExchanger;
#ifdef OSD_SUPPORT
    XHKEYS_PLUGIN_OSD_DATA osdData;
#endif
    continuousOpcode = continuousCmdIndex = -1;
    continuousProcessor = NULL;
    continuousBuffer = NULL;
    continuousParm = NULL;
    pluginRunning = False;
    
    for (i=0; i<PluginCount; i++)
    {
	handle = Plugins[i].handle;
	if (handle == NULL) continue;

	propExchanger = dlsym(handle, "property");
	if (propExchanger == NULL) continue;
	
	buffer = Plugins[i].buffer;

	(*propExchanger)(buffer, XHK_PLUGIN_APPVERSION, (int)VERSION);
	(*propExchanger)(buffer, XHK_PLUGIN_LOGMODE, (int) ((logConsole << 8) | logMode));

#ifdef OSD_SUPPORT
	FillOSDPluginData(&osdData);
	(*propExchanger)(buffer, XHK_PLUGIN_OSDDATA, &osdData, sizeof(osdData));
#endif	
    }

}



Bool RunPlugin(XHKEYS_PLUGIN_PROCESS *processor, void *buffer,
                int opcode, int opflags, const char *parm, int behaviour)
{
    Bool success = False;
    char message[81];
    int i = 20;

    while(--i>=0 && pluginRunning)
	usleep(300000);

    if (pluginRunning) 
	strcpy(message, "XHKEYS Plugin is Busy");
    else {	
//	int result;

        pluginRunning = True;

#ifdef OSD_SUPPORT	
//	PrepareOSD(opflags & XHKEYS_PLUGOPTYPE_DONT_ERASE);
	PrepareOSD();
#endif

	success = (*processor)(buffer, opcode, parm, behaviour, message, sizeof(message));
//	result = (*processor)(buffer, opcode, parm, behaviour, message, sizeof(message));
    
#ifdef OSD_SUPPORT
//	success = (result != XHKEYS_PLUGPROCRC_ERROR);
	i = 0;	// Text length

//	if (success == False || (result & XHKEYS_PLUGPROCRC_OSDTEXT) != 0)
	    i = strlen(message);

	// In case of success there might be graphics to draw
	if (success || i > 0) ShowOSD(message, i);
#endif	    
        pluginRunning = False;
    }
    	
    if (success == False) 
        log_message(True, message);
    
    return success;
}		



Bool DiscontinuePlugin(Bool force)
{
    if (continuousCmdIndex != -1 &&
	(RunPlugin(continuousProcessor, continuousBuffer, continuousOpcode,
	 continuousFlags, continuousParm, XHK_BEHAVIOUR_DISCONTINUE) || force)) {
	// Discontinue
        ClearTickTime(0);
	continuousOpcode = continuousCmdIndex = -1;
	continuousProcessor = NULL;
        continuousBuffer = NULL;
	if (continuousParm != NULL) {
	    free(continuousParm);
	    continuousParm = NULL;
	}    
	
	return True;
    }	
    
    return False;
}

static void StartContinuousPlugin(int cmdIndex,
        XHKEYS_PLUGIN_PROCESS *processor, void *buffer,
	int opcode, int flags, const char *parm)
{	    
    if (cmdIndex != continuousCmdIndex)
	 DiscontinuePlugin(True);

    continuousCmdIndex = cmdIndex;	
    continuousOpcode = opcode;	
    continuousProcessor = processor;
    continuousBuffer = buffer;
    continuousFlags = flags;

    if (parm != NULL) continuousParm = strdup(parm);
    SetTickTime(0, pluginTimeout * 1000);
}

void ProcessPluginTick(const struct timeval *curTime)
{
    if (continuousCmdIndex != -1 &&
	(pluginRunning || 
	 RunPlugin(continuousProcessor, continuousBuffer, 
	    continuousOpcode, continuousFlags,
	    continuousParm, XHK_BEHAVIOUR_REPEATED))) {
	SetTickTime(0, pluginTimeout * 1000);
    }	
}



void DeinitPluginSupport(void)
{
    DiscontinuePlugin(True);
}
    


Bool CallPluginByIndex(int cmdIndex, int pluginIndex,
                       const char *cmdOpName, char *cmdParm, int behaviour,
		       char *message, int msglen)
{
    PluginData *plData;
    PLUGIN_HANDLE handle;
//    XHKEYS_PLUGIN_GETOPCOUNT *getopcountPtr;
//    XHKEYS_PLUGIN_GETOPDATA *getopdataPtr;
    XHKEYS_PLUGIN_PROCESS *processorPtr;
    void *buffer;

    Bool success = False;
    int cmdCode, opflags;
//    int opcount;
    const char *pluginName;
    
    // Got plugin name - process plugin data
    message[0] = '\0';

    plData = Plugins+pluginIndex;
    pluginName = plData->name;	// Fore error messages in case of search by index

    handle = plData->handle;

    if (handle == NULL) {
        snprintf(message, msglen, "Cmdline %d: No plugin handle for '%s'\n", cmdIndex, pluginName);
	goto OutOfHere;
    }

    buffer = plData->buffer;

/*
    getopcountPtr = (XHKEYS_PLUGIN_GETOPCOUNT *) dlsym(handle, "getopcount");
    if (getopcountPtr == NULL) {
        snprintf(message, msglen, "Cmdline %d: Missing 'getopcount' in '%s'\n", cmdIndex, pluginName);
	goto OutOfHere;
    }

    getopdataPtr = (XHKEYS_PLUGIN_GETOPDATA *) dlsym(handle, "getopdata");
    if (getopdataPtr == NULL) {
        snprintf(message, msglen, "Cmdline %d: Missing 'getopdata' in '%s'\n", cmdIndex,  pluginName);
	goto OutOfHere;
    }



    opcount = (*getopcountPtr)(buffer);

    opflags = 0;

    for (cmdCode = 0; cmdCode < opcount; cmdCode++)
    {
	if ((*getopdataPtr)(buffer, cmdCode, message, &opflags) &&
	   strcmp(cmdOpName, message) == 0) break;
    }
    

    if(cmdCode >= opcount) {
*/
    
    if (GetPluginOpnameInfo(plData, cmdOpName, &cmdCode, &opflags) == False) {
	snprintf(message, msglen,
	        "Operation '%s' in invalid for '%s'\n", cmdOpName, pluginName);
	goto OutOfHere;
    }

    processorPtr = (XHKEYS_PLUGIN_PROCESS *) dlsym(handle, "process");
    if (processorPtr == NULL) {
        snprintf(message, msglen, "Cmdline %d: Missing 'process' in '%s'\n",  cmdIndex, pluginName);
	goto OutOfHere;
    }


    if ((opflags & 3) == XHKEYS_PLUGOPTYPE_PARMNONE)cmdParm = NULL;

    if (cmdParm == NULL)
    {
	if ((opflags & 3) == XHKEYS_PLUGOPTYPE_PARMREQUIRED) {
	    snprintf(message, msglen, "%s: operation %s requires a parameter",
	             pluginName, cmdOpName);
	    goto OutOfHere;
	}    
    }
    else
    {
	if ((opflags & XHKEYS_PLUGOPTYPE_PARMSPECCHARS) == 0) {
	    char *next;
	    cmdParm += strspn (cmdParm, " \t");
	    next = cmdParm;
	    strsep(&next, " \t#");
	}    

	if (*cmdParm == '\0') cmdParm = NULL;
    }       

    if ((opflags & XHKEYS_PLUGOPTYPE_CANCONTINUE) == 0)
	behaviour = XHK_BEHAVIOUR_ONCE;

    // Loggng is done inside call
    success = RunPlugin(processorPtr, buffer, cmdCode, opflags, cmdParm, behaviour);
    if (success && (behaviour == XHK_BEHAVIOUR_CONTINUOUS)) 
	    StartContinuousPlugin(cmdIndex, processorPtr, buffer, cmdCode, opflags, cmdParm);
    // Logging	 (if necessary is performed in RunPlugin)   
    *message = '\0';	    


OutOfHere:
    return success;
}
    	


Bool CallPluginByName(int cmdIndex, char *pluginName,
                      const char *cmdName,  char *cmdParm, int behaviour)
{
    Bool result = False;
    int ind = FindPluginByName(pluginName);

    if (ind >= 0) {
	char msg[81];
	result = CallPluginByIndex(cmdIndex, ind, cmdName, cmdParm, behaviour, msg, sizeof(msg));
	if (result == False) log_message(True, msg);
    }	
    
    return result;
}


Bool ProcessPlugin(int cmdIndex)
{
    char msg[81];
    char *cmdcopy, *strNext;
    char *pluginName=NULL;
    int pluginIndex;
    Bool success = False;
    int type_modif;
    int behaviour;

    if (cmdIndex == continuousCmdIndex && 
	(continuousFlags & XHKEYS_PLUGOPTYPE_PERSISTENT) != XHKEYS_PLUGOPTYPE_PERSISTENT &&    
	 DiscontinuePlugin(False)) {
#ifdef OSD_SUPPORT
	HideOSD();
#endif
	return True;
    }	

    type_modif =  Commands[cmdIndex].type_modifier;
    behaviour = Commands[cmdIndex].target_selection;

    strNext = cmdcopy = strdup(Commands[cmdIndex].command);
    if (cmdcopy == NULL) goto OutOfHere;

    pluginName = strsep(&strNext, "; ");
    if (pluginName == NULL) goto OutOfHere;  

    if (type_modif == 0) 
	// By name
	pluginIndex = FindPluginByName(pluginName);
    else {
	char *strSep;
	long pluginLine = strtol(pluginName, &strSep, 0);
	if (pluginLine <= 0 || *strSep != '\0') pluginIndex = -1;	
	else pluginIndex = FindPluginByLineNo((unsigned int)pluginLine);
    }	

    if (pluginIndex < 0) {
        snprintf(msg, sizeof(msg), "Invalid plugin %s: %s\n",
	      type_modif == 0 ? "name" : "order number",  pluginName);
        goto OutOfHere;
    }	    

    if (strNext != NULL) strNext += strspn(strNext, " \t");
    
    if (strNext == NULL || *strNext == '\0') {
        snprintf(msg, sizeof(msg), "Cmdline %d: missing command for '%s'\n",  cmdIndex, pluginName);
        goto OutOfHere;
    }

    pluginName = strsep(&strNext, " \t;.-");	
    pluginName += strspn(pluginName, " \t");

    // pluginName is cmdName, strNext is cmdParm
    success = CallPluginByIndex(cmdIndex, pluginIndex,
                pluginName, strNext, behaviour, msg, sizeof(msg));

OutOfHere:
    if (success == False) log_message(True, msg);
    if (cmdcopy) free(cmdcopy);    	
    return success;

}

#endif
