#include "license_pbs.h" /* See here for the software license */
/*
 *
 * qrerun - (PBS) rerun batch job
 *
 * Authors:
 *      Terry Heidelberg
 *      Livermore Computing
 *
 *      Bruce Kelly
 *      National Energy Research Supercomputer Center
 *
 *      Lawrence Livermore National Laboratory
 *      University of California
 */

#include <iostream>
#include "cmds.h"
#include "net_cache.h"
#include <pbs_config.h>   /* the master config generated by configure */
#include "lib_ifl.h"


int main(

  int    argc,
  char **argv) /* qrerun */

  {
  int any_failed = 0;

  char job_id[PBS_MAXCLTJOBID];       /* from the command line */

  char job_id_out[PBS_MAXCLTJOBID];
  char server_out[PBS_MAXSERVERNAME] = "";
  char rmt_server[MAXSERVERNAME];

  char extend[1024];

  int  errflg = 0;

  int c;

  static char usage[] = "usage: qrerun [-f] <JOBID>[ <JOBID>]...\n";

  if (argc < 2)
    {
    fprintf(stderr,"%s", usage);

    exit(2);
    }

#define GETOPT_ARGS "m:f"

  extend[0] = '\0';

  while ((c = (char) getopt(argc, argv, GETOPT_ARGS)) != EOF)
    {
    switch (c)
      {

      case 'm':

        /* add delete message */

        if (extend[0] != '\0')
          {
          /* extension option already specified */

          errflg++;

          break;
          }

        if (strchr(optarg, '='))
          {
          /* message cannot contain '=' character */

          errflg++;

          break;
          }

        snprintf(extend, sizeof(extend), "%s", optarg);

        break;

      case 'f':

        if (extend[0] != '\0')
          {
          errflg++;

          break;
          }

        strcpy(extend, RERUNFORCE);

        break;

      }  /* END switch (c) */
    }    /* END while ((c = getopt(argc,argv,GETOPT_ARGS)) != EOF) */

  if ((errflg != 0) || (optind >= argc))
    {
    fprintf(stderr,"%s", usage);

    exit(2);
    }

  for (;optind < argc;optind++)
    {
    int connect;
    int stat = 0;
    int located = FALSE;
    std::string server_name;
    std::vector<std::string> id_list;

    snprintf(job_id, sizeof(job_id), "%s", argv[optind]);

    if (!strcasecmp(job_id, "all"))
      {
      std::string confirmation;
      std::cout << "This will requeue all jobs without contact moms. Continue? (y/n)" << std::endl;
      std::cin >> confirmation;
      if ((confirmation.size() > 0) &&
          ((confirmation.c_str()[0] == 'y') ||
           (confirmation.c_str()[0] == 'Y')))
        std::cout << "Operation confirmed, continuing." << std::endl;
      else
        {
        std::cout << "Operation cancelled." << std::endl;
        continue;
        }
      }

    if (get_server_and_job_ids(job_id, id_list, server_name))
      {
      fprintf(stderr, "qrerun: illegally formed job identifier: %s\n",
              job_id);

      any_failed = 1;

      continue;
      }

    snprintf(server_out, sizeof(server_out), "%s", server_name.c_str());

cnt:

    connect = cnt2server(server_out, false);

    if (connect <= 0)
      {
      any_failed = -1 * connect;

      if (server_out[0] != 0)
        fprintf(stderr, "qrerun: cannot connect to server %s (errno=%d) %s\n",
              server_out,
              any_failed,
              pbs_strerror(any_failed));
      else
        fprintf(stderr, "qrerun: cannot connect to server %s (errno=%d) %s\n",
              pbs_server,
              any_failed,
              pbs_strerror(any_failed));


      continue;
      }

    for (size_t i = 0; i < id_list.size(); i++)
      {
      snprintf(job_id_out, sizeof(job_id_out), "%s", id_list[i].c_str());
    
      if (extend[0] != '\0')
        stat = pbs_rerunjob_err(connect, job_id_out, extend, &any_failed);
      else
        stat = pbs_rerunjob_err(connect, job_id_out, NULL, &any_failed);

      if (any_failed != PBSE_UNKJOBID)
        break;
      }

    if (stat && (any_failed != PBSE_UNKJOBID))
      {
      prt_job_err("qrerun", connect, job_id_out);
      }
    else if (stat && (any_failed == PBSE_UNKJOBID) && !located)
      {
      located = TRUE;

      if (locate_job(job_id_out, server_out, rmt_server))
        {
        pbs_disconnect(connect);

        snprintf(server_out, sizeof(server_out), "%s", rmt_server);

        goto cnt;
        }

      prt_job_err("qrerun", connect, job_id_out);
      }

    pbs_disconnect(connect);
    }

  exit(any_failed);
  }  /* END main() */

/* END qrerun.c */


