#include "license_pbs.h" /* See here for the software license */
/*
 * qorder - change the order of two batch jobs in a queue
 */

#include <string.h>
#include "cmds.h"
#include "net_connect.h"
#include "net_cache.h"
#include <pbs_config.h>   /* the master config generated by configure */
#include "lib_ifl.h"

int main(

  int    argc,   /* I */
  char **argv)   /* I */

  {
  char job_id1[PBS_MAXCLTJOBID+1];  /* from the command line */
  char job_id2[PBS_MAXCLTJOBID+1];  /* from the command line */
  char job_id1_out[PBS_MAXCLTJOBID+1];
  char job_id2_out[PBS_MAXCLTJOBID+1];
  char *pn;
  int  port1 = 0;
  int  port2 = 0;
  char server_out1[MAXSERVERNAME+1];
  char server_out2[MAXSERVERNAME+1];
  char svrtmp[MAXSERVERNAME+1] = "";
  int connect;
  int stat = 0;
  int rc = 0;
  int local_errno = 0;

  if (argc != 3)
    {
    static char usage[] = "usage: qorder job_identifier job_identifier\n";

    fprintf(stderr, "%s",
            usage);

    exit(2);
    }

  snprintf(job_id1, sizeof(job_id1), "%s", argv[1]);

  snprintf(job_id2, sizeof(job_id2), "%s", argv[2]);

  svrtmp[0] = '\0';

  if (get_server(job_id1, job_id1_out, sizeof(job_id1_out), svrtmp, sizeof(svrtmp)))
    {
    fprintf(stderr, "qorder: illegally formed job identifier: %s\n",
            job_id1);

    exit(1);
    }

  if (*svrtmp == '\0')
    {
    if ((pn = pbs_default()))
      {
      snprintf(svrtmp, sizeof(svrtmp), "%s", pn);
      }
    else
      {
      fprintf(stderr, "qorder: could not get default server: %s\n",
              job_id1);

      exit(1);
      }
    }

  if ((pn = strchr(svrtmp, (int)':')) != 0)
    {
    *pn = '\0';

    port1 = atoi(pn + 1);
    }

  if (get_fullhostname(svrtmp, server_out1, MAXSERVERNAME, NULL) != 0)
    {
    fprintf(stderr, "qorder: invalid server name: %s\n",
            job_id1);

    exit(1);
    }

  svrtmp[0] = '\0';

  if (get_server(job_id2, job_id2_out, sizeof(job_id2_out), svrtmp, sizeof(svrtmp)))
    {
    fprintf(stderr, "qorder: illegally formed job identifier: %s\n",
            job_id2);

    exit(1);
    }

  if (*svrtmp == '\0')
    {
    if ((pn = pbs_default()))
      {
      snprintf(svrtmp, sizeof(svrtmp), "%s", pn);
      }
    else
      {
      fprintf(stderr, "qorder: could not get default server: %s\n",
              job_id1);

      exit(1);
      }
    }

  if ((pn = strchr(svrtmp, (int)':')) != 0)
    {
    *pn = '\0';

    port2 = atoi(pn + 1);
    }

  if (get_fullhostname(svrtmp, server_out2, MAXSERVERNAME, NULL) != 0)
    {
    fprintf(stderr, "qorder: invalid server name: %s\n",
            job_id2);

    exit(1);
    }

  if ((strcmp(server_out1, server_out2) != 0) || (port1 != port2))
    {
    fprintf(stderr, "qorder: both jobs ids must specify the same server\n");

    exit(1);
    }

  if (pn != NULL)
    *pn = ':'; /* restore : if it was present */

  connect = cnt2server(svrtmp, false);

  if (connect <= 0)
    {
    local_errno = -1 * connect;

    if (svrtmp[0] != 0)
      fprintf(stderr, "qorder: cannot connect to server %s (errno=%d) %s\n",
            svrtmp,
            local_errno,
            pbs_strerror(local_errno));
    else
      fprintf(stderr, "qorder: cannot connect to server %s (errno=%d) %s\n",
            pbs_server,
            local_errno,
            pbs_strerror(local_errno));

    exit(1);
    }

  stat = pbs_orderjob_err(connect, job_id1_out, job_id2_out, NULL, &local_errno);

  if (stat != 0)
    {
    prt_job_err("qorder", connect, "");

    rc = local_errno;
    }

  pbs_disconnect(connect);

  exit(rc);
  }  /* END main() */

/* END qorder.c */

