/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.Scope;

public class Name
extends AstNode {
    private String identifier;
    private Scope scope;

    public Name() {
        this.type = 39;
    }

    public Name(int n) {
        super(n);
        this.type = 39;
    }

    public Name(int n, int n2) {
        super(n, n2);
        this.type = 39;
    }

    public Name(int n, int n2, String string) {
        super(n, n2);
        this.type = 39;
        this.setIdentifier(string);
    }

    public Name(int n, String string) {
        super(n);
        this.type = 39;
        this.setIdentifier(string);
        this.setLength(string.length());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.assertNotNull(string);
        this.identifier = string;
        this.setLength(string.length());
    }

    @Override
    public void setScope(Scope scope) {
        this.scope = scope;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    public Scope getDefiningScope() {
        Scope scope = this.getEnclosingScope();
        String string = this.getIdentifier();
        return scope == null ? null : scope.getDefiningScope(string);
    }

    public boolean isLocalName() {
        Scope scope = this.getDefiningScope();
        return scope != null && scope.getParentScope() != null;
    }

    public int length() {
        return this.identifier == null ? 0 : this.identifier.length();
    }

    @Override
    public String toSource(int n) {
        return this.makeIndent(n) + (this.identifier == null ? "<null>" : this.identifier);
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        nodeVisitor.visit(this);
    }
}

