/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class ExpressionStatement
extends AstNode {
    private AstNode expr;

    public void setHasResult() {
        this.type = 134;
    }

    public ExpressionStatement() {
        this.type = 133;
    }

    public ExpressionStatement(AstNode astNode, boolean bl) {
        this(astNode);
        if (bl) {
            this.setHasResult();
        }
    }

    public ExpressionStatement(AstNode astNode) {
        this(astNode.getPosition(), astNode.getLength(), astNode);
    }

    public ExpressionStatement(int n, int n2) {
        super(n, n2);
        this.type = 133;
    }

    public ExpressionStatement(int n, int n2, AstNode astNode) {
        super(n, n2);
        this.type = 133;
        this.setExpression(astNode);
    }

    public AstNode getExpression() {
        return this.expr;
    }

    public void setExpression(AstNode astNode) {
        this.assertNotNull(astNode);
        this.expr = astNode;
        astNode.setParent(this);
        this.setLineno(astNode.getLineno());
    }

    @Override
    public boolean hasSideEffects() {
        return this.type == 134 || this.expr.hasSideEffects();
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.expr.toSource(n));
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.expr.visit(nodeVisitor);
        }
    }
}

