/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.ScriptNode;

public class NodeTransformer {
    private ObjArray loops;
    private ObjArray loopEnds;
    private boolean hasFinally;

    public final void transform(ScriptNode scriptNode) {
        this.transformCompilationUnit(scriptNode);
        for (int i = 0; i != scriptNode.getFunctionCount(); ++i) {
            FunctionNode functionNode = scriptNode.getFunctionNode(i);
            this.transform(functionNode);
        }
    }

    private void transformCompilationUnit(ScriptNode scriptNode) {
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        this.hasFinally = false;
        boolean bl = scriptNode.getType() != 109 || ((FunctionNode)scriptNode).requiresActivation();
        scriptNode.flattenSymbolTable(!bl);
        boolean bl2 = scriptNode instanceof AstRoot && ((AstRoot)scriptNode).isInStrictMode();
        this.transformCompilationUnit_r(scriptNode, scriptNode, scriptNode, bl, bl2);
    }

    private void transformCompilationUnit_r(ScriptNode scriptNode, Node node, Scope scope, boolean bl, boolean bl2) {
        Node node2 = null;
        block17: while (true) {
            Object object;
            Node node3;
            Object object2;
            Object object3;
            Node node4 = null;
            if (node2 == null) {
                node2 = node.getFirstChild();
            } else {
                node4 = node2;
                node2 = node2.getNext();
            }
            if (node2 == null) break;
            int n = node2.getType();
            if (bl && (n == 129 || n == 132 || n == 157) && node2 instanceof Scope && ((Scope)(object3 = (Scope)node2)).getSymbolTable() != null) {
                object2 = new Node(n == 157 ? 158 : 153);
                node3 = new Node(153);
                ((Node)object2).addChildToBack(node3);
                for (String string : ((Scope)object3).getSymbolTable().keySet()) {
                    node3.addChildToBack(Node.newString(39, string));
                }
                ((Scope)object3).setSymbolTable(null);
                object = node2;
                node2 = NodeTransformer.replaceCurrent(node, node4, node2, (Node)object2);
                n = node2.getType();
                ((Node)object2).addChildToBack((Node)object);
            }
            switch (n) {
                case 114: 
                case 130: 
                case 132: {
                    this.loops.push(node2);
                    this.loopEnds.push(((Jump)node2).target);
                    break;
                }
                case 123: {
                    this.loops.push(node2);
                    object3 = node2.getNext();
                    if (((Node)object3).getType() != 3) {
                        Kit.codeBug();
                    }
                    this.loopEnds.push(object3);
                    break;
                }
                case 81: {
                    object3 = (Jump)node2;
                    object2 = ((Jump)object3).getFinally();
                    if (object2 == null) break;
                    this.hasFinally = true;
                    this.loops.push(node2);
                    this.loopEnds.push(object2);
                    break;
                }
                case 3: 
                case 131: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node2) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 72: {
                    ((FunctionNode)scriptNode).addResumptionPoint(node2);
                    break;
                }
                case 4: {
                    Node node5;
                    Jump jump;
                    boolean bl3;
                    boolean bl4 = bl3 = scriptNode.getType() == 109 && ((FunctionNode)scriptNode).isGenerator();
                    if (bl3) {
                        node2.putIntProp(20, 1);
                    }
                    if (!this.hasFinally) break;
                    object2 = null;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        object = (Node)this.loops.get(i);
                        int n2 = ((Node)object).getType();
                        if (n2 != 81 && n2 != 123) continue;
                        if (n2 == 81) {
                            Node node6;
                            jump = new Jump(135);
                            jump.target = node6 = ((Jump)object).getFinally();
                            node5 = jump;
                        } else {
                            node5 = new Node(3);
                        }
                        if (object2 == null) {
                            object2 = new Node(129, node2.getLineno());
                        }
                        ((Node)object2).addChildToBack(node5);
                    }
                    if (object2 == null) break;
                    Node node7 = node2;
                    object = node7.getFirstChild();
                    node2 = NodeTransformer.replaceCurrent(node, node4, node2, (Node)object2);
                    if (object == null || bl3) {
                        ((Node)object2).addChildToBack(node7);
                        continue block17;
                    }
                    Node node8 = new Node(134, (Node)object);
                    ((Node)object2).addChildToFront(node8);
                    node7 = new Node(64);
                    ((Node)object2).addChildToBack(node7);
                    this.transformCompilationUnit_r(scriptNode, node8, scope, bl, bl2);
                    continue block17;
                }
                case 120: 
                case 121: {
                    Node node5;
                    Jump jump;
                    object3 = (Jump)node2;
                    object2 = ((Jump)object3).getJumpStatement();
                    if (object2 == null) {
                        Kit.codeBug();
                    }
                    int n3 = this.loops.size();
                    while (true) {
                        if (n3 == 0) {
                            throw Kit.codeBug();
                        }
                        if ((object = (Node)this.loops.get(--n3)) == object2) break;
                        int n4 = ((Node)object).getType();
                        if (n4 == 123) {
                            node5 = new Node(3);
                            node4 = NodeTransformer.addBeforeCurrent(node, node4, node2, node5);
                            continue;
                        }
                        if (n4 != 81) continue;
                        node5 = (Jump)object;
                        jump = new Jump(135);
                        jump.target = ((Jump)node5).getFinally();
                        node4 = NodeTransformer.addBeforeCurrent(node, node4, node2, jump);
                    }
                    ((Jump)object3).target = n == 120 ? ((Jump)object2).target : ((Jump)object2).getContinue();
                    ((Node)object3).setType(5);
                    break;
                }
                case 38: {
                    this.visitCall(node2, scriptNode);
                    break;
                }
                case 30: {
                    this.visitNew(node2, scriptNode);
                    break;
                }
                case 153: 
                case 158: {
                    object3 = node2.getFirstChild();
                    if (((Node)object3).getType() == 153) {
                        boolean bl5 = scriptNode.getType() != 109 || ((FunctionNode)scriptNode).requiresActivation();
                        node2 = this.visitLet(bl5, node, node4, node2);
                        break;
                    }
                }
                case 122: 
                case 154: {
                    object3 = new Node(129);
                    object2 = node2.getFirstChild();
                    while (object2 != null) {
                        node3 = object2;
                        object2 = ((Node)object2).getNext();
                        if (node3.getType() == 39) {
                            if (!node3.hasChildren()) continue;
                            object = node3.getFirstChild();
                            node3.removeChild((Node)object);
                            node3.setType(49);
                            node3 = new Node(n == 154 ? 155 : 8, node3, (Node)object);
                        } else if (node3.getType() != 158) {
                            throw Kit.codeBug();
                        }
                        object = new Node(133, node3, node2.getLineno());
                        ((Node)object3).addChildToBack((Node)object);
                    }
                    node2 = NodeTransformer.replaceCurrent(node, node4, node2, (Node)object3);
                    break;
                }
                case 137: {
                    object3 = scope.getDefiningScope(node2.getString());
                    if (object3 == null) break;
                    node2.setScope((Scope)object3);
                    break;
                }
                case 7: 
                case 32: {
                    object3 = node2.getFirstChild();
                    if (n == 7) {
                        while (((Node)object3).getType() == 26) {
                            object3 = ((Node)object3).getFirstChild();
                        }
                        if (((Node)object3).getType() == 12 || ((Node)object3).getType() == 13) {
                            object2 = ((Node)object3).getFirstChild();
                            node3 = ((Node)object3).getLastChild();
                            if (((Node)object2).getType() == 39 && ((Node)object2).getString().equals("undefined")) {
                                object3 = node3;
                            } else if (node3.getType() == 39 && node3.getString().equals("undefined")) {
                                object3 = object2;
                            }
                        }
                    }
                    if (((Node)object3).getType() != 33) break;
                    ((Node)object3).setType(34);
                    break;
                }
                case 8: {
                    if (bl2) {
                        node2.setType(73);
                    }
                }
                case 31: 
                case 39: 
                case 155: {
                    if (bl) break;
                    if (n == 39) {
                        object3 = node2;
                    } else {
                        object3 = node2.getFirstChild();
                        if (((Node)object3).getType() != 49) {
                            if (n == 31) break;
                            throw Kit.codeBug();
                        }
                    }
                    if (((Node)object3).getScope() != null || (node3 = scope.getDefiningScope((String)(object2 = ((Node)object3).getString()))) == null) break;
                    ((Node)object3).setScope((Scope)node3);
                    if (n == 39) {
                        node2.setType(55);
                        break;
                    }
                    if (n == 8 || n == 73) {
                        node2.setType(56);
                        ((Node)object3).setType(41);
                        break;
                    }
                    if (n == 155) {
                        node2.setType(156);
                        ((Node)object3).setType(41);
                        break;
                    }
                    if (n == 31) {
                        object = new Node(44);
                        node2 = NodeTransformer.replaceCurrent(node, node4, node2, (Node)object);
                        break;
                    }
                    throw Kit.codeBug();
                }
            }
            this.transformCompilationUnit_r(scriptNode, node2, node2 instanceof Scope ? (Scope)node2 : scope, bl, bl2);
        }
    }

    protected void visitNew(Node node, ScriptNode scriptNode) {
    }

    protected void visitCall(Node node, ScriptNode scriptNode) {
    }

    protected Node visitLet(boolean bl, Node node, Node node2, Node node3) {
        Node node4;
        boolean bl2;
        Node node5 = node3.getFirstChild();
        Node node6 = node5.getNext();
        node3.removeChild(node5);
        node3.removeChild(node6);
        boolean bl3 = bl2 = node3.getType() == 158;
        if (bl) {
            node4 = new Node(bl2 ? 159 : 129);
            node4 = NodeTransformer.replaceCurrent(node, node2, node3, node4);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Node node7 = new Node(66);
            for (Node node8 = node5.getFirstChild(); node8 != null; node8 = node8.getNext()) {
                Iterable iterable;
                Node node9 = node8;
                if (node9.getType() == 158) {
                    iterable = (List)node9.getProp(22);
                    Node node10 = node9.getFirstChild();
                    if (node10.getType() != 153) {
                        throw Kit.codeBug();
                    }
                    node6 = bl2 ? new Node(89, node10.getNext(), node6) : new Node(129, new Node(133, node10.getNext()), node6);
                    if (iterable != null) {
                        arrayList.addAll((Collection<Object>)iterable);
                        for (int i = 0; i < iterable.size(); ++i) {
                            node7.addChildToBack(new Node(126, Node.newNumber(0.0)));
                        }
                    }
                    node9 = node10.getFirstChild();
                }
                if (node9.getType() != 39) {
                    throw Kit.codeBug();
                }
                arrayList.add(ScriptRuntime.getIndexObject(node9.getString()));
                iterable = node9.getFirstChild();
                if (iterable == null) {
                    iterable = new Node(126, Node.newNumber(0.0));
                }
                node7.addChildToBack((Node)iterable);
            }
            node7.putProp(12, arrayList.toArray());
            Node node11 = new Node(2, node7);
            node4.addChildToBack(node11);
            node4.addChildToBack(new Node(123, node6));
            node4.addChildToBack(new Node(3));
        } else {
            Node node12;
            node4 = new Node(bl2 ? 89 : 129);
            node4 = NodeTransformer.replaceCurrent(node, node2, node3, node4);
            Node node13 = new Node(89);
            for (node12 = node5.getFirstChild(); node12 != null; node12 = node12.getNext()) {
                Node node14;
                Node node15 = node12;
                if (node15.getType() == 158) {
                    node14 = node15.getFirstChild();
                    if (node14.getType() != 153) {
                        throw Kit.codeBug();
                    }
                    node6 = bl2 ? new Node(89, node14.getNext(), node6) : new Node(129, new Node(133, node14.getNext()), node6);
                    Scope.joinScopes((Scope)node15, (Scope)node3);
                    node15 = node14.getFirstChild();
                }
                if (node15.getType() != 39) {
                    throw Kit.codeBug();
                }
                node14 = Node.newString(node15.getString());
                node14.setScope((Scope)node3);
                Node node16 = node15.getFirstChild();
                if (node16 == null) {
                    node16 = new Node(126, Node.newNumber(0.0));
                }
                node13.addChildToBack(new Node(56, node14, node16));
            }
            if (bl2) {
                node4.addChildToBack(node13);
                node3.setType(89);
                node4.addChildToBack(node3);
                node3.addChildToBack(node6);
                if (node6 instanceof Scope) {
                    node12 = ((Scope)node6).getParentScope();
                    ((Scope)node6).setParentScope((Scope)node3);
                    ((Scope)node3).setParentScope((Scope)node12);
                }
            } else {
                node4.addChildToBack(new Node(133, node13));
                node3.setType(129);
                node4.addChildToBack(node3);
                node3.addChildrenToBack(node6);
                if (node6 instanceof Scope) {
                    node12 = ((Scope)node6).getParentScope();
                    ((Scope)node6).setParentScope((Scope)node3);
                    ((Scope)node3).setParentScope((Scope)node12);
                }
            }
        }
        return node4;
    }

    private static Node addBeforeCurrent(Node node, Node node2, Node node3, Node node4) {
        if (node2 == null) {
            if (node3 != node.getFirstChild()) {
                Kit.codeBug();
            }
            node.addChildToFront(node4);
        } else {
            if (node3 != node2.getNext()) {
                Kit.codeBug();
            }
            node.addChildAfter(node4, node2);
        }
        return node4;
    }

    private static Node replaceCurrent(Node node, Node node2, Node node3, Node node4) {
        if (node2 == null) {
            if (node3 != node.getFirstChild()) {
                Kit.codeBug();
            }
            node.replaceChild(node3, node4);
        } else if (node2.next == node3) {
            node.replaceChildAfter(node2, node4);
        } else {
            node.replaceChild(node3, node4);
        }
        return node4;
    }
}

