/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xml.XMLLib;

public class NativeGlobal
implements Serializable,
IdFunctionCall {
    static final long serialVersionUID = 6080442165748707530L;
    private static final String URI_DECODE_RESERVED = ";/?:@&=+$,#";
    private static final int INVALID_UTF8 = Integer.MAX_VALUE;
    private static final Object FTAG = "Global";
    private static final int Id_decodeURI = 1;
    private static final int Id_decodeURIComponent = 2;
    private static final int Id_encodeURI = 3;
    private static final int Id_encodeURIComponent = 4;
    private static final int Id_escape = 5;
    private static final int Id_eval = 6;
    private static final int Id_isFinite = 7;
    private static final int Id_isNaN = 8;
    private static final int Id_isXMLName = 9;
    private static final int Id_parseFloat = 10;
    private static final int Id_parseInt = 11;
    private static final int Id_unescape = 12;
    private static final int Id_uneval = 13;
    private static final int LAST_SCOPE_FUNCTION_ID = 13;
    private static final int Id_new_CommonError = 14;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeGlobal nativeGlobal = new NativeGlobal();
        for (int i = 1; i <= 13; ++i) {
            String string;
            int n = 1;
            switch (i) {
                case 1: {
                    string = "decodeURI";
                    break;
                }
                case 2: {
                    string = "decodeURIComponent";
                    break;
                }
                case 3: {
                    string = "encodeURI";
                    break;
                }
                case 4: {
                    string = "encodeURIComponent";
                    break;
                }
                case 5: {
                    string = "escape";
                    break;
                }
                case 6: {
                    string = "eval";
                    break;
                }
                case 7: {
                    string = "isFinite";
                    break;
                }
                case 8: {
                    string = "isNaN";
                    break;
                }
                case 9: {
                    string = "isXMLName";
                    break;
                }
                case 10: {
                    string = "parseFloat";
                    break;
                }
                case 11: {
                    string = "parseInt";
                    n = 2;
                    break;
                }
                case 12: {
                    string = "unescape";
                    break;
                }
                case 13: {
                    string = "uneval";
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            IdFunctionObject object = new IdFunctionObject(nativeGlobal, FTAG, i, string, n, scriptable);
            if (bl) {
                object.sealObject();
            }
            object.exportAsScopeProperty();
        }
        ScriptableObject.defineProperty(scriptable, "NaN", ScriptRuntime.NaNobj, 7);
        ScriptableObject.defineProperty(scriptable, "Infinity", ScriptRuntime.wrapNumber(Double.POSITIVE_INFINITY), 7);
        ScriptableObject.defineProperty(scriptable, "undefined", Undefined.instance, 7);
        for (TopLevel.NativeErrors nativeErrors : TopLevel.NativeErrors.values()) {
            if (nativeErrors == TopLevel.NativeErrors.Error) continue;
            String string = nativeErrors.name();
            ScriptableObject scriptableObject = (ScriptableObject)ScriptRuntime.newBuiltinObject(context, scriptable, TopLevel.Builtins.Error, ScriptRuntime.emptyArgs);
            scriptableObject.put("name", (Scriptable)scriptableObject, (Object)string);
            scriptableObject.put("message", (Scriptable)scriptableObject, (Object)"");
            IdFunctionObject idFunctionObject = new IdFunctionObject(nativeGlobal, FTAG, 14, string, 1, scriptable);
            idFunctionObject.markAsConstructor(scriptableObject);
            scriptableObject.put("constructor", (Scriptable)scriptableObject, (Object)idFunctionObject);
            scriptableObject.setAttributes("constructor", 2);
            if (bl) {
                scriptableObject.sealObject();
                idFunctionObject.sealObject();
            }
            idFunctionObject.exportAsScopeProperty();
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (idFunctionObject.hasTag(FTAG)) {
            int n = idFunctionObject.methodId();
            switch (n) {
                case 1: 
                case 2: {
                    String string = ScriptRuntime.toString(objectArray, 0);
                    return NativeGlobal.decode(string, n == 1);
                }
                case 3: 
                case 4: {
                    String string = ScriptRuntime.toString(objectArray, 0);
                    return NativeGlobal.encode(string, n == 3);
                }
                case 5: {
                    return this.js_escape(objectArray);
                }
                case 6: {
                    return this.js_eval(context, scriptable, objectArray);
                }
                case 7: {
                    if (objectArray.length < 1) {
                        return Boolean.FALSE;
                    }
                    return NativeNumber.isFinite(objectArray[0]);
                }
                case 8: {
                    double d;
                    boolean bl = objectArray.length < 1 ? true : (d = ScriptRuntime.toNumber(objectArray[0])) != d;
                    return ScriptRuntime.wrapBoolean(bl);
                }
                case 9: {
                    Object object = objectArray.length == 0 ? Undefined.instance : objectArray[0];
                    XMLLib xMLLib = XMLLib.extractFromScope(scriptable);
                    return ScriptRuntime.wrapBoolean(xMLLib.isXMLName(context, object));
                }
                case 10: {
                    return NativeGlobal.js_parseFloat(objectArray);
                }
                case 11: {
                    return NativeGlobal.js_parseInt(objectArray);
                }
                case 12: {
                    return this.js_unescape(objectArray);
                }
                case 13: {
                    Object object = objectArray.length != 0 ? objectArray[0] : Undefined.instance;
                    return ScriptRuntime.uneval(context, scriptable, object);
                }
                case 14: {
                    return NativeError.make(context, scriptable, idFunctionObject, objectArray);
                }
            }
        }
        throw idFunctionObject.unknown();
    }

    static Object js_parseInt(Object[] objectArray) {
        char c;
        String string = ScriptRuntime.toString(objectArray, 0);
        int n = ScriptRuntime.toInt32(objectArray, 1);
        int n2 = string.length();
        if (n2 == 0) {
            return ScriptRuntime.NaNobj;
        }
        boolean bl = false;
        int n3 = 0;
        while (ScriptRuntime.isStrWhiteSpaceChar(c = string.charAt(n3)) && ++n3 < n2) {
        }
        if (c == '+' || (bl = c == '-')) {
            ++n3;
        }
        int n4 = -1;
        if (n == 0) {
            n = -1;
        } else {
            if (n < 2 || n > 36) {
                return ScriptRuntime.NaNobj;
            }
            if (n == 16 && n2 - n3 > 1 && string.charAt(n3) == '0' && ((c = string.charAt(n3 + 1)) == 'x' || c == 'X')) {
                n3 += 2;
            }
        }
        if (n == -1) {
            n = 10;
            if (n2 - n3 > 1 && string.charAt(n3) == '0') {
                c = string.charAt(n3 + 1);
                if (c == 'x' || c == 'X') {
                    n = 16;
                    n3 += 2;
                } else if ('0' <= c && c <= '9') {
                    n = 8;
                    ++n3;
                }
            }
        }
        double d = ScriptRuntime.stringToNumber(string, n3, n);
        return ScriptRuntime.wrapNumber(bl ? -d : d);
    }

    static Object js_parseFloat(Object[] objectArray) {
        char c;
        if (objectArray.length < 1) {
            return ScriptRuntime.NaNobj;
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        int n = string.length();
        int n2 = 0;
        while (true) {
            if (n2 == n) {
                return ScriptRuntime.NaNobj;
            }
            c = string.charAt(n2);
            if (!ScriptRuntime.isStrWhiteSpaceChar(c)) break;
            ++n2;
        }
        int n3 = n2;
        if (c == '+' || c == '-') {
            if (++n3 == n) {
                return ScriptRuntime.NaNobj;
            }
            c = string.charAt(n3);
        }
        if (c == 'I') {
            if (n3 + 8 <= n && string.regionMatches(n3, "Infinity", 0, 8)) {
                double d = string.charAt(n2) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                return ScriptRuntime.wrapNumber(d);
            }
            return ScriptRuntime.NaNobj;
        }
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        block9: while (n3 < n) {
            switch (string.charAt(n3)) {
                case '.': {
                    if (n4 != -1) break block9;
                    n4 = n3;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (n5 != -1 || n3 == n - 1) break block9;
                    n5 = n3;
                    break;
                }
                case '+': 
                case '-': {
                    if (n5 != n3 - 1) break block9;
                    if (n3 != n - 1) break;
                    --n3;
                    break block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (n5 == -1) break;
                    bl = true;
                    break;
                }
                default: {
                    break block9;
                }
            }
            ++n3;
        }
        if (n5 != -1 && !bl) {
            n3 = n5;
        }
        string = string.substring(n2, n3);
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return ScriptRuntime.NaNobj;
        }
    }

    private Object js_escape(Object[] objectArray) {
        double d;
        boolean bl = true;
        int n = 2;
        int n2 = 4;
        String string = ScriptRuntime.toString(objectArray, 0);
        int n3 = 7;
        if (objectArray.length > 1 && ((d = ScriptRuntime.toNumber(objectArray[1])) != d || (double)(n3 = (int)d) != d || 0 != (n3 & 0xFFFFFFF8))) {
            throw Context.reportRuntimeError0("msg.bad.esc.mask");
        }
        StringBuilder stringBuilder = null;
        int n4 = string.length();
        for (int i = 0; i != n4; ++i) {
            int n5;
            char c = string.charAt(i);
            if (n3 != 0 && (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '@' || c == '*' || c == '_' || c == '-' || c == '.' || 0 != (n3 & 4) && (c == '/' || c == '+'))) {
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(n4 + 3);
                stringBuilder.append(string);
                stringBuilder.setLength(i);
            }
            if (c < '\u0100') {
                if (c == ' ' && n3 == 2) {
                    stringBuilder.append('+');
                    continue;
                }
                stringBuilder.append('%');
                n5 = 2;
            } else {
                stringBuilder.append('%');
                stringBuilder.append('u');
                n5 = 4;
            }
            for (int j = (n5 - 1) * 4; j >= 0; j -= 4) {
                int n6 = 0xF & c >> j;
                int n7 = n6 < 10 ? 48 + n6 : 55 + n6;
                stringBuilder.append((char)n7);
            }
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    private Object js_unescape(Object[] objectArray) {
        String string = ScriptRuntime.toString(objectArray, 0);
        int n = string.indexOf(37);
        if (n >= 0) {
            int n2 = string.length();
            char[] cArray = string.toCharArray();
            int n3 = n;
            int n4 = n;
            while (n4 != n2) {
                char c = cArray[n4];
                if (c == '%' && ++n4 != n2) {
                    int n5;
                    int n6;
                    if (cArray[n4] == 'u') {
                        n6 = n4 + 1;
                        n5 = n4 + 5;
                    } else {
                        n6 = n4;
                        n5 = n4 + 2;
                    }
                    if (n5 <= n2) {
                        int n7 = 0;
                        for (int i = n6; i != n5; ++i) {
                            n7 = Kit.xDigitToInt(cArray[i], n7);
                        }
                        if (n7 >= 0) {
                            c = (char)n7;
                            n4 = n5;
                        }
                    }
                }
                cArray[n3] = c;
                ++n3;
            }
            string = new String(cArray, 0, n3);
        }
        return string;
    }

    private Object js_eval(Context context, Scriptable scriptable, Object[] objectArray) {
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        return ScriptRuntime.evalSpecial(context, scriptable2, scriptable2, objectArray, "eval code", 1);
    }

    static boolean isEvalFunction(Object object) {
        IdFunctionObject idFunctionObject;
        return object instanceof IdFunctionObject && (idFunctionObject = (IdFunctionObject)object).hasTag(FTAG) && idFunctionObject.methodId() == 6;
    }

    @Deprecated
    public static EcmaError constructError(Context context, String string, String string2, Scriptable scriptable) {
        return ScriptRuntime.constructError(string, string2);
    }

    @Deprecated
    public static EcmaError constructError(Context context, String string, String string2, Scriptable scriptable, String string3, int n, int n2, String string4) {
        return ScriptRuntime.constructError(string, string2, string3, n, string4, n2);
    }

    private static String encode(String string, boolean bl) {
        byte[] byArray = null;
        StringBuilder stringBuilder = null;
        int n = string.length();
        for (int i = 0; i != n; ++i) {
            int n2;
            int n3;
            int n4 = string.charAt(i);
            if (NativeGlobal.encodeUnescaped((char)n4, bl)) {
                if (stringBuilder == null) continue;
                stringBuilder.append((char)n4);
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(n + 3);
                stringBuilder.append(string);
                stringBuilder.setLength(i);
                byArray = new byte[6];
            }
            if (56320 <= n4 && n4 <= 57343) {
                throw NativeGlobal.uriError();
            }
            if (n4 < 55296 || 56319 < n4) {
                n3 = n4;
            } else {
                if (++i == n) {
                    throw NativeGlobal.uriError();
                }
                n2 = string.charAt(i);
                if (56320 > n2 || n2 > 57343) {
                    throw NativeGlobal.uriError();
                }
                n3 = (n4 - 55296 << 10) + (n2 - 56320) + 65536;
            }
            n2 = NativeGlobal.oneUcs4ToUtf8Char(byArray, n3);
            for (int j = 0; j < n2; ++j) {
                int n5 = 0xFF & byArray[j];
                stringBuilder.append('%');
                stringBuilder.append(NativeGlobal.toHexChar(n5 >>> 4));
                stringBuilder.append(NativeGlobal.toHexChar(n5 & 0xF));
            }
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    private static char toHexChar(int n) {
        if (n >> 4 != 0) {
            Kit.codeBug();
        }
        return (char)(n < 10 ? n + 48 : n - 10 + 65);
    }

    private static int unHex(char c) {
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return -1;
    }

    private static int unHex(char c, char c2) {
        int n = NativeGlobal.unHex(c);
        int n2 = NativeGlobal.unHex(c2);
        if (n >= 0 && n2 >= 0) {
            return n << 4 | n2;
        }
        return -1;
    }

    private static String decode(String string, boolean bl) {
        char[] cArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 != n3) {
            int n4;
            char c = string.charAt(n2);
            if (c != '%') {
                if (cArray != null) {
                    cArray[n++] = c;
                }
                ++n2;
                continue;
            }
            if (cArray == null) {
                cArray = new char[n3];
                string.getChars(0, n2, cArray, 0);
                n = n2;
            }
            int n5 = n2;
            if (n2 + 3 > n3) {
                throw NativeGlobal.uriError();
            }
            int n6 = NativeGlobal.unHex(string.charAt(n2 + 1), string.charAt(n2 + 2));
            if (n6 < 0) {
                throw NativeGlobal.uriError();
            }
            n2 += 3;
            if ((n6 & 0x80) == 0) {
                c = (char)n6;
            } else {
                int n7;
                int n8;
                int n9;
                if ((n6 & 0xC0) == 128) {
                    throw NativeGlobal.uriError();
                }
                if ((n6 & 0x20) == 0) {
                    n4 = 1;
                    n9 = n6 & 0x1F;
                    n8 = 128;
                } else if ((n6 & 0x10) == 0) {
                    n4 = 2;
                    n9 = n6 & 0xF;
                    n8 = 2048;
                } else if ((n6 & 8) == 0) {
                    n4 = 3;
                    n9 = n6 & 7;
                    n8 = 65536;
                } else if ((n6 & 4) == 0) {
                    n4 = 4;
                    n9 = n6 & 3;
                    n8 = 0x200000;
                } else if ((n6 & 2) == 0) {
                    n4 = 5;
                    n9 = n6 & 1;
                    n8 = 0x4000000;
                } else {
                    throw NativeGlobal.uriError();
                }
                if (n2 + 3 * n4 > n3) {
                    throw NativeGlobal.uriError();
                }
                for (n7 = 0; n7 != n4; ++n7) {
                    if (string.charAt(n2) != '%') {
                        throw NativeGlobal.uriError();
                    }
                    n6 = NativeGlobal.unHex(string.charAt(n2 + 1), string.charAt(n2 + 2));
                    if (n6 < 0 || (n6 & 0xC0) != 128) {
                        throw NativeGlobal.uriError();
                    }
                    n9 = n9 << 6 | n6 & 0x3F;
                    n2 += 3;
                }
                if (n9 < n8 || n9 >= 55296 && n9 <= 57343) {
                    n9 = Integer.MAX_VALUE;
                } else if (n9 == 65534 || n9 == 65535) {
                    n9 = 65533;
                }
                if (n9 >= 65536) {
                    if ((n9 -= 65536) > 1048575) {
                        throw NativeGlobal.uriError();
                    }
                    n7 = (char)((n9 >>> 10) + 55296);
                    c = (char)((n9 & 0x3FF) + 56320);
                    cArray[n++] = n7;
                } else {
                    c = (char)n9;
                }
            }
            if (bl && URI_DECODE_RESERVED.indexOf(c) >= 0) {
                for (n4 = n5; n4 != n2; ++n4) {
                    cArray[n++] = string.charAt(n4);
                }
                continue;
            }
            cArray[n++] = c;
        }
        return cArray == null ? string : new String(cArray, 0, n);
    }

    private static boolean encodeUnescaped(char c, boolean bl) {
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9') {
            return true;
        }
        if ("-_.!~*'()".indexOf(c) >= 0) {
            return true;
        }
        if (bl) {
            return URI_DECODE_RESERVED.indexOf(c) >= 0;
        }
        return false;
    }

    private static EcmaError uriError() {
        return ScriptRuntime.constructError("URIError", ScriptRuntime.getMessage0("msg.bad.uri"));
    }

    private static int oneUcs4ToUtf8Char(byte[] byArray, int n) {
        int n2 = 1;
        if ((n & 0xFFFFFF80) == 0) {
            byArray[0] = (byte)n;
        } else {
            int n3 = n >>> 11;
            n2 = 2;
            while (n3 != 0) {
                n3 >>>= 5;
                ++n2;
            }
            int n4 = n2;
            while (--n4 > 0) {
                byArray[n4] = (byte)(n & 0x3F | 0x80);
                n >>>= 6;
            }
            byArray[0] = (byte)(256 - (1 << 8 - n2) + n);
        }
        return n2;
    }
}

