#ifdef _cplusplus
extern "C" {
#endif
#include "hspscaninterface.h"

/* Function:  free_HSPScanInterface(hsi)
 *
 * Descrip:    Frees overrides dynamite default
 *
 *
 * Arg:        hsi [UNKN ] Undocumented argument [HSPScanInterface *]
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterface *]
 *
 */
# line 30 "hspscaninterface.dy"
HSPScanInterface * free_HSPScanInterface(HSPScanInterface * hsi)
{
  if( hsi == NULL ) {
    return NULL;
  }

  (*hsi->free_data)(hsi->data);
  ckfree(hsi);

  return NULL;

}




# line 30 "hspscaninterface.c"
/* Function:  hard_link_HSPScanInterfacePara(obj)
 *
 * Descrip:    Bumps up the reference count of the object
 *             Meaning that multiple pointers can 'own' it
 *
 *
 * Arg:        obj [UNKN ] Object to be hard linked [HSPScanInterfacePara *]
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterfacePara *]
 *
 */
HSPScanInterfacePara * hard_link_HSPScanInterfacePara(HSPScanInterfacePara * obj) 
{
    if( obj == NULL )    {  
      warn("Trying to hard link to a HSPScanInterfacePara object: passed a NULL object");    
      return NULL;   
      }  
    obj->dynamite_hard_link++;   
    return obj;  
}    


/* Function:  HSPScanInterfacePara_alloc(void)
 *
 * Descrip:    Allocates structure: assigns defaults if given 
 *
 *
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterfacePara *]
 *
 */
HSPScanInterfacePara * HSPScanInterfacePara_alloc(void) 
{
    HSPScanInterfacePara * out; /* out is exported at end of function */ 


    /* call ckalloc and see if NULL */ 
    if((out=(HSPScanInterfacePara *) ckalloc (sizeof(HSPScanInterfacePara))) == NULL)    {  
      warn("HSPScanInterfacePara_alloc failed ");    
      return NULL;  /* calling function should respond! */ 
      }  
    out->dynamite_hard_link = 1; 
#ifdef PTHREAD   
    pthread_mutex_init(&(out->dynamite_mutex),NULL);     
#endif   
    out->min_score = 0;  
    out->max_results = 0;    
    out->flags = 0;  
    out->use_protein_heuristic = TRUE;   


    return out;  
}    


/* Function:  free_HSPScanInterfacePara(obj)
 *
 * Descrip:    Free Function: removes the memory held by obj
 *             Will chain up to owned members and clear all lists
 *
 *
 * Arg:        obj [UNKN ] Object that is free'd [HSPScanInterfacePara *]
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterfacePara *]
 *
 */
HSPScanInterfacePara * free_HSPScanInterfacePara(HSPScanInterfacePara * obj) 
{
    int return_early = 0;    


    if( obj == NULL) {  
      warn("Attempting to free a NULL pointer to a HSPScanInterfacePara obj. Should be trappable");  
      return NULL;   
      }  


#ifdef PTHREAD   
    assert(pthread_mutex_lock(&(obj->dynamite_mutex)) == 0); 
#endif   
    if( obj->dynamite_hard_link > 1)     {  
      return_early = 1;  
      obj->dynamite_hard_link--; 
      }  
#ifdef PTHREAD   
    assert(pthread_mutex_unlock(&(obj->dynamite_mutex)) == 0);   
#endif   
    if( return_early == 1)   
      return NULL;   


    ckfree(obj); 
    return NULL; 
}    


/* Function:  hard_link_HSPScanInterface(obj)
 *
 * Descrip:    Bumps up the reference count of the object
 *             Meaning that multiple pointers can 'own' it
 *
 *
 * Arg:        obj [UNKN ] Object to be hard linked [HSPScanInterface *]
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterface *]
 *
 */
HSPScanInterface * hard_link_HSPScanInterface(HSPScanInterface * obj) 
{
    if( obj == NULL )    {  
      warn("Trying to hard link to a HSPScanInterface object: passed a NULL object");    
      return NULL;   
      }  
    obj->dynamite_hard_link++;   
    return obj;  
}    


/* Function:  HSPScanInterface_alloc(void)
 *
 * Descrip:    Allocates structure: assigns defaults if given 
 *
 *
 *
 * Return [UNKN ]  Undocumented return value [HSPScanInterface *]
 *
 */
HSPScanInterface * HSPScanInterface_alloc(void) 
{
    HSPScanInterface * out; /* out is exported at end of function */ 


    /* call ckalloc and see if NULL */ 
    if((out=(HSPScanInterface *) ckalloc (sizeof(HSPScanInterface))) == NULL)    {  
      warn("HSPScanInterface_alloc failed ");    
      return NULL;  /* calling function should respond! */ 
      }  
    out->dynamite_hard_link = 1; 
#ifdef PTHREAD   
    pthread_mutex_init(&(out->dynamite_mutex),NULL);     
#endif   
    out->scan_query = NULL;  
    out->free_data = NULL;   


    return out;  
}    



#ifdef _cplusplus
}
#endif
