
#include "pcap_functions.h"

/**************************************************************************
 **SA Network Connection Profiler [sancp] - A TCP/IP statistical/collection tool
 * ************************************************************************
 * * Copyright (C) 2003 John Curry <john.curry@metre.net>
 * *
 * * This program is distributed under the terms of version 1.0 of the
 * * Q Public License.  See LICENSE.QPL for further details.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * *
 * ***********************************************************************/


void ProcessMyPacket(char *user, struct pcap_pkthdr * pkthdr, u_char * pkt);

void close_pcap_file(pcap_t *ph){
	if(ph)
	pcap_close(ph);
}

pcap_t *open_pcap_file(char *mbpf_filter,char *input_filename){
	pcap_t *ph;
	// Read from a file
	char errorbuf[MAX_VAR];

	// Reliquish any set-uid or set-gid privileges
	setuid(getuid());
	
        ph = pcap_open_offline(input_filename, errorbuf);
	if( ph == NULL )
	{
		fprintf(stderr,"Unable to read from file %s\n", input_filename);
		return ph;
	}
	//dlt= pcap_datalink(ph);
	//dlt_name = pcap_datalink_val_to_name(dlt);
	
	if(mbpf_filter && apply_filter(ph,mbpf_filter,1,0)==-1)
	{ 
		fprintf(stderr,"Error with bpf filter: %s \"%s\"\n",pcap_geterr(ph),mbpf_filter);
	}

	return ph;
}

pcap_t *open_pcap_live(char *mbpf_filter,char *default_device){
	// Read from an interface
	pcap_t *ph;
	char errorbuf[MAX_VAR];
	int snaplen = 0xFFFF;
	int promisc_mode_var = 1;
 	ph = pcap_open_live(default_device, snaplen,
	       	promisc_mode_var ? PROMISC : 0, READ_TIMEOUT, errorbuf);
	if( ph == NULL)
	{
		fprintf(stderr,"Unable to read from interface %s (%s)\n", default_device,errorbuf);
		return ph;
	}
	if(mbpf_filter && apply_filter(ph,mbpf_filter,1,0)==-1)
	{ 
		fprintf(stderr,"Error with bpf filer: %s\n",pcap_geterr(ph));
	}
	return ph;
}

int apply_filter(pcap_t *mph, char *mfilter, int optimize, bpf_u_int32 xnetmask )
{
	struct bpf_program filterprogram;
	int result=-1;
	bpf_u_int32 defaultnet = 0xFFFFFF00;
	bpf_u_int32 netmask;

	netmask = htonl(defaultnet);
	
	if((result=pcap_compile(mph, &filterprogram, mfilter, optimize, netmask))<0)
	{
		fprintf(stderr,"OpenPcap() FSM compilation failed: \n\t%s\n PCAP command: %s\n", pcap_geterr(mph), mfilter);

	}

	if((pcap_setfilter(mph,&filterprogram))<0) 
	{
		fprintf(stderr,"OpenPcap() FSM compilation failed: \n\t%s\n PCAP command: %s\n", pcap_geterr(mph), mfilter);

	}
		
	return result;
}
	


void start_pcap_loop(pcap_t *ph)
{
	if(pcap_loop(ph, -1, (pcap_handler) ProcessMyPacket, NULL) < 0)
	{
		fprintf(stderr,"pcap_loop: %s\n", pcap_geterr(ph));
	}
}

