---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              opérateurs mathématiques
---

# Comment définir un nouvel opérateur ou symbole ?

## Avec les commandes de bases

Les commandes permettant de définir d'autres commandes peuvent être ici 
utilisées, en les plaçant plutôt dans le préambule du document (sans que 
cela soit obligatoire). 

Ainsi, voici un exemple avec `\newcommand`, la principale commande 
de définition avec LaTeX :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newcommand{\affecte}{\mathrel{:=}}
  \newcommand{\surconditionne}{\mathrm{\ surc\ }}

\begin{document}
$x \affecte 0$, $y \affecte 1$

$ A \surconditionne B \surconditionne C $
\end{document}
```

Il faut noter ici que, pour définir un nouveau symbole 
de plusieurs caractères textuels, il faut utiliser les commandes `\mathrm` 
(caractères romains) ou `\mathit` (caractères italiques) pour encadrer 
ce symbole. La présence des commandes `\ ` permet d'insérer des espaces simples
avant et après ce symbole (solution qui pourrait ne pas être toujours 
satisfaisante en fonction du positionnement du symbole).

Dans des cas moins fréquents (car exigeant plus de précautions d'usage), 
la commande `\def` (issue de TeX) est également disponible :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \makeatletter
  \def\log{\mathop{\operator@font log}\nolimits}
  \makeatother

\begin{document}
$ \log 28 = 1.447158 $
\end{document}
```

Cet exemple illustre également l'utilisation de la commande `\mathop`.

```{todo}
Détailler un peu plus ce sujet de `\mathop`.
```


## Avec l'extension <ctanpkg:mathtools> 

Pour faire ce type de définition, il existe la commande `\DeclareMathOperator`
de l'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>). Elle s'utilise 
dans le préambule comme ici :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

  \DeclareMathOperator{\init}{init}

\begin{document}
\[  \init f = 0 \quad \mathrm{au \ lieu \ de}\quad init f = 0  \]
\end{document}
```