---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, communication, correspondance
              mailing, liste de diffusion, courrier, communication d'entreprise
---

# Comment mettre en forme un courrier interne (newsletter) ?

## Avec l'extension <ctanpkg:newspaper>

L'extension <ctanpkg:newspaper>, de Matthew Allen, permet d'obtenir quelques 
commandes pour faire une mise en forme ressemblant à celle d'un journal 
(en l'occurrence, une première page ressamblant à celle du 
*[New York Times](https://www.nytimes.com/)*).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}         % Du faux texte
  \usepackage{multicol}

  \usepackage{newspaper}
  % Réglages pour le titre 
  \date{\today}
  \currentvolume{12}
  \currentissue{1}
  \SetPaperName{L'irrégulier}
  \SetHeaderName{L'irrégulier}
  \SetPaperLocation{}
  \SetPaperSlogan{\og Vous ne le verrez pas venir ! \fg{}}
  \SetPaperPrice{Gratuit}

\begin{document}
\maketitle %  génération du bandeau de titre
\begin{multicols}{3}
  \headline{Ciel, mon Lipsum !}
  \lipsum[1-5]
  \closearticle
  \headline{Faux-texte, quand tu nous tiens.}
  \lipsum[6-7]
  \closearticle
\end{multicols}
\end{document}
```


## Avec l'extension <ctanpkg:letgut>

Cette extension de [l'association GuTenberg](https://www.gutenberg-asso.fr/) 
permet de mettre en forme son bulletin irrégulomestriel, 
la [Lettre de GuTenberg](https://publications.gutenberg-asso.fr/lettre). Elle
pourrait donc être librement utilisée et adaptée pour d'autres parutions.

:::{todo} Ajouter un exemple
:::


## Avec l'extension <ctanpkg:newsletr>

L'extension <ctanpkg:newsletr> offre un ensemble de commandes pour mettre 
en page des *newsletters*. Il est destiné à TeX (et pas LaTeX). Le résultat 
est très satisfaisant (multicolonnages, cadres simples, etc.).


## Avec des canevas

Des [canevas](https://www.latextemplates.com/cat/newsletters) sont proposés 
sur le site de [LaTeX Templates](https://www.latextemplates.com/).