//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;
#[cfg(feature = "objc2-core-image")]
#[cfg(not(target_os = "watchos"))]
use objc2_core_image::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimageorientation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIImageOrientation(pub NSInteger);
impl UIImageOrientation {
    #[doc(alias = "UIImageOrientationUp")]
    pub const Up: Self = Self(0);
    #[doc(alias = "UIImageOrientationDown")]
    pub const Down: Self = Self(1);
    #[doc(alias = "UIImageOrientationLeft")]
    pub const Left: Self = Self(2);
    #[doc(alias = "UIImageOrientationRight")]
    pub const Right: Self = Self(3);
    #[doc(alias = "UIImageOrientationUpMirrored")]
    pub const UpMirrored: Self = Self(4);
    #[doc(alias = "UIImageOrientationDownMirrored")]
    pub const DownMirrored: Self = Self(5);
    #[doc(alias = "UIImageOrientationLeftMirrored")]
    pub const LeftMirrored: Self = Self(6);
    #[doc(alias = "UIImageOrientationRightMirrored")]
    pub const RightMirrored: Self = Self(7);
}

unsafe impl Encode for UIImageOrientation {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIImageOrientation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimageresizingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIImageResizingMode(pub NSInteger);
impl UIImageResizingMode {}

unsafe impl Encode for UIImageResizingMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIImageResizingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimagerenderingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIImageRenderingMode(pub NSInteger);
impl UIImageRenderingMode {
    #[doc(alias = "UIImageRenderingModeAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "UIImageRenderingModeAlwaysOriginal")]
    pub const AlwaysOriginal: Self = Self(1);
    #[doc(alias = "UIImageRenderingModeAlwaysTemplate")]
    pub const AlwaysTemplate: Self = Self(2);
}

unsafe impl Encode for UIImageRenderingMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIImageRenderingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiimage?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIImage;
);

unsafe impl Send for UIImage {}

unsafe impl Sync for UIImage {}

extern_conformance!(
    unsafe impl NSCoding for UIImage {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIImage {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UIImage {}
);

impl UIImage {
    extern_methods!(
        #[unsafe(method(systemImageNamed:))]
        #[unsafe(method_family = none)]
        pub fn systemImageNamed(name: &NSString) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImageConfiguration")]
        #[unsafe(method(systemImageNamed:withConfiguration:))]
        #[unsafe(method_family = none)]
        pub fn systemImageNamed_withConfiguration(
            name: &NSString,
            configuration: Option<&UIImageConfiguration>,
        ) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UITraitCollection")]
        #[unsafe(method(systemImageNamed:compatibleWithTraitCollection:))]
        #[unsafe(method_family = none)]
        pub fn systemImageNamed_compatibleWithTraitCollection(
            name: &NSString,
            trait_collection: Option<&UITraitCollection>,
        ) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImageConfiguration")]
        /// Retrieve a system-provided image with the specified name and variable value (between 0 and 1).
        ///
        /// This will only return system-provided images. If you want a custom image as defined in your own catalogs,
        /// you should use
        /// `+imageNamed:inBundle:variableValue:withConfiguration:.`
        /// Returns
        /// `nil`if an image with specified name doesn't exist.
        #[unsafe(method(systemImageNamed:variableValue:withConfiguration:))]
        #[unsafe(method_family = none)]
        pub fn systemImageNamed_variableValue_withConfiguration(
            name: &NSString,
            value: c_double,
            configuration: Option<&UIImageConfiguration>,
        ) -> Option<Retained<UIImage>>;

        #[unsafe(method(imageNamed:))]
        #[unsafe(method_family = none)]
        pub fn imageNamed(name: &NSString) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImageConfiguration")]
        #[unsafe(method(imageNamed:inBundle:withConfiguration:))]
        #[unsafe(method_family = none)]
        pub fn imageNamed_inBundle_withConfiguration(
            name: &NSString,
            bundle: Option<&NSBundle>,
            configuration: Option<&UIImageConfiguration>,
        ) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UITraitCollection")]
        #[unsafe(method(imageNamed:inBundle:compatibleWithTraitCollection:))]
        #[unsafe(method_family = none)]
        pub fn imageNamed_inBundle_compatibleWithTraitCollection(
            name: &NSString,
            bundle: Option<&NSBundle>,
            trait_collection: Option<&UITraitCollection>,
        ) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImageConfiguration")]
        /// Retrieve a image with the specified name and variable value (between 0 and 1).
        ///
        /// This will only return custom images defined in your own catalogs. If you want a system-provided image,
        /// you should use
        /// `+systemImageNamed:variableValue:withConfiguration:.`
        /// Returns
        /// `nil`if an image with specified name doesn't exist.
        #[unsafe(method(imageNamed:inBundle:variableValue:withConfiguration:))]
        #[unsafe(method_family = none)]
        pub fn imageNamed_inBundle_variableValue_withConfiguration(
            name: &NSString,
            bundle: Option<&NSBundle>,
            value: c_double,
            configuration: Option<&UIImageConfiguration>,
        ) -> Option<Retained<UIImage>>;

        #[unsafe(method(imageWithContentsOfFile:))]
        #[unsafe(method_family = none)]
        pub fn imageWithContentsOfFile(path: &NSString) -> Option<Retained<UIImage>>;

        #[unsafe(method(imageWithData:))]
        #[unsafe(method_family = none)]
        pub fn imageWithData(data: &NSData) -> Option<Retained<UIImage>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(imageWithData:scale:))]
        #[unsafe(method_family = none)]
        pub fn imageWithData_scale(data: &NSData, scale: CGFloat) -> Option<Retained<UIImage>>;

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(imageWithCGImage:))]
        #[unsafe(method_family = none)]
        pub fn imageWithCGImage(cg_image: &CGImage) -> Retained<UIImage>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        #[unsafe(method(imageWithCGImage:scale:orientation:))]
        #[unsafe(method_family = none)]
        pub fn imageWithCGImage_scale_orientation(
            cg_image: &CGImage,
            scale: CGFloat,
            orientation: UIImageOrientation,
        ) -> Retained<UIImage>;

        #[cfg(feature = "objc2-core-image")]
        #[cfg(not(target_os = "watchos"))]
        #[unsafe(method(imageWithCIImage:))]
        #[unsafe(method_family = none)]
        pub fn imageWithCIImage(ci_image: &CIImage) -> Retained<UIImage>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-image"))]
        #[cfg(not(target_os = "watchos"))]
        #[unsafe(method(imageWithCIImage:scale:orientation:))]
        #[unsafe(method_family = none)]
        pub fn imageWithCIImage_scale_orientation(
            ci_image: &CIImage,
            scale: CGFloat,
            orientation: UIImageOrientation,
        ) -> Retained<UIImage>;

        #[unsafe(method(initWithContentsOfFile:))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfFile(
            this: Allocated<Self>,
            path: &NSString,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithData:))]
        #[unsafe(method_family = init)]
        pub fn initWithData(this: Allocated<Self>, data: &NSData) -> Option<Retained<Self>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithData:scale:))]
        #[unsafe(method_family = init)]
        pub fn initWithData_scale(
            this: Allocated<Self>,
            data: &NSData,
            scale: CGFloat,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(initWithCGImage:))]
        #[unsafe(method_family = init)]
        pub fn initWithCGImage(this: Allocated<Self>, cg_image: &CGImage) -> Retained<Self>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        #[unsafe(method(initWithCGImage:scale:orientation:))]
        #[unsafe(method_family = init)]
        pub fn initWithCGImage_scale_orientation(
            this: Allocated<Self>,
            cg_image: &CGImage,
            scale: CGFloat,
            orientation: UIImageOrientation,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-image")]
        #[cfg(not(target_os = "watchos"))]
        #[unsafe(method(initWithCIImage:))]
        #[unsafe(method_family = init)]
        pub fn initWithCIImage(this: Allocated<Self>, ci_image: &CIImage) -> Retained<Self>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-image"))]
        #[cfg(not(target_os = "watchos"))]
        #[unsafe(method(initWithCIImage:scale:orientation:))]
        #[unsafe(method_family = init)]
        pub fn initWithCIImage_scale_orientation(
            this: Allocated<Self>,
            ci_image: &CIImage,
            scale: CGFloat,
            orientation: UIImageOrientation,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(size))]
        #[unsafe(method_family = none)]
        pub unsafe fn size(&self) -> CGSize;

        #[cfg(feature = "objc2-core-graphics")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(CGImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn CGImage(&self) -> Option<Retained<CGImage>>;

        #[cfg(feature = "objc2-core-image")]
        #[cfg(not(target_os = "watchos"))]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(CIImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn CIImage(&self) -> Option<Retained<CIImage>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(imageOrientation))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageOrientation(&self) -> UIImageOrientation;

        #[cfg(feature = "objc2-core-foundation")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(scale))]
        #[unsafe(method_family = none)]
        pub unsafe fn scale(&self) -> CGFloat;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(isSymbolImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn isSymbolImage(&self) -> bool;

        #[unsafe(method(animatedImageNamed:duration:))]
        #[unsafe(method_family = none)]
        pub fn animatedImageNamed_duration(
            name: &NSString,
            duration: NSTimeInterval,
        ) -> Option<Retained<UIImage>>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(animatedResizableImageNamed:capInsets:duration:))]
        #[unsafe(method_family = none)]
        pub fn animatedResizableImageNamed_capInsets_duration(
            name: &NSString,
            cap_insets: UIEdgeInsets,
            duration: NSTimeInterval,
        ) -> Option<Retained<UIImage>>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(animatedResizableImageNamed:capInsets:resizingMode:duration:))]
        #[unsafe(method_family = none)]
        pub fn animatedResizableImageNamed_capInsets_resizingMode_duration(
            name: &NSString,
            cap_insets: UIEdgeInsets,
            resizing_mode: UIImageResizingMode,
            duration: NSTimeInterval,
        ) -> Option<Retained<UIImage>>;

        #[unsafe(method(animatedImageWithImages:duration:))]
        #[unsafe(method_family = none)]
        pub fn animatedImageWithImages_duration(
            images: &NSArray<UIImage>,
            duration: NSTimeInterval,
        ) -> Option<Retained<UIImage>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(images))]
        #[unsafe(method_family = none)]
        pub unsafe fn images(&self) -> Option<Retained<NSArray<UIImage>>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(duration))]
        #[unsafe(method_family = none)]
        pub unsafe fn duration(&self) -> NSTimeInterval;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(drawAtPoint:))]
        #[unsafe(method_family = none)]
        pub fn drawAtPoint(&self, point: CGPoint);

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        #[unsafe(method(drawAtPoint:blendMode:alpha:))]
        #[unsafe(method_family = none)]
        pub fn drawAtPoint_blendMode_alpha(
            &self,
            point: CGPoint,
            blend_mode: CGBlendMode,
            alpha: CGFloat,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(drawInRect:))]
        #[unsafe(method_family = none)]
        pub fn drawInRect(&self, rect: CGRect);

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        #[unsafe(method(drawInRect:blendMode:alpha:))]
        #[unsafe(method_family = none)]
        pub fn drawInRect_blendMode_alpha(
            &self,
            rect: CGRect,
            blend_mode: CGBlendMode,
            alpha: CGFloat,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(drawAsPatternInRect:))]
        #[unsafe(method_family = none)]
        pub fn drawAsPatternInRect(&self, rect: CGRect);

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(resizableImageWithCapInsets:))]
        #[unsafe(method_family = none)]
        pub fn resizableImageWithCapInsets(&self, cap_insets: UIEdgeInsets) -> Retained<UIImage>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(resizableImageWithCapInsets:resizingMode:))]
        #[unsafe(method_family = none)]
        pub fn resizableImageWithCapInsets_resizingMode(
            &self,
            cap_insets: UIEdgeInsets,
            resizing_mode: UIImageResizingMode,
        ) -> Retained<UIImage>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(capInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn capInsets(&self) -> UIEdgeInsets;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(resizingMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn resizingMode(&self) -> UIImageResizingMode;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(imageWithAlignmentRectInsets:))]
        #[unsafe(method_family = none)]
        pub fn imageWithAlignmentRectInsets(
            &self,
            alignment_insets: UIEdgeInsets,
        ) -> Retained<UIImage>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(alignmentRectInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignmentRectInsets(&self) -> UIEdgeInsets;

        #[unsafe(method(imageWithRenderingMode:))]
        #[unsafe(method_family = none)]
        pub fn imageWithRenderingMode(
            &self,
            rendering_mode: UIImageRenderingMode,
        ) -> Retained<UIImage>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(renderingMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn renderingMode(&self) -> UIImageRenderingMode;

        #[cfg(all(feature = "UIGraphicsImageRenderer", feature = "UIGraphicsRenderer"))]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(imageRendererFormat))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageRendererFormat(&self) -> Retained<UIGraphicsImageRendererFormat>;

        #[cfg(feature = "UITraitCollection")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(traitCollection))]
        #[unsafe(method_family = none)]
        pub unsafe fn traitCollection(&self) -> Retained<UITraitCollection>;

        #[cfg(feature = "UIImageAsset")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(imageAsset))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageAsset(&self) -> Option<Retained<UIImageAsset>>;

        #[unsafe(method(imageFlippedForRightToLeftLayoutDirection))]
        #[unsafe(method_family = none)]
        pub fn imageFlippedForRightToLeftLayoutDirection(&self) -> Retained<UIImage>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(flipsForRightToLeftLayoutDirection))]
        #[unsafe(method_family = none)]
        pub unsafe fn flipsForRightToLeftLayoutDirection(&self) -> bool;

        #[unsafe(method(imageWithHorizontallyFlippedOrientation))]
        #[unsafe(method_family = none)]
        pub fn imageWithHorizontallyFlippedOrientation(&self) -> Retained<UIImage>;

        #[cfg(feature = "objc2-core-foundation")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(baselineOffsetFromBottom))]
        #[unsafe(method_family = none)]
        pub unsafe fn baselineOffsetFromBottom(&self) -> CGFloat;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(hasBaseline))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasBaseline(&self) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(imageWithBaselineOffsetFromBottom:))]
        #[unsafe(method_family = none)]
        pub fn imageWithBaselineOffsetFromBottom(
            &self,
            baseline_offset: CGFloat,
        ) -> Retained<UIImage>;

        #[unsafe(method(imageWithoutBaseline))]
        #[unsafe(method_family = none)]
        pub fn imageWithoutBaseline(&self) -> Retained<UIImage>;

        #[cfg(feature = "UIImageConfiguration")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(configuration))]
        #[unsafe(method_family = none)]
        pub unsafe fn configuration(&self) -> Option<Retained<UIImageConfiguration>>;

        #[cfg(feature = "UIImageConfiguration")]
        #[unsafe(method(imageWithConfiguration:))]
        #[unsafe(method_family = none)]
        pub fn imageWithConfiguration(
            &self,
            configuration: &UIImageConfiguration,
        ) -> Retained<UIImage>;

        #[cfg(all(
            feature = "UIImageConfiguration",
            feature = "UIImageSymbolConfiguration"
        ))]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(symbolConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn symbolConfiguration(&self) -> Option<Retained<UIImageSymbolConfiguration>>;

        #[cfg(all(
            feature = "UIImageConfiguration",
            feature = "UIImageSymbolConfiguration"
        ))]
        #[unsafe(method(imageByApplyingSymbolConfiguration:))]
        #[unsafe(method_family = none)]
        pub fn imageByApplyingSymbolConfiguration(
            &self,
            configuration: &UIImageSymbolConfiguration,
        ) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIColor")]
        #[unsafe(method(imageWithTintColor:))]
        #[unsafe(method_family = none)]
        pub fn imageWithTintColor(&self, color: &UIColor) -> Retained<UIImage>;

        #[cfg(feature = "UIColor")]
        #[unsafe(method(imageWithTintColor:renderingMode:))]
        #[unsafe(method_family = none)]
        pub fn imageWithTintColor_renderingMode(
            &self,
            color: &UIColor,
            rendering_mode: UIImageRenderingMode,
        ) -> Retained<UIImage>;

        /// Decodes an image synchronously and provides a new one for display in views and animations.
        ///
        ///
        /// Returns: A new version of the image object for display. If the system can’t decode the image, this method returns `nil`.
        ///
        ///
        /// Note: The prepared `UIImage` is not related to the original image. If the properties of the screen (such as its resolution or color gamut) change, or if the image is displayed on a different screen that the one it was prepared for, it may not render correctly.
        #[unsafe(method(imageByPreparingForDisplay))]
        #[unsafe(method_family = none)]
        pub fn imageByPreparingForDisplay(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "block2")]
        /// Decodes an image asynchronously and provides a new one for display in views and animations.
        ///
        /// The completion handler will be invoked on a private queue. Be sure to return to the main queue before assigning the prepared image to an image view.
        ///
        ///
        /// Parameter `completionHandler`: A block to invoke with the prepared image. If preparation failed (for example, because the image data is corrupt),
        /// `image`will be `nil`.
        ///
        ///
        /// Note: The prepared `UIImage` is not related to the original image. If the properties of the screen (such as its resolution or color gamut) change, or if the image is displayed on a different screen that the one it was prepared for, it may not render correctly.
        #[unsafe(method(prepareForDisplayWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub fn prepareForDisplayWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<dyn Fn(*mut UIImage)>,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(imageByPreparingThumbnailOfSize:))]
        #[unsafe(method_family = none)]
        pub fn imageByPreparingThumbnailOfSize(&self, size: CGSize) -> Option<Retained<UIImage>>;

        #[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
        #[unsafe(method(prepareThumbnailOfSize:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn prepareThumbnailOfSize_completionHandler(
            &self,
            size: CGSize,
            completion_handler: &block2::DynBlock<dyn Fn(*mut UIImage)>,
        );

        /// Indicates that this image is tagged for display of high dynamic range content.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(isHighDynamicRange))]
        #[unsafe(method_family = none)]
        pub unsafe fn isHighDynamicRange(&self) -> bool;

        /// Returns a new image that will render within the standard range.
        #[unsafe(method(imageRestrictedToStandardDynamicRange))]
        #[unsafe(method_family = none)]
        pub fn imageRestrictedToStandardDynamicRange(&self) -> Retained<UIImage>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UIImage {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for UIImage {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// PreconfiguredSystemImages.
impl UIImage {
    extern_methods!(
        #[unsafe(method(actionsImage))]
        #[unsafe(method_family = none)]
        pub fn actionsImage() -> Retained<UIImage>;

        #[unsafe(method(addImage))]
        #[unsafe(method_family = none)]
        pub fn addImage() -> Retained<UIImage>;

        #[unsafe(method(removeImage))]
        #[unsafe(method_family = none)]
        pub fn removeImage() -> Retained<UIImage>;

        #[unsafe(method(checkmarkImage))]
        #[unsafe(method_family = none)]
        pub fn checkmarkImage() -> Retained<UIImage>;

        #[unsafe(method(strokedCheckmarkImage))]
        #[unsafe(method_family = none)]
        pub fn strokedCheckmarkImage() -> Retained<UIImage>;
    );
}

/// NSItemProvider.
impl UIImage {
    extern_methods!();
}

extern_conformance!(
    unsafe impl NSItemProviderReading for UIImage {}
);

extern_conformance!(
    unsafe impl NSItemProviderWriting for UIImage {}
);

/// UIImage.
#[cfg(feature = "NSTextAttachment")]
impl NSTextAttachment {
    extern_methods!(
        #[unsafe(method(textAttachmentWithImage:))]
        #[unsafe(method_family = none)]
        pub fn textAttachmentWithImage(image: &UIImage) -> Retained<NSTextAttachment>;
    );
}

/// UIImageDeprecated.
impl UIImage {
    extern_methods!(
        #[unsafe(method(stretchableImageWithLeftCapWidth:topCapHeight:))]
        #[unsafe(method_family = none)]
        pub fn stretchableImageWithLeftCapWidth_topCapHeight(
            &self,
            left_cap_width: NSInteger,
            top_cap_height: NSInteger,
        ) -> Retained<UIImage>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(leftCapWidth))]
        #[unsafe(method_family = none)]
        pub unsafe fn leftCapWidth(&self) -> NSInteger;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(topCapHeight))]
        #[unsafe(method_family = none)]
        pub unsafe fn topCapHeight(&self) -> NSInteger;
    );
}

mod private_CIImageUIKitAdditions {
    pub trait Sealed {}
}

/// Category "UIKitAdditions" on [`CIImage`].
#[doc(alias = "UIKitAdditions")]
pub unsafe trait CIImageUIKitAdditions:
    ClassType + Sized + private_CIImageUIKitAdditions::Sealed
{
    extern_methods!(
        #[unsafe(method(initWithImage:))]
        #[unsafe(method_family = init)]
        fn initWithImage(this: Allocated<Self>, image: &UIImage) -> Option<Retained<Self>>;

        #[cfg(feature = "objc2-core-image")]
        #[cfg(not(target_os = "watchos"))]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(initWithImage:options:))]
        #[unsafe(method_family = init)]
        unsafe fn initWithImage_options(
            this: Allocated<Self>,
            image: &UIImage,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Option<Retained<Self>>;
    );
}

#[cfg(feature = "objc2-core-image")]
#[cfg(not(target_os = "watchos"))]
impl private_CIImageUIKitAdditions::Sealed for CIImage {}
#[cfg(feature = "objc2-core-image")]
#[cfg(not(target_os = "watchos"))]
unsafe impl CIImageUIKitAdditions for CIImage {}

impl UIImage {
    /// return image as PNG. May return nil if image has no CGImageRef or invalid bitmap format
    #[doc(alias = "UIImagePNGRepresentation")]
    #[inline]
    pub fn png_representation(&self) -> Option<Retained<NSData>> {
        extern "C-unwind" {
            fn UIImagePNGRepresentation(image: &UIImage) -> *mut NSData;
        }
        let ret = unsafe { UIImagePNGRepresentation(self) };
        unsafe { Retained::retain_autoreleased(ret) }
    }

    /// return image as JPEG. May return nil if image has no CGImageRef or invalid bitmap format. compression is 0(most)..1(least)
    #[doc(alias = "UIImageJPEGRepresentation")]
    #[cfg(feature = "objc2-core-foundation")]
    #[inline]
    pub fn jpeg_representation(&self, compression_quality: CGFloat) -> Option<Retained<NSData>> {
        extern "C-unwind" {
            fn UIImageJPEGRepresentation(
                image: &UIImage,
                compression_quality: CGFloat,
            ) -> *mut NSData;
        }
        let ret = unsafe { UIImageJPEGRepresentation(self, compression_quality) };
        unsafe { Retained::retain_autoreleased(ret) }
    }

    /// Returns HEIC data representing the image, or nil if such a representation could not be generated. HEIC is recommended for efficiently storing all kinds of images, including those with high dynamic range content.
    #[doc(alias = "UIImageHEICRepresentation")]
    #[inline]
    pub fn heic_representation(&self) -> Option<Retained<NSData>> {
        extern "C-unwind" {
            fn UIImageHEICRepresentation(image: &UIImage) -> *mut NSData;
        }
        let ret = unsafe { UIImageHEICRepresentation(self) };
        unsafe { Retained::retain_autoreleased(ret) }
    }
}

#[deprecated = "renamed to `UIImage::png_representation`"]
#[inline]
pub extern "C-unwind" fn UIImagePNGRepresentation(image: &UIImage) -> Option<Retained<NSData>> {
    extern "C-unwind" {
        fn UIImagePNGRepresentation(image: &UIImage) -> *mut NSData;
    }
    let ret = unsafe { UIImagePNGRepresentation(image) };
    unsafe { Retained::retain_autoreleased(ret) }
}

#[cfg(feature = "objc2-core-foundation")]
#[deprecated = "renamed to `UIImage::jpeg_representation`"]
#[inline]
pub extern "C-unwind" fn UIImageJPEGRepresentation(
    image: &UIImage,
    compression_quality: CGFloat,
) -> Option<Retained<NSData>> {
    extern "C-unwind" {
        fn UIImageJPEGRepresentation(image: &UIImage, compression_quality: CGFloat) -> *mut NSData;
    }
    let ret = unsafe { UIImageJPEGRepresentation(image, compression_quality) };
    unsafe { Retained::retain_autoreleased(ret) }
}

#[deprecated = "renamed to `UIImage::heic_representation`"]
#[inline]
pub extern "C-unwind" fn UIImageHEICRepresentation(image: &UIImage) -> Option<Retained<NSData>> {
    extern "C-unwind" {
        fn UIImageHEICRepresentation(image: &UIImage) -> *mut NSData;
    }
    let ret = unsafe { UIImageHEICRepresentation(image) };
    unsafe { Retained::retain_autoreleased(ret) }
}
