// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2alpha1

import (
	"context"
	"time"

	v2alpha1 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2alpha1"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CiliumCIDRGroupsGetter has a method to return a CiliumCIDRGroupInterface.
// A group's client should implement this interface.
type CiliumCIDRGroupsGetter interface {
	CiliumCIDRGroups() CiliumCIDRGroupInterface
}

// CiliumCIDRGroupInterface has methods to work with CiliumCIDRGroup resources.
type CiliumCIDRGroupInterface interface {
	Create(ctx context.Context, ciliumCIDRGroup *v2alpha1.CiliumCIDRGroup, opts v1.CreateOptions) (*v2alpha1.CiliumCIDRGroup, error)
	Update(ctx context.Context, ciliumCIDRGroup *v2alpha1.CiliumCIDRGroup, opts v1.UpdateOptions) (*v2alpha1.CiliumCIDRGroup, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2alpha1.CiliumCIDRGroup, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2alpha1.CiliumCIDRGroupList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumCIDRGroup, err error)
	CiliumCIDRGroupExpansion
}

// ciliumCIDRGroups implements CiliumCIDRGroupInterface
type ciliumCIDRGroups struct {
	client rest.Interface
}

// newCiliumCIDRGroups returns a CiliumCIDRGroups
func newCiliumCIDRGroups(c *CiliumV2alpha1Client) *ciliumCIDRGroups {
	return &ciliumCIDRGroups{
		client: c.RESTClient(),
	}
}

// Get takes name of the ciliumCIDRGroup, and returns the corresponding ciliumCIDRGroup object, and an error if there is any.
func (c *ciliumCIDRGroups) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2alpha1.CiliumCIDRGroup, err error) {
	result = &v2alpha1.CiliumCIDRGroup{}
	err = c.client.Get().
		Resource("ciliumcidrgroups").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CiliumCIDRGroups that match those selectors.
func (c *ciliumCIDRGroups) List(ctx context.Context, opts v1.ListOptions) (result *v2alpha1.CiliumCIDRGroupList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2alpha1.CiliumCIDRGroupList{}
	err = c.client.Get().
		Resource("ciliumcidrgroups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ciliumCIDRGroups.
func (c *ciliumCIDRGroups) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("ciliumcidrgroups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ciliumCIDRGroup and creates it.  Returns the server's representation of the ciliumCIDRGroup, and an error, if there is any.
func (c *ciliumCIDRGroups) Create(ctx context.Context, ciliumCIDRGroup *v2alpha1.CiliumCIDRGroup, opts v1.CreateOptions) (result *v2alpha1.CiliumCIDRGroup, err error) {
	result = &v2alpha1.CiliumCIDRGroup{}
	err = c.client.Post().
		Resource("ciliumcidrgroups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumCIDRGroup).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ciliumCIDRGroup and updates it. Returns the server's representation of the ciliumCIDRGroup, and an error, if there is any.
func (c *ciliumCIDRGroups) Update(ctx context.Context, ciliumCIDRGroup *v2alpha1.CiliumCIDRGroup, opts v1.UpdateOptions) (result *v2alpha1.CiliumCIDRGroup, err error) {
	result = &v2alpha1.CiliumCIDRGroup{}
	err = c.client.Put().
		Resource("ciliumcidrgroups").
		Name(ciliumCIDRGroup.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumCIDRGroup).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ciliumCIDRGroup and deletes it. Returns an error if one occurs.
func (c *ciliumCIDRGroups) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("ciliumcidrgroups").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ciliumCIDRGroups) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("ciliumcidrgroups").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ciliumCIDRGroup.
func (c *ciliumCIDRGroups) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumCIDRGroup, err error) {
	result = &v2alpha1.CiliumCIDRGroup{}
	err = c.client.Patch(pt).
		Resource("ciliumcidrgroups").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
