/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.util.collections.IteratorUtil;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;

public final class Sets {
    public static final SortedSet EMPTY_SORTED_SET;

    private Sets() {
    }

    public static <E> List<Set<E>> allSubsets(Set<E> set) {
        return Sets.allSubsets(set.iterator());
    }

    private static <E> List<Set<E>> allSubsets(Iterator<E> it) {
        if (!it.hasNext()) {
            ArrayList result = new ArrayList();
            result.add(Collections.emptySet());
            return result;
        }
        E firstElement = it.next();
        List allSubsets = Sets.allSubsets(it);
        ArrayList<Set<E>> tmp = new ArrayList<Set<E>>(allSubsets.size());
        for (Set<E> ss : allSubsets) {
            if (ss.isEmpty()) {
                tmp.add(Collections.singleton(firstElement));
                continue;
            }
            HashSet<E> tmp2 = new HashSet<E>(ss);
            tmp2.add(firstElement);
            tmp.add(tmp2);
        }
        allSubsets.addAll(tmp);
        return allSubsets;
    }

    public static <T> SortedSet<T> emptySortedSet() {
        return EMPTY_SORTED_SET;
    }

    public static <T> Set<T> of(T ... values) {
        if (values.length == 1) {
            return Collections.singleton(values[0]);
        }
        HashSet<T> result = new HashSet<T>(values.length);
        for (T v : values) {
            result.add(v);
        }
        return result;
    }

    public static <T> Set<T> union(Collection<? extends T> lhs, Collection<? extends T> rhs) {
        HashSet<T> result = new HashSet<T>(lhs);
        result.addAll(rhs);
        return result;
    }

    public static <T> Set<T> intersection(Collection<? extends T> lhs, Collection<? extends T> rhs) {
        HashSet<T> result = new HashSet<T>();
        for (T e : lhs) {
            if (!rhs.contains(e)) continue;
            result.add(e);
        }
        return result;
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        EMPTY_SORTED_SET = new EmptySortedSet();
    }

    @NotNullByDefault(value=false)
    private static class EmptySortedSet
    extends AbstractSet
    implements SortedSet,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EmptySortedSet() {
        }

        @Override
        public Iterator iterator() {
            return IteratorUtil.AT_END;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        public Comparator comparator() {
            return null;
        }

        public SortedSet subSet(Object from, Object to) {
            return EMPTY_SORTED_SET;
        }

        public SortedSet headSet(Object toElement) {
            return EMPTY_SORTED_SET;
        }

        public SortedSet tailSet(Object fromElement) {
            return EMPTY_SORTED_SET;
        }

        public Object first() {
            throw new NoSuchElementException();
        }

        public Object last() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof SortedSet && ((SortedSet)o).size() == 0;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

