/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.lang.ExceptionUtil;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;

public final class EnhancedServiceLoader {
    public static final EnhancedServiceLoader DEFAULT = new EnhancedServiceLoader(ClassLoader.getSystemClassLoader());
    private final ClassLoader loader;
    private final Map<Class<?>, Iterable<?>> cache = new HashMap();

    public EnhancedServiceLoader(ClassLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> Iterable<S> load(Class<S> service) throws ServiceConfigurationError {
        Map<Class<?>, Iterable<?>> map = this.cache;
        synchronized (map) {
            Iterable<?> result = this.cache.get(service);
            if (result != null) {
                return result;
            }
            return this.reload(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> Iterable<S> reload(Class<S> service) throws ServiceConfigurationError {
        Iterable<S> result;
        try {
            result = this.load2(service);
        }
        catch (ServiceConfigurationError sce) {
            throw ExceptionUtil.wrap("Service " + service, sce);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap("Service " + service, e, ServiceConfigurationError.class);
        }
        Map<Class<?>, Iterable<?>> map = this.cache;
        synchronized (map) {
            this.cache.put(service, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S> Iterable<S> load2(Class<S> service) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Enumeration<URL> en = this.loader.getResources("META-INF/services/" + service.getName());
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            Properties properties = new Properties();
            InputStream is = url.openStream();
            try {
                properties.load(is);
                is.close();
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            ArrayList<String> classNames = new ArrayList<String>();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                if (!value.isEmpty()) continue;
                classNames.add(key);
            }
            Collections.sort(classNames);
            for (String className : classNames) {
                Object instance = EnhancedServiceLoader.getInstance(this.loader.loadClass(className), properties, className + ".");
                Class<?> actualType = instance.getClass();
                if (!service.isAssignableFrom(actualType)) {
                    throw new ServiceConfigurationError(actualType + " does not extend or implement the service");
                }
                Object instance2 = instance;
                result.add(instance2);
            }
        }
        return Collections.unmodifiableList(result);
    }

    private static <S> Object getInstance(Class<?> clasS, Properties properties, String keyPrefix) throws Exception {
        String instanceFieldName = properties.getProperty(keyPrefix + "instanceField");
        if (instanceFieldName != null) {
            return clasS.getField(instanceFieldName).get(null);
        }
        String instanceMethodName = properties.getProperty(keyPrefix + "instanceMethod");
        if (instanceMethodName != null) {
            Method method = clasS.getMethod(instanceMethodName, new Class[0]);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalStateException(method + " is not static");
            }
            return method.invoke(null, new Object[0]);
        }
        return clasS.newInstance();
    }
}

