/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.json;

import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.text.json.Json;
import de.unkrig.commons.text.json.JsonScanner;
import de.unkrig.commons.text.parser.AbstractParser;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import de.unkrig.commons.text.scanner.ScannerUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JsonParser
extends AbstractParser<JsonScanner.TokenType> {
    public JsonParser(ProducerWhichThrows<? extends AbstractScanner.Token<JsonScanner.TokenType>, ? extends ScanException> scanner) {
        super(scanner);
    }

    public JsonParser(Reader r) {
        super(ScannerUtil.toDocumentScanner(JsonScanner.stringScanner(), r));
    }

    public Json.ObjecT parseObject() throws IOException, ParseException {
        this.read("{");
        ArrayList<Json.Member> svps = new ArrayList<Json.Member>();
        if (!this.peekRead("}")) {
            while (true) {
                this.read("\"");
                Json.StrinG string = this.parseStringRest();
                this.read(":");
                Json.Value value = this.parseValue();
                svps.add(new Json.Member(string, value));
                if (this.peekRead("}")) break;
                this.read(",");
            }
        }
        return new Json.ObjecT(svps);
    }

    public Json.Value parseValue() throws IOException, ParseException {
        if (this.peek("{")) {
            return this.parseObject();
        }
        if (this.peek("[")) {
            return this.parseArray();
        }
        AbstractScanner.Token t = this.read();
        switch ((JsonScanner.TokenType)((Object)t.type)) {
            case DOUBLE_QUOTE: {
                return this.parseStringRest();
            }
            case NUMBER: {
                return new Json.NumbeR(t.text);
            }
            case KEYWORD: {
                if ("true".equals(t.text)) {
                    return new Json.True();
                }
                if ("false".equals(t.text)) {
                    return new Json.False();
                }
                if ("null".equals(t.text)) {
                    return new Json.Null();
                }
                throw new ParseException("Invalid keyword '" + t.text + "'");
            }
        }
        throw new ParseException("Unexpected token '" + t.text + "'");
    }

    private Json.StrinG parseStringRest() throws ParseException {
        StringBuilder sb = new StringBuilder();
        block6: while (true) {
            AbstractScanner.Token t = this.read();
            String text = t.text;
            switch ((JsonScanner.TokenType)((Object)t.type)) {
                case STRING_CHARS: {
                    sb.append(text);
                    continue block6;
                }
                case STRING_ESCAPE: {
                    char c = text.charAt(1);
                    int idx = "bfnrt".indexOf(c);
                    if (idx != -1) {
                        c = "\b\f\n\r\t".charAt(idx);
                    }
                    sb.append(c);
                    continue block6;
                }
                case STRING_UNICODE_ESCAPE: {
                    sb.append((char)(Character.digit(text.charAt(5), 16) + (Character.digit(text.charAt(4), 16) << 4) + (Character.digit(text.charAt(3), 16) << 8) + (Character.digit(text.charAt(2), 16) << 12)));
                    continue block6;
                }
                case DOUBLE_QUOTE: {
                    return new Json.StrinG(sb.toString());
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public Json.Value parseArray() throws IOException, ParseException {
        this.read("[");
        if (this.peekRead("]")) {
            List<Json.Value> noValues = Collections.emptyList();
            return new Json.Array(noValues);
        }
        ArrayList<Json.Value> l = new ArrayList<Json.Value>();
        while (true) {
            Json.Value value = this.parseValue();
            l.add(value);
            if (this.peekRead("]")) break;
            this.read(",");
        }
        return new Json.Array(l);
    }
}

