/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http.servlett;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.HttpResponse;
import de.unkrig.commons.net.http.servlett.AbstractServlett;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleServlett
extends AbstractServlett {
    private static final Logger LOGGER = Logger.getLogger(SimpleServlett.class.getName());
    private final HttpResponse.Status status;
    private final String contentType;
    private final String body;

    public SimpleServlett(HttpResponse.Status status, String contentType, String body) {
        this.status = status;
        this.contentType = contentType;
        this.body = body;
    }

    @Override
    public HttpResponse getOrPost(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) {
        String expandedBody = this.body;
        expandedBody = expandedBody.replace("${path}", httpRequest.getUri().getPath());
        expandedBody = expandedBody.replace("${statusCode}", Integer.toString(this.status.getCode()));
        expandedBody = expandedBody.replace("${reasonPhrase}", this.status.getReasonPhrase());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Expanded body is '" + expandedBody + "'");
        }
        HttpResponse httpResponse = HttpResponse.response(this.status, expandedBody);
        httpResponse.addHeader("Content-Type", this.contentType);
        return httpResponse;
    }
}

