/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http.io;

import de.unkrig.commons.net.http.MessageHeader;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

@NotNullByDefault(value=false)
public class ChunkedOutputStream
extends FilterOutputStream {
    private final List<MessageHeader> trailer = new ArrayList<MessageHeader>();

    public ChunkedOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length) {
            throw new IndexOutOfBoundsException("off");
        }
        if (len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("len");
        }
        if (len == 0) {
            return;
        }
        this.out.write((Integer.toString(len, 16) + "\r\n").getBytes());
        this.out.write(b, off, len);
        this.out.write(new byte[]{13, 10});
        this.out.flush();
    }

    @Override
    public void flush() {
    }

    public void addHeader(String name, String value) {
        this.trailer.add(new MessageHeader(name, value));
    }

    @Override
    public void close() throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(this.out, Charset.forName("ISO-8859-1"));
        w.write("0\r\n");
        for (MessageHeader header : this.trailer) {
            w.write(header.getName() + ": " + header.getValue() + "\r\n");
        }
        w.write("\r\n");
        ((Writer)w).flush();
        super.close();
    }
}

