/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.Writers;
import de.unkrig.commons.lang.protocol.StringTransformers;
import de.unkrig.commons.lang.protocol.TransformerUtil;
import de.unkrig.commons.lang.protocol.TransformerWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import javax.swing.text.Segment;

public class TransformingFilterWriter
extends Writer {
    private final TransformerWhichThrows<? super CharSequence, ? extends CharSequence, ? extends IOException> transformer;
    private final Appendable delegate;

    public static Writer create(TransformerWhichThrows<? super CharSequence, ? extends CharSequence, ? extends IOException> transformer, Appendable delegate) {
        if (transformer == TransformerUtil.identity()) {
            return Writers.fromAppendable(delegate);
        }
        if (transformer == StringTransformers.TO_EMPTY) {
            return Writers.DISCARD;
        }
        return new TransformingFilterWriter(transformer, delegate);
    }

    public TransformingFilterWriter(TransformerWhichThrows<? super CharSequence, ? extends CharSequence, ? extends IOException> transformer, Appendable delegate) {
        this.transformer = transformer;
        this.delegate = delegate;
    }

    @Override
    @NotNullByDefault(value=false)
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.append(new Segment(cbuf, off, len));
    }

    @Override
    @NotNullByDefault(value=false)
    public void write(String str, int off, int len) throws IOException {
        this.append(str, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.append(this.transformer.transform(""));
        if (this.delegate instanceof Flushable) {
            ((Flushable)((Object)this.delegate)).flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.append(this.transformer.transform(""));
        if (this.delegate instanceof Closeable) {
            ((Closeable)((Object)this.delegate)).close();
        }
    }

    @Override
    @NotNullByDefault(value=false)
    public Writer append(CharSequence csq) throws IOException {
        if (csq.length() > 0) {
            this.delegate.append(this.transformer.transform(csq));
        }
        return this;
    }

    @Override
    @NotNullByDefault(value=false)
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (end > start) {
            this.append(csq.subSequence(start, end));
        }
        return this;
    }
}

