/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.identity;

import com.sun.msv.driver.textui.Debug;
import com.sun.msv.grammar.xmlschema.ElementDeclExp;
import com.sun.msv.grammar.xmlschema.IdentityConstraint;
import com.sun.msv.grammar.xmlschema.KeyRefConstraint;
import com.sun.msv.grammar.xmlschema.XMLSchemaGrammar;
import com.sun.msv.util.LightStack;
import com.sun.msv.util.StartTagInfo;
import com.sun.msv.verifier.Acceptor;
import com.sun.msv.verifier.ErrorInfo;
import com.sun.msv.verifier.ValidityViolation;
import com.sun.msv.verifier.Verifier;
import com.sun.msv.verifier.identity.KeyValue;
import com.sun.msv.verifier.identity.Matcher;
import com.sun.msv.verifier.identity.SelectorMatcher;
import com.sun.msv.verifier.regexp.xmlschema.XSREDocDecl;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.relaxng.datatype.Datatype;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class IDConstraintChecker
extends Verifier {
    protected final XMLSchemaGrammar grammar;
    protected final Vector matchers = new Vector();
    private final Map keyValues = new HashMap();
    private final Map referenceScope = new HashMap();
    private final Map activeScopes = new HashMap();
    public static final String ERR_UNMATCHED_KEY_FIELD = "IdentityConstraint.UnmatchedKeyField";
    public static final String ERR_NOT_UNIQUE = "IdentityConstraint.NotUnique";
    public static final String ERR_NOT_UNIQUE_DIAG = "IdentityConstraint.NotUnique.Diag";
    public static final String ERR_DOUBLE_MATCH = "IdentityConstraint.DoubleMatch";
    public static final String ERR_UNDEFINED_KEY = "IdentityConstraint.UndefinedKey";

    public IDConstraintChecker(XMLSchemaGrammar xMLSchemaGrammar, ErrorHandler errorHandler) {
        super(new XSREDocDecl(xMLSchemaGrammar), errorHandler);
        this.grammar = xMLSchemaGrammar;
    }

    protected void add(Matcher matcher) {
        this.matchers.add(matcher);
    }

    protected void remove(Matcher matcher) {
        this.matchers.remove(matcher);
    }

    protected SelectorMatcher getActiveScope(IdentityConstraint identityConstraint) {
        LightStack lightStack = (LightStack)this.activeScopes.get(identityConstraint);
        if (lightStack == null) {
            return null;
        }
        if (lightStack.size() == 0) {
            return null;
        }
        return (SelectorMatcher)lightStack.top();
    }

    protected void pushActiveScope(IdentityConstraint identityConstraint, SelectorMatcher selectorMatcher) {
        LightStack lightStack = (LightStack)this.activeScopes.get(identityConstraint);
        if (lightStack == null) {
            lightStack = new LightStack();
            this.activeScopes.put(identityConstraint, lightStack);
        }
        lightStack.push(selectorMatcher);
    }

    protected void popActiveScope(IdentityConstraint identityConstraint, SelectorMatcher selectorMatcher) {
        LightStack lightStack = (LightStack)this.activeScopes.get(identityConstraint);
        if (lightStack == null) {
            throw new Error();
        }
        if (lightStack.pop() != selectorMatcher) {
            throw new Error();
        }
    }

    protected boolean addKeyValue(SelectorMatcher selectorMatcher, KeyValue keyValue) {
        HashSet<KeyValue> hashSet = (HashSet<KeyValue>)this.keyValues.get(selectorMatcher);
        if (hashSet == null) {
            hashSet = new HashSet<KeyValue>();
            this.keyValues.put(selectorMatcher, hashSet);
        }
        return hashSet.add(keyValue);
    }

    protected KeyValue[] getKeyValues(SelectorMatcher selectorMatcher) {
        Set set = (Set)this.keyValues.get(selectorMatcher);
        if (set == null) {
            return new KeyValue[0];
        }
        return set.toArray(new KeyValue[set.size()]);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.keyValues.clear();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        Map.Entry[] entryArray = this.keyValues.entrySet().toArray(new Map.Entry[this.keyValues.size()]);
        if (Debug.debug) {
            System.out.println("key/keyref check: there are " + this.keyValues.size() + " scope(s)");
        }
        int n = 0;
        while (n < entryArray.length) {
            SelectorMatcher selectorMatcher = (SelectorMatcher)entryArray[n].getKey();
            Set set = (Set)entryArray[n].getValue();
            if (selectorMatcher.idConst instanceof KeyRefConstraint) {
                Set set2 = (Set)this.keyValues.get(this.referenceScope.get(selectorMatcher));
                KeyValue[] keyValueArray = set.toArray(new KeyValue[set.size()]);
                int n2 = 0;
                while (n2 < keyValueArray.length) {
                    if (set2 == null || !set2.contains(keyValueArray[n2])) {
                        this.reportError(keyValueArray[n2].locator, null, ERR_UNDEFINED_KEY, new Object[]{selectorMatcher.idConst.namespaceURI, selectorMatcher.idConst.localName});
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    protected void onNextAcceptorReady(StartTagInfo startTagInfo, Acceptor acceptor) throws SAXException {
        Object object;
        int n = this.matchers.size();
        int n2 = 0;
        while (n2 < n) {
            object = (Matcher)this.matchers.get(n2);
            ((Matcher)object).startElement(startTagInfo.namespaceURI, startTagInfo.localName);
            ++n2;
        }
        object = acceptor.getOwnerType();
        if (object instanceof ElementDeclExp.XSElementExp) {
            ElementDeclExp.XSElementExp xSElementExp = (ElementDeclExp.XSElementExp)object;
            if (xSElementExp.identityConstraints != null) {
                int n3 = xSElementExp.identityConstraints.size();
                int n4 = 0;
                while (n4 < n3) {
                    this.add(new SelectorMatcher(this, (IdentityConstraint)xSElementExp.identityConstraints.get(n4), startTagInfo.namespaceURI, startTagInfo.localName));
                    ++n4;
                }
                int n5 = 0;
                while (n5 < n3) {
                    IdentityConstraint identityConstraint = (IdentityConstraint)xSElementExp.identityConstraints.get(n5);
                    if (identityConstraint instanceof KeyRefConstraint) {
                        SelectorMatcher selectorMatcher = this.getActiveScope(((KeyRefConstraint)identityConstraint).key);
                        if (selectorMatcher == null) {
                            // empty if block
                        }
                        this.referenceScope.put(this.getActiveScope(identityConstraint), selectorMatcher);
                    }
                    ++n5;
                }
            }
        }
    }

    protected Datatype[] feedAttribute(Acceptor acceptor, String string, String string2, String string3, String string4) throws SAXException {
        Datatype[] datatypeArray = super.feedAttribute(acceptor, string, string2, string3, string4);
        int n = this.matchers.size();
        int n2 = 0;
        while (n2 < n) {
            Matcher matcher = (Matcher)this.matchers.get(n2);
            matcher.onAttribute(string, string2, string4, datatypeArray == null ? null : datatypeArray[0]);
            ++n2;
        }
        return datatypeArray;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        int n3 = this.matchers.size();
        int n4 = 0;
        while (n4 < n3) {
            ((Matcher)this.matchers.get(n4)).characters(cArray, n, n2);
            ++n4;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        Datatype[] datatypeArray = this.getLastCharacterType();
        Datatype datatype = datatypeArray == null || datatypeArray.length == 0 ? null : this.getLastCharacterType()[0];
        int n = this.matchers.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            ((Matcher)this.matchers.get(n2)).endElement(datatype);
            --n2;
        }
    }

    protected void reportError(ErrorInfo errorInfo, String string, Object[] objectArray) throws SAXException {
        this.reportError(this.getLocator(), errorInfo, string, objectArray);
    }

    protected void reportError(Locator locator, ErrorInfo errorInfo, String string, Object[] objectArray) throws SAXException {
        this.hadError = true;
        this.errorHandler.error(new ValidityViolation(locator, IDConstraintChecker.localizeMessage(string, objectArray), errorInfo));
    }

    public static String localizeMessage(String string, Object object) {
        return IDConstraintChecker.localizeMessage(string, new Object[]{object});
    }

    public static String localizeMessage(String string, Object[] objectArray) {
        String string2 = ResourceBundle.getBundle("com.sun.msv.verifier.identity.Messages").getString(string);
        return MessageFormat.format(string2, objectArray);
    }
}

