/*
 */
#ifndef NOEXEC_MACRO_H
#define NOEXEC_MACRO_H

//#include <time.h>
//#include <sys/types.h>

#define PRELOAD_LIBRARY_PATH "/usr/lib"
#define PRELOAD_LIBRARY_NAME "libnoexec.so"

#define _MY_FPRINTF(Operation, File)                   \
   fprintf(                                            \
      stderr,                                          \
      "%s: Can not %s file '%s' (errno=%d, %s).\n",    \
      PgmName, Operation, File, errno, strerror(errno) \
   )

#define MY_FPRINTF(Operation) _MY_FPRINTF(Operation, TestFileFullName)

#define MY_MALLOC(Variable, Length)                                        \
{                                                                          \
   Variable = malloc(Length);                                              \
   if (Variable == NULL) {                                                 \
      fprintf(stderr, "%s: Can not malloc for %s.\n", PgmName, #Variable); \
      exit(1);                                                             \
   }                                                                       \
}

#define SETENV(Var, Value)                                \
   {                                                      \
      char *tmp;                                          \
      MY_MALLOC(tmp, strlen(Var) + 1 + strlen(Value) + 1); \
      sprintf(tmp,"%s=%s", Var, Value);         \
      if (putenv(tmp) == -1) {                  \
         fprintf(                                         \
            stderr,                                       \
            "%s: Can't set environment variable '%s'.\n", \
            PgmName, Var                                  \
         );                                               \
         exit(1);                                         \
      }                                                   \
    }

#endif /* NOEXEC_MACRO_H */
