import { $n as e, A as t, Zn as n, Zt as r, fn as i, ft as a, kn as o, pn as s, un as c } from "./index-COzxT5ru.js";
var l = { mixins: [t], name: "OhVideoWebRTC", props: { src: { type: String }, stunServer: { type: String }, candidatesTimeout: { type: Number }, startManually: { type: Boolean }, startMuted: { type: Boolean }, hideControls: { type: Boolean }, posterURL: { type: String }, sendAudio: { type: Boolean } }, data() {
  return { webrtc: null, localAudioStream: null, audioTransceiver: null, isMicOn: false };
}, watch: { src(e2) {
  this.startStream();
}, sendAudio(e2) {
  e2 === false && this.isMicOn && (this.isMicOn = false, this.disableMicrophone());
} }, computed: { computedPosterUrl() {
  if (this.posterURL && this.posterURL.startsWith("data:")) return this.posterURL;
  let e2 = (/* @__PURE__ */ new Date()).toISOString();
  return this.posterURL ? this.posterURL.indexOf("?") === -1 ? "".concat(this.posterURL, "?_ts=").concat(e2) : "".concat(this.posterURL, "&_ts=").concat(e2) : this.posterURL;
} }, methods: { stopStream() {
  if (console.debug("WebRTC Closing Connection"), this.webrtc) {
    this.webrtc.isClosed = true;
    try {
      this.disableMicrophone();
    } catch {
    }
    this.webrtc.close(), this.audioTransceiver = null, this.webrtc = null;
  }
}, startStream() {
  if (!this.inForeground || !this.src) return;
  this.stopStream();
  let e2 = this, t2 = new RTCPeerConnection({ iceServers: [{ urls: [e2.stunServer || "stun:stun.l.google.com:19302"] }], sdpSemantics: "unified-plan" });
  t2.isClosed = false, t2.ontrack = function(t3) {
    console.debug(t3.streams.length + " track is delivered"), e2.$refs.videoPlayer.srcObject = t3.streams[0];
  }, t2.addTransceiver("video", { direction: "sendrecv" }), this.audioTransceiver = t2.addTransceiver("audio", { direction: "sendrecv" }), this.isMicOn && this.enableMicrophone(t2, this.audioTransceiver), t2.onnegotiationneeded = function() {
    t2.createOffer().then((e3) => t2.setLocalDescription(e3)).then(() => n3(e2.candidatesTimeout)).then(() => r2()).then((e3) => t2.setRemoteDescription(new RTCSessionDescription({ type: "answer", sdp: e3 }))).catch((e3) => console.warn(e3));
    function n3(e3 = 2e3) {
      return new Promise((n4, r3) => {
        let i2 = null;
        e3 > 0 && (i2 = setTimeout(() => {
          n4();
        }, e3)), t2.addEventListener("icegatheringstatechange", (e4) => {
          e4.target.iceGatheringState === "complete" && (n4(), i2 && clearTimeout(i2));
        });
      });
    }
    function r2() {
      return console.debug("Offer: ", t2.localDescription.sdp), new Promise((n4, r3) => {
        fetch(e2.src, { method: "POST", body: new URLSearchParams({ data: btoa(t2.localDescription.sdp) }) }).then((e3) => e3.text()).then((e3) => {
          let t3 = atob(e3);
          console.debug("Answer: ", t3), n4(t3);
        }).catch((e3) => r3(e3));
      });
    }
  };
  let n2 = t2.createDataChannel("dataSendChannel");
  n2.onclose = (r2) => {
    console.debug("".concat(n2.label, " has closed")), t2.isClosed || (console.warn("".concat(n2.label, " closed prematurely, restarting")), e2.startStream());
  }, this.webrtc = t2;
}, toggleMic() {
  if (this.isMicOn = !this.isMicOn, !this.webrtc) {
    this.inForeground && this.src && this.startStream();
    return;
  }
  this.isMicOn ? this.enableMicrophone(this.webrtc, this.audioTransceiver) : this.disableMicrophone();
}, async enableMicrophone(e2, t2) {
  try {
    if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
      r.dialog.alert("To enable the microphone, please make sure that HTTPS is in use and WebRTC is supported by this browser, including microphone access.");
      return;
    }
    if (this.localAudioStream && this.localAudioStream.getAudioTracks().some((e3) => e3.enabled)) return;
    let n2 = await navigator.mediaDevices.getUserMedia({ audio: true });
    this.localAudioStream = n2;
    let [i2] = n2.getAudioTracks();
    if (!i2) return;
    t2 && t2.sender ? await t2.sender.replaceTrack(i2) : e2 && e2.addTrack(i2, n2);
  } catch (e3) {
    console.warn("Failed to enable microphone:", e3), r.dialog.alert("Microphone could not be enabled: " + (e3.message || "Unknown error"));
  }
}, disableMicrophone() {
  try {
    this.audioTransceiver && this.audioTransceiver.sender && this.audioTransceiver.sender.replaceTrack(null), this.localAudioStream && (this.localAudioStream = (this.localAudioStream.getTracks().forEach((e2) => {
      try {
        e2.stop();
      } catch {
      }
    }), null));
  } catch (e2) {
    console.warn("Failed to disable microphone:", e2);
  }
}, startForegroundActivity() {
  this.startStream();
}, stopForegroundActivity() {
  this.stopStream();
} } }, u = { class: "oh-video-wrapper" }, d = ["autoplay", "controls", "muted", "poster"], f = ["title"], p = { class: "material-icons" };
function m(t2, r2, a2, l2, m2, h2) {
  return o(), s("div", u, [c("video", { ref: "videoPlayer", autoplay: !this.startManually, controls: !this.hideControls, muted: !!a2.startMuted, poster: h2.computedPosterUrl, playsinline: "", style: { "max-width": "100%" } }, " Sorry, your browser doesn't support embedded videos. ", 8, d), a2.sendAudio ? (o(), s("button", { key: 0, class: n(["oh-video-mic", { active: m2.isMicOn }]), onClick: r2[0] || (r2[0] = (...e2) => h2.toggleMic && h2.toggleMic(...e2)), title: m2.isMicOn ? "Mute microphone" : "Send microphone" }, [c("i", p, e(m2.isMicOn ? "mic" : "mic_off"), 1)], 10, f)) : i("", true)]);
}
var h = a(l, [["render", m], ["__scopeId", "data-v-240ca8ab"]]);
export {
  h as default
};
