/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.option.BaseOptionDefinition;
import org.eclipse.californium.elements.util.Bytes;

public class EmptyOptionDefinition
extends BaseOptionDefinition {
    private static final int[] LENGTHS = new int[]{0, 0};

    public EmptyOptionDefinition(int number, String name) {
        super(number, name, OptionNumberRegistry.OptionFormat.EMPTY, true, LENGTHS);
    }

    @Override
    public Option create(byte[] value) {
        if (value == null) {
            throw new NullPointerException("Option " + this.getName() + " value must not be null.");
        }
        if (value.length > 0) {
            throw new IllegalArgumentException("Option " + this.getName() + " value must be empty.");
        }
        return new Option(this, Bytes.EMPTY);
    }
}

