// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/vision/v1/product_search_service.proto

package vision // import "google.golang.org/genproto/googleapis/cloud/vision/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import status "google.golang.org/genproto/googleapis/rpc/status"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Enumerates the possible states that the batch request can be in.
type BatchOperationMetadata_State int32

const (
	// Invalid.
	BatchOperationMetadata_STATE_UNSPECIFIED BatchOperationMetadata_State = 0
	// Request is actively being processed.
	BatchOperationMetadata_PROCESSING BatchOperationMetadata_State = 1
	// The request is done and at least one item has been successfully
	// processed.
	BatchOperationMetadata_SUCCESSFUL BatchOperationMetadata_State = 2
	// The request is done and no item has been successfully processed.
	BatchOperationMetadata_FAILED BatchOperationMetadata_State = 3
	// The request is done after the longrunning.Operations.CancelOperation has
	// been called by the user.  Any records that were processed before the
	// cancel command are output as specified in the request.
	BatchOperationMetadata_CANCELLED BatchOperationMetadata_State = 4
)

var BatchOperationMetadata_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "PROCESSING",
	2: "SUCCESSFUL",
	3: "FAILED",
	4: "CANCELLED",
}
var BatchOperationMetadata_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"PROCESSING":        1,
	"SUCCESSFUL":        2,
	"FAILED":            3,
	"CANCELLED":         4,
}

func (x BatchOperationMetadata_State) String() string {
	return proto.EnumName(BatchOperationMetadata_State_name, int32(x))
}
func (BatchOperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{28, 0}
}

// A Product contains ReferenceImages.
type Product struct {
	// The resource name of the product.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
	//
	// This field is ignored when creating a product.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The user-provided name for this Product. Must not be empty. Must be at most
	// 4096 characters long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// User-provided metadata to be stored with this product. Must be at most 4096
	// characters long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The category for the product identified by the reference image. This should
	// be either "homegoods", "apparel", or "toys".
	//
	// This field is immutable.
	ProductCategory string `protobuf:"bytes,4,opt,name=product_category,json=productCategory,proto3" json:"product_category,omitempty"`
	// Key-value pairs that can be attached to a product. At query time,
	// constraints can be specified based on the product_labels.
	//
	// Note that integer values can be provided as strings, e.g. "1199". Only
	// strings with integer values can match a range-based restriction which is
	// to be supported soon.
	//
	// Multiple values can be assigned to the same key. One product may have up to
	// 100 product_labels.
	ProductLabels        []*Product_KeyValue `protobuf:"bytes,5,rep,name=product_labels,json=productLabels,proto3" json:"product_labels,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Product) Reset()         { *m = Product{} }
func (m *Product) String() string { return proto.CompactTextString(m) }
func (*Product) ProtoMessage()    {}
func (*Product) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{0}
}
func (m *Product) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Product.Unmarshal(m, b)
}
func (m *Product) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Product.Marshal(b, m, deterministic)
}
func (dst *Product) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Product.Merge(dst, src)
}
func (m *Product) XXX_Size() int {
	return xxx_messageInfo_Product.Size(m)
}
func (m *Product) XXX_DiscardUnknown() {
	xxx_messageInfo_Product.DiscardUnknown(m)
}

var xxx_messageInfo_Product proto.InternalMessageInfo

func (m *Product) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Product) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Product) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Product) GetProductCategory() string {
	if m != nil {
		return m.ProductCategory
	}
	return ""
}

func (m *Product) GetProductLabels() []*Product_KeyValue {
	if m != nil {
		return m.ProductLabels
	}
	return nil
}

// A product label represented as a key-value pair.
type Product_KeyValue struct {
	// The key of the label attached to the product. Cannot be empty and cannot
	// exceed 128 bytes.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value of the label attached to the product. Cannot be empty and
	// cannot exceed 128 bytes.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Product_KeyValue) Reset()         { *m = Product_KeyValue{} }
func (m *Product_KeyValue) String() string { return proto.CompactTextString(m) }
func (*Product_KeyValue) ProtoMessage()    {}
func (*Product_KeyValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{0, 0}
}
func (m *Product_KeyValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Product_KeyValue.Unmarshal(m, b)
}
func (m *Product_KeyValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Product_KeyValue.Marshal(b, m, deterministic)
}
func (dst *Product_KeyValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Product_KeyValue.Merge(dst, src)
}
func (m *Product_KeyValue) XXX_Size() int {
	return xxx_messageInfo_Product_KeyValue.Size(m)
}
func (m *Product_KeyValue) XXX_DiscardUnknown() {
	xxx_messageInfo_Product_KeyValue.DiscardUnknown(m)
}

var xxx_messageInfo_Product_KeyValue proto.InternalMessageInfo

func (m *Product_KeyValue) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Product_KeyValue) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A ProductSet contains Products. A ProductSet can contain a maximum of 1
// million reference images. If the limit is exceeded, periodic indexing will
// fail.
type ProductSet struct {
	// The resource name of the ProductSet.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
	//
	// This field is ignored when creating a ProductSet.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The user-provided name for this ProductSet. Must not be empty. Must be at
	// most 4096 characters long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The time at which this ProductSet was last indexed. Query
	// results will reflect all updates before this time. If this ProductSet has
	// never been indexed, this timestamp is the default value
	// "1970-01-01T00:00:00Z".
	//
	// This field is ignored when creating a ProductSet.
	IndexTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=index_time,json=indexTime,proto3" json:"index_time,omitempty"`
	// Output only. If there was an error with indexing the product set, the field
	// is populated.
	//
	// This field is ignored when creating a ProductSet.
	IndexError           *status.Status `protobuf:"bytes,4,opt,name=index_error,json=indexError,proto3" json:"index_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ProductSet) Reset()         { *m = ProductSet{} }
func (m *ProductSet) String() string { return proto.CompactTextString(m) }
func (*ProductSet) ProtoMessage()    {}
func (*ProductSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{1}
}
func (m *ProductSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductSet.Unmarshal(m, b)
}
func (m *ProductSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductSet.Marshal(b, m, deterministic)
}
func (dst *ProductSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductSet.Merge(dst, src)
}
func (m *ProductSet) XXX_Size() int {
	return xxx_messageInfo_ProductSet.Size(m)
}
func (m *ProductSet) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductSet.DiscardUnknown(m)
}

var xxx_messageInfo_ProductSet proto.InternalMessageInfo

func (m *ProductSet) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ProductSet) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *ProductSet) GetIndexTime() *timestamp.Timestamp {
	if m != nil {
		return m.IndexTime
	}
	return nil
}

func (m *ProductSet) GetIndexError() *status.Status {
	if m != nil {
		return m.IndexError
	}
	return nil
}

// A `ReferenceImage` represents a product image and its associated metadata,
// such as bounding boxes.
type ReferenceImage struct {
	// The resource name of the reference image.
	//
	// Format is:
	//
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
	//
	// This field is ignored when creating a reference image.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The Google Cloud Storage URI of the reference image.
	//
	// The URI must start with `gs://`.
	//
	// Required.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Bounding polygons around the areas of interest in the reference image.
	// Optional. If this field is empty, the system will try to detect regions of
	// interest. At most 10 bounding polygons will be used.
	//
	// The provided shape is converted into a non-rotated rectangle. Once
	// converted, the small edge of the rectangle must be greater than or equal
	// to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
	// is not).
	BoundingPolys        []*BoundingPoly `protobuf:"bytes,3,rep,name=bounding_polys,json=boundingPolys,proto3" json:"bounding_polys,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ReferenceImage) Reset()         { *m = ReferenceImage{} }
func (m *ReferenceImage) String() string { return proto.CompactTextString(m) }
func (*ReferenceImage) ProtoMessage()    {}
func (*ReferenceImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{2}
}
func (m *ReferenceImage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReferenceImage.Unmarshal(m, b)
}
func (m *ReferenceImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReferenceImage.Marshal(b, m, deterministic)
}
func (dst *ReferenceImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReferenceImage.Merge(dst, src)
}
func (m *ReferenceImage) XXX_Size() int {
	return xxx_messageInfo_ReferenceImage.Size(m)
}
func (m *ReferenceImage) XXX_DiscardUnknown() {
	xxx_messageInfo_ReferenceImage.DiscardUnknown(m)
}

var xxx_messageInfo_ReferenceImage proto.InternalMessageInfo

func (m *ReferenceImage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ReferenceImage) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *ReferenceImage) GetBoundingPolys() []*BoundingPoly {
	if m != nil {
		return m.BoundingPolys
	}
	return nil
}

// Request message for the `CreateProduct` method.
type CreateProductRequest struct {
	// The project in which the Product should be created.
	//
	// Format is
	// `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The product to create.
	Product *Product `protobuf:"bytes,2,opt,name=product,proto3" json:"product,omitempty"`
	// A user-supplied resource id for this Product. If set, the server will
	// attempt to use this value as the resource id. If it is already in use, an
	// error is returned with code ALREADY_EXISTS. Must be at most 128 characters
	// long. It cannot contain the character `/`.
	ProductId            string   `protobuf:"bytes,3,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateProductRequest) Reset()         { *m = CreateProductRequest{} }
func (m *CreateProductRequest) String() string { return proto.CompactTextString(m) }
func (*CreateProductRequest) ProtoMessage()    {}
func (*CreateProductRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{3}
}
func (m *CreateProductRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateProductRequest.Unmarshal(m, b)
}
func (m *CreateProductRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateProductRequest.Marshal(b, m, deterministic)
}
func (dst *CreateProductRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateProductRequest.Merge(dst, src)
}
func (m *CreateProductRequest) XXX_Size() int {
	return xxx_messageInfo_CreateProductRequest.Size(m)
}
func (m *CreateProductRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateProductRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateProductRequest proto.InternalMessageInfo

func (m *CreateProductRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateProductRequest) GetProduct() *Product {
	if m != nil {
		return m.Product
	}
	return nil
}

func (m *CreateProductRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

// Request message for the `ListProducts` method.
type ListProductsRequest struct {
	// The project OR ProductSet from which Products should be listed.
	//
	// Format:
	// `projects/PROJECT_ID/locations/LOC_ID`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductsRequest) Reset()         { *m = ListProductsRequest{} }
func (m *ListProductsRequest) String() string { return proto.CompactTextString(m) }
func (*ListProductsRequest) ProtoMessage()    {}
func (*ListProductsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{4}
}
func (m *ListProductsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductsRequest.Unmarshal(m, b)
}
func (m *ListProductsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductsRequest.Marshal(b, m, deterministic)
}
func (dst *ListProductsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductsRequest.Merge(dst, src)
}
func (m *ListProductsRequest) XXX_Size() int {
	return xxx_messageInfo_ListProductsRequest.Size(m)
}
func (m *ListProductsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductsRequest proto.InternalMessageInfo

func (m *ListProductsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListProductsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListProductsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for the `ListProducts` method.
type ListProductsResponse struct {
	// List of products.
	Products []*Product `protobuf:"bytes,1,rep,name=products,proto3" json:"products,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductsResponse) Reset()         { *m = ListProductsResponse{} }
func (m *ListProductsResponse) String() string { return proto.CompactTextString(m) }
func (*ListProductsResponse) ProtoMessage()    {}
func (*ListProductsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{5}
}
func (m *ListProductsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductsResponse.Unmarshal(m, b)
}
func (m *ListProductsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductsResponse.Marshal(b, m, deterministic)
}
func (dst *ListProductsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductsResponse.Merge(dst, src)
}
func (m *ListProductsResponse) XXX_Size() int {
	return xxx_messageInfo_ListProductsResponse.Size(m)
}
func (m *ListProductsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductsResponse proto.InternalMessageInfo

func (m *ListProductsResponse) GetProducts() []*Product {
	if m != nil {
		return m.Products
	}
	return nil
}

func (m *ListProductsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for the `GetProduct` method.
type GetProductRequest struct {
	// Resource name of the Product to get.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetProductRequest) Reset()         { *m = GetProductRequest{} }
func (m *GetProductRequest) String() string { return proto.CompactTextString(m) }
func (*GetProductRequest) ProtoMessage()    {}
func (*GetProductRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{6}
}
func (m *GetProductRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetProductRequest.Unmarshal(m, b)
}
func (m *GetProductRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetProductRequest.Marshal(b, m, deterministic)
}
func (dst *GetProductRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProductRequest.Merge(dst, src)
}
func (m *GetProductRequest) XXX_Size() int {
	return xxx_messageInfo_GetProductRequest.Size(m)
}
func (m *GetProductRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProductRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetProductRequest proto.InternalMessageInfo

func (m *GetProductRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `UpdateProduct` method.
type UpdateProductRequest struct {
	// The Product resource which replaces the one on the server.
	// product.name is immutable.
	Product *Product `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
	// The [FieldMask][google.protobuf.FieldMask] that specifies which fields
	// to update.
	// If update_mask isn't specified, all mutable fields are to be updated.
	// Valid mask paths include `product_labels`, `display_name`, and
	// `description`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateProductRequest) Reset()         { *m = UpdateProductRequest{} }
func (m *UpdateProductRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateProductRequest) ProtoMessage()    {}
func (*UpdateProductRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{7}
}
func (m *UpdateProductRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateProductRequest.Unmarshal(m, b)
}
func (m *UpdateProductRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateProductRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateProductRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateProductRequest.Merge(dst, src)
}
func (m *UpdateProductRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateProductRequest.Size(m)
}
func (m *UpdateProductRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateProductRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateProductRequest proto.InternalMessageInfo

func (m *UpdateProductRequest) GetProduct() *Product {
	if m != nil {
		return m.Product
	}
	return nil
}

func (m *UpdateProductRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for the `DeleteProduct` method.
type DeleteProductRequest struct {
	// Resource name of product to delete.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteProductRequest) Reset()         { *m = DeleteProductRequest{} }
func (m *DeleteProductRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteProductRequest) ProtoMessage()    {}
func (*DeleteProductRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{8}
}
func (m *DeleteProductRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteProductRequest.Unmarshal(m, b)
}
func (m *DeleteProductRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteProductRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteProductRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteProductRequest.Merge(dst, src)
}
func (m *DeleteProductRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteProductRequest.Size(m)
}
func (m *DeleteProductRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteProductRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteProductRequest proto.InternalMessageInfo

func (m *DeleteProductRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `CreateProductSet` method.
type CreateProductSetRequest struct {
	// The project in which the ProductSet should be created.
	//
	// Format is `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The ProductSet to create.
	ProductSet *ProductSet `protobuf:"bytes,2,opt,name=product_set,json=productSet,proto3" json:"product_set,omitempty"`
	// A user-supplied resource id for this ProductSet. If set, the server will
	// attempt to use this value as the resource id. If it is already in use, an
	// error is returned with code ALREADY_EXISTS. Must be at most 128 characters
	// long. It cannot contain the character `/`.
	ProductSetId         string   `protobuf:"bytes,3,opt,name=product_set_id,json=productSetId,proto3" json:"product_set_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateProductSetRequest) Reset()         { *m = CreateProductSetRequest{} }
func (m *CreateProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateProductSetRequest) ProtoMessage()    {}
func (*CreateProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{9}
}
func (m *CreateProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateProductSetRequest.Unmarshal(m, b)
}
func (m *CreateProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateProductSetRequest.Marshal(b, m, deterministic)
}
func (dst *CreateProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateProductSetRequest.Merge(dst, src)
}
func (m *CreateProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateProductSetRequest.Size(m)
}
func (m *CreateProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateProductSetRequest proto.InternalMessageInfo

func (m *CreateProductSetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateProductSetRequest) GetProductSet() *ProductSet {
	if m != nil {
		return m.ProductSet
	}
	return nil
}

func (m *CreateProductSetRequest) GetProductSetId() string {
	if m != nil {
		return m.ProductSetId
	}
	return ""
}

// Request message for the `ListProductSets` method.
type ListProductSetsRequest struct {
	// The project from which ProductSets should be listed.
	//
	// Format is `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductSetsRequest) Reset()         { *m = ListProductSetsRequest{} }
func (m *ListProductSetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListProductSetsRequest) ProtoMessage()    {}
func (*ListProductSetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{10}
}
func (m *ListProductSetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductSetsRequest.Unmarshal(m, b)
}
func (m *ListProductSetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductSetsRequest.Marshal(b, m, deterministic)
}
func (dst *ListProductSetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductSetsRequest.Merge(dst, src)
}
func (m *ListProductSetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListProductSetsRequest.Size(m)
}
func (m *ListProductSetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductSetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductSetsRequest proto.InternalMessageInfo

func (m *ListProductSetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListProductSetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListProductSetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for the `ListProductSets` method.
type ListProductSetsResponse struct {
	// List of ProductSets.
	ProductSets []*ProductSet `protobuf:"bytes,1,rep,name=product_sets,json=productSets,proto3" json:"product_sets,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductSetsResponse) Reset()         { *m = ListProductSetsResponse{} }
func (m *ListProductSetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListProductSetsResponse) ProtoMessage()    {}
func (*ListProductSetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{11}
}
func (m *ListProductSetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductSetsResponse.Unmarshal(m, b)
}
func (m *ListProductSetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductSetsResponse.Marshal(b, m, deterministic)
}
func (dst *ListProductSetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductSetsResponse.Merge(dst, src)
}
func (m *ListProductSetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListProductSetsResponse.Size(m)
}
func (m *ListProductSetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductSetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductSetsResponse proto.InternalMessageInfo

func (m *ListProductSetsResponse) GetProductSets() []*ProductSet {
	if m != nil {
		return m.ProductSets
	}
	return nil
}

func (m *ListProductSetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for the `GetProductSet` method.
type GetProductSetRequest struct {
	// Resource name of the ProductSet to get.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOG_ID/productSets/PRODUCT_SET_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetProductSetRequest) Reset()         { *m = GetProductSetRequest{} }
func (m *GetProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*GetProductSetRequest) ProtoMessage()    {}
func (*GetProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{12}
}
func (m *GetProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetProductSetRequest.Unmarshal(m, b)
}
func (m *GetProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetProductSetRequest.Marshal(b, m, deterministic)
}
func (dst *GetProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProductSetRequest.Merge(dst, src)
}
func (m *GetProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_GetProductSetRequest.Size(m)
}
func (m *GetProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetProductSetRequest proto.InternalMessageInfo

func (m *GetProductSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `UpdateProductSet` method.
type UpdateProductSetRequest struct {
	// The ProductSet resource which replaces the one on the server.
	ProductSet *ProductSet `protobuf:"bytes,1,opt,name=product_set,json=productSet,proto3" json:"product_set,omitempty"`
	// The [FieldMask][google.protobuf.FieldMask] that specifies which fields to
	// update.
	// If update_mask isn't specified, all mutable fields are to be updated.
	// Valid mask path is `display_name`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateProductSetRequest) Reset()         { *m = UpdateProductSetRequest{} }
func (m *UpdateProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateProductSetRequest) ProtoMessage()    {}
func (*UpdateProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{13}
}
func (m *UpdateProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateProductSetRequest.Unmarshal(m, b)
}
func (m *UpdateProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateProductSetRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateProductSetRequest.Merge(dst, src)
}
func (m *UpdateProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateProductSetRequest.Size(m)
}
func (m *UpdateProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateProductSetRequest proto.InternalMessageInfo

func (m *UpdateProductSetRequest) GetProductSet() *ProductSet {
	if m != nil {
		return m.ProductSet
	}
	return nil
}

func (m *UpdateProductSetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for the `DeleteProductSet` method.
type DeleteProductSetRequest struct {
	// Resource name of the ProductSet to delete.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteProductSetRequest) Reset()         { *m = DeleteProductSetRequest{} }
func (m *DeleteProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteProductSetRequest) ProtoMessage()    {}
func (*DeleteProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{14}
}
func (m *DeleteProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteProductSetRequest.Unmarshal(m, b)
}
func (m *DeleteProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteProductSetRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteProductSetRequest.Merge(dst, src)
}
func (m *DeleteProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteProductSetRequest.Size(m)
}
func (m *DeleteProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteProductSetRequest proto.InternalMessageInfo

func (m *DeleteProductSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `CreateReferenceImage` method.
type CreateReferenceImageRequest struct {
	// Resource name of the product in which to create the reference image.
	//
	// Format is
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The reference image to create.
	// If an image ID is specified, it is ignored.
	ReferenceImage *ReferenceImage `protobuf:"bytes,2,opt,name=reference_image,json=referenceImage,proto3" json:"reference_image,omitempty"`
	// A user-supplied resource id for the ReferenceImage to be added. If set,
	// the server will attempt to use this value as the resource id. If it is
	// already in use, an error is returned with code ALREADY_EXISTS. Must be at
	// most 128 characters long. It cannot contain the character `/`.
	ReferenceImageId     string   `protobuf:"bytes,3,opt,name=reference_image_id,json=referenceImageId,proto3" json:"reference_image_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateReferenceImageRequest) Reset()         { *m = CreateReferenceImageRequest{} }
func (m *CreateReferenceImageRequest) String() string { return proto.CompactTextString(m) }
func (*CreateReferenceImageRequest) ProtoMessage()    {}
func (*CreateReferenceImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{15}
}
func (m *CreateReferenceImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateReferenceImageRequest.Unmarshal(m, b)
}
func (m *CreateReferenceImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateReferenceImageRequest.Marshal(b, m, deterministic)
}
func (dst *CreateReferenceImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateReferenceImageRequest.Merge(dst, src)
}
func (m *CreateReferenceImageRequest) XXX_Size() int {
	return xxx_messageInfo_CreateReferenceImageRequest.Size(m)
}
func (m *CreateReferenceImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateReferenceImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateReferenceImageRequest proto.InternalMessageInfo

func (m *CreateReferenceImageRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateReferenceImageRequest) GetReferenceImage() *ReferenceImage {
	if m != nil {
		return m.ReferenceImage
	}
	return nil
}

func (m *CreateReferenceImageRequest) GetReferenceImageId() string {
	if m != nil {
		return m.ReferenceImageId
	}
	return ""
}

// Request message for the `ListReferenceImages` method.
type ListReferenceImagesRequest struct {
	// Resource name of the product containing the reference images.
	//
	// Format is
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results to be returned. This is the value
	// of `nextPageToken` returned in a previous reference image list request.
	//
	// Defaults to the first page if not specified.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListReferenceImagesRequest) Reset()         { *m = ListReferenceImagesRequest{} }
func (m *ListReferenceImagesRequest) String() string { return proto.CompactTextString(m) }
func (*ListReferenceImagesRequest) ProtoMessage()    {}
func (*ListReferenceImagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{16}
}
func (m *ListReferenceImagesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListReferenceImagesRequest.Unmarshal(m, b)
}
func (m *ListReferenceImagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListReferenceImagesRequest.Marshal(b, m, deterministic)
}
func (dst *ListReferenceImagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReferenceImagesRequest.Merge(dst, src)
}
func (m *ListReferenceImagesRequest) XXX_Size() int {
	return xxx_messageInfo_ListReferenceImagesRequest.Size(m)
}
func (m *ListReferenceImagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReferenceImagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListReferenceImagesRequest proto.InternalMessageInfo

func (m *ListReferenceImagesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListReferenceImagesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListReferenceImagesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for the `ListReferenceImages` method.
type ListReferenceImagesResponse struct {
	// The list of reference images.
	ReferenceImages []*ReferenceImage `protobuf:"bytes,1,rep,name=reference_images,json=referenceImages,proto3" json:"reference_images,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	NextPageToken        string   `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListReferenceImagesResponse) Reset()         { *m = ListReferenceImagesResponse{} }
func (m *ListReferenceImagesResponse) String() string { return proto.CompactTextString(m) }
func (*ListReferenceImagesResponse) ProtoMessage()    {}
func (*ListReferenceImagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{17}
}
func (m *ListReferenceImagesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListReferenceImagesResponse.Unmarshal(m, b)
}
func (m *ListReferenceImagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListReferenceImagesResponse.Marshal(b, m, deterministic)
}
func (dst *ListReferenceImagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReferenceImagesResponse.Merge(dst, src)
}
func (m *ListReferenceImagesResponse) XXX_Size() int {
	return xxx_messageInfo_ListReferenceImagesResponse.Size(m)
}
func (m *ListReferenceImagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReferenceImagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListReferenceImagesResponse proto.InternalMessageInfo

func (m *ListReferenceImagesResponse) GetReferenceImages() []*ReferenceImage {
	if m != nil {
		return m.ReferenceImages
	}
	return nil
}

func (m *ListReferenceImagesResponse) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListReferenceImagesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for the `GetReferenceImage` method.
type GetReferenceImageRequest struct {
	// The resource name of the ReferenceImage to get.
	//
	// Format is:
	//
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetReferenceImageRequest) Reset()         { *m = GetReferenceImageRequest{} }
func (m *GetReferenceImageRequest) String() string { return proto.CompactTextString(m) }
func (*GetReferenceImageRequest) ProtoMessage()    {}
func (*GetReferenceImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{18}
}
func (m *GetReferenceImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetReferenceImageRequest.Unmarshal(m, b)
}
func (m *GetReferenceImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetReferenceImageRequest.Marshal(b, m, deterministic)
}
func (dst *GetReferenceImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReferenceImageRequest.Merge(dst, src)
}
func (m *GetReferenceImageRequest) XXX_Size() int {
	return xxx_messageInfo_GetReferenceImageRequest.Size(m)
}
func (m *GetReferenceImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReferenceImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetReferenceImageRequest proto.InternalMessageInfo

func (m *GetReferenceImageRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `DeleteReferenceImage` method.
type DeleteReferenceImageRequest struct {
	// The resource name of the reference image to delete.
	//
	// Format is:
	//
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteReferenceImageRequest) Reset()         { *m = DeleteReferenceImageRequest{} }
func (m *DeleteReferenceImageRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteReferenceImageRequest) ProtoMessage()    {}
func (*DeleteReferenceImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{19}
}
func (m *DeleteReferenceImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteReferenceImageRequest.Unmarshal(m, b)
}
func (m *DeleteReferenceImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteReferenceImageRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteReferenceImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteReferenceImageRequest.Merge(dst, src)
}
func (m *DeleteReferenceImageRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteReferenceImageRequest.Size(m)
}
func (m *DeleteReferenceImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteReferenceImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteReferenceImageRequest proto.InternalMessageInfo

func (m *DeleteReferenceImageRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `AddProductToProductSet` method.
type AddProductToProductSetRequest struct {
	// The resource name for the ProductSet to modify.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource name for the Product to be added to this ProductSet.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Product              string   `protobuf:"bytes,2,opt,name=product,proto3" json:"product,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddProductToProductSetRequest) Reset()         { *m = AddProductToProductSetRequest{} }
func (m *AddProductToProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*AddProductToProductSetRequest) ProtoMessage()    {}
func (*AddProductToProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{20}
}
func (m *AddProductToProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddProductToProductSetRequest.Unmarshal(m, b)
}
func (m *AddProductToProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddProductToProductSetRequest.Marshal(b, m, deterministic)
}
func (dst *AddProductToProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddProductToProductSetRequest.Merge(dst, src)
}
func (m *AddProductToProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_AddProductToProductSetRequest.Size(m)
}
func (m *AddProductToProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddProductToProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddProductToProductSetRequest proto.InternalMessageInfo

func (m *AddProductToProductSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AddProductToProductSetRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

// Request message for the `RemoveProductFromProductSet` method.
type RemoveProductFromProductSetRequest struct {
	// The resource name for the ProductSet to modify.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource name for the Product to be removed from this ProductSet.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Product              string   `protobuf:"bytes,2,opt,name=product,proto3" json:"product,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveProductFromProductSetRequest) Reset()         { *m = RemoveProductFromProductSetRequest{} }
func (m *RemoveProductFromProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*RemoveProductFromProductSetRequest) ProtoMessage()    {}
func (*RemoveProductFromProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{21}
}
func (m *RemoveProductFromProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveProductFromProductSetRequest.Unmarshal(m, b)
}
func (m *RemoveProductFromProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveProductFromProductSetRequest.Marshal(b, m, deterministic)
}
func (dst *RemoveProductFromProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveProductFromProductSetRequest.Merge(dst, src)
}
func (m *RemoveProductFromProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_RemoveProductFromProductSetRequest.Size(m)
}
func (m *RemoveProductFromProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveProductFromProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveProductFromProductSetRequest proto.InternalMessageInfo

func (m *RemoveProductFromProductSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RemoveProductFromProductSetRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

// Request message for the `ListProductsInProductSet` method.
type ListProductsInProductSetRequest struct {
	// The ProductSet resource for which to retrieve Products.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductsInProductSetRequest) Reset()         { *m = ListProductsInProductSetRequest{} }
func (m *ListProductsInProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*ListProductsInProductSetRequest) ProtoMessage()    {}
func (*ListProductsInProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{22}
}
func (m *ListProductsInProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductsInProductSetRequest.Unmarshal(m, b)
}
func (m *ListProductsInProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductsInProductSetRequest.Marshal(b, m, deterministic)
}
func (dst *ListProductsInProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductsInProductSetRequest.Merge(dst, src)
}
func (m *ListProductsInProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_ListProductsInProductSetRequest.Size(m)
}
func (m *ListProductsInProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductsInProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductsInProductSetRequest proto.InternalMessageInfo

func (m *ListProductsInProductSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListProductsInProductSetRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListProductsInProductSetRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for the `ListProductsInProductSet` method.
type ListProductsInProductSetResponse struct {
	// The list of Products.
	Products []*Product `protobuf:"bytes,1,rep,name=products,proto3" json:"products,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductsInProductSetResponse) Reset()         { *m = ListProductsInProductSetResponse{} }
func (m *ListProductsInProductSetResponse) String() string { return proto.CompactTextString(m) }
func (*ListProductsInProductSetResponse) ProtoMessage()    {}
func (*ListProductsInProductSetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{23}
}
func (m *ListProductsInProductSetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductsInProductSetResponse.Unmarshal(m, b)
}
func (m *ListProductsInProductSetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductsInProductSetResponse.Marshal(b, m, deterministic)
}
func (dst *ListProductsInProductSetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductsInProductSetResponse.Merge(dst, src)
}
func (m *ListProductsInProductSetResponse) XXX_Size() int {
	return xxx_messageInfo_ListProductsInProductSetResponse.Size(m)
}
func (m *ListProductsInProductSetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductsInProductSetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductsInProductSetResponse proto.InternalMessageInfo

func (m *ListProductsInProductSetResponse) GetProducts() []*Product {
	if m != nil {
		return m.Products
	}
	return nil
}

func (m *ListProductsInProductSetResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The Google Cloud Storage location for a csv file which preserves a list of
// ImportProductSetRequests in each line.
type ImportProductSetsGcsSource struct {
	// The Google Cloud Storage URI of the input csv file.
	//
	// The URI must start with `gs://`.
	//
	// The format of the input csv file should be one image per line.
	// In each line, there are 8 columns.
	//
	// 1.  image-uri
	// 2.  image-id
	// 3.  product-set-id
	// 4.  product-id
	// 5.  product-category
	// 6.  product-display-name
	// 7.  labels
	// 8.  bounding-poly
	//
	// The `image-uri`, `product-set-id`, `product-id`, and `product-category`
	// columns are required. All other columns are optional.
	//
	// If the `ProductSet` or `Product` specified by the `product-set-id` and
	// `product-id` values does not exist, then the system will create a new
	// `ProductSet` or `Product` for the image. In this case, the
	// `product-display-name` column refers to
	// [display_name][google.cloud.vision.v1.Product.display_name], the
	// `product-category` column refers to
	// [product_category][google.cloud.vision.v1.Product.product_category], and
	// the `labels` column refers to
	// [product_labels][google.cloud.vision.v1.Product.product_labels].
	//
	// The `image-id` column is optional but must be unique if provided. If it is
	// empty, the system will automatically assign a unique id to the image.
	//
	// The `product-display-name` column is optional. If it is empty, the system
	// sets the [display_name][google.cloud.vision.v1.Product.display_name] field
	// for the product to a space (" "). You can update the `display_name` later
	// by using the API.
	//
	// If a `Product` with the specified `product-id` already exists, then the
	// system ignores the `product-display-name`, `product-category`, and `labels`
	// columns.
	//
	// The `labels` column (optional) is a line containing a list of
	// comma-separated key-value pairs, in the following format:
	//
	//     "key_1=value_1,key_2=value_2,...,key_n=value_n"
	//
	// The `bounding-poly` column (optional) identifies one region of
	// interest from the image in the same manner as `CreateReferenceImage`. If
	// you do not specify the `bounding-poly` column, then the system will try to
	// detect regions of interest automatically.
	//
	// At most one `bounding-poly` column is allowed per line. If the image
	// contains multiple regions of interest, add a line to the CSV file that
	// includes the same product information, and the `bounding-poly` values for
	// each region of interest.
	//
	// The `bounding-poly` column must contain an even number of comma-separated
	// numbers, in the format "p1_x,p1_y,p2_x,p2_y,...,pn_x,pn_y". Use
	// non-negative integers for absolute bounding polygons, and float values
	// in [0, 1] for normalized bounding polygons.
	//
	// The system will resize the image if the image resolution is too
	// large to process (larger than 20MP).
	CsvFileUri           string   `protobuf:"bytes,1,opt,name=csv_file_uri,json=csvFileUri,proto3" json:"csv_file_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportProductSetsGcsSource) Reset()         { *m = ImportProductSetsGcsSource{} }
func (m *ImportProductSetsGcsSource) String() string { return proto.CompactTextString(m) }
func (*ImportProductSetsGcsSource) ProtoMessage()    {}
func (*ImportProductSetsGcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{24}
}
func (m *ImportProductSetsGcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportProductSetsGcsSource.Unmarshal(m, b)
}
func (m *ImportProductSetsGcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportProductSetsGcsSource.Marshal(b, m, deterministic)
}
func (dst *ImportProductSetsGcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportProductSetsGcsSource.Merge(dst, src)
}
func (m *ImportProductSetsGcsSource) XXX_Size() int {
	return xxx_messageInfo_ImportProductSetsGcsSource.Size(m)
}
func (m *ImportProductSetsGcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportProductSetsGcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_ImportProductSetsGcsSource proto.InternalMessageInfo

func (m *ImportProductSetsGcsSource) GetCsvFileUri() string {
	if m != nil {
		return m.CsvFileUri
	}
	return ""
}

// The input content for the `ImportProductSets` method.
type ImportProductSetsInputConfig struct {
	// The source of the input.
	//
	// Types that are valid to be assigned to Source:
	//	*ImportProductSetsInputConfig_GcsSource
	Source               isImportProductSetsInputConfig_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *ImportProductSetsInputConfig) Reset()         { *m = ImportProductSetsInputConfig{} }
func (m *ImportProductSetsInputConfig) String() string { return proto.CompactTextString(m) }
func (*ImportProductSetsInputConfig) ProtoMessage()    {}
func (*ImportProductSetsInputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{25}
}
func (m *ImportProductSetsInputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportProductSetsInputConfig.Unmarshal(m, b)
}
func (m *ImportProductSetsInputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportProductSetsInputConfig.Marshal(b, m, deterministic)
}
func (dst *ImportProductSetsInputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportProductSetsInputConfig.Merge(dst, src)
}
func (m *ImportProductSetsInputConfig) XXX_Size() int {
	return xxx_messageInfo_ImportProductSetsInputConfig.Size(m)
}
func (m *ImportProductSetsInputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportProductSetsInputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ImportProductSetsInputConfig proto.InternalMessageInfo

type isImportProductSetsInputConfig_Source interface {
	isImportProductSetsInputConfig_Source()
}

type ImportProductSetsInputConfig_GcsSource struct {
	GcsSource *ImportProductSetsGcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*ImportProductSetsInputConfig_GcsSource) isImportProductSetsInputConfig_Source() {}

func (m *ImportProductSetsInputConfig) GetSource() isImportProductSetsInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *ImportProductSetsInputConfig) GetGcsSource() *ImportProductSetsGcsSource {
	if x, ok := m.GetSource().(*ImportProductSetsInputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ImportProductSetsInputConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ImportProductSetsInputConfig_OneofMarshaler, _ImportProductSetsInputConfig_OneofUnmarshaler, _ImportProductSetsInputConfig_OneofSizer, []interface{}{
		(*ImportProductSetsInputConfig_GcsSource)(nil),
	}
}

func _ImportProductSetsInputConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ImportProductSetsInputConfig)
	// source
	switch x := m.Source.(type) {
	case *ImportProductSetsInputConfig_GcsSource:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GcsSource); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ImportProductSetsInputConfig.Source has unexpected type %T", x)
	}
	return nil
}

func _ImportProductSetsInputConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ImportProductSetsInputConfig)
	switch tag {
	case 1: // source.gcs_source
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ImportProductSetsGcsSource)
		err := b.DecodeMessage(msg)
		m.Source = &ImportProductSetsInputConfig_GcsSource{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ImportProductSetsInputConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ImportProductSetsInputConfig)
	// source
	switch x := m.Source.(type) {
	case *ImportProductSetsInputConfig_GcsSource:
		s := proto.Size(x.GcsSource)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request message for the `ImportProductSets` method.
type ImportProductSetsRequest struct {
	// The project in which the ProductSets should be imported.
	//
	// Format is `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The input content for the list of requests.
	InputConfig          *ImportProductSetsInputConfig `protobuf:"bytes,2,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *ImportProductSetsRequest) Reset()         { *m = ImportProductSetsRequest{} }
func (m *ImportProductSetsRequest) String() string { return proto.CompactTextString(m) }
func (*ImportProductSetsRequest) ProtoMessage()    {}
func (*ImportProductSetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{26}
}
func (m *ImportProductSetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportProductSetsRequest.Unmarshal(m, b)
}
func (m *ImportProductSetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportProductSetsRequest.Marshal(b, m, deterministic)
}
func (dst *ImportProductSetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportProductSetsRequest.Merge(dst, src)
}
func (m *ImportProductSetsRequest) XXX_Size() int {
	return xxx_messageInfo_ImportProductSetsRequest.Size(m)
}
func (m *ImportProductSetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportProductSetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportProductSetsRequest proto.InternalMessageInfo

func (m *ImportProductSetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ImportProductSetsRequest) GetInputConfig() *ImportProductSetsInputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

// Response message for the `ImportProductSets` method.
//
// This message is returned by the
// [google.longrunning.Operations.GetOperation][google.longrunning.Operations.GetOperation]
// method in the returned
// [google.longrunning.Operation.response][google.longrunning.Operation.response]
// field.
type ImportProductSetsResponse struct {
	// The list of reference_images that are imported successfully.
	ReferenceImages []*ReferenceImage `protobuf:"bytes,1,rep,name=reference_images,json=referenceImages,proto3" json:"reference_images,omitempty"`
	// The rpc status for each ImportProductSet request, including both successes
	// and errors.
	//
	// The number of statuses here matches the number of lines in the csv file,
	// and statuses[i] stores the success or failure status of processing the i-th
	// line of the csv, starting from line 0.
	Statuses             []*status.Status `protobuf:"bytes,2,rep,name=statuses,proto3" json:"statuses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ImportProductSetsResponse) Reset()         { *m = ImportProductSetsResponse{} }
func (m *ImportProductSetsResponse) String() string { return proto.CompactTextString(m) }
func (*ImportProductSetsResponse) ProtoMessage()    {}
func (*ImportProductSetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{27}
}
func (m *ImportProductSetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportProductSetsResponse.Unmarshal(m, b)
}
func (m *ImportProductSetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportProductSetsResponse.Marshal(b, m, deterministic)
}
func (dst *ImportProductSetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportProductSetsResponse.Merge(dst, src)
}
func (m *ImportProductSetsResponse) XXX_Size() int {
	return xxx_messageInfo_ImportProductSetsResponse.Size(m)
}
func (m *ImportProductSetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportProductSetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImportProductSetsResponse proto.InternalMessageInfo

func (m *ImportProductSetsResponse) GetReferenceImages() []*ReferenceImage {
	if m != nil {
		return m.ReferenceImages
	}
	return nil
}

func (m *ImportProductSetsResponse) GetStatuses() []*status.Status {
	if m != nil {
		return m.Statuses
	}
	return nil
}

// Metadata for the batch operations such as the current state.
//
// This is included in the `metadata` field of the `Operation` returned by the
// `GetOperation` call of the `google::longrunning::Operations` service.
type BatchOperationMetadata struct {
	// The current state of the batch operation.
	State BatchOperationMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.vision.v1.BatchOperationMetadata_State" json:"state,omitempty"`
	// The time when the batch request was submitted to the server.
	SubmitTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// The time when the batch request is finished and
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] is
	// set to true.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *BatchOperationMetadata) Reset()         { *m = BatchOperationMetadata{} }
func (m *BatchOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*BatchOperationMetadata) ProtoMessage()    {}
func (*BatchOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_product_search_service_05b23c95580d8dfa, []int{28}
}
func (m *BatchOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchOperationMetadata.Unmarshal(m, b)
}
func (m *BatchOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *BatchOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchOperationMetadata.Merge(dst, src)
}
func (m *BatchOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_BatchOperationMetadata.Size(m)
}
func (m *BatchOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BatchOperationMetadata proto.InternalMessageInfo

func (m *BatchOperationMetadata) GetState() BatchOperationMetadata_State {
	if m != nil {
		return m.State
	}
	return BatchOperationMetadata_STATE_UNSPECIFIED
}

func (m *BatchOperationMetadata) GetSubmitTime() *timestamp.Timestamp {
	if m != nil {
		return m.SubmitTime
	}
	return nil
}

func (m *BatchOperationMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func init() {
	proto.RegisterType((*Product)(nil), "google.cloud.vision.v1.Product")
	proto.RegisterType((*Product_KeyValue)(nil), "google.cloud.vision.v1.Product.KeyValue")
	proto.RegisterType((*ProductSet)(nil), "google.cloud.vision.v1.ProductSet")
	proto.RegisterType((*ReferenceImage)(nil), "google.cloud.vision.v1.ReferenceImage")
	proto.RegisterType((*CreateProductRequest)(nil), "google.cloud.vision.v1.CreateProductRequest")
	proto.RegisterType((*ListProductsRequest)(nil), "google.cloud.vision.v1.ListProductsRequest")
	proto.RegisterType((*ListProductsResponse)(nil), "google.cloud.vision.v1.ListProductsResponse")
	proto.RegisterType((*GetProductRequest)(nil), "google.cloud.vision.v1.GetProductRequest")
	proto.RegisterType((*UpdateProductRequest)(nil), "google.cloud.vision.v1.UpdateProductRequest")
	proto.RegisterType((*DeleteProductRequest)(nil), "google.cloud.vision.v1.DeleteProductRequest")
	proto.RegisterType((*CreateProductSetRequest)(nil), "google.cloud.vision.v1.CreateProductSetRequest")
	proto.RegisterType((*ListProductSetsRequest)(nil), "google.cloud.vision.v1.ListProductSetsRequest")
	proto.RegisterType((*ListProductSetsResponse)(nil), "google.cloud.vision.v1.ListProductSetsResponse")
	proto.RegisterType((*GetProductSetRequest)(nil), "google.cloud.vision.v1.GetProductSetRequest")
	proto.RegisterType((*UpdateProductSetRequest)(nil), "google.cloud.vision.v1.UpdateProductSetRequest")
	proto.RegisterType((*DeleteProductSetRequest)(nil), "google.cloud.vision.v1.DeleteProductSetRequest")
	proto.RegisterType((*CreateReferenceImageRequest)(nil), "google.cloud.vision.v1.CreateReferenceImageRequest")
	proto.RegisterType((*ListReferenceImagesRequest)(nil), "google.cloud.vision.v1.ListReferenceImagesRequest")
	proto.RegisterType((*ListReferenceImagesResponse)(nil), "google.cloud.vision.v1.ListReferenceImagesResponse")
	proto.RegisterType((*GetReferenceImageRequest)(nil), "google.cloud.vision.v1.GetReferenceImageRequest")
	proto.RegisterType((*DeleteReferenceImageRequest)(nil), "google.cloud.vision.v1.DeleteReferenceImageRequest")
	proto.RegisterType((*AddProductToProductSetRequest)(nil), "google.cloud.vision.v1.AddProductToProductSetRequest")
	proto.RegisterType((*RemoveProductFromProductSetRequest)(nil), "google.cloud.vision.v1.RemoveProductFromProductSetRequest")
	proto.RegisterType((*ListProductsInProductSetRequest)(nil), "google.cloud.vision.v1.ListProductsInProductSetRequest")
	proto.RegisterType((*ListProductsInProductSetResponse)(nil), "google.cloud.vision.v1.ListProductsInProductSetResponse")
	proto.RegisterType((*ImportProductSetsGcsSource)(nil), "google.cloud.vision.v1.ImportProductSetsGcsSource")
	proto.RegisterType((*ImportProductSetsInputConfig)(nil), "google.cloud.vision.v1.ImportProductSetsInputConfig")
	proto.RegisterType((*ImportProductSetsRequest)(nil), "google.cloud.vision.v1.ImportProductSetsRequest")
	proto.RegisterType((*ImportProductSetsResponse)(nil), "google.cloud.vision.v1.ImportProductSetsResponse")
	proto.RegisterType((*BatchOperationMetadata)(nil), "google.cloud.vision.v1.BatchOperationMetadata")
	proto.RegisterEnum("google.cloud.vision.v1.BatchOperationMetadata_State", BatchOperationMetadata_State_name, BatchOperationMetadata_State_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ProductSearchClient is the client API for ProductSearch service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProductSearchClient interface {
	// Creates and returns a new ProductSet resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
	//   4096 characters.
	CreateProductSet(ctx context.Context, in *CreateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Lists ProductSets in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
	//   than 1.
	ListProductSets(ctx context.Context, in *ListProductSetsRequest, opts ...grpc.CallOption) (*ListProductSetsResponse, error)
	// Gets information associated with a ProductSet.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	GetProductSet(ctx context.Context, in *GetProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Makes changes to a ProductSet resource.
	// Only display_name can be updated currently.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
	//   missing from the request or longer than 4096 characters.
	UpdateProductSet(ctx context.Context, in *UpdateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Permanently deletes a ProductSet. Products and ReferenceImages in the
	// ProductSet are not deleted.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteProductSet(ctx context.Context, in *DeleteProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates and returns a new product resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is missing or invalid.
	CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Lists products in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error)
	// Gets information associated with a Product.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Makes changes to a Product resource.
	// Only the `display_name`, `description`, and `labels` fields can be updated
	// right now.
	//
	// If labels are updated, the change will not be reflected in queries until
	// the next index time.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but is
	//   missing from the request or longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if description is present in update_mask but is
	//   longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is present in update_mask.
	UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Permanently deletes a product and its reference images.
	//
	// Metadata of the product and all its images will be deleted right away, but
	// search queries against ProductSets containing the product may still work
	// until all related caches are refreshed.
	DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates and returns a new ReferenceImage resource.
	//
	// The `bounding_poly` field is optional. If `bounding_poly` is not specified,
	// the system will try to detect regions of interest in the image that are
	// compatible with the product_category on the parent product. If it is
	// specified, detection is ALWAYS skipped. The system converts polygons into
	// non-rotated rectangles.
	//
	// Note that the pipeline will resize the image if the image resolution is too
	// large to process (above 50MP).
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if the product does not exist.
	// * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
	//   compatible with the parent product's product_category is detected.
	// * Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
	CreateReferenceImage(ctx context.Context, in *CreateReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error)
	// Permanently deletes a reference image.
	//
	// The image metadata will be deleted right away, but search queries
	// against ProductSets containing the image may still work until all related
	// caches are refreshed.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteReferenceImage(ctx context.Context, in *DeleteReferenceImageRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists reference images.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the parent product does not exist.
	// * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
	//   than 1.
	ListReferenceImages(ctx context.Context, in *ListReferenceImagesRequest, opts ...grpc.CallOption) (*ListReferenceImagesResponse, error)
	// Gets information associated with a ReferenceImage.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the specified image does not exist.
	GetReferenceImage(ctx context.Context, in *GetReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error)
	// Adds a Product to the specified ProductSet. If the Product is already
	// present, no change is made.
	//
	// One Product can be added to at most 100 ProductSets.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
	AddProductToProductSet(ctx context.Context, in *AddProductToProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Removes a Product from the specified ProductSet.
	RemoveProductFromProductSet(ctx context.Context, in *RemoveProductFromProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists the Products in a ProductSet, in an unspecified order. If the
	// ProductSet does not exist, the products field of the response will be
	// empty.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProductsInProductSet(ctx context.Context, in *ListProductsInProductSetRequest, opts ...grpc.CallOption) (*ListProductsInProductSetResponse, error)
	// Asynchronous API that imports a list of reference images to specified
	// product sets based on a list of image information.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be
	// used to keep track of the progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	// `Operation.response` contains `ImportProductSetsResponse`. (results)
	//
	// The input source of this method is a csv file on Google Cloud Storage.
	// For the format of the csv file please see
	// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
	ImportProductSets(ctx context.Context, in *ImportProductSetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type productSearchClient struct {
	cc *grpc.ClientConn
}

func NewProductSearchClient(cc *grpc.ClientConn) ProductSearchClient {
	return &productSearchClient{cc}
}

func (c *productSearchClient) CreateProductSet(ctx context.Context, in *CreateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/CreateProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProductSets(ctx context.Context, in *ListProductSetsRequest, opts ...grpc.CallOption) (*ListProductSetsResponse, error) {
	out := new(ListProductSetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListProductSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetProductSet(ctx context.Context, in *GetProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/GetProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) UpdateProductSet(ctx context.Context, in *UpdateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/UpdateProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteProductSet(ctx context.Context, in *DeleteProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/DeleteProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/CreateProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error) {
	out := new(ListProductsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/GetProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/UpdateProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/DeleteProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) CreateReferenceImage(ctx context.Context, in *CreateReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error) {
	out := new(ReferenceImage)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/CreateReferenceImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteReferenceImage(ctx context.Context, in *DeleteReferenceImageRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/DeleteReferenceImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListReferenceImages(ctx context.Context, in *ListReferenceImagesRequest, opts ...grpc.CallOption) (*ListReferenceImagesResponse, error) {
	out := new(ListReferenceImagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListReferenceImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetReferenceImage(ctx context.Context, in *GetReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error) {
	out := new(ReferenceImage)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/GetReferenceImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) AddProductToProductSet(ctx context.Context, in *AddProductToProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/AddProductToProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) RemoveProductFromProductSet(ctx context.Context, in *RemoveProductFromProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/RemoveProductFromProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProductsInProductSet(ctx context.Context, in *ListProductsInProductSetRequest, opts ...grpc.CallOption) (*ListProductsInProductSetResponse, error) {
	out := new(ListProductsInProductSetResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListProductsInProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ImportProductSets(ctx context.Context, in *ImportProductSetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ImportProductSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProductSearchServer is the server API for ProductSearch service.
type ProductSearchServer interface {
	// Creates and returns a new ProductSet resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
	//   4096 characters.
	CreateProductSet(context.Context, *CreateProductSetRequest) (*ProductSet, error)
	// Lists ProductSets in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
	//   than 1.
	ListProductSets(context.Context, *ListProductSetsRequest) (*ListProductSetsResponse, error)
	// Gets information associated with a ProductSet.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	GetProductSet(context.Context, *GetProductSetRequest) (*ProductSet, error)
	// Makes changes to a ProductSet resource.
	// Only display_name can be updated currently.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
	//   missing from the request or longer than 4096 characters.
	UpdateProductSet(context.Context, *UpdateProductSetRequest) (*ProductSet, error)
	// Permanently deletes a ProductSet. Products and ReferenceImages in the
	// ProductSet are not deleted.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteProductSet(context.Context, *DeleteProductSetRequest) (*empty.Empty, error)
	// Creates and returns a new product resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is missing or invalid.
	CreateProduct(context.Context, *CreateProductRequest) (*Product, error)
	// Lists products in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error)
	// Gets information associated with a Product.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	GetProduct(context.Context, *GetProductRequest) (*Product, error)
	// Makes changes to a Product resource.
	// Only the `display_name`, `description`, and `labels` fields can be updated
	// right now.
	//
	// If labels are updated, the change will not be reflected in queries until
	// the next index time.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but is
	//   missing from the request or longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if description is present in update_mask but is
	//   longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is present in update_mask.
	UpdateProduct(context.Context, *UpdateProductRequest) (*Product, error)
	// Permanently deletes a product and its reference images.
	//
	// Metadata of the product and all its images will be deleted right away, but
	// search queries against ProductSets containing the product may still work
	// until all related caches are refreshed.
	DeleteProduct(context.Context, *DeleteProductRequest) (*empty.Empty, error)
	// Creates and returns a new ReferenceImage resource.
	//
	// The `bounding_poly` field is optional. If `bounding_poly` is not specified,
	// the system will try to detect regions of interest in the image that are
	// compatible with the product_category on the parent product. If it is
	// specified, detection is ALWAYS skipped. The system converts polygons into
	// non-rotated rectangles.
	//
	// Note that the pipeline will resize the image if the image resolution is too
	// large to process (above 50MP).
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if the product does not exist.
	// * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
	//   compatible with the parent product's product_category is detected.
	// * Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
	CreateReferenceImage(context.Context, *CreateReferenceImageRequest) (*ReferenceImage, error)
	// Permanently deletes a reference image.
	//
	// The image metadata will be deleted right away, but search queries
	// against ProductSets containing the image may still work until all related
	// caches are refreshed.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteReferenceImage(context.Context, *DeleteReferenceImageRequest) (*empty.Empty, error)
	// Lists reference images.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the parent product does not exist.
	// * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
	//   than 1.
	ListReferenceImages(context.Context, *ListReferenceImagesRequest) (*ListReferenceImagesResponse, error)
	// Gets information associated with a ReferenceImage.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the specified image does not exist.
	GetReferenceImage(context.Context, *GetReferenceImageRequest) (*ReferenceImage, error)
	// Adds a Product to the specified ProductSet. If the Product is already
	// present, no change is made.
	//
	// One Product can be added to at most 100 ProductSets.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
	AddProductToProductSet(context.Context, *AddProductToProductSetRequest) (*empty.Empty, error)
	// Removes a Product from the specified ProductSet.
	RemoveProductFromProductSet(context.Context, *RemoveProductFromProductSetRequest) (*empty.Empty, error)
	// Lists the Products in a ProductSet, in an unspecified order. If the
	// ProductSet does not exist, the products field of the response will be
	// empty.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProductsInProductSet(context.Context, *ListProductsInProductSetRequest) (*ListProductsInProductSetResponse, error)
	// Asynchronous API that imports a list of reference images to specified
	// product sets based on a list of image information.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be
	// used to keep track of the progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	// `Operation.response` contains `ImportProductSetsResponse`. (results)
	//
	// The input source of this method is a csv file on Google Cloud Storage.
	// For the format of the csv file please see
	// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
	ImportProductSets(context.Context, *ImportProductSetsRequest) (*longrunning.Operation, error)
}

func RegisterProductSearchServer(s *grpc.Server, srv ProductSearchServer) {
	s.RegisterService(&_ProductSearch_serviceDesc, srv)
}

func _ProductSearch_CreateProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/CreateProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateProductSet(ctx, req.(*CreateProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProductSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProductSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListProductSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProductSets(ctx, req.(*ListProductSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/GetProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetProductSet(ctx, req.(*GetProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_UpdateProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).UpdateProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/UpdateProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).UpdateProductSet(ctx, req.(*UpdateProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/DeleteProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteProductSet(ctx, req.(*DeleteProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_CreateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/CreateProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateProduct(ctx, req.(*CreateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProducts(ctx, req.(*ListProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/GetProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetProduct(ctx, req.(*GetProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_UpdateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).UpdateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/UpdateProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).UpdateProduct(ctx, req.(*UpdateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/DeleteProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteProduct(ctx, req.(*DeleteProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_CreateReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/CreateReferenceImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateReferenceImage(ctx, req.(*CreateReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/DeleteReferenceImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteReferenceImage(ctx, req.(*DeleteReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListReferenceImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReferenceImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListReferenceImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListReferenceImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListReferenceImages(ctx, req.(*ListReferenceImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/GetReferenceImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetReferenceImage(ctx, req.(*GetReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_AddProductToProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddProductToProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).AddProductToProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/AddProductToProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).AddProductToProductSet(ctx, req.(*AddProductToProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_RemoveProductFromProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveProductFromProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).RemoveProductFromProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/RemoveProductFromProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).RemoveProductFromProductSet(ctx, req.(*RemoveProductFromProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProductsInProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsInProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProductsInProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListProductsInProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProductsInProductSet(ctx, req.(*ListProductsInProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ImportProductSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportProductSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ImportProductSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ImportProductSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ImportProductSets(ctx, req.(*ImportProductSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProductSearch_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1.ProductSearch",
	HandlerType: (*ProductSearchServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateProductSet",
			Handler:    _ProductSearch_CreateProductSet_Handler,
		},
		{
			MethodName: "ListProductSets",
			Handler:    _ProductSearch_ListProductSets_Handler,
		},
		{
			MethodName: "GetProductSet",
			Handler:    _ProductSearch_GetProductSet_Handler,
		},
		{
			MethodName: "UpdateProductSet",
			Handler:    _ProductSearch_UpdateProductSet_Handler,
		},
		{
			MethodName: "DeleteProductSet",
			Handler:    _ProductSearch_DeleteProductSet_Handler,
		},
		{
			MethodName: "CreateProduct",
			Handler:    _ProductSearch_CreateProduct_Handler,
		},
		{
			MethodName: "ListProducts",
			Handler:    _ProductSearch_ListProducts_Handler,
		},
		{
			MethodName: "GetProduct",
			Handler:    _ProductSearch_GetProduct_Handler,
		},
		{
			MethodName: "UpdateProduct",
			Handler:    _ProductSearch_UpdateProduct_Handler,
		},
		{
			MethodName: "DeleteProduct",
			Handler:    _ProductSearch_DeleteProduct_Handler,
		},
		{
			MethodName: "CreateReferenceImage",
			Handler:    _ProductSearch_CreateReferenceImage_Handler,
		},
		{
			MethodName: "DeleteReferenceImage",
			Handler:    _ProductSearch_DeleteReferenceImage_Handler,
		},
		{
			MethodName: "ListReferenceImages",
			Handler:    _ProductSearch_ListReferenceImages_Handler,
		},
		{
			MethodName: "GetReferenceImage",
			Handler:    _ProductSearch_GetReferenceImage_Handler,
		},
		{
			MethodName: "AddProductToProductSet",
			Handler:    _ProductSearch_AddProductToProductSet_Handler,
		},
		{
			MethodName: "RemoveProductFromProductSet",
			Handler:    _ProductSearch_RemoveProductFromProductSet_Handler,
		},
		{
			MethodName: "ListProductsInProductSet",
			Handler:    _ProductSearch_ListProductsInProductSet_Handler,
		},
		{
			MethodName: "ImportProductSets",
			Handler:    _ProductSearch_ImportProductSets_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vision/v1/product_search_service.proto",
}

func init() {
	proto.RegisterFile("google/cloud/vision/v1/product_search_service.proto", fileDescriptor_product_search_service_05b23c95580d8dfa)
}

var fileDescriptor_product_search_service_05b23c95580d8dfa = []byte{
	// 1853 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0x4f, 0x73, 0xdb, 0xc6,
	0x15, 0xcf, 0x4a, 0x96, 0x2d, 0x3d, 0x8a, 0x12, 0xbd, 0x55, 0x25, 0x86, 0x8a, 0xc7, 0x2a, 0x9a,
	0xa6, 0x0e, 0xeb, 0x02, 0x35, 0xe5, 0xd4, 0x09, 0x55, 0xbb, 0x91, 0x68, 0x4a, 0x61, 0x22, 0xcb,
	0x0a, 0x28, 0x25, 0xd3, 0x5e, 0x38, 0x10, 0xb0, 0x42, 0x50, 0x81, 0x00, 0x82, 0x05, 0x35, 0x51,
	0x32, 0x3e, 0xb4, 0x3d, 0x34, 0x33, 0x99, 0xc9, 0xa1, 0xed, 0xa9, 0x7f, 0x67, 0x3a, 0xd3, 0xe9,
	0xa1, 0xd3, 0x5e, 0xd2, 0x1c, 0x3a, 0xbd, 0xf7, 0xd4, 0x19, 0x1f, 0xfa, 0x15, 0xfa, 0x21, 0x7a,
	0xec, 0xec, 0x62, 0x41, 0x02, 0x10, 0x20, 0x82, 0xd6, 0xb8, 0x37, 0x2c, 0xf0, 0xfe, 0xfc, 0xde,
	0x7b, 0xbf, 0xdd, 0x7d, 0x8f, 0x84, 0x75, 0xd3, 0x75, 0x4d, 0x9b, 0x28, 0xba, 0xed, 0x0e, 0x0c,
	0xe5, 0xd4, 0xa2, 0x96, 0xeb, 0x28, 0xa7, 0x77, 0x14, 0xcf, 0x77, 0x8d, 0x81, 0x1e, 0xf4, 0x28,
	0xd1, 0x7c, 0xfd, 0x83, 0x1e, 0x25, 0xfe, 0xa9, 0xa5, 0x13, 0xd9, 0xf3, 0xdd, 0xc0, 0xc5, 0xcb,
	0xa1, 0x92, 0xcc, 0x95, 0xe4, 0x50, 0x49, 0x3e, 0xbd, 0x53, 0x7b, 0x49, 0x18, 0xd3, 0x3c, 0x4b,
	0xd1, 0x1c, 0xc7, 0x0d, 0xb4, 0xc0, 0x72, 0x1d, 0x1a, 0x6a, 0xd5, 0xbe, 0x91, 0xe3, 0xca, 0x24,
	0x6e, 0x9f, 0x04, 0xfe, 0x99, 0x10, 0xfb, 0xba, 0x10, 0xb3, 0x5d, 0xc7, 0xf4, 0x07, 0x8e, 0x63,
	0x39, 0xa6, 0xe2, 0x7a, 0xc4, 0x4f, 0xd8, 0x5a, 0x15, 0x42, 0x7c, 0x75, 0x34, 0x38, 0x56, 0x48,
	0xdf, 0x0b, 0x22, 0x0b, 0x6b, 0xe9, 0x8f, 0xc7, 0x16, 0xb1, 0x8d, 0x5e, 0x5f, 0xa3, 0x27, 0x42,
	0xe2, 0x66, 0x5a, 0x22, 0xb0, 0xfa, 0x84, 0x06, 0x5a, 0xdf, 0x13, 0x02, 0x2b, 0x42, 0xc0, 0xf7,
	0x74, 0x85, 0x06, 0x5a, 0x30, 0x10, 0x8e, 0xa5, 0x9f, 0x4f, 0xc1, 0xb5, 0xfd, 0x30, 0x37, 0x18,
	0xc3, 0x15, 0x47, 0xeb, 0x93, 0x2a, 0x5a, 0x43, 0xb7, 0xe6, 0x54, 0xfe, 0x8c, 0xbf, 0x06, 0xf3,
	0x86, 0x45, 0x3d, 0x5b, 0x3b, 0xeb, 0xf1, 0x6f, 0x53, 0xfc, 0x5b, 0x49, 0xbc, 0xdb, 0x63, 0x22,
	0x6b, 0x50, 0x32, 0x08, 0xd5, 0x7d, 0xcb, 0x63, 0x11, 0x55, 0xa7, 0x85, 0xc4, 0xe8, 0x15, 0x7e,
	0x15, 0x2a, 0x51, 0xfe, 0x75, 0x2d, 0x20, 0xa6, 0xeb, 0x9f, 0x55, 0xaf, 0x70, 0xb1, 0x45, 0xf1,
	0xbe, 0x25, 0x5e, 0xe3, 0xc7, 0xb0, 0x10, 0x89, 0xda, 0xda, 0x11, 0xb1, 0x69, 0x75, 0x66, 0x6d,
	0xfa, 0x56, 0xa9, 0x71, 0x4b, 0xce, 0xae, 0x91, 0x2c, 0xc0, 0xcb, 0xef, 0x90, 0xb3, 0xf7, 0x34,
	0x7b, 0x40, 0xd4, 0xb2, 0xd0, 0xdf, 0xe5, 0xea, 0xb5, 0x06, 0xcc, 0x46, 0x9f, 0x70, 0x05, 0xa6,
	0x4f, 0xc8, 0x99, 0x88, 0x8f, 0x3d, 0xe2, 0x25, 0x98, 0x39, 0x65, 0x9f, 0x44, 0x5c, 0xe1, 0x42,
	0xfa, 0x02, 0x01, 0x08, 0xbb, 0x5d, 0xf2, 0xcc, 0x79, 0x79, 0x03, 0xc0, 0x72, 0x0c, 0xf2, 0x51,
	0x8f, 0x15, 0x83, 0xa7, 0xa5, 0xd4, 0xa8, 0x45, 0x61, 0x44, 0x95, 0x92, 0x0f, 0xa2, 0x4a, 0xa9,
	0x73, 0x5c, 0x9a, 0xad, 0xf1, 0x3a, 0x94, 0x42, 0x55, 0xe2, 0xfb, 0xae, 0xcf, 0x73, 0x55, 0x6a,
	0xe0, 0x48, 0xd7, 0xf7, 0x74, 0xb9, 0xcb, 0x8b, 0xa8, 0x86, 0x1e, 0xda, 0x4c, 0x4a, 0xfa, 0x29,
	0x82, 0x05, 0x95, 0x1c, 0x13, 0x9f, 0x38, 0x3a, 0xe9, 0xf4, 0x35, 0x93, 0x64, 0x22, 0xaf, 0xc0,
	0xf4, 0xc0, 0xb7, 0x04, 0x60, 0xf6, 0x88, 0xdf, 0x81, 0x85, 0x23, 0x77, 0xe0, 0x18, 0x96, 0x63,
	0xf6, 0x3c, 0xd7, 0x3e, 0xa3, 0xd5, 0x69, 0x9e, 0xf3, 0x97, 0xf3, 0x72, 0xbe, 0x25, 0xa4, 0xf7,
	0x5d, 0xfb, 0x4c, 0x2d, 0x1f, 0xc5, 0x56, 0x54, 0xfa, 0x14, 0xc1, 0x52, 0xcb, 0x27, 0x5a, 0x40,
	0x44, 0x06, 0x55, 0xf2, 0xe1, 0x80, 0xd0, 0x00, 0x2f, 0xc3, 0x55, 0x4f, 0xf3, 0x89, 0x13, 0x08,
	0x34, 0x62, 0x85, 0xdf, 0x80, 0x6b, 0xa2, 0x62, 0x1c, 0x53, 0xa9, 0x71, 0x73, 0x4c, 0xa9, 0xd5,
	0x48, 0x1e, 0xdf, 0x00, 0x88, 0xc8, 0x62, 0x19, 0x82, 0x78, 0x73, 0xe2, 0x4d, 0xc7, 0x90, 0x2c,
	0xf8, 0xca, 0xae, 0x45, 0x03, 0xa1, 0x46, 0xc7, 0x01, 0x59, 0x85, 0x39, 0x4f, 0x33, 0x49, 0x8f,
	0x5a, 0x1f, 0x87, 0xf5, 0x9c, 0x51, 0x67, 0xd9, 0x8b, 0xae, 0xf5, 0x31, 0xe1, 0xae, 0xd8, 0xc7,
	0xc0, 0x3d, 0x21, 0xce, 0xd0, 0x95, 0x66, 0x92, 0x03, 0xf6, 0x42, 0xfa, 0x04, 0x96, 0x92, 0xae,
	0xa8, 0xe7, 0x3a, 0x94, 0xe0, 0x0d, 0x98, 0x15, 0x78, 0x68, 0x15, 0xf1, 0xa4, 0x8e, 0x8d, 0x6e,
	0xa8, 0x80, 0x5f, 0x81, 0x45, 0x87, 0x7c, 0x14, 0xf4, 0x62, 0x8e, 0xc3, 0xaa, 0x95, 0xd9, 0xeb,
	0xfd, 0xa1, 0xf3, 0x6f, 0xc2, 0xf5, 0x1d, 0x12, 0xa4, 0xd2, 0x9d, 0x51, 0x7a, 0xe9, 0x73, 0x04,
	0x4b, 0x87, 0x9e, 0x71, 0xbe, 0x36, 0xb1, 0x1a, 0xa0, 0x09, 0x6b, 0xb0, 0x01, 0xa5, 0x01, 0x37,
	0xc9, 0xcf, 0x23, 0x51, 0xc2, 0xf3, 0x34, 0xdf, 0x66, 0x47, 0xd6, 0x23, 0x8d, 0x9e, 0xa8, 0x10,
	0x8a, 0xb3, 0x67, 0xa9, 0x0e, 0x4b, 0x0f, 0x89, 0x4d, 0xce, 0xe1, 0xc9, 0x02, 0xff, 0x1b, 0x04,
	0x2b, 0x09, 0x62, 0x75, 0xc9, 0x58, 0x6e, 0xb5, 0xa0, 0x34, 0x3a, 0xf8, 0x23, 0x7e, 0x49, 0x63,
	0x62, 0x63, 0x76, 0x23, 0x5e, 0xb1, 0xed, 0xff, 0xf2, 0xe8, 0x48, 0xa2, 0x24, 0xc6, 0xb4, 0xf9,
	0x91, 0x4c, 0xc7, 0x90, 0x6c, 0x58, 0x8e, 0x31, 0xa0, 0x4b, 0x9e, 0x2f, 0xdf, 0x3e, 0x45, 0xb0,
	0x72, 0xce, 0x9d, 0xe0, 0x5c, 0x1b, 0xe6, 0x63, 0x78, 0x23, 0xde, 0x15, 0x89, 0xba, 0x34, 0x8a,
	0xa8, 0x38, 0xfb, 0xea, 0xb0, 0x34, 0x62, 0x5f, 0xac, 0x26, 0x59, 0x35, 0xfc, 0x35, 0x82, 0x95,
	0x04, 0x01, 0x63, 0xf2, 0xa9, 0x5a, 0xa1, 0x67, 0xaa, 0xd5, 0xa5, 0xd8, 0xf8, 0x6d, 0x58, 0x49,
	0xb0, 0x71, 0x4c, 0x30, 0x7f, 0x43, 0xb0, 0x1a, 0x12, 0x32, 0x79, 0xea, 0x8e, 0xab, 0xfb, 0x63,
	0x58, 0xf4, 0x23, 0x85, 0x9e, 0xc5, 0x34, 0x04, 0xce, 0x57, 0xf2, 0x82, 0x4d, 0xd9, 0x5f, 0xf0,
	0x93, 0xa7, 0xfc, 0x6d, 0xc0, 0x29, 0x83, 0x23, 0x92, 0x56, 0x92, 0xb2, 0x1d, 0x43, 0xf2, 0xa0,
	0xc6, 0x98, 0x93, 0xb4, 0xf9, 0x5c, 0xc9, 0xfa, 0x25, 0x82, 0xd5, 0x4c, 0x97, 0x82, 0xb0, 0xef,
	0x42, 0x25, 0x85, 0x3f, 0x22, 0x6d, 0xd1, 0x8c, 0x2c, 0x26, 0xa3, 0xa4, 0x17, 0xc3, 0xcd, 0x60,
	0xf6, 0x74, 0x16, 0xb3, 0x65, 0xa8, 0xee, 0x90, 0x20, 0xbb, 0xb8, 0x59, 0x84, 0xb8, 0x03, 0xab,
	0x21, 0x7f, 0x8a, 0xab, 0x3c, 0x82, 0x1b, 0x9b, 0x86, 0x21, 0xf8, 0x76, 0xe0, 0x16, 0x22, 0x1e,
	0xae, 0x26, 0x6f, 0xcc, 0xb9, 0xe1, 0x61, 0x2c, 0xa9, 0x20, 0xa9, 0xa4, 0xef, 0x9e, 0x46, 0x0c,
	0xde, 0xf6, 0xdd, 0xfe, 0x65, 0x6d, 0x7e, 0x08, 0x37, 0xe3, 0x57, 0x5b, 0xc7, 0x29, 0x66, 0xf0,
	0x32, 0x84, 0xf9, 0x19, 0x82, 0xb5, 0x7c, 0x9f, 0xff, 0xcf, 0xab, 0xf5, 0x01, 0xd4, 0x3a, 0x7d,
	0xcf, 0xf5, 0xe3, 0x07, 0xed, 0x8e, 0x4e, 0xbb, 0xee, 0xc0, 0xd7, 0x59, 0xe7, 0x3b, 0xaf, 0xd3,
	0xd3, 0xde, 0xb1, 0x65, 0x93, 0x1e, 0xeb, 0xa9, 0xc2, 0xf8, 0x41, 0xa7, 0xa7, 0xdb, 0x96, 0x4d,
	0x0e, 0x7d, 0x4b, 0x7a, 0x02, 0x2f, 0x9d, 0xd3, 0xef, 0x38, 0xde, 0x20, 0x68, 0xb9, 0xce, 0xb1,
	0x65, 0xe2, 0x2e, 0x80, 0xa9, 0xd3, 0x1e, 0xe5, 0xf6, 0xc4, 0x99, 0xd7, 0xc8, 0x0b, 0x23, 0x1f,
	0xc9, 0x5b, 0x2f, 0xa8, 0x73, 0x66, 0xb4, 0xd8, 0x9a, 0x85, 0xab, 0xa1, 0x41, 0xe9, 0x33, 0x04,
	0xd5, 0x73, 0x5a, 0xe3, 0xb6, 0xfa, 0xfb, 0x30, 0x6f, 0x31, 0x88, 0x3d, 0x9d, 0x63, 0x14, 0x87,
	0xd3, 0xdd, 0xc2, 0xa8, 0x62, 0xf1, 0xa9, 0x25, 0x6b, 0xb4, 0x90, 0x7e, 0x87, 0xe0, 0xc5, 0x0c,
	0x34, 0xcf, 0xef, 0x14, 0x90, 0x61, 0x36, 0x1c, 0x76, 0x08, 0xad, 0x4e, 0x71, 0x53, 0x59, 0x3d,
	0xf4, 0x50, 0x46, 0xfa, 0x62, 0x0a, 0x96, 0xb7, 0xb4, 0x40, 0xff, 0xe0, 0x71, 0x34, 0x9f, 0x3d,
	0x22, 0x81, 0x66, 0x68, 0x81, 0x86, 0xdf, 0x86, 0x19, 0x26, 0x16, 0xd6, 0x68, 0x21, 0x3f, 0x1b,
	0xd9, 0xea, 0xdc, 0x15, 0x51, 0x43, 0x13, 0xec, 0x92, 0xa2, 0x83, 0xa3, 0xbe, 0x15, 0x84, 0x93,
	0xc1, 0xd4, 0xd8, 0xc9, 0x00, 0x42, 0x71, 0x3e, 0x1a, 0xbc, 0x06, 0xb3, 0xc4, 0x31, 0x8a, 0xce,
	0x14, 0xd7, 0x88, 0x63, 0xb0, 0x95, 0xf4, 0x03, 0x98, 0xe1, 0x18, 0xf0, 0x57, 0xe1, 0x7a, 0xf7,
	0x60, 0xf3, 0xa0, 0xdd, 0x3b, 0xdc, 0xeb, 0xee, 0xb7, 0x5b, 0x9d, 0xed, 0x4e, 0xfb, 0x61, 0xe5,
	0x05, 0xbc, 0x00, 0xb0, 0xaf, 0x3e, 0x6e, 0xb5, 0xbb, 0xdd, 0xce, 0xde, 0x4e, 0x05, 0xb1, 0x75,
	0xf7, 0xb0, 0xc5, 0xd6, 0xdb, 0x87, 0xbb, 0x95, 0x29, 0x0c, 0x70, 0x75, 0x7b, 0xb3, 0xb3, 0xdb,
	0x7e, 0x58, 0x99, 0xc6, 0x65, 0x98, 0x6b, 0x6d, 0xee, 0xb5, 0xda, 0xbb, 0x6c, 0x79, 0xa5, 0xf1,
	0xb4, 0x0a, 0xe5, 0x61, 0x41, 0xd9, 0x74, 0x8d, 0xff, 0x82, 0xa0, 0x92, 0x6e, 0xd5, 0xb0, 0x92,
	0x97, 0xb2, 0x9c, 0xa6, 0xae, 0x56, 0xe0, 0xee, 0x97, 0x1e, 0xfe, 0xe4, 0xdf, 0xff, 0xf9, 0xc5,
	0xd4, 0x03, 0x49, 0x61, 0x83, 0xf7, 0x27, 0x21, 0x81, 0xef, 0x7b, 0xbe, 0xfb, 0x23, 0xa2, 0x07,
	0x54, 0xa9, 0x2b, 0xb6, 0xab, 0x87, 0x73, 0xb6, 0x52, 0x7f, 0xa2, 0xc4, 0xba, 0x9b, 0x66, 0xbc,
	0xd7, 0xc0, 0x7f, 0x46, 0xb0, 0x98, 0xea, 0xa6, 0xb0, 0x9c, 0xe7, 0x3d, 0xbb, 0xcb, 0xab, 0x29,
	0x85, 0xe5, 0x43, 0xbe, 0x4b, 0xf7, 0x38, 0xf4, 0x3b, 0x78, 0x52, 0xe8, 0xf8, 0x57, 0x08, 0xca,
	0x89, 0x8e, 0x0b, 0xdf, 0xce, 0xf3, 0x9d, 0xd5, 0x98, 0x15, 0xca, 0x6b, 0x12, 0x1c, 0x3b, 0xd0,
	0x73, 0xa0, 0xc5, 0x91, 0x29, 0xf5, 0x27, 0xf8, 0xef, 0x08, 0x2a, 0xe9, 0x0e, 0x2f, 0xbf, 0xf4,
	0x39, 0xbd, 0x60, 0x21, 0x88, 0xfb, 0x1c, 0xe2, 0xdb, 0x8d, 0x8d, 0x30, 0x7f, 0xa3, 0x72, 0xca,
	0xc5, 0xe1, 0x26, 0x69, 0xf0, 0x4b, 0x04, 0x95, 0x74, 0x03, 0x98, 0x8f, 0x3d, 0xa7, 0x55, 0xac,
	0x2d, 0x9f, 0xdb, 0x8e, 0xed, 0xbe, 0x17, 0x9c, 0x45, 0x29, 0xad, 0x4f, 0x9c, 0xd2, 0xdf, 0x22,
	0x28, 0x27, 0xf6, 0x48, 0x7e, 0xbd, 0xb3, 0x06, 0xef, 0xda, 0xb8, 0x6b, 0x51, 0xba, 0xcf, 0x91,
	0xdd, 0x93, 0x6e, 0x4f, 0xc0, 0x44, 0xda, 0x1c, 0x4e, 0x80, 0xbf, 0x47, 0x30, 0x1f, 0xbf, 0xad,
	0xf1, 0xb7, 0x0a, 0x6c, 0x85, 0xe1, 0xbe, 0xb9, 0x5d, 0x4c, 0x58, 0x6c, 0x9a, 0xbb, 0x1c, 0xaa,
	0x8c, 0x27, 0x82, 0x8a, 0x3f, 0x47, 0x00, 0xa3, 0xad, 0x80, 0x5f, 0x1d, 0xbf, 0x5d, 0x0a, 0xe7,
	0x2e, 0x09, 0xa8, 0x40, 0x55, 0x79, 0x49, 0xff, 0x88, 0xa0, 0x9c, 0xe0, 0x7e, 0x7e, 0x49, 0xb3,
	0xe6, 0xf5, 0xf1, 0xb0, 0xda, 0x1c, 0xd6, 0xf7, 0x1b, 0x77, 0xe3, 0x9b, 0x43, 0x2e, 0x08, 0x6f,
	0x54, 0xda, 0xcf, 0x10, 0x94, 0x13, 0x3c, 0xcf, 0xc7, 0x99, 0x35, 0xc7, 0xe7, 0xee, 0x05, 0x91,
	0xb5, 0xfa, 0x64, 0x59, 0xfb, 0xd7, 0xf0, 0xa7, 0xa5, 0xd4, 0xcf, 0x5c, 0xeb, 0x17, 0xef, 0x87,
	0xcc, 0x76, 0xbc, 0x56, 0xb0, 0xab, 0x90, 0xde, 0xe7, 0x58, 0xdf, 0x95, 0x1e, 0x8c, 0xa7, 0x5c,
	0x1c, 0xad, 0x92, 0x6a, 0x46, 0x9a, 0xe9, 0xa1, 0x8f, 0xdd, 0x3a, 0x4b, 0x59, 0xf3, 0x42, 0x7e,
	0x38, 0x17, 0x4c, 0x17, 0xb9, 0xa9, 0xde, 0xe6, 0xf0, 0xdf, 0xac, 0x3f, 0x98, 0x20, 0xd5, 0x69,
	0xec, 0x2c, 0xf9, 0xff, 0x44, 0xe1, 0xaf, 0x69, 0xa9, 0x21, 0x0e, 0x37, 0x2e, 0xda, 0xbf, 0xd9,
	0x43, 0x66, 0x6d, 0x7d, 0x22, 0x1d, 0xb1, 0xf5, 0x45, 0x20, 0xf8, 0x92, 0x75, 0xc0, 0x5f, 0x22,
	0xfe, 0x73, 0x59, 0x2a, 0xe7, 0xdf, 0xb9, 0xe0, 0x4c, 0xb8, 0x1c, 0x7f, 0x92, 0xb8, 0x9f, 0xbd,
	0x00, 0x7f, 0x45, 0xb0, 0x9c, 0x3d, 0x2b, 0xe2, 0xd7, 0xf2, 0xa0, 0x5c, 0x38, 0x5b, 0xe6, 0x52,
	0x46, 0x1c, 0x1e, 0x52, 0x73, 0xc2, 0x9b, 0xaa, 0xa9, 0x0d, 0xdd, 0x35, 0x51, 0x1d, 0xff, 0x03,
	0xc1, 0xea, 0x05, 0xd3, 0x28, 0x6e, 0xe6, 0x27, 0x70, 0xdc, 0x08, 0x9b, 0x0b, 0xfd, 0x2d, 0x0e,
	0x7d, 0x4b, 0xba, 0x3f, 0x29, 0x74, 0x3f, 0xee, 0x93, 0xa1, 0x7f, 0x8a, 0xa0, 0x9a, 0x37, 0x83,
	0xe2, 0x7b, 0x45, 0x2e, 0xad, 0x8c, 0x49, 0xb9, 0xf6, 0xfa, 0xe4, 0x8a, 0x82, 0xfe, 0x6f, 0xf2,
	0xc8, 0x9a, 0xf8, 0xf5, 0x09, 0x23, 0x1b, 0xdd, 0x82, 0x7f, 0x42, 0x70, 0xfd, 0xdc, 0xf8, 0x95,
	0x4f, 0xfc, 0xbc, 0xb9, 0xb1, 0x76, 0x23, 0xd2, 0x88, 0xfd, 0xa3, 0x25, 0x0f, 0x47, 0x1e, 0x69,
	0x93, 0x03, 0xdd, 0x90, 0xbe, 0x3b, 0x69, 0x4b, 0x6e, 0x71, 0x87, 0x4d, 0x54, 0xdf, 0xfa, 0x31,
	0x82, 0x9a, 0xee, 0xf6, 0x73, 0x90, 0x6d, 0xbd, 0x98, 0x98, 0x36, 0xba, 0xe1, 0x5f, 0x79, 0xfb,
	0x8c, 0x08, 0xfb, 0xe8, 0x87, 0xdf, 0x13, 0x4a, 0xa6, 0x6b, 0x6b, 0x8e, 0x29, 0xbb, 0xbe, 0xa9,
	0x98, 0xc4, 0xe1, 0x34, 0x51, 0xc2, 0x4f, 0x9a, 0x67, 0xd1, 0xf4, 0x9f, 0x76, 0x1b, 0xe1, 0xd3,
	0x7f, 0x11, 0xfa, 0xc3, 0xd4, 0x95, 0x9d, 0xd6, 0x7b, 0x7b, 0x47, 0x57, 0xb9, 0xca, 0xfa, 0xff,
	0x02, 0x00, 0x00, 0xff, 0xff, 0x1d, 0xa2, 0x18, 0x20, 0x51, 0x1c, 0x00, 0x00,
}
