#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <glib.h>
#include <gtk/gtk.h>
#include "pop_common.h"

void emessage(gchar *message)
{
    GtkWidget *dialog = gtk_message_dialog_new( NULL,0,GTK_MESSAGE_INFO,GTK_BUTTONS_OK,"Error: %s",message);
    g_signal_connect_swapped (GTK_OBJECT (dialog),
  		    "response",
  		    G_CALLBACK (gtk_widget_destroy),
  		    GTK_OBJECT (dialog));
   gtk_widget_show(dialog);
}
void send_message(gpointer data[])
{
  struct in_addr **paddr;
  struct sockaddr_in clientsocket;
  struct hostent *he;
  G_CONST_RETURN gchar *hostname, *message;
  gchar *fullmessage;
  gint hlen, mlen,sfd;

  
  hostname =gtk_entry_get_text(data[0]);
  message=gtk_entry_get_text(data[1]);
  
  hlen=sizeof(hostname);
  mlen=sizeof(message);

  if(hlen==0 || mlen==0)
    {
      emessage(".");
      return;
    }
  if((he = (struct hostent *)gethostbyname(hostname))==NULL)
    {
      emessage("Could not resolve hostname.");
      return;
    }

   paddr = (struct in_addr **)he->h_addr_list;
    

   /***************
   Establish connection
   *****************/
   if((sfd=socket(PF_INET, SOCK_STREAM,0))<0) 
     {
       emessage("Establishing socket ");
       return;
     }
   memset(&clientsocket,0,sizeof(clientsocket));
   clientsocket.sin_family = AF_INET;
   clientsocket.sin_port   = htons(CP_PORT);
   if(!(inet_aton(inet_ntoa(**paddr) ,&clientsocket.sin_addr)))
     {
       emessage("Address failed");
       return;
     }
   if(inet_ntoa(**paddr),connect(sfd,(struct sockaddr *)&clientsocket,(socklen_t)sizeof(clientsocket))<0)
     {
       emessage("Connect failed. Perhaps server isn't running.");
       return;
     }
   fullmessage = g_strdup_printf("MSG:%s",message);/*Prepare the message*/
   write(sfd,fullmessage ,strlen(fullmessage)+1);
   gtk_main_quit ();
}

static void destroy( GtkWidget *widget, gpointer data )
{
  gtk_main_quit ();
}
static void bs_send( GtkWidget *widget, gpointer data )
{
  send_message(data);
}


int main (gint argc, gchar *argv[])
{
  GtkWidget *window, *vmain,*hmain,*vdata[2],*label[2], *tdata[2], *bsend;
  gtk_init (&argc, &argv); /* init gtk+ */
  
  /*
    setup our GTK+ widgets
  */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  hmain  = gtk_hbox_new(FALSE,1);
  vdata[0] = gtk_vbox_new(FALSE,5);
  vdata[1] = gtk_vbox_new(FALSE,5);
  vmain    = gtk_vbox_new(FALSE,2);
  label[0] = gtk_label_new("Host");
  label[1] = gtk_label_new("Message");
  tdata[0] = gtk_entry_new();
  tdata[1] = gtk_entry_new();
  bsend  = gtk_button_new_with_mnemonic("_Send"); 

  /* 
     attach signals
  */
  g_signal_connect (G_OBJECT (bsend), "clicked", G_CALLBACK (bs_send), tdata);
  g_signal_connect (G_OBJECT (window), "destroy", G_CALLBACK (destroy), NULL);

  /*
    stick GUI together
  */
  gtk_container_add (GTK_CONTAINER (vdata[0]), label[0]);
  gtk_container_add (GTK_CONTAINER (vdata[0]), label[1]);
  gtk_container_add (GTK_CONTAINER (vdata[1]), tdata[0]);
  gtk_container_add (GTK_CONTAINER (vdata[1]), tdata[1]);
  gtk_container_add (GTK_CONTAINER (hmain), vdata[0]);
  gtk_container_add (GTK_CONTAINER (hmain), vdata[1]);
  gtk_container_add (GTK_CONTAINER (vmain), hmain);
  gtk_container_add (GTK_CONTAINER (vmain), bsend);
  gtk_container_add (GTK_CONTAINER (window), vmain);

  gtk_widget_show_all(window);

  /* hand over to gtk.. */
  gtk_main();
  exit(0);
}
