#!/bin/sh

#TMPDIR=/tmp
TMPDIR=.
DVI2GR=./dvi2gr
FPATH="fonts/type1"
#LATEX="latex -interaction=batchmode"
LATEX=latex

input=$1

bname=$TMPDIR/dvi2gr$$
itex=${bname}.tex
idvi=${bname}.dvi
ilog=${bname}.log
iaux=${bname}.aux

istr=`sed 's/\\\\/\\\\\\\\/g' $input`

#exit

cat << EOPRE > $itex
\documentclass[10pt]{article}
\pagestyle{empty}
\begin{document}
\begin{displaymath}
EOPRE

cat $input >> $itex

cat << EOPOST >> $itex
\end{displaymath}
\end{document}
EOPOST

$LATEX $itex > /dev/null
ostr=`$DVI2GR $FPATH $idvi`

cat << EOCOM
g0 off
with string
  string on
  string loctype view
  string 0.05, 0.7
  string color 1
  string rot 0
  string font 0
  string just 12
  string char size 1.0
  string def "T\v{-.2}\-E\NX input:"
with string
  string on
  string loctype view
  string 0.05, 0.6
  string color 1
  string rot 0
  string font 0
  string just 12
  string char size 1.0
  string def "Result:"
with string
  string on
  string loctype view
  string 0.2, 0.7
  string color 1
  string rot 0
  string font "Helvetica"
  string just 12
  string char size 0.8
  string def "$istr"
with string
  string on
  string loctype view
  string 0.2, 0.6
  string color 1
  string rot 0
  string font 0
  string just 12
  string char size 1.0
  string def "$ostr"
EOCOM

rm -f $itex $idvi $iaux $ilog

