/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.groupsend;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Collection;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.groupsend.GroupSendFullToken;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class GroupSendEndorsement
extends ByteArray {
    public GroupSendEndorsement(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.GroupSendEndorsement_CheckValidContents(contents));
    }

    GroupSendEndorsement(byte[] contents, ByteArray.UncheckedAndUncloned marker) {
        super(contents, marker);
    }

    public static GroupSendEndorsement combine(Collection<GroupSendEndorsement> endorsements) {
        ByteBuffer[] buffers = new ByteBuffer[endorsements.size()];
        int nextOffset = 0;
        for (GroupSendEndorsement next : endorsements) {
            byte[] nextEndorsementRaw = next.getInternalContentsForJNI();
            buffers[nextOffset] = ByteBuffer.allocateDirect(nextEndorsementRaw.length);
            buffers[nextOffset].put(nextEndorsementRaw);
            ++nextOffset;
        }
        byte[] rawCombinedEndorsement = Native.GroupSendEndorsement_Combine(buffers);
        return FilterExceptions.filterExceptions(() -> new GroupSendEndorsement(rawCombinedEndorsement));
    }

    public GroupSendEndorsement byRemoving(GroupSendEndorsement toRemove) {
        byte[] rawResult = Native.GroupSendEndorsement_Remove(this.getInternalContentsForJNI(), toRemove.getInternalContentsForJNI());
        return FilterExceptions.filterExceptions(() -> new GroupSendEndorsement(rawResult));
    }

    public Token toToken(GroupSecretParams groupParams) {
        byte[] rawResult = Native.GroupSendEndorsement_ToToken(this.getInternalContentsForJNI(), groupParams.getInternalContentsForJNI());
        return FilterExceptions.filterExceptions(() -> new Token(rawResult));
    }

    public GroupSendFullToken toFullToken(GroupSecretParams groupParams, Instant expiration) {
        return this.toToken(groupParams).toFullToken(expiration);
    }

    public static class Token
    extends ByteArray {
        public Token(byte[] contents) throws InvalidInputException {
            super(contents);
            FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.GroupSendToken_CheckValidContents(contents));
        }

        public GroupSendFullToken toFullToken(Instant expiration) {
            byte[] rawResult = Native.GroupSendToken_ToFullToken(this.getInternalContentsForJNI(), expiration.getEpochSecond());
            return FilterExceptions.filterExceptions(() -> new GroupSendFullToken(rawResult));
        }
    }
}

