/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.stream;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.logging.Log;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0006\u0010\u0019\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/signal/core/util/stream/LimitedInputStream;", "Ljava/io/FilterInputStream;", "wrapped", "Ljava/io/InputStream;", "maxBytes", "", "<init>", "(Ljava/io/InputStream;J)V", "totalBytesRead", "lastMark", "read", "", "destination", "", "offset", "length", "skip", "requestedSkipCount", "available", "markSupported", "", "mark", "", "readlimit", "reset", "leftoverStream", "Companion", "core-util-jvm"})
public final class LimitedInputStream
extends FilterInputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream wrapped;
    private final long maxBytes;
    private long totalBytesRead;
    private long lastMark;
    private static final long UNLIMITED = -1L;
    @NotNull
    private static final String TAG = Log.tag(Reflection.getOrCreateKotlinClass(LimitedInputStream.class));

    public LimitedInputStream(@NotNull InputStream wrapped, long maxBytes) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        super(wrapped);
        this.wrapped = wrapped;
        this.maxBytes = maxBytes;
        this.lastMark = -1L;
    }

    @Override
    public int read() {
        if (this.maxBytes == -1L) {
            return this.wrapped.read();
        }
        if (this.totalBytesRead >= this.maxBytes) {
            return -1;
        }
        int read = this.wrapped.read();
        if (read >= 0) {
            long l = this.totalBytesRead;
            this.totalBytesRead = l + 1L;
        }
        return read;
    }

    @Override
    public int read(@NotNull byte[] destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return this.read(destination, 0, destination.length);
    }

    @Override
    public int read(@NotNull byte[] destination, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (this.maxBytes == -1L) {
            return this.wrapped.read(destination, offset, length);
        }
        if (this.totalBytesRead >= this.maxBytes) {
            return -1;
        }
        long bytesRemaining = this.maxBytes - this.totalBytesRead;
        int bytesToRead = Math.min(length, Math.toIntExact(bytesRemaining));
        int bytesRead = this.wrapped.read(destination, offset, bytesToRead);
        if (bytesRead > 0) {
            this.totalBytesRead += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long requestedSkipCount) {
        if (this.maxBytes == -1L) {
            return this.wrapped.skip(requestedSkipCount);
        }
        long bytesRemaining = this.maxBytes - this.totalBytesRead;
        long bytesToSkip = Math.min(bytesRemaining, requestedSkipCount);
        long skipCount = super.skip(bytesToSkip);
        this.totalBytesRead += skipCount;
        return skipCount;
    }

    @Override
    public int available() {
        if (this.maxBytes == -1L) {
            return this.wrapped.available();
        }
        int bytesRemaining = Math.toIntExact(this.maxBytes - this.totalBytesRead);
        return Math.min(bytesRemaining, this.wrapped.available());
    }

    @Override
    public boolean markSupported() {
        return this.wrapped.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        if (!this.markSupported()) {
            throw new UnsupportedOperationException("Mark not supported");
        }
        this.wrapped.mark(readlimit);
        if (this.maxBytes == -1L) {
            return;
        }
        this.lastMark = this.totalBytesRead;
    }

    @Override
    public void reset() {
        if (!this.markSupported()) {
            throw new UnsupportedOperationException("Mark not supported");
        }
        if (this.lastMark == -1L) {
            throw new UnsupportedOperationException("Mark not set");
        }
        this.wrapped.reset();
        if (this.maxBytes == -1L) {
            return;
        }
        this.totalBytesRead = this.lastMark;
    }

    @NotNull
    public final InputStream leftoverStream() {
        if (this.maxBytes == -1L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        if (this.totalBytesRead < this.maxBytes) {
            Log.w(TAG, "Reading leftover stream when the stream has not been fully read! maxBytes is " + this.maxBytes + ", but we've only read " + this.totalBytesRead);
        }
        return this.wrapped;
    }

    @JvmStatic
    @NotNull
    public static final LimitedInputStream withoutLimits(@NotNull InputStream wrapped) {
        return Companion.withoutLimits(wrapped);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/signal/core/util/stream/LimitedInputStream$Companion;", "", "<init>", "()V", "UNLIMITED", "", "TAG", "", "withoutLimits", "Lorg/signal/core/util/stream/LimitedInputStream;", "wrapped", "Ljava/io/InputStream;", "core-util-jvm"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LimitedInputStream withoutLimits(@NotNull InputStream wrapped) {
            Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
            return new LimitedInputStream(wrapped, -1L);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

