/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.signal.core.util.concurrent.FutureTransformers;
import org.signal.core.util.concurrent.ListenableFuture;

class FutureMapTransformer<Input, Output>
implements ListenableFuture<Output> {
    private final ListenableFuture<Input> future;
    private final FutureTransformers.Transformer<Input, Output> transformer;

    FutureMapTransformer(ListenableFuture<Input> future, FutureTransformers.Transformer<Input, Output> transformer) {
        this.future = future;
        this.transformer = transformer;
    }

    @Override
    public void addListener(final ListenableFuture.Listener<Output> listener) {
        this.future.addListener(new ListenableFuture.Listener<Input>(){

            @Override
            public void onSuccess(Input result) {
                try {
                    listener.onSuccess(FutureMapTransformer.this.transformer.transform(result));
                }
                catch (Exception e) {
                    listener.onFailure(new ExecutionException(e));
                }
            }

            @Override
            public void onFailure(ExecutionException e) {
                listener.onFailure(e);
            }
        });
    }

    @Override
    public boolean cancel(boolean b) {
        return this.future.cancel(b);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public Output get() throws InterruptedException, ExecutionException {
        Object input = this.future.get();
        try {
            return this.transformer.transform(input);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public Output get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Object input = this.future.get(l, timeUnit);
        try {
            return this.transformer.transform(input);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }
}

