/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.StickerPackUrl;
import org.asamk.signal.output.OutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddStickerPackCommand
implements JsonRpcLocalCommand {
    private static final Logger logger = LoggerFactory.getLogger(AddStickerPackCommand.class);

    @Override
    public String getName() {
        return "addStickerPack";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Install a sticker pack for this account.");
        subparser.addArgument(new String[]{"--uri"}).required(true).nargs("+").help("Specify the uri of the sticker pack. (e.g. https://signal.art/addstickers/#pack_id=XXX&pack_key=XXX)");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        List uris = ns.getList("uri");
        for (String uri : uris) {
            URI stickerUri;
            try {
                stickerUri = new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new UserErrorException("Sticker pack uri has invalid format: " + e.getMessage());
            }
            try {
                StickerPackUrl stickerPackUrl = StickerPackUrl.fromUri((URI)stickerUri);
                m.installStickerPack(stickerPackUrl);
            }
            catch (IOException e) {
                logger.error("Install sticker pack failed: {}", (Object)e.getMessage());
                throw new IOErrorException("Install sticker pack failed", e);
            }
            catch (StickerPackUrl.InvalidStickerPackLinkException e) {
                logger.error("Invalid sticker pack link");
                throw new UserErrorException("Invalid sticker pack link", e);
            }
        }
    }
}

