/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.account;

import java.security.SecureRandom;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.Base64;
import org.signal.libsignal.usernames.BaseUsernameException;
import org.signal.libsignal.usernames.Username;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.account.AccountAttributes;
import org.whispersystems.signalservice.api.account.ChangePhoneNumberRequest;
import org.whispersystems.signalservice.api.push.UsernameLinkComponents;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.ConfirmUsernameRequest;
import org.whispersystems.signalservice.internal.push.ConfirmUsernameResponse;
import org.whispersystems.signalservice.internal.push.GcmRegistrationId;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.push.ReserveUsernameRequest;
import org.whispersystems.signalservice.internal.push.ReserveUsernameResponse;
import org.whispersystems.signalservice.internal.push.SetUsernameLinkRequestBody;
import org.whispersystems.signalservice.internal.push.SetUsernameLinkResponseBody;
import org.whispersystems.signalservice.internal.push.VerifyAccountResponse;
import org.whispersystems.signalservice.internal.push.WhoAmIResponse;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\tJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0014\u001a\u00020\u000eJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\tJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\tJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\tJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\t2\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001fJ\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\tJ\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\t2\u0006\u0010)\u001a\u00020%J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020(0\t2\u0006\u0010)\u001a\u00020%J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020(0\t2\u0006\u0010)\u001a\u00020%2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/whispersystems/signalservice/api/account/AccountApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;)V", "random", "Ljava/security/SecureRandom;", "whoAmI", "Lorg/whispersystems/signalservice/api/NetworkResult;", "Lorg/whispersystems/signalservice/internal/push/WhoAmIResponse;", "setFcmToken", "", "fcmToken", "", "clearFcmToken", "setAccountAttributes", "accountAttributes", "Lorg/whispersystems/signalservice/api/account/AccountAttributes;", "enableRegistrationLock", "registrationLock", "disableRegistrationLock", "deleteAccount", "accountDataReport", "changeNumber", "Lorg/whispersystems/signalservice/internal/push/VerifyAccountResponse;", "changePhoneNumberRequest", "Lorg/whispersystems/signalservice/api/account/ChangePhoneNumberRequest;", "reserveUsername", "Lorg/whispersystems/signalservice/internal/push/ReserveUsernameResponse;", "usernameHashes", "", "confirmUsername", "Ljava/util/UUID;", "username", "Lorg/signal/libsignal/usernames/Username;", "link", "Lorg/signal/libsignal/usernames/Username$UsernameLink;", "deleteUsername", "createUsernameLink", "Lorg/whispersystems/signalservice/api/push/UsernameLinkComponents;", "usernameLink", "updateUsernameLink", "modifyUsernameLink", "keepLinkHandle", "", "signal-service-java"})
public final class AccountApi {
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private final SecureRandom random;

    public AccountApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        this.authWebSocket = authWebSocket;
        this.random = new SecureRandom();
    }

    @NotNull
    public final NetworkResult<WhoAmIResponse> whoAmI() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/accounts/whoami", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(WhoAmIResponse.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<Unit> setFcmToken(@NotNull String fcmToken) {
        Intrinsics.checkNotNullParameter((Object)fcmToken, (String)"fcmToken");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/accounts/gcm", new GcmRegistrationId(fcmToken, true), null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> clearFcmToken() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.delete$default(WebSocketRequestMessage.Companion, "/v1/accounts/gcm", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> setAccountAttributes(@NotNull AccountAttributes accountAttributes) {
        Intrinsics.checkNotNullParameter((Object)accountAttributes, (String)"accountAttributes");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/accounts/attributes", accountAttributes, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> enableRegistrationLock(@NotNull String registrationLock) {
        Intrinsics.checkNotNullParameter((Object)registrationLock, (String)"registrationLock");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/accounts/registration_lock", new PushServiceSocket.RegistrationLockV2(registrationLock), null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> disableRegistrationLock() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.delete$default(WebSocketRequestMessage.Companion, "/v1/accounts/registration_lock", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> deleteAccount() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.delete$default(WebSocketRequestMessage.Companion, "/v1/accounts/me", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<String> accountDataReport() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v2/accounts/data_report", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(String.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<VerifyAccountResponse> changeNumber(@NotNull ChangePhoneNumberRequest changePhoneNumberRequest) {
        Intrinsics.checkNotNullParameter((Object)changePhoneNumberRequest, (String)"changePhoneNumberRequest");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v2/accounts/number", changePhoneNumberRequest, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(VerifyAccountResponse.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<ReserveUsernameResponse> reserveUsername(@NotNull List<String> usernameHashes) {
        Intrinsics.checkNotNullParameter(usernameHashes, (String)"usernameHashes");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/accounts/username_hash/reserve", new ReserveUsernameRequest(usernameHashes), null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(ReserveUsernameResponse.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<UUID> confirmUsername(@NotNull Username username, @NotNull Username.UsernameLink link) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        byte[] randomness = new byte[32];
        this.random.nextBytes(randomness);
        try {
            byArray = username.generateProofWithRandomness(randomness);
            Intrinsics.checkNotNull((Object)byArray);
        }
        catch (BaseUsernameException e) {
            return new NetworkResult.ApplicationError(e);
        }
        byte[] proof = byArray;
        byte[] byArray2 = username.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getHash(...)");
        String string = Base64.encodeUrlSafeWithoutPadding((byte[])byArray2);
        String string2 = Base64.encodeUrlSafeWithoutPadding((byte[])proof);
        byte[] byArray3 = link.getEncryptedUsername();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getEncryptedUsername(...)");
        ConfirmUsernameRequest confirmUsernameRequest = new ConfirmUsernameRequest(string, string2, Base64.encodeUrlSafeWithoutPadding((byte[])byArray3));
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/accounts/username_hash/confirm", confirmUsernameRequest, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(ConfirmUsernameResponse.class), 0L, 8, null).map(AccountApi::confirmUsername$lambda$0);
    }

    @NotNull
    public final NetworkResult<Unit> deleteUsername() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.delete$default(WebSocketRequestMessage.Companion, "/v1/accounts/username_hash", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<UsernameLinkComponents> createUsernameLink(@NotNull Username.UsernameLink usernameLink) {
        Intrinsics.checkNotNullParameter((Object)usernameLink, (String)"usernameLink");
        return this.modifyUsernameLink(usernameLink, false);
    }

    @NotNull
    public final NetworkResult<UsernameLinkComponents> updateUsernameLink(@NotNull Username.UsernameLink usernameLink) {
        Intrinsics.checkNotNullParameter((Object)usernameLink, (String)"usernameLink");
        return this.modifyUsernameLink(usernameLink, true);
    }

    private final NetworkResult<UsernameLinkComponents> modifyUsernameLink(Username.UsernameLink usernameLink, boolean keepLinkHandle) {
        byte[] byArray = usernameLink.getEncryptedUsername();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncryptedUsername(...)");
        String encryptedUsername = Base64.encodeUrlSafeWithPadding((byte[])byArray);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/accounts/username_link", new SetUsernameLinkRequestBody(encryptedUsername, keepLinkHandle), null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(SetUsernameLinkResponseBody.class), 0L, 8, null).map(arg_0 -> AccountApi.modifyUsernameLink$lambda$1(usernameLink, arg_0));
    }

    private static final UUID confirmUsername$lambda$0(ConfirmUsernameResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUsernameLinkHandle();
    }

    private static final UsernameLinkComponents modifyUsernameLink$lambda$1(Username.UsernameLink $usernameLink, SetUsernameLinkResponseBody it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        byte[] byArray = $usernameLink.getEntropy();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEntropy(...)");
        return new UsernameLinkComponents(byArray, it.getUsernameLinkHandle());
    }
}

