# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.raku.
# Generated from Unicode version 15.0.0.

use Test;

plan 2000;

ok Uni.new(0x3297).NFKC.list ~~ (0x795D,), '3297 -> 795D';
ok Uni.new(0x3298).NFKC.list ~~ (0x52B4,), '3298 -> 52B4';
ok Uni.new(0x3299).NFKC.list ~~ (0x79D8,), '3299 -> 79D8';
ok Uni.new(0x329A).NFKC.list ~~ (0x7537,), '329A -> 7537';
ok Uni.new(0x329B).NFKC.list ~~ (0x5973,), '329B -> 5973';
ok Uni.new(0x329C).NFKC.list ~~ (0x9069,), '329C -> 9069';
ok Uni.new(0x329D).NFKC.list ~~ (0x512A,), '329D -> 512A';
ok Uni.new(0x329E).NFKC.list ~~ (0x5370,), '329E -> 5370';
ok Uni.new(0x329F).NFKC.list ~~ (0x6CE8,), '329F -> 6CE8';
ok Uni.new(0x32A0).NFKC.list ~~ (0x9805,), '32A0 -> 9805';
ok Uni.new(0x32A1).NFKC.list ~~ (0x4F11,), '32A1 -> 4F11';
ok Uni.new(0x32A2).NFKC.list ~~ (0x5199,), '32A2 -> 5199';
ok Uni.new(0x32A3).NFKC.list ~~ (0x6B63,), '32A3 -> 6B63';
ok Uni.new(0x32A4).NFKC.list ~~ (0x4E0A,), '32A4 -> 4E0A';
ok Uni.new(0x32A5).NFKC.list ~~ (0x4E2D,), '32A5 -> 4E2D';
ok Uni.new(0x32A6).NFKC.list ~~ (0x4E0B,), '32A6 -> 4E0B';
ok Uni.new(0x32A7).NFKC.list ~~ (0x5DE6,), '32A7 -> 5DE6';
ok Uni.new(0x32A8).NFKC.list ~~ (0x53F3,), '32A8 -> 53F3';
ok Uni.new(0x32A9).NFKC.list ~~ (0x533B,), '32A9 -> 533B';
ok Uni.new(0x32AA).NFKC.list ~~ (0x5B97,), '32AA -> 5B97';
ok Uni.new(0x32AB).NFKC.list ~~ (0x5B66,), '32AB -> 5B66';
ok Uni.new(0x32AC).NFKC.list ~~ (0x76E3,), '32AC -> 76E3';
ok Uni.new(0x32AD).NFKC.list ~~ (0x4F01,), '32AD -> 4F01';
ok Uni.new(0x32AE).NFKC.list ~~ (0x8CC7,), '32AE -> 8CC7';
ok Uni.new(0x32AF).NFKC.list ~~ (0x5354,), '32AF -> 5354';
ok Uni.new(0x32B0).NFKC.list ~~ (0x591C,), '32B0 -> 591C';
ok Uni.new(0x32B1).NFKC.list ~~ (0x0033, 0x0036,), '32B1 -> 0033 0036';
ok Uni.new(0x32B2).NFKC.list ~~ (0x0033, 0x0037,), '32B2 -> 0033 0037';
ok Uni.new(0x32B3).NFKC.list ~~ (0x0033, 0x0038,), '32B3 -> 0033 0038';
ok Uni.new(0x32B4).NFKC.list ~~ (0x0033, 0x0039,), '32B4 -> 0033 0039';
ok Uni.new(0x32B5).NFKC.list ~~ (0x0034, 0x0030,), '32B5 -> 0034 0030';
ok Uni.new(0x32B6).NFKC.list ~~ (0x0034, 0x0031,), '32B6 -> 0034 0031';
ok Uni.new(0x32B7).NFKC.list ~~ (0x0034, 0x0032,), '32B7 -> 0034 0032';
ok Uni.new(0x32B8).NFKC.list ~~ (0x0034, 0x0033,), '32B8 -> 0034 0033';
ok Uni.new(0x32B9).NFKC.list ~~ (0x0034, 0x0034,), '32B9 -> 0034 0034';
ok Uni.new(0x32BA).NFKC.list ~~ (0x0034, 0x0035,), '32BA -> 0034 0035';
ok Uni.new(0x32BB).NFKC.list ~~ (0x0034, 0x0036,), '32BB -> 0034 0036';
ok Uni.new(0x32BC).NFKC.list ~~ (0x0034, 0x0037,), '32BC -> 0034 0037';
ok Uni.new(0x32BD).NFKC.list ~~ (0x0034, 0x0038,), '32BD -> 0034 0038';
ok Uni.new(0x32BE).NFKC.list ~~ (0x0034, 0x0039,), '32BE -> 0034 0039';
ok Uni.new(0x32BF).NFKC.list ~~ (0x0035, 0x0030,), '32BF -> 0035 0030';
ok Uni.new(0x32C0).NFKC.list ~~ (0x0031, 0x6708,), '32C0 -> 0031 6708';
ok Uni.new(0x32C1).NFKC.list ~~ (0x0032, 0x6708,), '32C1 -> 0032 6708';
ok Uni.new(0x32C2).NFKC.list ~~ (0x0033, 0x6708,), '32C2 -> 0033 6708';
ok Uni.new(0x32C3).NFKC.list ~~ (0x0034, 0x6708,), '32C3 -> 0034 6708';
ok Uni.new(0x32C4).NFKC.list ~~ (0x0035, 0x6708,), '32C4 -> 0035 6708';
ok Uni.new(0x32C5).NFKC.list ~~ (0x0036, 0x6708,), '32C5 -> 0036 6708';
ok Uni.new(0x32C6).NFKC.list ~~ (0x0037, 0x6708,), '32C6 -> 0037 6708';
ok Uni.new(0x32C7).NFKC.list ~~ (0x0038, 0x6708,), '32C7 -> 0038 6708';
ok Uni.new(0x32C8).NFKC.list ~~ (0x0039, 0x6708,), '32C8 -> 0039 6708';
ok Uni.new(0x32C9).NFKC.list ~~ (0x0031, 0x0030, 0x6708,), '32C9 -> 0031 0030 6708';
ok Uni.new(0x32CA).NFKC.list ~~ (0x0031, 0x0031, 0x6708,), '32CA -> 0031 0031 6708';
ok Uni.new(0x32CB).NFKC.list ~~ (0x0031, 0x0032, 0x6708,), '32CB -> 0031 0032 6708';
ok Uni.new(0x32CC).NFKC.list ~~ (0x0048, 0x0067,), '32CC -> 0048 0067';
ok Uni.new(0x32CD).NFKC.list ~~ (0x0065, 0x0072, 0x0067,), '32CD -> 0065 0072 0067';
ok Uni.new(0x32CE).NFKC.list ~~ (0x0065, 0x0056,), '32CE -> 0065 0056';
ok Uni.new(0x32CF).NFKC.list ~~ (0x004C, 0x0054, 0x0044,), '32CF -> 004C 0054 0044';
ok Uni.new(0x32D0).NFKC.list ~~ (0x30A2,), '32D0 -> 30A2';
ok Uni.new(0x32D1).NFKC.list ~~ (0x30A4,), '32D1 -> 30A4';
ok Uni.new(0x32D2).NFKC.list ~~ (0x30A6,), '32D2 -> 30A6';
ok Uni.new(0x32D3).NFKC.list ~~ (0x30A8,), '32D3 -> 30A8';
ok Uni.new(0x32D4).NFKC.list ~~ (0x30AA,), '32D4 -> 30AA';
ok Uni.new(0x32D5).NFKC.list ~~ (0x30AB,), '32D5 -> 30AB';
ok Uni.new(0x32D6).NFKC.list ~~ (0x30AD,), '32D6 -> 30AD';
ok Uni.new(0x32D7).NFKC.list ~~ (0x30AF,), '32D7 -> 30AF';
ok Uni.new(0x32D8).NFKC.list ~~ (0x30B1,), '32D8 -> 30B1';
ok Uni.new(0x32D9).NFKC.list ~~ (0x30B3,), '32D9 -> 30B3';
ok Uni.new(0x32DA).NFKC.list ~~ (0x30B5,), '32DA -> 30B5';
ok Uni.new(0x32DB).NFKC.list ~~ (0x30B7,), '32DB -> 30B7';
ok Uni.new(0x32DC).NFKC.list ~~ (0x30B9,), '32DC -> 30B9';
ok Uni.new(0x32DD).NFKC.list ~~ (0x30BB,), '32DD -> 30BB';
ok Uni.new(0x32DE).NFKC.list ~~ (0x30BD,), '32DE -> 30BD';
ok Uni.new(0x32DF).NFKC.list ~~ (0x30BF,), '32DF -> 30BF';
ok Uni.new(0x32E0).NFKC.list ~~ (0x30C1,), '32E0 -> 30C1';
ok Uni.new(0x32E1).NFKC.list ~~ (0x30C4,), '32E1 -> 30C4';
ok Uni.new(0x32E2).NFKC.list ~~ (0x30C6,), '32E2 -> 30C6';
ok Uni.new(0x32E3).NFKC.list ~~ (0x30C8,), '32E3 -> 30C8';
ok Uni.new(0x32E4).NFKC.list ~~ (0x30CA,), '32E4 -> 30CA';
ok Uni.new(0x32E5).NFKC.list ~~ (0x30CB,), '32E5 -> 30CB';
ok Uni.new(0x32E6).NFKC.list ~~ (0x30CC,), '32E6 -> 30CC';
ok Uni.new(0x32E7).NFKC.list ~~ (0x30CD,), '32E7 -> 30CD';
ok Uni.new(0x32E8).NFKC.list ~~ (0x30CE,), '32E8 -> 30CE';
ok Uni.new(0x32E9).NFKC.list ~~ (0x30CF,), '32E9 -> 30CF';
ok Uni.new(0x32EA).NFKC.list ~~ (0x30D2,), '32EA -> 30D2';
ok Uni.new(0x32EB).NFKC.list ~~ (0x30D5,), '32EB -> 30D5';
ok Uni.new(0x32EC).NFKC.list ~~ (0x30D8,), '32EC -> 30D8';
ok Uni.new(0x32ED).NFKC.list ~~ (0x30DB,), '32ED -> 30DB';
ok Uni.new(0x32EE).NFKC.list ~~ (0x30DE,), '32EE -> 30DE';
ok Uni.new(0x32EF).NFKC.list ~~ (0x30DF,), '32EF -> 30DF';
ok Uni.new(0x32F0).NFKC.list ~~ (0x30E0,), '32F0 -> 30E0';
ok Uni.new(0x32F1).NFKC.list ~~ (0x30E1,), '32F1 -> 30E1';
ok Uni.new(0x32F2).NFKC.list ~~ (0x30E2,), '32F2 -> 30E2';
ok Uni.new(0x32F3).NFKC.list ~~ (0x30E4,), '32F3 -> 30E4';
ok Uni.new(0x32F4).NFKC.list ~~ (0x30E6,), '32F4 -> 30E6';
ok Uni.new(0x32F5).NFKC.list ~~ (0x30E8,), '32F5 -> 30E8';
ok Uni.new(0x32F6).NFKC.list ~~ (0x30E9,), '32F6 -> 30E9';
ok Uni.new(0x32F7).NFKC.list ~~ (0x30EA,), '32F7 -> 30EA';
ok Uni.new(0x32F8).NFKC.list ~~ (0x30EB,), '32F8 -> 30EB';
ok Uni.new(0x32F9).NFKC.list ~~ (0x30EC,), '32F9 -> 30EC';
ok Uni.new(0x32FA).NFKC.list ~~ (0x30ED,), '32FA -> 30ED';
ok Uni.new(0x32FB).NFKC.list ~~ (0x30EF,), '32FB -> 30EF';
ok Uni.new(0x32FC).NFKC.list ~~ (0x30F0,), '32FC -> 30F0';
ok Uni.new(0x32FD).NFKC.list ~~ (0x30F1,), '32FD -> 30F1';
ok Uni.new(0x32FE).NFKC.list ~~ (0x30F2,), '32FE -> 30F2';
ok Uni.new(0x32FF).NFKC.list ~~ (0x4EE4, 0x548C,), '32FF -> 4EE4 548C';
ok Uni.new(0x3300).NFKC.list ~~ (0x30A2, 0x30D1, 0x30FC, 0x30C8,), '3300 -> 30A2 30D1 30FC 30C8';
ok Uni.new(0x3301).NFKC.list ~~ (0x30A2, 0x30EB, 0x30D5, 0x30A1,), '3301 -> 30A2 30EB 30D5 30A1';
ok Uni.new(0x3302).NFKC.list ~~ (0x30A2, 0x30F3, 0x30DA, 0x30A2,), '3302 -> 30A2 30F3 30DA 30A2';
ok Uni.new(0x3303).NFKC.list ~~ (0x30A2, 0x30FC, 0x30EB,), '3303 -> 30A2 30FC 30EB';
ok Uni.new(0x3304).NFKC.list ~~ (0x30A4, 0x30CB, 0x30F3, 0x30B0,), '3304 -> 30A4 30CB 30F3 30B0';
ok Uni.new(0x3305).NFKC.list ~~ (0x30A4, 0x30F3, 0x30C1,), '3305 -> 30A4 30F3 30C1';
ok Uni.new(0x3306).NFKC.list ~~ (0x30A6, 0x30A9, 0x30F3,), '3306 -> 30A6 30A9 30F3';
ok Uni.new(0x3307).NFKC.list ~~ (0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C9,), '3307 -> 30A8 30B9 30AF 30FC 30C9';
ok Uni.new(0x3308).NFKC.list ~~ (0x30A8, 0x30FC, 0x30AB, 0x30FC,), '3308 -> 30A8 30FC 30AB 30FC';
ok Uni.new(0x3309).NFKC.list ~~ (0x30AA, 0x30F3, 0x30B9,), '3309 -> 30AA 30F3 30B9';
ok Uni.new(0x330A).NFKC.list ~~ (0x30AA, 0x30FC, 0x30E0,), '330A -> 30AA 30FC 30E0';
ok Uni.new(0x330B).NFKC.list ~~ (0x30AB, 0x30A4, 0x30EA,), '330B -> 30AB 30A4 30EA';
ok Uni.new(0x330C).NFKC.list ~~ (0x30AB, 0x30E9, 0x30C3, 0x30C8,), '330C -> 30AB 30E9 30C3 30C8';
ok Uni.new(0x330D).NFKC.list ~~ (0x30AB, 0x30ED, 0x30EA, 0x30FC,), '330D -> 30AB 30ED 30EA 30FC';
ok Uni.new(0x330E).NFKC.list ~~ (0x30AC, 0x30ED, 0x30F3,), '330E -> 30AC 30ED 30F3';
ok Uni.new(0x330F).NFKC.list ~~ (0x30AC, 0x30F3, 0x30DE,), '330F -> 30AC 30F3 30DE';
ok Uni.new(0x3310).NFKC.list ~~ (0x30AE, 0x30AC,), '3310 -> 30AE 30AC';
ok Uni.new(0x3311).NFKC.list ~~ (0x30AE, 0x30CB, 0x30FC,), '3311 -> 30AE 30CB 30FC';
ok Uni.new(0x3312).NFKC.list ~~ (0x30AD, 0x30E5, 0x30EA, 0x30FC,), '3312 -> 30AD 30E5 30EA 30FC';
ok Uni.new(0x3313).NFKC.list ~~ (0x30AE, 0x30EB, 0x30C0, 0x30FC,), '3313 -> 30AE 30EB 30C0 30FC';
ok Uni.new(0x3314).NFKC.list ~~ (0x30AD, 0x30ED,), '3314 -> 30AD 30ED';
ok Uni.new(0x3315).NFKC.list ~~ (0x30AD, 0x30ED, 0x30B0, 0x30E9, 0x30E0,), '3315 -> 30AD 30ED 30B0 30E9 30E0';
ok Uni.new(0x3316).NFKC.list ~~ (0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB,), '3316 -> 30AD 30ED 30E1 30FC 30C8 30EB';
ok Uni.new(0x3317).NFKC.list ~~ (0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8,), '3317 -> 30AD 30ED 30EF 30C3 30C8';
ok Uni.new(0x3318).NFKC.list ~~ (0x30B0, 0x30E9, 0x30E0,), '3318 -> 30B0 30E9 30E0';
ok Uni.new(0x3319).NFKC.list ~~ (0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3,), '3319 -> 30B0 30E9 30E0 30C8 30F3';
ok Uni.new(0x331A).NFKC.list ~~ (0x30AF, 0x30EB, 0x30BC, 0x30A4, 0x30ED,), '331A -> 30AF 30EB 30BC 30A4 30ED';
ok Uni.new(0x331B).NFKC.list ~~ (0x30AF, 0x30ED, 0x30FC, 0x30CD,), '331B -> 30AF 30ED 30FC 30CD';
ok Uni.new(0x331C).NFKC.list ~~ (0x30B1, 0x30FC, 0x30B9,), '331C -> 30B1 30FC 30B9';
ok Uni.new(0x331D).NFKC.list ~~ (0x30B3, 0x30EB, 0x30CA,), '331D -> 30B3 30EB 30CA';
ok Uni.new(0x331E).NFKC.list ~~ (0x30B3, 0x30FC, 0x30DD,), '331E -> 30B3 30FC 30DD';
ok Uni.new(0x331F).NFKC.list ~~ (0x30B5, 0x30A4, 0x30AF, 0x30EB,), '331F -> 30B5 30A4 30AF 30EB';
ok Uni.new(0x3320).NFKC.list ~~ (0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0,), '3320 -> 30B5 30F3 30C1 30FC 30E0';
ok Uni.new(0x3321).NFKC.list ~~ (0x30B7, 0x30EA, 0x30F3, 0x30B0,), '3321 -> 30B7 30EA 30F3 30B0';
ok Uni.new(0x3322).NFKC.list ~~ (0x30BB, 0x30F3, 0x30C1,), '3322 -> 30BB 30F3 30C1';
ok Uni.new(0x3323).NFKC.list ~~ (0x30BB, 0x30F3, 0x30C8,), '3323 -> 30BB 30F3 30C8';
ok Uni.new(0x3324).NFKC.list ~~ (0x30C0, 0x30FC, 0x30B9,), '3324 -> 30C0 30FC 30B9';
ok Uni.new(0x3325).NFKC.list ~~ (0x30C7, 0x30B7,), '3325 -> 30C7 30B7';
ok Uni.new(0x3326).NFKC.list ~~ (0x30C9, 0x30EB,), '3326 -> 30C9 30EB';
ok Uni.new(0x3327).NFKC.list ~~ (0x30C8, 0x30F3,), '3327 -> 30C8 30F3';
ok Uni.new(0x3328).NFKC.list ~~ (0x30CA, 0x30CE,), '3328 -> 30CA 30CE';
ok Uni.new(0x3329).NFKC.list ~~ (0x30CE, 0x30C3, 0x30C8,), '3329 -> 30CE 30C3 30C8';
ok Uni.new(0x332A).NFKC.list ~~ (0x30CF, 0x30A4, 0x30C4,), '332A -> 30CF 30A4 30C4';
ok Uni.new(0x332B).NFKC.list ~~ (0x30D1, 0x30FC, 0x30BB, 0x30F3, 0x30C8,), '332B -> 30D1 30FC 30BB 30F3 30C8';
ok Uni.new(0x332C).NFKC.list ~~ (0x30D1, 0x30FC, 0x30C4,), '332C -> 30D1 30FC 30C4';
ok Uni.new(0x332D).NFKC.list ~~ (0x30D0, 0x30FC, 0x30EC, 0x30EB,), '332D -> 30D0 30FC 30EC 30EB';
ok Uni.new(0x332E).NFKC.list ~~ (0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB,), '332E -> 30D4 30A2 30B9 30C8 30EB';
ok Uni.new(0x332F).NFKC.list ~~ (0x30D4, 0x30AF, 0x30EB,), '332F -> 30D4 30AF 30EB';
ok Uni.new(0x3330).NFKC.list ~~ (0x30D4, 0x30B3,), '3330 -> 30D4 30B3';
ok Uni.new(0x3331).NFKC.list ~~ (0x30D3, 0x30EB,), '3331 -> 30D3 30EB';
ok Uni.new(0x3332).NFKC.list ~~ (0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C9,), '3332 -> 30D5 30A1 30E9 30C3 30C9';
ok Uni.new(0x3333).NFKC.list ~~ (0x30D5, 0x30A3, 0x30FC, 0x30C8,), '3333 -> 30D5 30A3 30FC 30C8';
ok Uni.new(0x3334).NFKC.list ~~ (0x30D6, 0x30C3, 0x30B7, 0x30A7, 0x30EB,), '3334 -> 30D6 30C3 30B7 30A7 30EB';
ok Uni.new(0x3335).NFKC.list ~~ (0x30D5, 0x30E9, 0x30F3,), '3335 -> 30D5 30E9 30F3';
ok Uni.new(0x3336).NFKC.list ~~ (0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB,), '3336 -> 30D8 30AF 30BF 30FC 30EB';
ok Uni.new(0x3337).NFKC.list ~~ (0x30DA, 0x30BD,), '3337 -> 30DA 30BD';
ok Uni.new(0x3338).NFKC.list ~~ (0x30DA, 0x30CB, 0x30D2,), '3338 -> 30DA 30CB 30D2';
ok Uni.new(0x3339).NFKC.list ~~ (0x30D8, 0x30EB, 0x30C4,), '3339 -> 30D8 30EB 30C4';
ok Uni.new(0x333A).NFKC.list ~~ (0x30DA, 0x30F3, 0x30B9,), '333A -> 30DA 30F3 30B9';
ok Uni.new(0x333B).NFKC.list ~~ (0x30DA, 0x30FC, 0x30B8,), '333B -> 30DA 30FC 30B8';
ok Uni.new(0x333C).NFKC.list ~~ (0x30D9, 0x30FC, 0x30BF,), '333C -> 30D9 30FC 30BF';
ok Uni.new(0x333D).NFKC.list ~~ (0x30DD, 0x30A4, 0x30F3, 0x30C8,), '333D -> 30DD 30A4 30F3 30C8';
ok Uni.new(0x333E).NFKC.list ~~ (0x30DC, 0x30EB, 0x30C8,), '333E -> 30DC 30EB 30C8';
ok Uni.new(0x333F).NFKC.list ~~ (0x30DB, 0x30F3,), '333F -> 30DB 30F3';
ok Uni.new(0x3340).NFKC.list ~~ (0x30DD, 0x30F3, 0x30C9,), '3340 -> 30DD 30F3 30C9';
ok Uni.new(0x3341).NFKC.list ~~ (0x30DB, 0x30FC, 0x30EB,), '3341 -> 30DB 30FC 30EB';
ok Uni.new(0x3342).NFKC.list ~~ (0x30DB, 0x30FC, 0x30F3,), '3342 -> 30DB 30FC 30F3';
ok Uni.new(0x3343).NFKC.list ~~ (0x30DE, 0x30A4, 0x30AF, 0x30ED,), '3343 -> 30DE 30A4 30AF 30ED';
ok Uni.new(0x3344).NFKC.list ~~ (0x30DE, 0x30A4, 0x30EB,), '3344 -> 30DE 30A4 30EB';
ok Uni.new(0x3345).NFKC.list ~~ (0x30DE, 0x30C3, 0x30CF,), '3345 -> 30DE 30C3 30CF';
ok Uni.new(0x3346).NFKC.list ~~ (0x30DE, 0x30EB, 0x30AF,), '3346 -> 30DE 30EB 30AF';
ok Uni.new(0x3347).NFKC.list ~~ (0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3,), '3347 -> 30DE 30F3 30B7 30E7 30F3';
ok Uni.new(0x3348).NFKC.list ~~ (0x30DF, 0x30AF, 0x30ED, 0x30F3,), '3348 -> 30DF 30AF 30ED 30F3';
ok Uni.new(0x3349).NFKC.list ~~ (0x30DF, 0x30EA,), '3349 -> 30DF 30EA';
ok Uni.new(0x334A).NFKC.list ~~ (0x30DF, 0x30EA, 0x30D0, 0x30FC, 0x30EB,), '334A -> 30DF 30EA 30D0 30FC 30EB';
ok Uni.new(0x334B).NFKC.list ~~ (0x30E1, 0x30AC,), '334B -> 30E1 30AC';
ok Uni.new(0x334C).NFKC.list ~~ (0x30E1, 0x30AC, 0x30C8, 0x30F3,), '334C -> 30E1 30AC 30C8 30F3';
ok Uni.new(0x334D).NFKC.list ~~ (0x30E1, 0x30FC, 0x30C8, 0x30EB,), '334D -> 30E1 30FC 30C8 30EB';
ok Uni.new(0x334E).NFKC.list ~~ (0x30E4, 0x30FC, 0x30C9,), '334E -> 30E4 30FC 30C9';
ok Uni.new(0x334F).NFKC.list ~~ (0x30E4, 0x30FC, 0x30EB,), '334F -> 30E4 30FC 30EB';
ok Uni.new(0x3350).NFKC.list ~~ (0x30E6, 0x30A2, 0x30F3,), '3350 -> 30E6 30A2 30F3';
ok Uni.new(0x3351).NFKC.list ~~ (0x30EA, 0x30C3, 0x30C8, 0x30EB,), '3351 -> 30EA 30C3 30C8 30EB';
ok Uni.new(0x3352).NFKC.list ~~ (0x30EA, 0x30E9,), '3352 -> 30EA 30E9';
ok Uni.new(0x3353).NFKC.list ~~ (0x30EB, 0x30D4, 0x30FC,), '3353 -> 30EB 30D4 30FC';
ok Uni.new(0x3354).NFKC.list ~~ (0x30EB, 0x30FC, 0x30D6, 0x30EB,), '3354 -> 30EB 30FC 30D6 30EB';
ok Uni.new(0x3355).NFKC.list ~~ (0x30EC, 0x30E0,), '3355 -> 30EC 30E0';
ok Uni.new(0x3356).NFKC.list ~~ (0x30EC, 0x30F3, 0x30C8, 0x30B2, 0x30F3,), '3356 -> 30EC 30F3 30C8 30B2 30F3';
ok Uni.new(0x3357).NFKC.list ~~ (0x30EF, 0x30C3, 0x30C8,), '3357 -> 30EF 30C3 30C8';
ok Uni.new(0x3358).NFKC.list ~~ (0x0030, 0x70B9,), '3358 -> 0030 70B9';
ok Uni.new(0x3359).NFKC.list ~~ (0x0031, 0x70B9,), '3359 -> 0031 70B9';
ok Uni.new(0x335A).NFKC.list ~~ (0x0032, 0x70B9,), '335A -> 0032 70B9';
ok Uni.new(0x335B).NFKC.list ~~ (0x0033, 0x70B9,), '335B -> 0033 70B9';
ok Uni.new(0x335C).NFKC.list ~~ (0x0034, 0x70B9,), '335C -> 0034 70B9';
ok Uni.new(0x335D).NFKC.list ~~ (0x0035, 0x70B9,), '335D -> 0035 70B9';
ok Uni.new(0x335E).NFKC.list ~~ (0x0036, 0x70B9,), '335E -> 0036 70B9';
ok Uni.new(0x335F).NFKC.list ~~ (0x0037, 0x70B9,), '335F -> 0037 70B9';
ok Uni.new(0x3360).NFKC.list ~~ (0x0038, 0x70B9,), '3360 -> 0038 70B9';
ok Uni.new(0x3361).NFKC.list ~~ (0x0039, 0x70B9,), '3361 -> 0039 70B9';
ok Uni.new(0x3362).NFKC.list ~~ (0x0031, 0x0030, 0x70B9,), '3362 -> 0031 0030 70B9';
ok Uni.new(0x3363).NFKC.list ~~ (0x0031, 0x0031, 0x70B9,), '3363 -> 0031 0031 70B9';
ok Uni.new(0x3364).NFKC.list ~~ (0x0031, 0x0032, 0x70B9,), '3364 -> 0031 0032 70B9';
ok Uni.new(0x3365).NFKC.list ~~ (0x0031, 0x0033, 0x70B9,), '3365 -> 0031 0033 70B9';
ok Uni.new(0x3366).NFKC.list ~~ (0x0031, 0x0034, 0x70B9,), '3366 -> 0031 0034 70B9';
ok Uni.new(0x3367).NFKC.list ~~ (0x0031, 0x0035, 0x70B9,), '3367 -> 0031 0035 70B9';
ok Uni.new(0x3368).NFKC.list ~~ (0x0031, 0x0036, 0x70B9,), '3368 -> 0031 0036 70B9';
ok Uni.new(0x3369).NFKC.list ~~ (0x0031, 0x0037, 0x70B9,), '3369 -> 0031 0037 70B9';
ok Uni.new(0x336A).NFKC.list ~~ (0x0031, 0x0038, 0x70B9,), '336A -> 0031 0038 70B9';
ok Uni.new(0x336B).NFKC.list ~~ (0x0031, 0x0039, 0x70B9,), '336B -> 0031 0039 70B9';
ok Uni.new(0x336C).NFKC.list ~~ (0x0032, 0x0030, 0x70B9,), '336C -> 0032 0030 70B9';
ok Uni.new(0x336D).NFKC.list ~~ (0x0032, 0x0031, 0x70B9,), '336D -> 0032 0031 70B9';
ok Uni.new(0x336E).NFKC.list ~~ (0x0032, 0x0032, 0x70B9,), '336E -> 0032 0032 70B9';
ok Uni.new(0x336F).NFKC.list ~~ (0x0032, 0x0033, 0x70B9,), '336F -> 0032 0033 70B9';
ok Uni.new(0x3370).NFKC.list ~~ (0x0032, 0x0034, 0x70B9,), '3370 -> 0032 0034 70B9';
ok Uni.new(0x3371).NFKC.list ~~ (0x0068, 0x0050, 0x0061,), '3371 -> 0068 0050 0061';
ok Uni.new(0x3372).NFKC.list ~~ (0x0064, 0x0061,), '3372 -> 0064 0061';
ok Uni.new(0x3373).NFKC.list ~~ (0x0041, 0x0055,), '3373 -> 0041 0055';
ok Uni.new(0x3374).NFKC.list ~~ (0x0062, 0x0061, 0x0072,), '3374 -> 0062 0061 0072';
ok Uni.new(0x3375).NFKC.list ~~ (0x006F, 0x0056,), '3375 -> 006F 0056';
ok Uni.new(0x3376).NFKC.list ~~ (0x0070, 0x0063,), '3376 -> 0070 0063';
ok Uni.new(0x3377).NFKC.list ~~ (0x0064, 0x006D,), '3377 -> 0064 006D';
ok Uni.new(0x3378).NFKC.list ~~ (0x0064, 0x006D, 0x0032,), '3378 -> 0064 006D 0032';
ok Uni.new(0x3379).NFKC.list ~~ (0x0064, 0x006D, 0x0033,), '3379 -> 0064 006D 0033';
ok Uni.new(0x337A).NFKC.list ~~ (0x0049, 0x0055,), '337A -> 0049 0055';
ok Uni.new(0x337B).NFKC.list ~~ (0x5E73, 0x6210,), '337B -> 5E73 6210';
ok Uni.new(0x337C).NFKC.list ~~ (0x662D, 0x548C,), '337C -> 662D 548C';
ok Uni.new(0x337D).NFKC.list ~~ (0x5927, 0x6B63,), '337D -> 5927 6B63';
ok Uni.new(0x337E).NFKC.list ~~ (0x660E, 0x6CBB,), '337E -> 660E 6CBB';
ok Uni.new(0x337F).NFKC.list ~~ (0x682A, 0x5F0F, 0x4F1A, 0x793E,), '337F -> 682A 5F0F 4F1A 793E';
ok Uni.new(0x3380).NFKC.list ~~ (0x0070, 0x0041,), '3380 -> 0070 0041';
ok Uni.new(0x3381).NFKC.list ~~ (0x006E, 0x0041,), '3381 -> 006E 0041';
ok Uni.new(0x3382).NFKC.list ~~ (0x03BC, 0x0041,), '3382 -> 03BC 0041';
ok Uni.new(0x3383).NFKC.list ~~ (0x006D, 0x0041,), '3383 -> 006D 0041';
ok Uni.new(0x3384).NFKC.list ~~ (0x006B, 0x0041,), '3384 -> 006B 0041';
ok Uni.new(0x3385).NFKC.list ~~ (0x004B, 0x0042,), '3385 -> 004B 0042';
ok Uni.new(0x3386).NFKC.list ~~ (0x004D, 0x0042,), '3386 -> 004D 0042';
ok Uni.new(0x3387).NFKC.list ~~ (0x0047, 0x0042,), '3387 -> 0047 0042';
ok Uni.new(0x3388).NFKC.list ~~ (0x0063, 0x0061, 0x006C,), '3388 -> 0063 0061 006C';
ok Uni.new(0x3389).NFKC.list ~~ (0x006B, 0x0063, 0x0061, 0x006C,), '3389 -> 006B 0063 0061 006C';
ok Uni.new(0x338A).NFKC.list ~~ (0x0070, 0x0046,), '338A -> 0070 0046';
ok Uni.new(0x338B).NFKC.list ~~ (0x006E, 0x0046,), '338B -> 006E 0046';
ok Uni.new(0x338C).NFKC.list ~~ (0x03BC, 0x0046,), '338C -> 03BC 0046';
ok Uni.new(0x338D).NFKC.list ~~ (0x03BC, 0x0067,), '338D -> 03BC 0067';
ok Uni.new(0x338E).NFKC.list ~~ (0x006D, 0x0067,), '338E -> 006D 0067';
ok Uni.new(0x338F).NFKC.list ~~ (0x006B, 0x0067,), '338F -> 006B 0067';
ok Uni.new(0x3390).NFKC.list ~~ (0x0048, 0x007A,), '3390 -> 0048 007A';
ok Uni.new(0x3391).NFKC.list ~~ (0x006B, 0x0048, 0x007A,), '3391 -> 006B 0048 007A';
ok Uni.new(0x3392).NFKC.list ~~ (0x004D, 0x0048, 0x007A,), '3392 -> 004D 0048 007A';
ok Uni.new(0x3393).NFKC.list ~~ (0x0047, 0x0048, 0x007A,), '3393 -> 0047 0048 007A';
ok Uni.new(0x3394).NFKC.list ~~ (0x0054, 0x0048, 0x007A,), '3394 -> 0054 0048 007A';
ok Uni.new(0x3395).NFKC.list ~~ (0x03BC, 0x006C,), '3395 -> 03BC 006C';
ok Uni.new(0x3396).NFKC.list ~~ (0x006D, 0x006C,), '3396 -> 006D 006C';
ok Uni.new(0x3397).NFKC.list ~~ (0x0064, 0x006C,), '3397 -> 0064 006C';
ok Uni.new(0x3398).NFKC.list ~~ (0x006B, 0x006C,), '3398 -> 006B 006C';
ok Uni.new(0x3399).NFKC.list ~~ (0x0066, 0x006D,), '3399 -> 0066 006D';
ok Uni.new(0x339A).NFKC.list ~~ (0x006E, 0x006D,), '339A -> 006E 006D';
ok Uni.new(0x339B).NFKC.list ~~ (0x03BC, 0x006D,), '339B -> 03BC 006D';
ok Uni.new(0x339C).NFKC.list ~~ (0x006D, 0x006D,), '339C -> 006D 006D';
ok Uni.new(0x339D).NFKC.list ~~ (0x0063, 0x006D,), '339D -> 0063 006D';
ok Uni.new(0x339E).NFKC.list ~~ (0x006B, 0x006D,), '339E -> 006B 006D';
ok Uni.new(0x339F).NFKC.list ~~ (0x006D, 0x006D, 0x0032,), '339F -> 006D 006D 0032';
ok Uni.new(0x33A0).NFKC.list ~~ (0x0063, 0x006D, 0x0032,), '33A0 -> 0063 006D 0032';
ok Uni.new(0x33A1).NFKC.list ~~ (0x006D, 0x0032,), '33A1 -> 006D 0032';
ok Uni.new(0x33A2).NFKC.list ~~ (0x006B, 0x006D, 0x0032,), '33A2 -> 006B 006D 0032';
ok Uni.new(0x33A3).NFKC.list ~~ (0x006D, 0x006D, 0x0033,), '33A3 -> 006D 006D 0033';
ok Uni.new(0x33A4).NFKC.list ~~ (0x0063, 0x006D, 0x0033,), '33A4 -> 0063 006D 0033';
ok Uni.new(0x33A5).NFKC.list ~~ (0x006D, 0x0033,), '33A5 -> 006D 0033';
ok Uni.new(0x33A6).NFKC.list ~~ (0x006B, 0x006D, 0x0033,), '33A6 -> 006B 006D 0033';
ok Uni.new(0x33A7).NFKC.list ~~ (0x006D, 0x2215, 0x0073,), '33A7 -> 006D 2215 0073';
ok Uni.new(0x33A8).NFKC.list ~~ (0x006D, 0x2215, 0x0073, 0x0032,), '33A8 -> 006D 2215 0073 0032';
ok Uni.new(0x33A9).NFKC.list ~~ (0x0050, 0x0061,), '33A9 -> 0050 0061';
ok Uni.new(0x33AA).NFKC.list ~~ (0x006B, 0x0050, 0x0061,), '33AA -> 006B 0050 0061';
ok Uni.new(0x33AB).NFKC.list ~~ (0x004D, 0x0050, 0x0061,), '33AB -> 004D 0050 0061';
ok Uni.new(0x33AC).NFKC.list ~~ (0x0047, 0x0050, 0x0061,), '33AC -> 0047 0050 0061';
ok Uni.new(0x33AD).NFKC.list ~~ (0x0072, 0x0061, 0x0064,), '33AD -> 0072 0061 0064';
ok Uni.new(0x33AE).NFKC.list ~~ (0x0072, 0x0061, 0x0064, 0x2215, 0x0073,), '33AE -> 0072 0061 0064 2215 0073';
ok Uni.new(0x33AF).NFKC.list ~~ (0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0032,), '33AF -> 0072 0061 0064 2215 0073 0032';
ok Uni.new(0x33B0).NFKC.list ~~ (0x0070, 0x0073,), '33B0 -> 0070 0073';
ok Uni.new(0x33B1).NFKC.list ~~ (0x006E, 0x0073,), '33B1 -> 006E 0073';
ok Uni.new(0x33B2).NFKC.list ~~ (0x03BC, 0x0073,), '33B2 -> 03BC 0073';
ok Uni.new(0x33B3).NFKC.list ~~ (0x006D, 0x0073,), '33B3 -> 006D 0073';
ok Uni.new(0x33B4).NFKC.list ~~ (0x0070, 0x0056,), '33B4 -> 0070 0056';
ok Uni.new(0x33B5).NFKC.list ~~ (0x006E, 0x0056,), '33B5 -> 006E 0056';
ok Uni.new(0x33B6).NFKC.list ~~ (0x03BC, 0x0056,), '33B6 -> 03BC 0056';
ok Uni.new(0x33B7).NFKC.list ~~ (0x006D, 0x0056,), '33B7 -> 006D 0056';
ok Uni.new(0x33B8).NFKC.list ~~ (0x006B, 0x0056,), '33B8 -> 006B 0056';
ok Uni.new(0x33B9).NFKC.list ~~ (0x004D, 0x0056,), '33B9 -> 004D 0056';
ok Uni.new(0x33BA).NFKC.list ~~ (0x0070, 0x0057,), '33BA -> 0070 0057';
ok Uni.new(0x33BB).NFKC.list ~~ (0x006E, 0x0057,), '33BB -> 006E 0057';
ok Uni.new(0x33BC).NFKC.list ~~ (0x03BC, 0x0057,), '33BC -> 03BC 0057';
ok Uni.new(0x33BD).NFKC.list ~~ (0x006D, 0x0057,), '33BD -> 006D 0057';
ok Uni.new(0x33BE).NFKC.list ~~ (0x006B, 0x0057,), '33BE -> 006B 0057';
ok Uni.new(0x33BF).NFKC.list ~~ (0x004D, 0x0057,), '33BF -> 004D 0057';
ok Uni.new(0x33C0).NFKC.list ~~ (0x006B, 0x03A9,), '33C0 -> 006B 03A9';
ok Uni.new(0x33C1).NFKC.list ~~ (0x004D, 0x03A9,), '33C1 -> 004D 03A9';
ok Uni.new(0x33C2).NFKC.list ~~ (0x0061, 0x002E, 0x006D, 0x002E,), '33C2 -> 0061 002E 006D 002E';
ok Uni.new(0x33C3).NFKC.list ~~ (0x0042, 0x0071,), '33C3 -> 0042 0071';
ok Uni.new(0x33C4).NFKC.list ~~ (0x0063, 0x0063,), '33C4 -> 0063 0063';
ok Uni.new(0x33C5).NFKC.list ~~ (0x0063, 0x0064,), '33C5 -> 0063 0064';
ok Uni.new(0x33C6).NFKC.list ~~ (0x0043, 0x2215, 0x006B, 0x0067,), '33C6 -> 0043 2215 006B 0067';
ok Uni.new(0x33C7).NFKC.list ~~ (0x0043, 0x006F, 0x002E,), '33C7 -> 0043 006F 002E';
ok Uni.new(0x33C8).NFKC.list ~~ (0x0064, 0x0042,), '33C8 -> 0064 0042';
ok Uni.new(0x33C9).NFKC.list ~~ (0x0047, 0x0079,), '33C9 -> 0047 0079';
ok Uni.new(0x33CA).NFKC.list ~~ (0x0068, 0x0061,), '33CA -> 0068 0061';
ok Uni.new(0x33CB).NFKC.list ~~ (0x0048, 0x0050,), '33CB -> 0048 0050';
ok Uni.new(0x33CC).NFKC.list ~~ (0x0069, 0x006E,), '33CC -> 0069 006E';
ok Uni.new(0x33CD).NFKC.list ~~ (0x004B, 0x004B,), '33CD -> 004B 004B';
ok Uni.new(0x33CE).NFKC.list ~~ (0x004B, 0x004D,), '33CE -> 004B 004D';
ok Uni.new(0x33CF).NFKC.list ~~ (0x006B, 0x0074,), '33CF -> 006B 0074';
ok Uni.new(0x33D0).NFKC.list ~~ (0x006C, 0x006D,), '33D0 -> 006C 006D';
ok Uni.new(0x33D1).NFKC.list ~~ (0x006C, 0x006E,), '33D1 -> 006C 006E';
ok Uni.new(0x33D2).NFKC.list ~~ (0x006C, 0x006F, 0x0067,), '33D2 -> 006C 006F 0067';
ok Uni.new(0x33D3).NFKC.list ~~ (0x006C, 0x0078,), '33D3 -> 006C 0078';
ok Uni.new(0x33D4).NFKC.list ~~ (0x006D, 0x0062,), '33D4 -> 006D 0062';
ok Uni.new(0x33D5).NFKC.list ~~ (0x006D, 0x0069, 0x006C,), '33D5 -> 006D 0069 006C';
ok Uni.new(0x33D6).NFKC.list ~~ (0x006D, 0x006F, 0x006C,), '33D6 -> 006D 006F 006C';
ok Uni.new(0x33D7).NFKC.list ~~ (0x0050, 0x0048,), '33D7 -> 0050 0048';
ok Uni.new(0x33D8).NFKC.list ~~ (0x0070, 0x002E, 0x006D, 0x002E,), '33D8 -> 0070 002E 006D 002E';
ok Uni.new(0x33D9).NFKC.list ~~ (0x0050, 0x0050, 0x004D,), '33D9 -> 0050 0050 004D';
ok Uni.new(0x33DA).NFKC.list ~~ (0x0050, 0x0052,), '33DA -> 0050 0052';
ok Uni.new(0x33DB).NFKC.list ~~ (0x0073, 0x0072,), '33DB -> 0073 0072';
ok Uni.new(0x33DC).NFKC.list ~~ (0x0053, 0x0076,), '33DC -> 0053 0076';
ok Uni.new(0x33DD).NFKC.list ~~ (0x0057, 0x0062,), '33DD -> 0057 0062';
ok Uni.new(0x33DE).NFKC.list ~~ (0x0056, 0x2215, 0x006D,), '33DE -> 0056 2215 006D';
ok Uni.new(0x33DF).NFKC.list ~~ (0x0041, 0x2215, 0x006D,), '33DF -> 0041 2215 006D';
ok Uni.new(0x33E0).NFKC.list ~~ (0x0031, 0x65E5,), '33E0 -> 0031 65E5';
ok Uni.new(0x33E1).NFKC.list ~~ (0x0032, 0x65E5,), '33E1 -> 0032 65E5';
ok Uni.new(0x33E2).NFKC.list ~~ (0x0033, 0x65E5,), '33E2 -> 0033 65E5';
ok Uni.new(0x33E3).NFKC.list ~~ (0x0034, 0x65E5,), '33E3 -> 0034 65E5';
ok Uni.new(0x33E4).NFKC.list ~~ (0x0035, 0x65E5,), '33E4 -> 0035 65E5';
ok Uni.new(0x33E5).NFKC.list ~~ (0x0036, 0x65E5,), '33E5 -> 0036 65E5';
ok Uni.new(0x33E6).NFKC.list ~~ (0x0037, 0x65E5,), '33E6 -> 0037 65E5';
ok Uni.new(0x33E7).NFKC.list ~~ (0x0038, 0x65E5,), '33E7 -> 0038 65E5';
ok Uni.new(0x33E8).NFKC.list ~~ (0x0039, 0x65E5,), '33E8 -> 0039 65E5';
ok Uni.new(0x33E9).NFKC.list ~~ (0x0031, 0x0030, 0x65E5,), '33E9 -> 0031 0030 65E5';
ok Uni.new(0x33EA).NFKC.list ~~ (0x0031, 0x0031, 0x65E5,), '33EA -> 0031 0031 65E5';
ok Uni.new(0x33EB).NFKC.list ~~ (0x0031, 0x0032, 0x65E5,), '33EB -> 0031 0032 65E5';
ok Uni.new(0x33EC).NFKC.list ~~ (0x0031, 0x0033, 0x65E5,), '33EC -> 0031 0033 65E5';
ok Uni.new(0x33ED).NFKC.list ~~ (0x0031, 0x0034, 0x65E5,), '33ED -> 0031 0034 65E5';
ok Uni.new(0x33EE).NFKC.list ~~ (0x0031, 0x0035, 0x65E5,), '33EE -> 0031 0035 65E5';
ok Uni.new(0x33EF).NFKC.list ~~ (0x0031, 0x0036, 0x65E5,), '33EF -> 0031 0036 65E5';
ok Uni.new(0x33F0).NFKC.list ~~ (0x0031, 0x0037, 0x65E5,), '33F0 -> 0031 0037 65E5';
ok Uni.new(0x33F1).NFKC.list ~~ (0x0031, 0x0038, 0x65E5,), '33F1 -> 0031 0038 65E5';
ok Uni.new(0x33F2).NFKC.list ~~ (0x0031, 0x0039, 0x65E5,), '33F2 -> 0031 0039 65E5';
ok Uni.new(0x33F3).NFKC.list ~~ (0x0032, 0x0030, 0x65E5,), '33F3 -> 0032 0030 65E5';
ok Uni.new(0x33F4).NFKC.list ~~ (0x0032, 0x0031, 0x65E5,), '33F4 -> 0032 0031 65E5';
ok Uni.new(0x33F5).NFKC.list ~~ (0x0032, 0x0032, 0x65E5,), '33F5 -> 0032 0032 65E5';
ok Uni.new(0x33F6).NFKC.list ~~ (0x0032, 0x0033, 0x65E5,), '33F6 -> 0032 0033 65E5';
ok Uni.new(0x33F7).NFKC.list ~~ (0x0032, 0x0034, 0x65E5,), '33F7 -> 0032 0034 65E5';
ok Uni.new(0x33F8).NFKC.list ~~ (0x0032, 0x0035, 0x65E5,), '33F8 -> 0032 0035 65E5';
ok Uni.new(0x33F9).NFKC.list ~~ (0x0032, 0x0036, 0x65E5,), '33F9 -> 0032 0036 65E5';
ok Uni.new(0x33FA).NFKC.list ~~ (0x0032, 0x0037, 0x65E5,), '33FA -> 0032 0037 65E5';
ok Uni.new(0x33FB).NFKC.list ~~ (0x0032, 0x0038, 0x65E5,), '33FB -> 0032 0038 65E5';
ok Uni.new(0x33FC).NFKC.list ~~ (0x0032, 0x0039, 0x65E5,), '33FC -> 0032 0039 65E5';
ok Uni.new(0x33FD).NFKC.list ~~ (0x0033, 0x0030, 0x65E5,), '33FD -> 0033 0030 65E5';
ok Uni.new(0x33FE).NFKC.list ~~ (0x0033, 0x0031, 0x65E5,), '33FE -> 0033 0031 65E5';
ok Uni.new(0x33FF).NFKC.list ~~ (0x0067, 0x0061, 0x006C,), '33FF -> 0067 0061 006C';
ok Uni.new(0xA69C).NFKC.list ~~ (0x044A,), 'A69C -> 044A';
ok Uni.new(0xA69D).NFKC.list ~~ (0x044C,), 'A69D -> 044C';
ok Uni.new(0xA770).NFKC.list ~~ (0xA76F,), 'A770 -> A76F';
ok Uni.new(0xA7F2).NFKC.list ~~ (0x0043,), 'A7F2 -> 0043';
ok Uni.new(0xA7F3).NFKC.list ~~ (0x0046,), 'A7F3 -> 0046';
ok Uni.new(0xA7F4).NFKC.list ~~ (0x0051,), 'A7F4 -> 0051';
ok Uni.new(0xA7F8).NFKC.list ~~ (0x0126,), 'A7F8 -> 0126';
ok Uni.new(0xA7F9).NFKC.list ~~ (0x0153,), 'A7F9 -> 0153';
ok Uni.new(0xAB5C).NFKC.list ~~ (0xA727,), 'AB5C -> A727';
ok Uni.new(0xAB5D).NFKC.list ~~ (0xAB37,), 'AB5D -> AB37';
ok Uni.new(0xAB5E).NFKC.list ~~ (0x026B,), 'AB5E -> 026B';
ok Uni.new(0xAB5F).NFKC.list ~~ (0xAB52,), 'AB5F -> AB52';
ok Uni.new(0xAB69).NFKC.list ~~ (0x028D,), 'AB69 -> 028D';
ok Uni.new(0xAC00).NFKC.list ~~ (0xAC00,), 'AC00 -> AC00';
ok Uni.new(0xAC01).NFKC.list ~~ (0xAC01,), 'AC01 -> AC01';
ok Uni.new(0xAC02).NFKC.list ~~ (0xAC02,), 'AC02 -> AC02';
ok Uni.new(0xAC03).NFKC.list ~~ (0xAC03,), 'AC03 -> AC03';
ok Uni.new(0xAC04).NFKC.list ~~ (0xAC04,), 'AC04 -> AC04';
ok Uni.new(0xAC05).NFKC.list ~~ (0xAC05,), 'AC05 -> AC05';
ok Uni.new(0xAC06).NFKC.list ~~ (0xAC06,), 'AC06 -> AC06';
ok Uni.new(0xAC07).NFKC.list ~~ (0xAC07,), 'AC07 -> AC07';
ok Uni.new(0xAC08).NFKC.list ~~ (0xAC08,), 'AC08 -> AC08';
ok Uni.new(0xAC09).NFKC.list ~~ (0xAC09,), 'AC09 -> AC09';
ok Uni.new(0xAC0A).NFKC.list ~~ (0xAC0A,), 'AC0A -> AC0A';
ok Uni.new(0xAC0B).NFKC.list ~~ (0xAC0B,), 'AC0B -> AC0B';
ok Uni.new(0xAC0C).NFKC.list ~~ (0xAC0C,), 'AC0C -> AC0C';
ok Uni.new(0xAC0D).NFKC.list ~~ (0xAC0D,), 'AC0D -> AC0D';
ok Uni.new(0xAC0E).NFKC.list ~~ (0xAC0E,), 'AC0E -> AC0E';
ok Uni.new(0xAC0F).NFKC.list ~~ (0xAC0F,), 'AC0F -> AC0F';
ok Uni.new(0xAC10).NFKC.list ~~ (0xAC10,), 'AC10 -> AC10';
ok Uni.new(0xAC11).NFKC.list ~~ (0xAC11,), 'AC11 -> AC11';
ok Uni.new(0xAC12).NFKC.list ~~ (0xAC12,), 'AC12 -> AC12';
ok Uni.new(0xAC13).NFKC.list ~~ (0xAC13,), 'AC13 -> AC13';
ok Uni.new(0xAC14).NFKC.list ~~ (0xAC14,), 'AC14 -> AC14';
ok Uni.new(0xAC15).NFKC.list ~~ (0xAC15,), 'AC15 -> AC15';
ok Uni.new(0xAC16).NFKC.list ~~ (0xAC16,), 'AC16 -> AC16';
ok Uni.new(0xAC17).NFKC.list ~~ (0xAC17,), 'AC17 -> AC17';
ok Uni.new(0xAC18).NFKC.list ~~ (0xAC18,), 'AC18 -> AC18';
ok Uni.new(0xAC19).NFKC.list ~~ (0xAC19,), 'AC19 -> AC19';
ok Uni.new(0xAC1A).NFKC.list ~~ (0xAC1A,), 'AC1A -> AC1A';
ok Uni.new(0xAC1B).NFKC.list ~~ (0xAC1B,), 'AC1B -> AC1B';
ok Uni.new(0xAC1C).NFKC.list ~~ (0xAC1C,), 'AC1C -> AC1C';
ok Uni.new(0xAC1D).NFKC.list ~~ (0xAC1D,), 'AC1D -> AC1D';
ok Uni.new(0xAC1E).NFKC.list ~~ (0xAC1E,), 'AC1E -> AC1E';
ok Uni.new(0xAC1F).NFKC.list ~~ (0xAC1F,), 'AC1F -> AC1F';
ok Uni.new(0xAC20).NFKC.list ~~ (0xAC20,), 'AC20 -> AC20';
ok Uni.new(0xAC21).NFKC.list ~~ (0xAC21,), 'AC21 -> AC21';
ok Uni.new(0xAC22).NFKC.list ~~ (0xAC22,), 'AC22 -> AC22';
ok Uni.new(0xAC23).NFKC.list ~~ (0xAC23,), 'AC23 -> AC23';
ok Uni.new(0xAC24).NFKC.list ~~ (0xAC24,), 'AC24 -> AC24';
ok Uni.new(0xAC25).NFKC.list ~~ (0xAC25,), 'AC25 -> AC25';
ok Uni.new(0xAC26).NFKC.list ~~ (0xAC26,), 'AC26 -> AC26';
ok Uni.new(0xAC27).NFKC.list ~~ (0xAC27,), 'AC27 -> AC27';
ok Uni.new(0xAC28).NFKC.list ~~ (0xAC28,), 'AC28 -> AC28';
ok Uni.new(0xAC29).NFKC.list ~~ (0xAC29,), 'AC29 -> AC29';
ok Uni.new(0xAC2A).NFKC.list ~~ (0xAC2A,), 'AC2A -> AC2A';
ok Uni.new(0xAC2B).NFKC.list ~~ (0xAC2B,), 'AC2B -> AC2B';
ok Uni.new(0xAC2C).NFKC.list ~~ (0xAC2C,), 'AC2C -> AC2C';
ok Uni.new(0xAC2D).NFKC.list ~~ (0xAC2D,), 'AC2D -> AC2D';
ok Uni.new(0xAC2E).NFKC.list ~~ (0xAC2E,), 'AC2E -> AC2E';
ok Uni.new(0xAC2F).NFKC.list ~~ (0xAC2F,), 'AC2F -> AC2F';
ok Uni.new(0xAC30).NFKC.list ~~ (0xAC30,), 'AC30 -> AC30';
ok Uni.new(0xAC31).NFKC.list ~~ (0xAC31,), 'AC31 -> AC31';
ok Uni.new(0xAC32).NFKC.list ~~ (0xAC32,), 'AC32 -> AC32';
ok Uni.new(0xAC33).NFKC.list ~~ (0xAC33,), 'AC33 -> AC33';
ok Uni.new(0xAC34).NFKC.list ~~ (0xAC34,), 'AC34 -> AC34';
ok Uni.new(0xAC35).NFKC.list ~~ (0xAC35,), 'AC35 -> AC35';
ok Uni.new(0xAC36).NFKC.list ~~ (0xAC36,), 'AC36 -> AC36';
ok Uni.new(0xAC37).NFKC.list ~~ (0xAC37,), 'AC37 -> AC37';
ok Uni.new(0xAC38).NFKC.list ~~ (0xAC38,), 'AC38 -> AC38';
ok Uni.new(0xAC39).NFKC.list ~~ (0xAC39,), 'AC39 -> AC39';
ok Uni.new(0xAC3A).NFKC.list ~~ (0xAC3A,), 'AC3A -> AC3A';
ok Uni.new(0xAC3B).NFKC.list ~~ (0xAC3B,), 'AC3B -> AC3B';
ok Uni.new(0xAC3C).NFKC.list ~~ (0xAC3C,), 'AC3C -> AC3C';
ok Uni.new(0xAC3D).NFKC.list ~~ (0xAC3D,), 'AC3D -> AC3D';
ok Uni.new(0xAC3E).NFKC.list ~~ (0xAC3E,), 'AC3E -> AC3E';
ok Uni.new(0xAC3F).NFKC.list ~~ (0xAC3F,), 'AC3F -> AC3F';
ok Uni.new(0xAC40).NFKC.list ~~ (0xAC40,), 'AC40 -> AC40';
ok Uni.new(0xAC41).NFKC.list ~~ (0xAC41,), 'AC41 -> AC41';
ok Uni.new(0xAC42).NFKC.list ~~ (0xAC42,), 'AC42 -> AC42';
ok Uni.new(0xAC43).NFKC.list ~~ (0xAC43,), 'AC43 -> AC43';
ok Uni.new(0xAC44).NFKC.list ~~ (0xAC44,), 'AC44 -> AC44';
ok Uni.new(0xAC45).NFKC.list ~~ (0xAC45,), 'AC45 -> AC45';
ok Uni.new(0xAC46).NFKC.list ~~ (0xAC46,), 'AC46 -> AC46';
ok Uni.new(0xAC47).NFKC.list ~~ (0xAC47,), 'AC47 -> AC47';
ok Uni.new(0xAC48).NFKC.list ~~ (0xAC48,), 'AC48 -> AC48';
ok Uni.new(0xAC49).NFKC.list ~~ (0xAC49,), 'AC49 -> AC49';
ok Uni.new(0xAC4A).NFKC.list ~~ (0xAC4A,), 'AC4A -> AC4A';
ok Uni.new(0xAC4B).NFKC.list ~~ (0xAC4B,), 'AC4B -> AC4B';
ok Uni.new(0xAC4C).NFKC.list ~~ (0xAC4C,), 'AC4C -> AC4C';
ok Uni.new(0xAC4D).NFKC.list ~~ (0xAC4D,), 'AC4D -> AC4D';
ok Uni.new(0xAC4E).NFKC.list ~~ (0xAC4E,), 'AC4E -> AC4E';
ok Uni.new(0xAC4F).NFKC.list ~~ (0xAC4F,), 'AC4F -> AC4F';
ok Uni.new(0xAC50).NFKC.list ~~ (0xAC50,), 'AC50 -> AC50';
ok Uni.new(0xAC51).NFKC.list ~~ (0xAC51,), 'AC51 -> AC51';
ok Uni.new(0xAC52).NFKC.list ~~ (0xAC52,), 'AC52 -> AC52';
ok Uni.new(0xAC53).NFKC.list ~~ (0xAC53,), 'AC53 -> AC53';
ok Uni.new(0xAC54).NFKC.list ~~ (0xAC54,), 'AC54 -> AC54';
ok Uni.new(0xAC55).NFKC.list ~~ (0xAC55,), 'AC55 -> AC55';
ok Uni.new(0xAC56).NFKC.list ~~ (0xAC56,), 'AC56 -> AC56';
ok Uni.new(0xAC57).NFKC.list ~~ (0xAC57,), 'AC57 -> AC57';
ok Uni.new(0xAC58).NFKC.list ~~ (0xAC58,), 'AC58 -> AC58';
ok Uni.new(0xAC59).NFKC.list ~~ (0xAC59,), 'AC59 -> AC59';
ok Uni.new(0xAC5A).NFKC.list ~~ (0xAC5A,), 'AC5A -> AC5A';
ok Uni.new(0xAC5B).NFKC.list ~~ (0xAC5B,), 'AC5B -> AC5B';
ok Uni.new(0xAC5C).NFKC.list ~~ (0xAC5C,), 'AC5C -> AC5C';
ok Uni.new(0xAC5D).NFKC.list ~~ (0xAC5D,), 'AC5D -> AC5D';
ok Uni.new(0xAC5E).NFKC.list ~~ (0xAC5E,), 'AC5E -> AC5E';
ok Uni.new(0xAC5F).NFKC.list ~~ (0xAC5F,), 'AC5F -> AC5F';
ok Uni.new(0xAC60).NFKC.list ~~ (0xAC60,), 'AC60 -> AC60';
ok Uni.new(0xAC61).NFKC.list ~~ (0xAC61,), 'AC61 -> AC61';
ok Uni.new(0xAC62).NFKC.list ~~ (0xAC62,), 'AC62 -> AC62';
ok Uni.new(0xAC63).NFKC.list ~~ (0xAC63,), 'AC63 -> AC63';
ok Uni.new(0xAC64).NFKC.list ~~ (0xAC64,), 'AC64 -> AC64';
ok Uni.new(0xAC65).NFKC.list ~~ (0xAC65,), 'AC65 -> AC65';
ok Uni.new(0xAC66).NFKC.list ~~ (0xAC66,), 'AC66 -> AC66';
ok Uni.new(0xAC67).NFKC.list ~~ (0xAC67,), 'AC67 -> AC67';
ok Uni.new(0xAC68).NFKC.list ~~ (0xAC68,), 'AC68 -> AC68';
ok Uni.new(0xAC69).NFKC.list ~~ (0xAC69,), 'AC69 -> AC69';
ok Uni.new(0xAC6A).NFKC.list ~~ (0xAC6A,), 'AC6A -> AC6A';
ok Uni.new(0xAC6B).NFKC.list ~~ (0xAC6B,), 'AC6B -> AC6B';
ok Uni.new(0xAC6C).NFKC.list ~~ (0xAC6C,), 'AC6C -> AC6C';
ok Uni.new(0xAC6D).NFKC.list ~~ (0xAC6D,), 'AC6D -> AC6D';
ok Uni.new(0xAC6E).NFKC.list ~~ (0xAC6E,), 'AC6E -> AC6E';
ok Uni.new(0xAC6F).NFKC.list ~~ (0xAC6F,), 'AC6F -> AC6F';
ok Uni.new(0xAC70).NFKC.list ~~ (0xAC70,), 'AC70 -> AC70';
ok Uni.new(0xAC71).NFKC.list ~~ (0xAC71,), 'AC71 -> AC71';
ok Uni.new(0xAC72).NFKC.list ~~ (0xAC72,), 'AC72 -> AC72';
ok Uni.new(0xAC73).NFKC.list ~~ (0xAC73,), 'AC73 -> AC73';
ok Uni.new(0xAC74).NFKC.list ~~ (0xAC74,), 'AC74 -> AC74';
ok Uni.new(0xAC75).NFKC.list ~~ (0xAC75,), 'AC75 -> AC75';
ok Uni.new(0xAC76).NFKC.list ~~ (0xAC76,), 'AC76 -> AC76';
ok Uni.new(0xAC77).NFKC.list ~~ (0xAC77,), 'AC77 -> AC77';
ok Uni.new(0xAC78).NFKC.list ~~ (0xAC78,), 'AC78 -> AC78';
ok Uni.new(0xAC79).NFKC.list ~~ (0xAC79,), 'AC79 -> AC79';
ok Uni.new(0xAC7A).NFKC.list ~~ (0xAC7A,), 'AC7A -> AC7A';
ok Uni.new(0xAC7B).NFKC.list ~~ (0xAC7B,), 'AC7B -> AC7B';
ok Uni.new(0xAC7C).NFKC.list ~~ (0xAC7C,), 'AC7C -> AC7C';
ok Uni.new(0xAC7D).NFKC.list ~~ (0xAC7D,), 'AC7D -> AC7D';
ok Uni.new(0xAC7E).NFKC.list ~~ (0xAC7E,), 'AC7E -> AC7E';
ok Uni.new(0xAC7F).NFKC.list ~~ (0xAC7F,), 'AC7F -> AC7F';
ok Uni.new(0xAC80).NFKC.list ~~ (0xAC80,), 'AC80 -> AC80';
ok Uni.new(0xAC81).NFKC.list ~~ (0xAC81,), 'AC81 -> AC81';
ok Uni.new(0xAC82).NFKC.list ~~ (0xAC82,), 'AC82 -> AC82';
ok Uni.new(0xAC83).NFKC.list ~~ (0xAC83,), 'AC83 -> AC83';
ok Uni.new(0xAC84).NFKC.list ~~ (0xAC84,), 'AC84 -> AC84';
ok Uni.new(0xAC85).NFKC.list ~~ (0xAC85,), 'AC85 -> AC85';
ok Uni.new(0xAC86).NFKC.list ~~ (0xAC86,), 'AC86 -> AC86';
ok Uni.new(0xAC87).NFKC.list ~~ (0xAC87,), 'AC87 -> AC87';
ok Uni.new(0xAC88).NFKC.list ~~ (0xAC88,), 'AC88 -> AC88';
ok Uni.new(0xAC89).NFKC.list ~~ (0xAC89,), 'AC89 -> AC89';
ok Uni.new(0xAC8A).NFKC.list ~~ (0xAC8A,), 'AC8A -> AC8A';
ok Uni.new(0xAC8B).NFKC.list ~~ (0xAC8B,), 'AC8B -> AC8B';
ok Uni.new(0xAC8C).NFKC.list ~~ (0xAC8C,), 'AC8C -> AC8C';
ok Uni.new(0xAC8D).NFKC.list ~~ (0xAC8D,), 'AC8D -> AC8D';
ok Uni.new(0xAC8E).NFKC.list ~~ (0xAC8E,), 'AC8E -> AC8E';
ok Uni.new(0xAC8F).NFKC.list ~~ (0xAC8F,), 'AC8F -> AC8F';
ok Uni.new(0xAC90).NFKC.list ~~ (0xAC90,), 'AC90 -> AC90';
ok Uni.new(0xAC91).NFKC.list ~~ (0xAC91,), 'AC91 -> AC91';
ok Uni.new(0xAC92).NFKC.list ~~ (0xAC92,), 'AC92 -> AC92';
ok Uni.new(0xAC93).NFKC.list ~~ (0xAC93,), 'AC93 -> AC93';
ok Uni.new(0xAC94).NFKC.list ~~ (0xAC94,), 'AC94 -> AC94';
ok Uni.new(0xAC95).NFKC.list ~~ (0xAC95,), 'AC95 -> AC95';
ok Uni.new(0xAC96).NFKC.list ~~ (0xAC96,), 'AC96 -> AC96';
ok Uni.new(0xAC97).NFKC.list ~~ (0xAC97,), 'AC97 -> AC97';
ok Uni.new(0xAC98).NFKC.list ~~ (0xAC98,), 'AC98 -> AC98';
ok Uni.new(0xAC99).NFKC.list ~~ (0xAC99,), 'AC99 -> AC99';
ok Uni.new(0xAC9A).NFKC.list ~~ (0xAC9A,), 'AC9A -> AC9A';
ok Uni.new(0xAC9B).NFKC.list ~~ (0xAC9B,), 'AC9B -> AC9B';
ok Uni.new(0xAC9C).NFKC.list ~~ (0xAC9C,), 'AC9C -> AC9C';
ok Uni.new(0xAC9D).NFKC.list ~~ (0xAC9D,), 'AC9D -> AC9D';
ok Uni.new(0xAC9E).NFKC.list ~~ (0xAC9E,), 'AC9E -> AC9E';
ok Uni.new(0xAC9F).NFKC.list ~~ (0xAC9F,), 'AC9F -> AC9F';
ok Uni.new(0xACA0).NFKC.list ~~ (0xACA0,), 'ACA0 -> ACA0';
ok Uni.new(0xACA1).NFKC.list ~~ (0xACA1,), 'ACA1 -> ACA1';
ok Uni.new(0xACA2).NFKC.list ~~ (0xACA2,), 'ACA2 -> ACA2';
ok Uni.new(0xACA3).NFKC.list ~~ (0xACA3,), 'ACA3 -> ACA3';
ok Uni.new(0xACA4).NFKC.list ~~ (0xACA4,), 'ACA4 -> ACA4';
ok Uni.new(0xACA5).NFKC.list ~~ (0xACA5,), 'ACA5 -> ACA5';
ok Uni.new(0xACA6).NFKC.list ~~ (0xACA6,), 'ACA6 -> ACA6';
ok Uni.new(0xACA7).NFKC.list ~~ (0xACA7,), 'ACA7 -> ACA7';
ok Uni.new(0xACA8).NFKC.list ~~ (0xACA8,), 'ACA8 -> ACA8';
ok Uni.new(0xACA9).NFKC.list ~~ (0xACA9,), 'ACA9 -> ACA9';
ok Uni.new(0xACAA).NFKC.list ~~ (0xACAA,), 'ACAA -> ACAA';
ok Uni.new(0xACAB).NFKC.list ~~ (0xACAB,), 'ACAB -> ACAB';
ok Uni.new(0xACAC).NFKC.list ~~ (0xACAC,), 'ACAC -> ACAC';
ok Uni.new(0xACAD).NFKC.list ~~ (0xACAD,), 'ACAD -> ACAD';
ok Uni.new(0xACAE).NFKC.list ~~ (0xACAE,), 'ACAE -> ACAE';
ok Uni.new(0xACAF).NFKC.list ~~ (0xACAF,), 'ACAF -> ACAF';
ok Uni.new(0xACB0).NFKC.list ~~ (0xACB0,), 'ACB0 -> ACB0';
ok Uni.new(0xACB1).NFKC.list ~~ (0xACB1,), 'ACB1 -> ACB1';
ok Uni.new(0xACB2).NFKC.list ~~ (0xACB2,), 'ACB2 -> ACB2';
ok Uni.new(0xACB3).NFKC.list ~~ (0xACB3,), 'ACB3 -> ACB3';
ok Uni.new(0xACB4).NFKC.list ~~ (0xACB4,), 'ACB4 -> ACB4';
ok Uni.new(0xACB5).NFKC.list ~~ (0xACB5,), 'ACB5 -> ACB5';
ok Uni.new(0xACB6).NFKC.list ~~ (0xACB6,), 'ACB6 -> ACB6';
ok Uni.new(0xACB7).NFKC.list ~~ (0xACB7,), 'ACB7 -> ACB7';
ok Uni.new(0xACB8).NFKC.list ~~ (0xACB8,), 'ACB8 -> ACB8';
ok Uni.new(0xACB9).NFKC.list ~~ (0xACB9,), 'ACB9 -> ACB9';
ok Uni.new(0xACBA).NFKC.list ~~ (0xACBA,), 'ACBA -> ACBA';
ok Uni.new(0xACBB).NFKC.list ~~ (0xACBB,), 'ACBB -> ACBB';
ok Uni.new(0xACBC).NFKC.list ~~ (0xACBC,), 'ACBC -> ACBC';
ok Uni.new(0xACBD).NFKC.list ~~ (0xACBD,), 'ACBD -> ACBD';
ok Uni.new(0xACBE).NFKC.list ~~ (0xACBE,), 'ACBE -> ACBE';
ok Uni.new(0xACBF).NFKC.list ~~ (0xACBF,), 'ACBF -> ACBF';
ok Uni.new(0xACC0).NFKC.list ~~ (0xACC0,), 'ACC0 -> ACC0';
ok Uni.new(0xACC1).NFKC.list ~~ (0xACC1,), 'ACC1 -> ACC1';
ok Uni.new(0xACC2).NFKC.list ~~ (0xACC2,), 'ACC2 -> ACC2';
ok Uni.new(0xACC3).NFKC.list ~~ (0xACC3,), 'ACC3 -> ACC3';
ok Uni.new(0xACC4).NFKC.list ~~ (0xACC4,), 'ACC4 -> ACC4';
ok Uni.new(0xACC5).NFKC.list ~~ (0xACC5,), 'ACC5 -> ACC5';
ok Uni.new(0xACC6).NFKC.list ~~ (0xACC6,), 'ACC6 -> ACC6';
ok Uni.new(0xACC7).NFKC.list ~~ (0xACC7,), 'ACC7 -> ACC7';
ok Uni.new(0xACC8).NFKC.list ~~ (0xACC8,), 'ACC8 -> ACC8';
ok Uni.new(0xACC9).NFKC.list ~~ (0xACC9,), 'ACC9 -> ACC9';
ok Uni.new(0xACCA).NFKC.list ~~ (0xACCA,), 'ACCA -> ACCA';
ok Uni.new(0xACCB).NFKC.list ~~ (0xACCB,), 'ACCB -> ACCB';
ok Uni.new(0xACCC).NFKC.list ~~ (0xACCC,), 'ACCC -> ACCC';
ok Uni.new(0xACCD).NFKC.list ~~ (0xACCD,), 'ACCD -> ACCD';
ok Uni.new(0xACCE).NFKC.list ~~ (0xACCE,), 'ACCE -> ACCE';
ok Uni.new(0xACCF).NFKC.list ~~ (0xACCF,), 'ACCF -> ACCF';
ok Uni.new(0xACD0).NFKC.list ~~ (0xACD0,), 'ACD0 -> ACD0';
ok Uni.new(0xACD1).NFKC.list ~~ (0xACD1,), 'ACD1 -> ACD1';
ok Uni.new(0xACD2).NFKC.list ~~ (0xACD2,), 'ACD2 -> ACD2';
ok Uni.new(0xACD3).NFKC.list ~~ (0xACD3,), 'ACD3 -> ACD3';
ok Uni.new(0xACD4).NFKC.list ~~ (0xACD4,), 'ACD4 -> ACD4';
ok Uni.new(0xACD5).NFKC.list ~~ (0xACD5,), 'ACD5 -> ACD5';
ok Uni.new(0xACD6).NFKC.list ~~ (0xACD6,), 'ACD6 -> ACD6';
ok Uni.new(0xACD7).NFKC.list ~~ (0xACD7,), 'ACD7 -> ACD7';
ok Uni.new(0xACD8).NFKC.list ~~ (0xACD8,), 'ACD8 -> ACD8';
ok Uni.new(0xACD9).NFKC.list ~~ (0xACD9,), 'ACD9 -> ACD9';
ok Uni.new(0xACDA).NFKC.list ~~ (0xACDA,), 'ACDA -> ACDA';
ok Uni.new(0xACDB).NFKC.list ~~ (0xACDB,), 'ACDB -> ACDB';
ok Uni.new(0xACDC).NFKC.list ~~ (0xACDC,), 'ACDC -> ACDC';
ok Uni.new(0xACDD).NFKC.list ~~ (0xACDD,), 'ACDD -> ACDD';
ok Uni.new(0xACDE).NFKC.list ~~ (0xACDE,), 'ACDE -> ACDE';
ok Uni.new(0xACDF).NFKC.list ~~ (0xACDF,), 'ACDF -> ACDF';
ok Uni.new(0xACE0).NFKC.list ~~ (0xACE0,), 'ACE0 -> ACE0';
ok Uni.new(0xACE1).NFKC.list ~~ (0xACE1,), 'ACE1 -> ACE1';
ok Uni.new(0xACE2).NFKC.list ~~ (0xACE2,), 'ACE2 -> ACE2';
ok Uni.new(0xACE3).NFKC.list ~~ (0xACE3,), 'ACE3 -> ACE3';
ok Uni.new(0xACE4).NFKC.list ~~ (0xACE4,), 'ACE4 -> ACE4';
ok Uni.new(0xACE5).NFKC.list ~~ (0xACE5,), 'ACE5 -> ACE5';
ok Uni.new(0xACE6).NFKC.list ~~ (0xACE6,), 'ACE6 -> ACE6';
ok Uni.new(0xACE7).NFKC.list ~~ (0xACE7,), 'ACE7 -> ACE7';
ok Uni.new(0xACE8).NFKC.list ~~ (0xACE8,), 'ACE8 -> ACE8';
ok Uni.new(0xACE9).NFKC.list ~~ (0xACE9,), 'ACE9 -> ACE9';
ok Uni.new(0xACEA).NFKC.list ~~ (0xACEA,), 'ACEA -> ACEA';
ok Uni.new(0xACEB).NFKC.list ~~ (0xACEB,), 'ACEB -> ACEB';
ok Uni.new(0xACEC).NFKC.list ~~ (0xACEC,), 'ACEC -> ACEC';
ok Uni.new(0xACED).NFKC.list ~~ (0xACED,), 'ACED -> ACED';
ok Uni.new(0xACEE).NFKC.list ~~ (0xACEE,), 'ACEE -> ACEE';
ok Uni.new(0xACEF).NFKC.list ~~ (0xACEF,), 'ACEF -> ACEF';
ok Uni.new(0xACF0).NFKC.list ~~ (0xACF0,), 'ACF0 -> ACF0';
ok Uni.new(0xACF1).NFKC.list ~~ (0xACF1,), 'ACF1 -> ACF1';
ok Uni.new(0xACF2).NFKC.list ~~ (0xACF2,), 'ACF2 -> ACF2';
ok Uni.new(0xACF3).NFKC.list ~~ (0xACF3,), 'ACF3 -> ACF3';
ok Uni.new(0xACF4).NFKC.list ~~ (0xACF4,), 'ACF4 -> ACF4';
ok Uni.new(0xACF5).NFKC.list ~~ (0xACF5,), 'ACF5 -> ACF5';
ok Uni.new(0xACF6).NFKC.list ~~ (0xACF6,), 'ACF6 -> ACF6';
ok Uni.new(0xACF7).NFKC.list ~~ (0xACF7,), 'ACF7 -> ACF7';
ok Uni.new(0xACF8).NFKC.list ~~ (0xACF8,), 'ACF8 -> ACF8';
ok Uni.new(0xACF9).NFKC.list ~~ (0xACF9,), 'ACF9 -> ACF9';
ok Uni.new(0xACFA).NFKC.list ~~ (0xACFA,), 'ACFA -> ACFA';
ok Uni.new(0xACFB).NFKC.list ~~ (0xACFB,), 'ACFB -> ACFB';
ok Uni.new(0xACFC).NFKC.list ~~ (0xACFC,), 'ACFC -> ACFC';
ok Uni.new(0xACFD).NFKC.list ~~ (0xACFD,), 'ACFD -> ACFD';
ok Uni.new(0xACFE).NFKC.list ~~ (0xACFE,), 'ACFE -> ACFE';
ok Uni.new(0xACFF).NFKC.list ~~ (0xACFF,), 'ACFF -> ACFF';
ok Uni.new(0xAD00).NFKC.list ~~ (0xAD00,), 'AD00 -> AD00';
ok Uni.new(0xAD01).NFKC.list ~~ (0xAD01,), 'AD01 -> AD01';
ok Uni.new(0xAD02).NFKC.list ~~ (0xAD02,), 'AD02 -> AD02';
ok Uni.new(0xAD03).NFKC.list ~~ (0xAD03,), 'AD03 -> AD03';
ok Uni.new(0xAD04).NFKC.list ~~ (0xAD04,), 'AD04 -> AD04';
ok Uni.new(0xAD05).NFKC.list ~~ (0xAD05,), 'AD05 -> AD05';
ok Uni.new(0xAD06).NFKC.list ~~ (0xAD06,), 'AD06 -> AD06';
ok Uni.new(0xAD07).NFKC.list ~~ (0xAD07,), 'AD07 -> AD07';
ok Uni.new(0xAD08).NFKC.list ~~ (0xAD08,), 'AD08 -> AD08';
ok Uni.new(0xAD09).NFKC.list ~~ (0xAD09,), 'AD09 -> AD09';
ok Uni.new(0xAD0A).NFKC.list ~~ (0xAD0A,), 'AD0A -> AD0A';
ok Uni.new(0xAD0B).NFKC.list ~~ (0xAD0B,), 'AD0B -> AD0B';
ok Uni.new(0xAD0C).NFKC.list ~~ (0xAD0C,), 'AD0C -> AD0C';
ok Uni.new(0xAD0D).NFKC.list ~~ (0xAD0D,), 'AD0D -> AD0D';
ok Uni.new(0xAD0E).NFKC.list ~~ (0xAD0E,), 'AD0E -> AD0E';
ok Uni.new(0xAD0F).NFKC.list ~~ (0xAD0F,), 'AD0F -> AD0F';
ok Uni.new(0xAD10).NFKC.list ~~ (0xAD10,), 'AD10 -> AD10';
ok Uni.new(0xAD11).NFKC.list ~~ (0xAD11,), 'AD11 -> AD11';
ok Uni.new(0xAD12).NFKC.list ~~ (0xAD12,), 'AD12 -> AD12';
ok Uni.new(0xAD13).NFKC.list ~~ (0xAD13,), 'AD13 -> AD13';
ok Uni.new(0xAD14).NFKC.list ~~ (0xAD14,), 'AD14 -> AD14';
ok Uni.new(0xAD15).NFKC.list ~~ (0xAD15,), 'AD15 -> AD15';
ok Uni.new(0xAD16).NFKC.list ~~ (0xAD16,), 'AD16 -> AD16';
ok Uni.new(0xAD17).NFKC.list ~~ (0xAD17,), 'AD17 -> AD17';
ok Uni.new(0xAD18).NFKC.list ~~ (0xAD18,), 'AD18 -> AD18';
ok Uni.new(0xAD19).NFKC.list ~~ (0xAD19,), 'AD19 -> AD19';
ok Uni.new(0xAD1A).NFKC.list ~~ (0xAD1A,), 'AD1A -> AD1A';
ok Uni.new(0xAD1B).NFKC.list ~~ (0xAD1B,), 'AD1B -> AD1B';
ok Uni.new(0xAD1C).NFKC.list ~~ (0xAD1C,), 'AD1C -> AD1C';
ok Uni.new(0xAD1D).NFKC.list ~~ (0xAD1D,), 'AD1D -> AD1D';
ok Uni.new(0xAD1E).NFKC.list ~~ (0xAD1E,), 'AD1E -> AD1E';
ok Uni.new(0xAD1F).NFKC.list ~~ (0xAD1F,), 'AD1F -> AD1F';
ok Uni.new(0xAD20).NFKC.list ~~ (0xAD20,), 'AD20 -> AD20';
ok Uni.new(0xAD21).NFKC.list ~~ (0xAD21,), 'AD21 -> AD21';
ok Uni.new(0xAD22).NFKC.list ~~ (0xAD22,), 'AD22 -> AD22';
ok Uni.new(0xAD23).NFKC.list ~~ (0xAD23,), 'AD23 -> AD23';
ok Uni.new(0xAD24).NFKC.list ~~ (0xAD24,), 'AD24 -> AD24';
ok Uni.new(0xAD25).NFKC.list ~~ (0xAD25,), 'AD25 -> AD25';
ok Uni.new(0xAD26).NFKC.list ~~ (0xAD26,), 'AD26 -> AD26';
ok Uni.new(0xAD27).NFKC.list ~~ (0xAD27,), 'AD27 -> AD27';
ok Uni.new(0xAD28).NFKC.list ~~ (0xAD28,), 'AD28 -> AD28';
ok Uni.new(0xAD29).NFKC.list ~~ (0xAD29,), 'AD29 -> AD29';
ok Uni.new(0xAD2A).NFKC.list ~~ (0xAD2A,), 'AD2A -> AD2A';
ok Uni.new(0xAD2B).NFKC.list ~~ (0xAD2B,), 'AD2B -> AD2B';
ok Uni.new(0xAD2C).NFKC.list ~~ (0xAD2C,), 'AD2C -> AD2C';
ok Uni.new(0xAD2D).NFKC.list ~~ (0xAD2D,), 'AD2D -> AD2D';
ok Uni.new(0xAD2E).NFKC.list ~~ (0xAD2E,), 'AD2E -> AD2E';
ok Uni.new(0xAD2F).NFKC.list ~~ (0xAD2F,), 'AD2F -> AD2F';
ok Uni.new(0xAD30).NFKC.list ~~ (0xAD30,), 'AD30 -> AD30';
ok Uni.new(0xAD31).NFKC.list ~~ (0xAD31,), 'AD31 -> AD31';
ok Uni.new(0xAD32).NFKC.list ~~ (0xAD32,), 'AD32 -> AD32';
ok Uni.new(0xAD33).NFKC.list ~~ (0xAD33,), 'AD33 -> AD33';
ok Uni.new(0xAD34).NFKC.list ~~ (0xAD34,), 'AD34 -> AD34';
ok Uni.new(0xAD35).NFKC.list ~~ (0xAD35,), 'AD35 -> AD35';
ok Uni.new(0xAD36).NFKC.list ~~ (0xAD36,), 'AD36 -> AD36';
ok Uni.new(0xAD37).NFKC.list ~~ (0xAD37,), 'AD37 -> AD37';
ok Uni.new(0xAD38).NFKC.list ~~ (0xAD38,), 'AD38 -> AD38';
ok Uni.new(0xAD39).NFKC.list ~~ (0xAD39,), 'AD39 -> AD39';
ok Uni.new(0xAD3A).NFKC.list ~~ (0xAD3A,), 'AD3A -> AD3A';
ok Uni.new(0xAD3B).NFKC.list ~~ (0xAD3B,), 'AD3B -> AD3B';
ok Uni.new(0xAD3C).NFKC.list ~~ (0xAD3C,), 'AD3C -> AD3C';
ok Uni.new(0xAD3D).NFKC.list ~~ (0xAD3D,), 'AD3D -> AD3D';
ok Uni.new(0xAD3E).NFKC.list ~~ (0xAD3E,), 'AD3E -> AD3E';
ok Uni.new(0xAD3F).NFKC.list ~~ (0xAD3F,), 'AD3F -> AD3F';
ok Uni.new(0xAD40).NFKC.list ~~ (0xAD40,), 'AD40 -> AD40';
ok Uni.new(0xAD41).NFKC.list ~~ (0xAD41,), 'AD41 -> AD41';
ok Uni.new(0xAD42).NFKC.list ~~ (0xAD42,), 'AD42 -> AD42';
ok Uni.new(0xAD43).NFKC.list ~~ (0xAD43,), 'AD43 -> AD43';
ok Uni.new(0xAD44).NFKC.list ~~ (0xAD44,), 'AD44 -> AD44';
ok Uni.new(0xAD45).NFKC.list ~~ (0xAD45,), 'AD45 -> AD45';
ok Uni.new(0xAD46).NFKC.list ~~ (0xAD46,), 'AD46 -> AD46';
ok Uni.new(0xAD47).NFKC.list ~~ (0xAD47,), 'AD47 -> AD47';
ok Uni.new(0xAD48).NFKC.list ~~ (0xAD48,), 'AD48 -> AD48';
ok Uni.new(0xAD49).NFKC.list ~~ (0xAD49,), 'AD49 -> AD49';
ok Uni.new(0xAD4A).NFKC.list ~~ (0xAD4A,), 'AD4A -> AD4A';
ok Uni.new(0xAD4B).NFKC.list ~~ (0xAD4B,), 'AD4B -> AD4B';
ok Uni.new(0xAD4C).NFKC.list ~~ (0xAD4C,), 'AD4C -> AD4C';
ok Uni.new(0xAD4D).NFKC.list ~~ (0xAD4D,), 'AD4D -> AD4D';
ok Uni.new(0xAD4E).NFKC.list ~~ (0xAD4E,), 'AD4E -> AD4E';
ok Uni.new(0xAD4F).NFKC.list ~~ (0xAD4F,), 'AD4F -> AD4F';
ok Uni.new(0xAD50).NFKC.list ~~ (0xAD50,), 'AD50 -> AD50';
ok Uni.new(0xAD51).NFKC.list ~~ (0xAD51,), 'AD51 -> AD51';
ok Uni.new(0xAD52).NFKC.list ~~ (0xAD52,), 'AD52 -> AD52';
ok Uni.new(0xAD53).NFKC.list ~~ (0xAD53,), 'AD53 -> AD53';
ok Uni.new(0xAD54).NFKC.list ~~ (0xAD54,), 'AD54 -> AD54';
ok Uni.new(0xAD55).NFKC.list ~~ (0xAD55,), 'AD55 -> AD55';
ok Uni.new(0xAD56).NFKC.list ~~ (0xAD56,), 'AD56 -> AD56';
ok Uni.new(0xAD57).NFKC.list ~~ (0xAD57,), 'AD57 -> AD57';
ok Uni.new(0xAD58).NFKC.list ~~ (0xAD58,), 'AD58 -> AD58';
ok Uni.new(0xAD59).NFKC.list ~~ (0xAD59,), 'AD59 -> AD59';
ok Uni.new(0xAD5A).NFKC.list ~~ (0xAD5A,), 'AD5A -> AD5A';
ok Uni.new(0xAD5B).NFKC.list ~~ (0xAD5B,), 'AD5B -> AD5B';
ok Uni.new(0xAD5C).NFKC.list ~~ (0xAD5C,), 'AD5C -> AD5C';
ok Uni.new(0xAD5D).NFKC.list ~~ (0xAD5D,), 'AD5D -> AD5D';
ok Uni.new(0xAD5E).NFKC.list ~~ (0xAD5E,), 'AD5E -> AD5E';
ok Uni.new(0xAD5F).NFKC.list ~~ (0xAD5F,), 'AD5F -> AD5F';
ok Uni.new(0xAD60).NFKC.list ~~ (0xAD60,), 'AD60 -> AD60';
ok Uni.new(0xAD61).NFKC.list ~~ (0xAD61,), 'AD61 -> AD61';
ok Uni.new(0xAD62).NFKC.list ~~ (0xAD62,), 'AD62 -> AD62';
ok Uni.new(0xAD63).NFKC.list ~~ (0xAD63,), 'AD63 -> AD63';
ok Uni.new(0xAD64).NFKC.list ~~ (0xAD64,), 'AD64 -> AD64';
ok Uni.new(0xAD65).NFKC.list ~~ (0xAD65,), 'AD65 -> AD65';
ok Uni.new(0xAD66).NFKC.list ~~ (0xAD66,), 'AD66 -> AD66';
ok Uni.new(0xAD67).NFKC.list ~~ (0xAD67,), 'AD67 -> AD67';
ok Uni.new(0xAD68).NFKC.list ~~ (0xAD68,), 'AD68 -> AD68';
ok Uni.new(0xAD69).NFKC.list ~~ (0xAD69,), 'AD69 -> AD69';
ok Uni.new(0xAD6A).NFKC.list ~~ (0xAD6A,), 'AD6A -> AD6A';
ok Uni.new(0xAD6B).NFKC.list ~~ (0xAD6B,), 'AD6B -> AD6B';
ok Uni.new(0xAD6C).NFKC.list ~~ (0xAD6C,), 'AD6C -> AD6C';
ok Uni.new(0xAD6D).NFKC.list ~~ (0xAD6D,), 'AD6D -> AD6D';
ok Uni.new(0xAD6E).NFKC.list ~~ (0xAD6E,), 'AD6E -> AD6E';
ok Uni.new(0xAD6F).NFKC.list ~~ (0xAD6F,), 'AD6F -> AD6F';
ok Uni.new(0xAD70).NFKC.list ~~ (0xAD70,), 'AD70 -> AD70';
ok Uni.new(0xAD71).NFKC.list ~~ (0xAD71,), 'AD71 -> AD71';
ok Uni.new(0xAD72).NFKC.list ~~ (0xAD72,), 'AD72 -> AD72';
ok Uni.new(0xAD73).NFKC.list ~~ (0xAD73,), 'AD73 -> AD73';
ok Uni.new(0xAD74).NFKC.list ~~ (0xAD74,), 'AD74 -> AD74';
ok Uni.new(0xAD75).NFKC.list ~~ (0xAD75,), 'AD75 -> AD75';
ok Uni.new(0xAD76).NFKC.list ~~ (0xAD76,), 'AD76 -> AD76';
ok Uni.new(0xAD77).NFKC.list ~~ (0xAD77,), 'AD77 -> AD77';
ok Uni.new(0xAD78).NFKC.list ~~ (0xAD78,), 'AD78 -> AD78';
ok Uni.new(0xAD79).NFKC.list ~~ (0xAD79,), 'AD79 -> AD79';
ok Uni.new(0xAD7A).NFKC.list ~~ (0xAD7A,), 'AD7A -> AD7A';
ok Uni.new(0xAD7B).NFKC.list ~~ (0xAD7B,), 'AD7B -> AD7B';
ok Uni.new(0xAD7C).NFKC.list ~~ (0xAD7C,), 'AD7C -> AD7C';
ok Uni.new(0xAD7D).NFKC.list ~~ (0xAD7D,), 'AD7D -> AD7D';
ok Uni.new(0xAD7E).NFKC.list ~~ (0xAD7E,), 'AD7E -> AD7E';
ok Uni.new(0xAD7F).NFKC.list ~~ (0xAD7F,), 'AD7F -> AD7F';
ok Uni.new(0xAD80).NFKC.list ~~ (0xAD80,), 'AD80 -> AD80';
ok Uni.new(0xAD81).NFKC.list ~~ (0xAD81,), 'AD81 -> AD81';
ok Uni.new(0xAD82).NFKC.list ~~ (0xAD82,), 'AD82 -> AD82';
ok Uni.new(0xAD83).NFKC.list ~~ (0xAD83,), 'AD83 -> AD83';
ok Uni.new(0xAD84).NFKC.list ~~ (0xAD84,), 'AD84 -> AD84';
ok Uni.new(0xAD85).NFKC.list ~~ (0xAD85,), 'AD85 -> AD85';
ok Uni.new(0xAD86).NFKC.list ~~ (0xAD86,), 'AD86 -> AD86';
ok Uni.new(0xAD87).NFKC.list ~~ (0xAD87,), 'AD87 -> AD87';
ok Uni.new(0xAD88).NFKC.list ~~ (0xAD88,), 'AD88 -> AD88';
ok Uni.new(0xAD89).NFKC.list ~~ (0xAD89,), 'AD89 -> AD89';
ok Uni.new(0xAD8A).NFKC.list ~~ (0xAD8A,), 'AD8A -> AD8A';
ok Uni.new(0xAD8B).NFKC.list ~~ (0xAD8B,), 'AD8B -> AD8B';
ok Uni.new(0xAD8C).NFKC.list ~~ (0xAD8C,), 'AD8C -> AD8C';
ok Uni.new(0xAD8D).NFKC.list ~~ (0xAD8D,), 'AD8D -> AD8D';
ok Uni.new(0xAD8E).NFKC.list ~~ (0xAD8E,), 'AD8E -> AD8E';
ok Uni.new(0xAD8F).NFKC.list ~~ (0xAD8F,), 'AD8F -> AD8F';
ok Uni.new(0xAD90).NFKC.list ~~ (0xAD90,), 'AD90 -> AD90';
ok Uni.new(0xAD91).NFKC.list ~~ (0xAD91,), 'AD91 -> AD91';
ok Uni.new(0xAD92).NFKC.list ~~ (0xAD92,), 'AD92 -> AD92';
ok Uni.new(0xAD93).NFKC.list ~~ (0xAD93,), 'AD93 -> AD93';
ok Uni.new(0xAD94).NFKC.list ~~ (0xAD94,), 'AD94 -> AD94';
ok Uni.new(0xAD95).NFKC.list ~~ (0xAD95,), 'AD95 -> AD95';
ok Uni.new(0xAD96).NFKC.list ~~ (0xAD96,), 'AD96 -> AD96';
ok Uni.new(0xAD97).NFKC.list ~~ (0xAD97,), 'AD97 -> AD97';
ok Uni.new(0xAD98).NFKC.list ~~ (0xAD98,), 'AD98 -> AD98';
ok Uni.new(0xAD99).NFKC.list ~~ (0xAD99,), 'AD99 -> AD99';
ok Uni.new(0xAD9A).NFKC.list ~~ (0xAD9A,), 'AD9A -> AD9A';
ok Uni.new(0xAD9B).NFKC.list ~~ (0xAD9B,), 'AD9B -> AD9B';
ok Uni.new(0xAD9C).NFKC.list ~~ (0xAD9C,), 'AD9C -> AD9C';
ok Uni.new(0xAD9D).NFKC.list ~~ (0xAD9D,), 'AD9D -> AD9D';
ok Uni.new(0xAD9E).NFKC.list ~~ (0xAD9E,), 'AD9E -> AD9E';
ok Uni.new(0xAD9F).NFKC.list ~~ (0xAD9F,), 'AD9F -> AD9F';
ok Uni.new(0xADA0).NFKC.list ~~ (0xADA0,), 'ADA0 -> ADA0';
ok Uni.new(0xADA1).NFKC.list ~~ (0xADA1,), 'ADA1 -> ADA1';
ok Uni.new(0xADA2).NFKC.list ~~ (0xADA2,), 'ADA2 -> ADA2';
ok Uni.new(0xADA3).NFKC.list ~~ (0xADA3,), 'ADA3 -> ADA3';
ok Uni.new(0xADA4).NFKC.list ~~ (0xADA4,), 'ADA4 -> ADA4';
ok Uni.new(0xADA5).NFKC.list ~~ (0xADA5,), 'ADA5 -> ADA5';
ok Uni.new(0xADA6).NFKC.list ~~ (0xADA6,), 'ADA6 -> ADA6';
ok Uni.new(0xADA7).NFKC.list ~~ (0xADA7,), 'ADA7 -> ADA7';
ok Uni.new(0xADA8).NFKC.list ~~ (0xADA8,), 'ADA8 -> ADA8';
ok Uni.new(0xADA9).NFKC.list ~~ (0xADA9,), 'ADA9 -> ADA9';
ok Uni.new(0xADAA).NFKC.list ~~ (0xADAA,), 'ADAA -> ADAA';
ok Uni.new(0xADAB).NFKC.list ~~ (0xADAB,), 'ADAB -> ADAB';
ok Uni.new(0xADAC).NFKC.list ~~ (0xADAC,), 'ADAC -> ADAC';
ok Uni.new(0xADAD).NFKC.list ~~ (0xADAD,), 'ADAD -> ADAD';
ok Uni.new(0xADAE).NFKC.list ~~ (0xADAE,), 'ADAE -> ADAE';
ok Uni.new(0xADAF).NFKC.list ~~ (0xADAF,), 'ADAF -> ADAF';
ok Uni.new(0xADB0).NFKC.list ~~ (0xADB0,), 'ADB0 -> ADB0';
ok Uni.new(0xADB1).NFKC.list ~~ (0xADB1,), 'ADB1 -> ADB1';
ok Uni.new(0xADB2).NFKC.list ~~ (0xADB2,), 'ADB2 -> ADB2';
ok Uni.new(0xADB3).NFKC.list ~~ (0xADB3,), 'ADB3 -> ADB3';
ok Uni.new(0xADB4).NFKC.list ~~ (0xADB4,), 'ADB4 -> ADB4';
ok Uni.new(0xADB5).NFKC.list ~~ (0xADB5,), 'ADB5 -> ADB5';
ok Uni.new(0xADB6).NFKC.list ~~ (0xADB6,), 'ADB6 -> ADB6';
ok Uni.new(0xADB7).NFKC.list ~~ (0xADB7,), 'ADB7 -> ADB7';
ok Uni.new(0xADB8).NFKC.list ~~ (0xADB8,), 'ADB8 -> ADB8';
ok Uni.new(0xADB9).NFKC.list ~~ (0xADB9,), 'ADB9 -> ADB9';
ok Uni.new(0xADBA).NFKC.list ~~ (0xADBA,), 'ADBA -> ADBA';
ok Uni.new(0xADBB).NFKC.list ~~ (0xADBB,), 'ADBB -> ADBB';
ok Uni.new(0xADBC).NFKC.list ~~ (0xADBC,), 'ADBC -> ADBC';
ok Uni.new(0xADBD).NFKC.list ~~ (0xADBD,), 'ADBD -> ADBD';
ok Uni.new(0xADBE).NFKC.list ~~ (0xADBE,), 'ADBE -> ADBE';
ok Uni.new(0xADBF).NFKC.list ~~ (0xADBF,), 'ADBF -> ADBF';
ok Uni.new(0xADC0).NFKC.list ~~ (0xADC0,), 'ADC0 -> ADC0';
ok Uni.new(0xADC1).NFKC.list ~~ (0xADC1,), 'ADC1 -> ADC1';
ok Uni.new(0xADC2).NFKC.list ~~ (0xADC2,), 'ADC2 -> ADC2';
ok Uni.new(0xADC3).NFKC.list ~~ (0xADC3,), 'ADC3 -> ADC3';
ok Uni.new(0xADC4).NFKC.list ~~ (0xADC4,), 'ADC4 -> ADC4';
ok Uni.new(0xADC5).NFKC.list ~~ (0xADC5,), 'ADC5 -> ADC5';
ok Uni.new(0xADC6).NFKC.list ~~ (0xADC6,), 'ADC6 -> ADC6';
ok Uni.new(0xADC7).NFKC.list ~~ (0xADC7,), 'ADC7 -> ADC7';
ok Uni.new(0xADC8).NFKC.list ~~ (0xADC8,), 'ADC8 -> ADC8';
ok Uni.new(0xADC9).NFKC.list ~~ (0xADC9,), 'ADC9 -> ADC9';
ok Uni.new(0xADCA).NFKC.list ~~ (0xADCA,), 'ADCA -> ADCA';
ok Uni.new(0xADCB).NFKC.list ~~ (0xADCB,), 'ADCB -> ADCB';
ok Uni.new(0xADCC).NFKC.list ~~ (0xADCC,), 'ADCC -> ADCC';
ok Uni.new(0xADCD).NFKC.list ~~ (0xADCD,), 'ADCD -> ADCD';
ok Uni.new(0xADCE).NFKC.list ~~ (0xADCE,), 'ADCE -> ADCE';
ok Uni.new(0xADCF).NFKC.list ~~ (0xADCF,), 'ADCF -> ADCF';
ok Uni.new(0xADD0).NFKC.list ~~ (0xADD0,), 'ADD0 -> ADD0';
ok Uni.new(0xADD1).NFKC.list ~~ (0xADD1,), 'ADD1 -> ADD1';
ok Uni.new(0xADD2).NFKC.list ~~ (0xADD2,), 'ADD2 -> ADD2';
ok Uni.new(0xADD3).NFKC.list ~~ (0xADD3,), 'ADD3 -> ADD3';
ok Uni.new(0xADD4).NFKC.list ~~ (0xADD4,), 'ADD4 -> ADD4';
ok Uni.new(0xADD5).NFKC.list ~~ (0xADD5,), 'ADD5 -> ADD5';
ok Uni.new(0xADD6).NFKC.list ~~ (0xADD6,), 'ADD6 -> ADD6';
ok Uni.new(0xADD7).NFKC.list ~~ (0xADD7,), 'ADD7 -> ADD7';
ok Uni.new(0xADD8).NFKC.list ~~ (0xADD8,), 'ADD8 -> ADD8';
ok Uni.new(0xADD9).NFKC.list ~~ (0xADD9,), 'ADD9 -> ADD9';
ok Uni.new(0xADDA).NFKC.list ~~ (0xADDA,), 'ADDA -> ADDA';
ok Uni.new(0xADDB).NFKC.list ~~ (0xADDB,), 'ADDB -> ADDB';
ok Uni.new(0xADDC).NFKC.list ~~ (0xADDC,), 'ADDC -> ADDC';
ok Uni.new(0xADDD).NFKC.list ~~ (0xADDD,), 'ADDD -> ADDD';
ok Uni.new(0xADDE).NFKC.list ~~ (0xADDE,), 'ADDE -> ADDE';
ok Uni.new(0xADDF).NFKC.list ~~ (0xADDF,), 'ADDF -> ADDF';
ok Uni.new(0xADE0).NFKC.list ~~ (0xADE0,), 'ADE0 -> ADE0';
ok Uni.new(0xADE1).NFKC.list ~~ (0xADE1,), 'ADE1 -> ADE1';
ok Uni.new(0xADE2).NFKC.list ~~ (0xADE2,), 'ADE2 -> ADE2';
ok Uni.new(0xADE3).NFKC.list ~~ (0xADE3,), 'ADE3 -> ADE3';
ok Uni.new(0xADE4).NFKC.list ~~ (0xADE4,), 'ADE4 -> ADE4';
ok Uni.new(0xADE5).NFKC.list ~~ (0xADE5,), 'ADE5 -> ADE5';
ok Uni.new(0xADE6).NFKC.list ~~ (0xADE6,), 'ADE6 -> ADE6';
ok Uni.new(0xADE7).NFKC.list ~~ (0xADE7,), 'ADE7 -> ADE7';
ok Uni.new(0xADE8).NFKC.list ~~ (0xADE8,), 'ADE8 -> ADE8';
ok Uni.new(0xADE9).NFKC.list ~~ (0xADE9,), 'ADE9 -> ADE9';
ok Uni.new(0xADEA).NFKC.list ~~ (0xADEA,), 'ADEA -> ADEA';
ok Uni.new(0xADEB).NFKC.list ~~ (0xADEB,), 'ADEB -> ADEB';
ok Uni.new(0xADEC).NFKC.list ~~ (0xADEC,), 'ADEC -> ADEC';
ok Uni.new(0xADED).NFKC.list ~~ (0xADED,), 'ADED -> ADED';
ok Uni.new(0xADEE).NFKC.list ~~ (0xADEE,), 'ADEE -> ADEE';
ok Uni.new(0xADEF).NFKC.list ~~ (0xADEF,), 'ADEF -> ADEF';
ok Uni.new(0xADF0).NFKC.list ~~ (0xADF0,), 'ADF0 -> ADF0';
ok Uni.new(0xADF1).NFKC.list ~~ (0xADF1,), 'ADF1 -> ADF1';
ok Uni.new(0xADF2).NFKC.list ~~ (0xADF2,), 'ADF2 -> ADF2';
ok Uni.new(0xADF3).NFKC.list ~~ (0xADF3,), 'ADF3 -> ADF3';
ok Uni.new(0xADF4).NFKC.list ~~ (0xADF4,), 'ADF4 -> ADF4';
ok Uni.new(0xADF5).NFKC.list ~~ (0xADF5,), 'ADF5 -> ADF5';
ok Uni.new(0xADF6).NFKC.list ~~ (0xADF6,), 'ADF6 -> ADF6';
ok Uni.new(0xADF7).NFKC.list ~~ (0xADF7,), 'ADF7 -> ADF7';
ok Uni.new(0xADF8).NFKC.list ~~ (0xADF8,), 'ADF8 -> ADF8';
ok Uni.new(0xADF9).NFKC.list ~~ (0xADF9,), 'ADF9 -> ADF9';
ok Uni.new(0xADFA).NFKC.list ~~ (0xADFA,), 'ADFA -> ADFA';
ok Uni.new(0xADFB).NFKC.list ~~ (0xADFB,), 'ADFB -> ADFB';
ok Uni.new(0xADFC).NFKC.list ~~ (0xADFC,), 'ADFC -> ADFC';
ok Uni.new(0xADFD).NFKC.list ~~ (0xADFD,), 'ADFD -> ADFD';
ok Uni.new(0xADFE).NFKC.list ~~ (0xADFE,), 'ADFE -> ADFE';
ok Uni.new(0xADFF).NFKC.list ~~ (0xADFF,), 'ADFF -> ADFF';
ok Uni.new(0xAE00).NFKC.list ~~ (0xAE00,), 'AE00 -> AE00';
ok Uni.new(0xAE01).NFKC.list ~~ (0xAE01,), 'AE01 -> AE01';
ok Uni.new(0xAE02).NFKC.list ~~ (0xAE02,), 'AE02 -> AE02';
ok Uni.new(0xAE03).NFKC.list ~~ (0xAE03,), 'AE03 -> AE03';
ok Uni.new(0xAE04).NFKC.list ~~ (0xAE04,), 'AE04 -> AE04';
ok Uni.new(0xAE05).NFKC.list ~~ (0xAE05,), 'AE05 -> AE05';
ok Uni.new(0xAE06).NFKC.list ~~ (0xAE06,), 'AE06 -> AE06';
ok Uni.new(0xAE07).NFKC.list ~~ (0xAE07,), 'AE07 -> AE07';
ok Uni.new(0xAE08).NFKC.list ~~ (0xAE08,), 'AE08 -> AE08';
ok Uni.new(0xAE09).NFKC.list ~~ (0xAE09,), 'AE09 -> AE09';
ok Uni.new(0xAE0A).NFKC.list ~~ (0xAE0A,), 'AE0A -> AE0A';
ok Uni.new(0xAE0B).NFKC.list ~~ (0xAE0B,), 'AE0B -> AE0B';
ok Uni.new(0xAE0C).NFKC.list ~~ (0xAE0C,), 'AE0C -> AE0C';
ok Uni.new(0xAE0D).NFKC.list ~~ (0xAE0D,), 'AE0D -> AE0D';
ok Uni.new(0xAE0E).NFKC.list ~~ (0xAE0E,), 'AE0E -> AE0E';
ok Uni.new(0xAE0F).NFKC.list ~~ (0xAE0F,), 'AE0F -> AE0F';
ok Uni.new(0xAE10).NFKC.list ~~ (0xAE10,), 'AE10 -> AE10';
ok Uni.new(0xAE11).NFKC.list ~~ (0xAE11,), 'AE11 -> AE11';
ok Uni.new(0xAE12).NFKC.list ~~ (0xAE12,), 'AE12 -> AE12';
ok Uni.new(0xAE13).NFKC.list ~~ (0xAE13,), 'AE13 -> AE13';
ok Uni.new(0xAE14).NFKC.list ~~ (0xAE14,), 'AE14 -> AE14';
ok Uni.new(0xAE15).NFKC.list ~~ (0xAE15,), 'AE15 -> AE15';
ok Uni.new(0xAE16).NFKC.list ~~ (0xAE16,), 'AE16 -> AE16';
ok Uni.new(0xAE17).NFKC.list ~~ (0xAE17,), 'AE17 -> AE17';
ok Uni.new(0xAE18).NFKC.list ~~ (0xAE18,), 'AE18 -> AE18';
ok Uni.new(0xAE19).NFKC.list ~~ (0xAE19,), 'AE19 -> AE19';
ok Uni.new(0xAE1A).NFKC.list ~~ (0xAE1A,), 'AE1A -> AE1A';
ok Uni.new(0xAE1B).NFKC.list ~~ (0xAE1B,), 'AE1B -> AE1B';
ok Uni.new(0xAE1C).NFKC.list ~~ (0xAE1C,), 'AE1C -> AE1C';
ok Uni.new(0xAE1D).NFKC.list ~~ (0xAE1D,), 'AE1D -> AE1D';
ok Uni.new(0xAE1E).NFKC.list ~~ (0xAE1E,), 'AE1E -> AE1E';
ok Uni.new(0xAE1F).NFKC.list ~~ (0xAE1F,), 'AE1F -> AE1F';
ok Uni.new(0xAE20).NFKC.list ~~ (0xAE20,), 'AE20 -> AE20';
ok Uni.new(0xAE21).NFKC.list ~~ (0xAE21,), 'AE21 -> AE21';
ok Uni.new(0xAE22).NFKC.list ~~ (0xAE22,), 'AE22 -> AE22';
ok Uni.new(0xAE23).NFKC.list ~~ (0xAE23,), 'AE23 -> AE23';
ok Uni.new(0xAE24).NFKC.list ~~ (0xAE24,), 'AE24 -> AE24';
ok Uni.new(0xAE25).NFKC.list ~~ (0xAE25,), 'AE25 -> AE25';
ok Uni.new(0xAE26).NFKC.list ~~ (0xAE26,), 'AE26 -> AE26';
ok Uni.new(0xAE27).NFKC.list ~~ (0xAE27,), 'AE27 -> AE27';
ok Uni.new(0xAE28).NFKC.list ~~ (0xAE28,), 'AE28 -> AE28';
ok Uni.new(0xAE29).NFKC.list ~~ (0xAE29,), 'AE29 -> AE29';
ok Uni.new(0xAE2A).NFKC.list ~~ (0xAE2A,), 'AE2A -> AE2A';
ok Uni.new(0xAE2B).NFKC.list ~~ (0xAE2B,), 'AE2B -> AE2B';
ok Uni.new(0xAE2C).NFKC.list ~~ (0xAE2C,), 'AE2C -> AE2C';
ok Uni.new(0xAE2D).NFKC.list ~~ (0xAE2D,), 'AE2D -> AE2D';
ok Uni.new(0xAE2E).NFKC.list ~~ (0xAE2E,), 'AE2E -> AE2E';
ok Uni.new(0xAE2F).NFKC.list ~~ (0xAE2F,), 'AE2F -> AE2F';
ok Uni.new(0xAE30).NFKC.list ~~ (0xAE30,), 'AE30 -> AE30';
ok Uni.new(0xAE31).NFKC.list ~~ (0xAE31,), 'AE31 -> AE31';
ok Uni.new(0xAE32).NFKC.list ~~ (0xAE32,), 'AE32 -> AE32';
ok Uni.new(0xAE33).NFKC.list ~~ (0xAE33,), 'AE33 -> AE33';
ok Uni.new(0xAE34).NFKC.list ~~ (0xAE34,), 'AE34 -> AE34';
ok Uni.new(0xAE35).NFKC.list ~~ (0xAE35,), 'AE35 -> AE35';
ok Uni.new(0xAE36).NFKC.list ~~ (0xAE36,), 'AE36 -> AE36';
ok Uni.new(0xAE37).NFKC.list ~~ (0xAE37,), 'AE37 -> AE37';
ok Uni.new(0xAE38).NFKC.list ~~ (0xAE38,), 'AE38 -> AE38';
ok Uni.new(0xAE39).NFKC.list ~~ (0xAE39,), 'AE39 -> AE39';
ok Uni.new(0xAE3A).NFKC.list ~~ (0xAE3A,), 'AE3A -> AE3A';
ok Uni.new(0xAE3B).NFKC.list ~~ (0xAE3B,), 'AE3B -> AE3B';
ok Uni.new(0xAE3C).NFKC.list ~~ (0xAE3C,), 'AE3C -> AE3C';
ok Uni.new(0xAE3D).NFKC.list ~~ (0xAE3D,), 'AE3D -> AE3D';
ok Uni.new(0xAE3E).NFKC.list ~~ (0xAE3E,), 'AE3E -> AE3E';
ok Uni.new(0xAE3F).NFKC.list ~~ (0xAE3F,), 'AE3F -> AE3F';
ok Uni.new(0xAE40).NFKC.list ~~ (0xAE40,), 'AE40 -> AE40';
ok Uni.new(0xAE41).NFKC.list ~~ (0xAE41,), 'AE41 -> AE41';
ok Uni.new(0xAE42).NFKC.list ~~ (0xAE42,), 'AE42 -> AE42';
ok Uni.new(0xAE43).NFKC.list ~~ (0xAE43,), 'AE43 -> AE43';
ok Uni.new(0xAE44).NFKC.list ~~ (0xAE44,), 'AE44 -> AE44';
ok Uni.new(0xAE45).NFKC.list ~~ (0xAE45,), 'AE45 -> AE45';
ok Uni.new(0xAE46).NFKC.list ~~ (0xAE46,), 'AE46 -> AE46';
ok Uni.new(0xAE47).NFKC.list ~~ (0xAE47,), 'AE47 -> AE47';
ok Uni.new(0xAE48).NFKC.list ~~ (0xAE48,), 'AE48 -> AE48';
ok Uni.new(0xAE49).NFKC.list ~~ (0xAE49,), 'AE49 -> AE49';
ok Uni.new(0xAE4A).NFKC.list ~~ (0xAE4A,), 'AE4A -> AE4A';
ok Uni.new(0xAE4B).NFKC.list ~~ (0xAE4B,), 'AE4B -> AE4B';
ok Uni.new(0xAE4C).NFKC.list ~~ (0xAE4C,), 'AE4C -> AE4C';
ok Uni.new(0xAE4D).NFKC.list ~~ (0xAE4D,), 'AE4D -> AE4D';
ok Uni.new(0xAE4E).NFKC.list ~~ (0xAE4E,), 'AE4E -> AE4E';
ok Uni.new(0xAE4F).NFKC.list ~~ (0xAE4F,), 'AE4F -> AE4F';
ok Uni.new(0xAE50).NFKC.list ~~ (0xAE50,), 'AE50 -> AE50';
ok Uni.new(0xAE51).NFKC.list ~~ (0xAE51,), 'AE51 -> AE51';
ok Uni.new(0xAE52).NFKC.list ~~ (0xAE52,), 'AE52 -> AE52';
ok Uni.new(0xAE53).NFKC.list ~~ (0xAE53,), 'AE53 -> AE53';
ok Uni.new(0xAE54).NFKC.list ~~ (0xAE54,), 'AE54 -> AE54';
ok Uni.new(0xAE55).NFKC.list ~~ (0xAE55,), 'AE55 -> AE55';
ok Uni.new(0xAE56).NFKC.list ~~ (0xAE56,), 'AE56 -> AE56';
ok Uni.new(0xAE57).NFKC.list ~~ (0xAE57,), 'AE57 -> AE57';
ok Uni.new(0xAE58).NFKC.list ~~ (0xAE58,), 'AE58 -> AE58';
ok Uni.new(0xAE59).NFKC.list ~~ (0xAE59,), 'AE59 -> AE59';
ok Uni.new(0xAE5A).NFKC.list ~~ (0xAE5A,), 'AE5A -> AE5A';
ok Uni.new(0xAE5B).NFKC.list ~~ (0xAE5B,), 'AE5B -> AE5B';
ok Uni.new(0xAE5C).NFKC.list ~~ (0xAE5C,), 'AE5C -> AE5C';
ok Uni.new(0xAE5D).NFKC.list ~~ (0xAE5D,), 'AE5D -> AE5D';
ok Uni.new(0xAE5E).NFKC.list ~~ (0xAE5E,), 'AE5E -> AE5E';
ok Uni.new(0xAE5F).NFKC.list ~~ (0xAE5F,), 'AE5F -> AE5F';
ok Uni.new(0xAE60).NFKC.list ~~ (0xAE60,), 'AE60 -> AE60';
ok Uni.new(0xAE61).NFKC.list ~~ (0xAE61,), 'AE61 -> AE61';
ok Uni.new(0xAE62).NFKC.list ~~ (0xAE62,), 'AE62 -> AE62';
ok Uni.new(0xAE63).NFKC.list ~~ (0xAE63,), 'AE63 -> AE63';
ok Uni.new(0xAE64).NFKC.list ~~ (0xAE64,), 'AE64 -> AE64';
ok Uni.new(0xAE65).NFKC.list ~~ (0xAE65,), 'AE65 -> AE65';
ok Uni.new(0xAE66).NFKC.list ~~ (0xAE66,), 'AE66 -> AE66';
ok Uni.new(0xAE67).NFKC.list ~~ (0xAE67,), 'AE67 -> AE67';
ok Uni.new(0xAE68).NFKC.list ~~ (0xAE68,), 'AE68 -> AE68';
ok Uni.new(0xAE69).NFKC.list ~~ (0xAE69,), 'AE69 -> AE69';
ok Uni.new(0xAE6A).NFKC.list ~~ (0xAE6A,), 'AE6A -> AE6A';
ok Uni.new(0xAE6B).NFKC.list ~~ (0xAE6B,), 'AE6B -> AE6B';
ok Uni.new(0xAE6C).NFKC.list ~~ (0xAE6C,), 'AE6C -> AE6C';
ok Uni.new(0xAE6D).NFKC.list ~~ (0xAE6D,), 'AE6D -> AE6D';
ok Uni.new(0xAE6E).NFKC.list ~~ (0xAE6E,), 'AE6E -> AE6E';
ok Uni.new(0xAE6F).NFKC.list ~~ (0xAE6F,), 'AE6F -> AE6F';
ok Uni.new(0xAE70).NFKC.list ~~ (0xAE70,), 'AE70 -> AE70';
ok Uni.new(0xAE71).NFKC.list ~~ (0xAE71,), 'AE71 -> AE71';
ok Uni.new(0xAE72).NFKC.list ~~ (0xAE72,), 'AE72 -> AE72';
ok Uni.new(0xAE73).NFKC.list ~~ (0xAE73,), 'AE73 -> AE73';
ok Uni.new(0xAE74).NFKC.list ~~ (0xAE74,), 'AE74 -> AE74';
ok Uni.new(0xAE75).NFKC.list ~~ (0xAE75,), 'AE75 -> AE75';
ok Uni.new(0xAE76).NFKC.list ~~ (0xAE76,), 'AE76 -> AE76';
ok Uni.new(0xAE77).NFKC.list ~~ (0xAE77,), 'AE77 -> AE77';
ok Uni.new(0xAE78).NFKC.list ~~ (0xAE78,), 'AE78 -> AE78';
ok Uni.new(0xAE79).NFKC.list ~~ (0xAE79,), 'AE79 -> AE79';
ok Uni.new(0xAE7A).NFKC.list ~~ (0xAE7A,), 'AE7A -> AE7A';
ok Uni.new(0xAE7B).NFKC.list ~~ (0xAE7B,), 'AE7B -> AE7B';
ok Uni.new(0xAE7C).NFKC.list ~~ (0xAE7C,), 'AE7C -> AE7C';
ok Uni.new(0xAE7D).NFKC.list ~~ (0xAE7D,), 'AE7D -> AE7D';
ok Uni.new(0xAE7E).NFKC.list ~~ (0xAE7E,), 'AE7E -> AE7E';
ok Uni.new(0xAE7F).NFKC.list ~~ (0xAE7F,), 'AE7F -> AE7F';
ok Uni.new(0xAE80).NFKC.list ~~ (0xAE80,), 'AE80 -> AE80';
ok Uni.new(0xAE81).NFKC.list ~~ (0xAE81,), 'AE81 -> AE81';
ok Uni.new(0xAE82).NFKC.list ~~ (0xAE82,), 'AE82 -> AE82';
ok Uni.new(0xAE83).NFKC.list ~~ (0xAE83,), 'AE83 -> AE83';
ok Uni.new(0xAE84).NFKC.list ~~ (0xAE84,), 'AE84 -> AE84';
ok Uni.new(0xAE85).NFKC.list ~~ (0xAE85,), 'AE85 -> AE85';
ok Uni.new(0xAE86).NFKC.list ~~ (0xAE86,), 'AE86 -> AE86';
ok Uni.new(0xAE87).NFKC.list ~~ (0xAE87,), 'AE87 -> AE87';
ok Uni.new(0xAE88).NFKC.list ~~ (0xAE88,), 'AE88 -> AE88';
ok Uni.new(0xAE89).NFKC.list ~~ (0xAE89,), 'AE89 -> AE89';
ok Uni.new(0xAE8A).NFKC.list ~~ (0xAE8A,), 'AE8A -> AE8A';
ok Uni.new(0xAE8B).NFKC.list ~~ (0xAE8B,), 'AE8B -> AE8B';
ok Uni.new(0xAE8C).NFKC.list ~~ (0xAE8C,), 'AE8C -> AE8C';
ok Uni.new(0xAE8D).NFKC.list ~~ (0xAE8D,), 'AE8D -> AE8D';
ok Uni.new(0xAE8E).NFKC.list ~~ (0xAE8E,), 'AE8E -> AE8E';
ok Uni.new(0xAE8F).NFKC.list ~~ (0xAE8F,), 'AE8F -> AE8F';
ok Uni.new(0xAE90).NFKC.list ~~ (0xAE90,), 'AE90 -> AE90';
ok Uni.new(0xAE91).NFKC.list ~~ (0xAE91,), 'AE91 -> AE91';
ok Uni.new(0xAE92).NFKC.list ~~ (0xAE92,), 'AE92 -> AE92';
ok Uni.new(0xAE93).NFKC.list ~~ (0xAE93,), 'AE93 -> AE93';
ok Uni.new(0xAE94).NFKC.list ~~ (0xAE94,), 'AE94 -> AE94';
ok Uni.new(0xAE95).NFKC.list ~~ (0xAE95,), 'AE95 -> AE95';
ok Uni.new(0xAE96).NFKC.list ~~ (0xAE96,), 'AE96 -> AE96';
ok Uni.new(0xAE97).NFKC.list ~~ (0xAE97,), 'AE97 -> AE97';
ok Uni.new(0xAE98).NFKC.list ~~ (0xAE98,), 'AE98 -> AE98';
ok Uni.new(0xAE99).NFKC.list ~~ (0xAE99,), 'AE99 -> AE99';
ok Uni.new(0xAE9A).NFKC.list ~~ (0xAE9A,), 'AE9A -> AE9A';
ok Uni.new(0xAE9B).NFKC.list ~~ (0xAE9B,), 'AE9B -> AE9B';
ok Uni.new(0xAE9C).NFKC.list ~~ (0xAE9C,), 'AE9C -> AE9C';
ok Uni.new(0xAE9D).NFKC.list ~~ (0xAE9D,), 'AE9D -> AE9D';
ok Uni.new(0xAE9E).NFKC.list ~~ (0xAE9E,), 'AE9E -> AE9E';
ok Uni.new(0xAE9F).NFKC.list ~~ (0xAE9F,), 'AE9F -> AE9F';
ok Uni.new(0xAEA0).NFKC.list ~~ (0xAEA0,), 'AEA0 -> AEA0';
ok Uni.new(0xAEA1).NFKC.list ~~ (0xAEA1,), 'AEA1 -> AEA1';
ok Uni.new(0xAEA2).NFKC.list ~~ (0xAEA2,), 'AEA2 -> AEA2';
ok Uni.new(0xAEA3).NFKC.list ~~ (0xAEA3,), 'AEA3 -> AEA3';
ok Uni.new(0xAEA4).NFKC.list ~~ (0xAEA4,), 'AEA4 -> AEA4';
ok Uni.new(0xAEA5).NFKC.list ~~ (0xAEA5,), 'AEA5 -> AEA5';
ok Uni.new(0xAEA6).NFKC.list ~~ (0xAEA6,), 'AEA6 -> AEA6';
ok Uni.new(0xAEA7).NFKC.list ~~ (0xAEA7,), 'AEA7 -> AEA7';
ok Uni.new(0xAEA8).NFKC.list ~~ (0xAEA8,), 'AEA8 -> AEA8';
ok Uni.new(0xAEA9).NFKC.list ~~ (0xAEA9,), 'AEA9 -> AEA9';
ok Uni.new(0xAEAA).NFKC.list ~~ (0xAEAA,), 'AEAA -> AEAA';
ok Uni.new(0xAEAB).NFKC.list ~~ (0xAEAB,), 'AEAB -> AEAB';
ok Uni.new(0xAEAC).NFKC.list ~~ (0xAEAC,), 'AEAC -> AEAC';
ok Uni.new(0xAEAD).NFKC.list ~~ (0xAEAD,), 'AEAD -> AEAD';
ok Uni.new(0xAEAE).NFKC.list ~~ (0xAEAE,), 'AEAE -> AEAE';
ok Uni.new(0xAEAF).NFKC.list ~~ (0xAEAF,), 'AEAF -> AEAF';
ok Uni.new(0xAEB0).NFKC.list ~~ (0xAEB0,), 'AEB0 -> AEB0';
ok Uni.new(0xAEB1).NFKC.list ~~ (0xAEB1,), 'AEB1 -> AEB1';
ok Uni.new(0xAEB2).NFKC.list ~~ (0xAEB2,), 'AEB2 -> AEB2';
ok Uni.new(0xAEB3).NFKC.list ~~ (0xAEB3,), 'AEB3 -> AEB3';
ok Uni.new(0xAEB4).NFKC.list ~~ (0xAEB4,), 'AEB4 -> AEB4';
ok Uni.new(0xAEB5).NFKC.list ~~ (0xAEB5,), 'AEB5 -> AEB5';
ok Uni.new(0xAEB6).NFKC.list ~~ (0xAEB6,), 'AEB6 -> AEB6';
ok Uni.new(0xAEB7).NFKC.list ~~ (0xAEB7,), 'AEB7 -> AEB7';
ok Uni.new(0xAEB8).NFKC.list ~~ (0xAEB8,), 'AEB8 -> AEB8';
ok Uni.new(0xAEB9).NFKC.list ~~ (0xAEB9,), 'AEB9 -> AEB9';
ok Uni.new(0xAEBA).NFKC.list ~~ (0xAEBA,), 'AEBA -> AEBA';
ok Uni.new(0xAEBB).NFKC.list ~~ (0xAEBB,), 'AEBB -> AEBB';
ok Uni.new(0xAEBC).NFKC.list ~~ (0xAEBC,), 'AEBC -> AEBC';
ok Uni.new(0xAEBD).NFKC.list ~~ (0xAEBD,), 'AEBD -> AEBD';
ok Uni.new(0xAEBE).NFKC.list ~~ (0xAEBE,), 'AEBE -> AEBE';
ok Uni.new(0xAEBF).NFKC.list ~~ (0xAEBF,), 'AEBF -> AEBF';
ok Uni.new(0xAEC0).NFKC.list ~~ (0xAEC0,), 'AEC0 -> AEC0';
ok Uni.new(0xAEC1).NFKC.list ~~ (0xAEC1,), 'AEC1 -> AEC1';
ok Uni.new(0xAEC2).NFKC.list ~~ (0xAEC2,), 'AEC2 -> AEC2';
ok Uni.new(0xAEC3).NFKC.list ~~ (0xAEC3,), 'AEC3 -> AEC3';
ok Uni.new(0xAEC4).NFKC.list ~~ (0xAEC4,), 'AEC4 -> AEC4';
ok Uni.new(0xAEC5).NFKC.list ~~ (0xAEC5,), 'AEC5 -> AEC5';
ok Uni.new(0xAEC6).NFKC.list ~~ (0xAEC6,), 'AEC6 -> AEC6';
ok Uni.new(0xAEC7).NFKC.list ~~ (0xAEC7,), 'AEC7 -> AEC7';
ok Uni.new(0xAEC8).NFKC.list ~~ (0xAEC8,), 'AEC8 -> AEC8';
ok Uni.new(0xAEC9).NFKC.list ~~ (0xAEC9,), 'AEC9 -> AEC9';
ok Uni.new(0xAECA).NFKC.list ~~ (0xAECA,), 'AECA -> AECA';
ok Uni.new(0xAECB).NFKC.list ~~ (0xAECB,), 'AECB -> AECB';
ok Uni.new(0xAECC).NFKC.list ~~ (0xAECC,), 'AECC -> AECC';
ok Uni.new(0xAECD).NFKC.list ~~ (0xAECD,), 'AECD -> AECD';
ok Uni.new(0xAECE).NFKC.list ~~ (0xAECE,), 'AECE -> AECE';
ok Uni.new(0xAECF).NFKC.list ~~ (0xAECF,), 'AECF -> AECF';
ok Uni.new(0xAED0).NFKC.list ~~ (0xAED0,), 'AED0 -> AED0';
ok Uni.new(0xAED1).NFKC.list ~~ (0xAED1,), 'AED1 -> AED1';
ok Uni.new(0xAED2).NFKC.list ~~ (0xAED2,), 'AED2 -> AED2';
ok Uni.new(0xAED3).NFKC.list ~~ (0xAED3,), 'AED3 -> AED3';
ok Uni.new(0xAED4).NFKC.list ~~ (0xAED4,), 'AED4 -> AED4';
ok Uni.new(0xAED5).NFKC.list ~~ (0xAED5,), 'AED5 -> AED5';
ok Uni.new(0xAED6).NFKC.list ~~ (0xAED6,), 'AED6 -> AED6';
ok Uni.new(0xAED7).NFKC.list ~~ (0xAED7,), 'AED7 -> AED7';
ok Uni.new(0xAED8).NFKC.list ~~ (0xAED8,), 'AED8 -> AED8';
ok Uni.new(0xAED9).NFKC.list ~~ (0xAED9,), 'AED9 -> AED9';
ok Uni.new(0xAEDA).NFKC.list ~~ (0xAEDA,), 'AEDA -> AEDA';
ok Uni.new(0xAEDB).NFKC.list ~~ (0xAEDB,), 'AEDB -> AEDB';
ok Uni.new(0xAEDC).NFKC.list ~~ (0xAEDC,), 'AEDC -> AEDC';
ok Uni.new(0xAEDD).NFKC.list ~~ (0xAEDD,), 'AEDD -> AEDD';
ok Uni.new(0xAEDE).NFKC.list ~~ (0xAEDE,), 'AEDE -> AEDE';
ok Uni.new(0xAEDF).NFKC.list ~~ (0xAEDF,), 'AEDF -> AEDF';
ok Uni.new(0xAEE0).NFKC.list ~~ (0xAEE0,), 'AEE0 -> AEE0';
ok Uni.new(0xAEE1).NFKC.list ~~ (0xAEE1,), 'AEE1 -> AEE1';
ok Uni.new(0xAEE2).NFKC.list ~~ (0xAEE2,), 'AEE2 -> AEE2';
ok Uni.new(0xAEE3).NFKC.list ~~ (0xAEE3,), 'AEE3 -> AEE3';
ok Uni.new(0xAEE4).NFKC.list ~~ (0xAEE4,), 'AEE4 -> AEE4';
ok Uni.new(0xAEE5).NFKC.list ~~ (0xAEE5,), 'AEE5 -> AEE5';
ok Uni.new(0xAEE6).NFKC.list ~~ (0xAEE6,), 'AEE6 -> AEE6';
ok Uni.new(0xAEE7).NFKC.list ~~ (0xAEE7,), 'AEE7 -> AEE7';
ok Uni.new(0xAEE8).NFKC.list ~~ (0xAEE8,), 'AEE8 -> AEE8';
ok Uni.new(0xAEE9).NFKC.list ~~ (0xAEE9,), 'AEE9 -> AEE9';
ok Uni.new(0xAEEA).NFKC.list ~~ (0xAEEA,), 'AEEA -> AEEA';
ok Uni.new(0xAEEB).NFKC.list ~~ (0xAEEB,), 'AEEB -> AEEB';
ok Uni.new(0xAEEC).NFKC.list ~~ (0xAEEC,), 'AEEC -> AEEC';
ok Uni.new(0xAEED).NFKC.list ~~ (0xAEED,), 'AEED -> AEED';
ok Uni.new(0xAEEE).NFKC.list ~~ (0xAEEE,), 'AEEE -> AEEE';
ok Uni.new(0xAEEF).NFKC.list ~~ (0xAEEF,), 'AEEF -> AEEF';
ok Uni.new(0xAEF0).NFKC.list ~~ (0xAEF0,), 'AEF0 -> AEF0';
ok Uni.new(0xAEF1).NFKC.list ~~ (0xAEF1,), 'AEF1 -> AEF1';
ok Uni.new(0xAEF2).NFKC.list ~~ (0xAEF2,), 'AEF2 -> AEF2';
ok Uni.new(0xAEF3).NFKC.list ~~ (0xAEF3,), 'AEF3 -> AEF3';
ok Uni.new(0xAEF4).NFKC.list ~~ (0xAEF4,), 'AEF4 -> AEF4';
ok Uni.new(0xAEF5).NFKC.list ~~ (0xAEF5,), 'AEF5 -> AEF5';
ok Uni.new(0xAEF6).NFKC.list ~~ (0xAEF6,), 'AEF6 -> AEF6';
ok Uni.new(0xAEF7).NFKC.list ~~ (0xAEF7,), 'AEF7 -> AEF7';
ok Uni.new(0xAEF8).NFKC.list ~~ (0xAEF8,), 'AEF8 -> AEF8';
ok Uni.new(0xAEF9).NFKC.list ~~ (0xAEF9,), 'AEF9 -> AEF9';
ok Uni.new(0xAEFA).NFKC.list ~~ (0xAEFA,), 'AEFA -> AEFA';
ok Uni.new(0xAEFB).NFKC.list ~~ (0xAEFB,), 'AEFB -> AEFB';
ok Uni.new(0xAEFC).NFKC.list ~~ (0xAEFC,), 'AEFC -> AEFC';
ok Uni.new(0xAEFD).NFKC.list ~~ (0xAEFD,), 'AEFD -> AEFD';
ok Uni.new(0xAEFE).NFKC.list ~~ (0xAEFE,), 'AEFE -> AEFE';
ok Uni.new(0xAEFF).NFKC.list ~~ (0xAEFF,), 'AEFF -> AEFF';
ok Uni.new(0xAF00).NFKC.list ~~ (0xAF00,), 'AF00 -> AF00';
ok Uni.new(0xAF01).NFKC.list ~~ (0xAF01,), 'AF01 -> AF01';
ok Uni.new(0xAF02).NFKC.list ~~ (0xAF02,), 'AF02 -> AF02';
ok Uni.new(0xAF03).NFKC.list ~~ (0xAF03,), 'AF03 -> AF03';
ok Uni.new(0xAF04).NFKC.list ~~ (0xAF04,), 'AF04 -> AF04';
ok Uni.new(0xAF05).NFKC.list ~~ (0xAF05,), 'AF05 -> AF05';
ok Uni.new(0xAF06).NFKC.list ~~ (0xAF06,), 'AF06 -> AF06';
ok Uni.new(0xAF07).NFKC.list ~~ (0xAF07,), 'AF07 -> AF07';
ok Uni.new(0xAF08).NFKC.list ~~ (0xAF08,), 'AF08 -> AF08';
ok Uni.new(0xAF09).NFKC.list ~~ (0xAF09,), 'AF09 -> AF09';
ok Uni.new(0xAF0A).NFKC.list ~~ (0xAF0A,), 'AF0A -> AF0A';
ok Uni.new(0xAF0B).NFKC.list ~~ (0xAF0B,), 'AF0B -> AF0B';
ok Uni.new(0xAF0C).NFKC.list ~~ (0xAF0C,), 'AF0C -> AF0C';
ok Uni.new(0xAF0D).NFKC.list ~~ (0xAF0D,), 'AF0D -> AF0D';
ok Uni.new(0xAF0E).NFKC.list ~~ (0xAF0E,), 'AF0E -> AF0E';
ok Uni.new(0xAF0F).NFKC.list ~~ (0xAF0F,), 'AF0F -> AF0F';
ok Uni.new(0xAF10).NFKC.list ~~ (0xAF10,), 'AF10 -> AF10';
ok Uni.new(0xAF11).NFKC.list ~~ (0xAF11,), 'AF11 -> AF11';
ok Uni.new(0xAF12).NFKC.list ~~ (0xAF12,), 'AF12 -> AF12';
ok Uni.new(0xAF13).NFKC.list ~~ (0xAF13,), 'AF13 -> AF13';
ok Uni.new(0xAF14).NFKC.list ~~ (0xAF14,), 'AF14 -> AF14';
ok Uni.new(0xAF15).NFKC.list ~~ (0xAF15,), 'AF15 -> AF15';
ok Uni.new(0xAF16).NFKC.list ~~ (0xAF16,), 'AF16 -> AF16';
ok Uni.new(0xAF17).NFKC.list ~~ (0xAF17,), 'AF17 -> AF17';
ok Uni.new(0xAF18).NFKC.list ~~ (0xAF18,), 'AF18 -> AF18';
ok Uni.new(0xAF19).NFKC.list ~~ (0xAF19,), 'AF19 -> AF19';
ok Uni.new(0xAF1A).NFKC.list ~~ (0xAF1A,), 'AF1A -> AF1A';
ok Uni.new(0xAF1B).NFKC.list ~~ (0xAF1B,), 'AF1B -> AF1B';
ok Uni.new(0xAF1C).NFKC.list ~~ (0xAF1C,), 'AF1C -> AF1C';
ok Uni.new(0xAF1D).NFKC.list ~~ (0xAF1D,), 'AF1D -> AF1D';
ok Uni.new(0xAF1E).NFKC.list ~~ (0xAF1E,), 'AF1E -> AF1E';
ok Uni.new(0xAF1F).NFKC.list ~~ (0xAF1F,), 'AF1F -> AF1F';
ok Uni.new(0xAF20).NFKC.list ~~ (0xAF20,), 'AF20 -> AF20';
ok Uni.new(0xAF21).NFKC.list ~~ (0xAF21,), 'AF21 -> AF21';
ok Uni.new(0xAF22).NFKC.list ~~ (0xAF22,), 'AF22 -> AF22';
ok Uni.new(0xAF23).NFKC.list ~~ (0xAF23,), 'AF23 -> AF23';
ok Uni.new(0xAF24).NFKC.list ~~ (0xAF24,), 'AF24 -> AF24';
ok Uni.new(0xAF25).NFKC.list ~~ (0xAF25,), 'AF25 -> AF25';
ok Uni.new(0xAF26).NFKC.list ~~ (0xAF26,), 'AF26 -> AF26';
ok Uni.new(0xAF27).NFKC.list ~~ (0xAF27,), 'AF27 -> AF27';
ok Uni.new(0xAF28).NFKC.list ~~ (0xAF28,), 'AF28 -> AF28';
ok Uni.new(0xAF29).NFKC.list ~~ (0xAF29,), 'AF29 -> AF29';
ok Uni.new(0xAF2A).NFKC.list ~~ (0xAF2A,), 'AF2A -> AF2A';
ok Uni.new(0xAF2B).NFKC.list ~~ (0xAF2B,), 'AF2B -> AF2B';
ok Uni.new(0xAF2C).NFKC.list ~~ (0xAF2C,), 'AF2C -> AF2C';
ok Uni.new(0xAF2D).NFKC.list ~~ (0xAF2D,), 'AF2D -> AF2D';
ok Uni.new(0xAF2E).NFKC.list ~~ (0xAF2E,), 'AF2E -> AF2E';
ok Uni.new(0xAF2F).NFKC.list ~~ (0xAF2F,), 'AF2F -> AF2F';
ok Uni.new(0xAF30).NFKC.list ~~ (0xAF30,), 'AF30 -> AF30';
ok Uni.new(0xAF31).NFKC.list ~~ (0xAF31,), 'AF31 -> AF31';
ok Uni.new(0xAF32).NFKC.list ~~ (0xAF32,), 'AF32 -> AF32';
ok Uni.new(0xAF33).NFKC.list ~~ (0xAF33,), 'AF33 -> AF33';
ok Uni.new(0xAF34).NFKC.list ~~ (0xAF34,), 'AF34 -> AF34';
ok Uni.new(0xAF35).NFKC.list ~~ (0xAF35,), 'AF35 -> AF35';
ok Uni.new(0xAF36).NFKC.list ~~ (0xAF36,), 'AF36 -> AF36';
ok Uni.new(0xAF37).NFKC.list ~~ (0xAF37,), 'AF37 -> AF37';
ok Uni.new(0xAF38).NFKC.list ~~ (0xAF38,), 'AF38 -> AF38';
ok Uni.new(0xAF39).NFKC.list ~~ (0xAF39,), 'AF39 -> AF39';
ok Uni.new(0xAF3A).NFKC.list ~~ (0xAF3A,), 'AF3A -> AF3A';
ok Uni.new(0xAF3B).NFKC.list ~~ (0xAF3B,), 'AF3B -> AF3B';
ok Uni.new(0xAF3C).NFKC.list ~~ (0xAF3C,), 'AF3C -> AF3C';
ok Uni.new(0xAF3D).NFKC.list ~~ (0xAF3D,), 'AF3D -> AF3D';
ok Uni.new(0xAF3E).NFKC.list ~~ (0xAF3E,), 'AF3E -> AF3E';
ok Uni.new(0xAF3F).NFKC.list ~~ (0xAF3F,), 'AF3F -> AF3F';
ok Uni.new(0xAF40).NFKC.list ~~ (0xAF40,), 'AF40 -> AF40';
ok Uni.new(0xAF41).NFKC.list ~~ (0xAF41,), 'AF41 -> AF41';
ok Uni.new(0xAF42).NFKC.list ~~ (0xAF42,), 'AF42 -> AF42';
ok Uni.new(0xAF43).NFKC.list ~~ (0xAF43,), 'AF43 -> AF43';
ok Uni.new(0xAF44).NFKC.list ~~ (0xAF44,), 'AF44 -> AF44';
ok Uni.new(0xAF45).NFKC.list ~~ (0xAF45,), 'AF45 -> AF45';
ok Uni.new(0xAF46).NFKC.list ~~ (0xAF46,), 'AF46 -> AF46';
ok Uni.new(0xAF47).NFKC.list ~~ (0xAF47,), 'AF47 -> AF47';
ok Uni.new(0xAF48).NFKC.list ~~ (0xAF48,), 'AF48 -> AF48';
ok Uni.new(0xAF49).NFKC.list ~~ (0xAF49,), 'AF49 -> AF49';
ok Uni.new(0xAF4A).NFKC.list ~~ (0xAF4A,), 'AF4A -> AF4A';
ok Uni.new(0xAF4B).NFKC.list ~~ (0xAF4B,), 'AF4B -> AF4B';
ok Uni.new(0xAF4C).NFKC.list ~~ (0xAF4C,), 'AF4C -> AF4C';
ok Uni.new(0xAF4D).NFKC.list ~~ (0xAF4D,), 'AF4D -> AF4D';
ok Uni.new(0xAF4E).NFKC.list ~~ (0xAF4E,), 'AF4E -> AF4E';
ok Uni.new(0xAF4F).NFKC.list ~~ (0xAF4F,), 'AF4F -> AF4F';
ok Uni.new(0xAF50).NFKC.list ~~ (0xAF50,), 'AF50 -> AF50';
ok Uni.new(0xAF51).NFKC.list ~~ (0xAF51,), 'AF51 -> AF51';
ok Uni.new(0xAF52).NFKC.list ~~ (0xAF52,), 'AF52 -> AF52';
ok Uni.new(0xAF53).NFKC.list ~~ (0xAF53,), 'AF53 -> AF53';
ok Uni.new(0xAF54).NFKC.list ~~ (0xAF54,), 'AF54 -> AF54';
ok Uni.new(0xAF55).NFKC.list ~~ (0xAF55,), 'AF55 -> AF55';
ok Uni.new(0xAF56).NFKC.list ~~ (0xAF56,), 'AF56 -> AF56';
ok Uni.new(0xAF57).NFKC.list ~~ (0xAF57,), 'AF57 -> AF57';
ok Uni.new(0xAF58).NFKC.list ~~ (0xAF58,), 'AF58 -> AF58';
ok Uni.new(0xAF59).NFKC.list ~~ (0xAF59,), 'AF59 -> AF59';
ok Uni.new(0xAF5A).NFKC.list ~~ (0xAF5A,), 'AF5A -> AF5A';
ok Uni.new(0xAF5B).NFKC.list ~~ (0xAF5B,), 'AF5B -> AF5B';
ok Uni.new(0xAF5C).NFKC.list ~~ (0xAF5C,), 'AF5C -> AF5C';
ok Uni.new(0xAF5D).NFKC.list ~~ (0xAF5D,), 'AF5D -> AF5D';
ok Uni.new(0xAF5E).NFKC.list ~~ (0xAF5E,), 'AF5E -> AF5E';
ok Uni.new(0xAF5F).NFKC.list ~~ (0xAF5F,), 'AF5F -> AF5F';
ok Uni.new(0xAF60).NFKC.list ~~ (0xAF60,), 'AF60 -> AF60';
ok Uni.new(0xAF61).NFKC.list ~~ (0xAF61,), 'AF61 -> AF61';
ok Uni.new(0xAF62).NFKC.list ~~ (0xAF62,), 'AF62 -> AF62';
ok Uni.new(0xAF63).NFKC.list ~~ (0xAF63,), 'AF63 -> AF63';
ok Uni.new(0xAF64).NFKC.list ~~ (0xAF64,), 'AF64 -> AF64';
ok Uni.new(0xAF65).NFKC.list ~~ (0xAF65,), 'AF65 -> AF65';
ok Uni.new(0xAF66).NFKC.list ~~ (0xAF66,), 'AF66 -> AF66';
ok Uni.new(0xAF67).NFKC.list ~~ (0xAF67,), 'AF67 -> AF67';
ok Uni.new(0xAF68).NFKC.list ~~ (0xAF68,), 'AF68 -> AF68';
ok Uni.new(0xAF69).NFKC.list ~~ (0xAF69,), 'AF69 -> AF69';
ok Uni.new(0xAF6A).NFKC.list ~~ (0xAF6A,), 'AF6A -> AF6A';
ok Uni.new(0xAF6B).NFKC.list ~~ (0xAF6B,), 'AF6B -> AF6B';
ok Uni.new(0xAF6C).NFKC.list ~~ (0xAF6C,), 'AF6C -> AF6C';
ok Uni.new(0xAF6D).NFKC.list ~~ (0xAF6D,), 'AF6D -> AF6D';
ok Uni.new(0xAF6E).NFKC.list ~~ (0xAF6E,), 'AF6E -> AF6E';
ok Uni.new(0xAF6F).NFKC.list ~~ (0xAF6F,), 'AF6F -> AF6F';
ok Uni.new(0xAF70).NFKC.list ~~ (0xAF70,), 'AF70 -> AF70';
ok Uni.new(0xAF71).NFKC.list ~~ (0xAF71,), 'AF71 -> AF71';
ok Uni.new(0xAF72).NFKC.list ~~ (0xAF72,), 'AF72 -> AF72';
ok Uni.new(0xAF73).NFKC.list ~~ (0xAF73,), 'AF73 -> AF73';
ok Uni.new(0xAF74).NFKC.list ~~ (0xAF74,), 'AF74 -> AF74';
ok Uni.new(0xAF75).NFKC.list ~~ (0xAF75,), 'AF75 -> AF75';
ok Uni.new(0xAF76).NFKC.list ~~ (0xAF76,), 'AF76 -> AF76';
ok Uni.new(0xAF77).NFKC.list ~~ (0xAF77,), 'AF77 -> AF77';
ok Uni.new(0xAF78).NFKC.list ~~ (0xAF78,), 'AF78 -> AF78';
ok Uni.new(0xAF79).NFKC.list ~~ (0xAF79,), 'AF79 -> AF79';
ok Uni.new(0xAF7A).NFKC.list ~~ (0xAF7A,), 'AF7A -> AF7A';
ok Uni.new(0xAF7B).NFKC.list ~~ (0xAF7B,), 'AF7B -> AF7B';
ok Uni.new(0xAF7C).NFKC.list ~~ (0xAF7C,), 'AF7C -> AF7C';
ok Uni.new(0xAF7D).NFKC.list ~~ (0xAF7D,), 'AF7D -> AF7D';
ok Uni.new(0xAF7E).NFKC.list ~~ (0xAF7E,), 'AF7E -> AF7E';
ok Uni.new(0xAF7F).NFKC.list ~~ (0xAF7F,), 'AF7F -> AF7F';
ok Uni.new(0xAF80).NFKC.list ~~ (0xAF80,), 'AF80 -> AF80';
ok Uni.new(0xAF81).NFKC.list ~~ (0xAF81,), 'AF81 -> AF81';
ok Uni.new(0xAF82).NFKC.list ~~ (0xAF82,), 'AF82 -> AF82';
ok Uni.new(0xAF83).NFKC.list ~~ (0xAF83,), 'AF83 -> AF83';
ok Uni.new(0xAF84).NFKC.list ~~ (0xAF84,), 'AF84 -> AF84';
ok Uni.new(0xAF85).NFKC.list ~~ (0xAF85,), 'AF85 -> AF85';
ok Uni.new(0xAF86).NFKC.list ~~ (0xAF86,), 'AF86 -> AF86';
ok Uni.new(0xAF87).NFKC.list ~~ (0xAF87,), 'AF87 -> AF87';
ok Uni.new(0xAF88).NFKC.list ~~ (0xAF88,), 'AF88 -> AF88';
ok Uni.new(0xAF89).NFKC.list ~~ (0xAF89,), 'AF89 -> AF89';
ok Uni.new(0xAF8A).NFKC.list ~~ (0xAF8A,), 'AF8A -> AF8A';
ok Uni.new(0xAF8B).NFKC.list ~~ (0xAF8B,), 'AF8B -> AF8B';
ok Uni.new(0xAF8C).NFKC.list ~~ (0xAF8C,), 'AF8C -> AF8C';
ok Uni.new(0xAF8D).NFKC.list ~~ (0xAF8D,), 'AF8D -> AF8D';
ok Uni.new(0xAF8E).NFKC.list ~~ (0xAF8E,), 'AF8E -> AF8E';
ok Uni.new(0xAF8F).NFKC.list ~~ (0xAF8F,), 'AF8F -> AF8F';
ok Uni.new(0xAF90).NFKC.list ~~ (0xAF90,), 'AF90 -> AF90';
ok Uni.new(0xAF91).NFKC.list ~~ (0xAF91,), 'AF91 -> AF91';
ok Uni.new(0xAF92).NFKC.list ~~ (0xAF92,), 'AF92 -> AF92';
ok Uni.new(0xAF93).NFKC.list ~~ (0xAF93,), 'AF93 -> AF93';
ok Uni.new(0xAF94).NFKC.list ~~ (0xAF94,), 'AF94 -> AF94';
ok Uni.new(0xAF95).NFKC.list ~~ (0xAF95,), 'AF95 -> AF95';
ok Uni.new(0xAF96).NFKC.list ~~ (0xAF96,), 'AF96 -> AF96';
ok Uni.new(0xAF97).NFKC.list ~~ (0xAF97,), 'AF97 -> AF97';
ok Uni.new(0xAF98).NFKC.list ~~ (0xAF98,), 'AF98 -> AF98';
ok Uni.new(0xAF99).NFKC.list ~~ (0xAF99,), 'AF99 -> AF99';
ok Uni.new(0xAF9A).NFKC.list ~~ (0xAF9A,), 'AF9A -> AF9A';
ok Uni.new(0xAF9B).NFKC.list ~~ (0xAF9B,), 'AF9B -> AF9B';
ok Uni.new(0xAF9C).NFKC.list ~~ (0xAF9C,), 'AF9C -> AF9C';
ok Uni.new(0xAF9D).NFKC.list ~~ (0xAF9D,), 'AF9D -> AF9D';
ok Uni.new(0xAF9E).NFKC.list ~~ (0xAF9E,), 'AF9E -> AF9E';
ok Uni.new(0xAF9F).NFKC.list ~~ (0xAF9F,), 'AF9F -> AF9F';
ok Uni.new(0xAFA0).NFKC.list ~~ (0xAFA0,), 'AFA0 -> AFA0';
ok Uni.new(0xAFA1).NFKC.list ~~ (0xAFA1,), 'AFA1 -> AFA1';
ok Uni.new(0xAFA2).NFKC.list ~~ (0xAFA2,), 'AFA2 -> AFA2';
ok Uni.new(0xAFA3).NFKC.list ~~ (0xAFA3,), 'AFA3 -> AFA3';
ok Uni.new(0xAFA4).NFKC.list ~~ (0xAFA4,), 'AFA4 -> AFA4';
ok Uni.new(0xAFA5).NFKC.list ~~ (0xAFA5,), 'AFA5 -> AFA5';
ok Uni.new(0xAFA6).NFKC.list ~~ (0xAFA6,), 'AFA6 -> AFA6';
ok Uni.new(0xAFA7).NFKC.list ~~ (0xAFA7,), 'AFA7 -> AFA7';
ok Uni.new(0xAFA8).NFKC.list ~~ (0xAFA8,), 'AFA8 -> AFA8';
ok Uni.new(0xAFA9).NFKC.list ~~ (0xAFA9,), 'AFA9 -> AFA9';
ok Uni.new(0xAFAA).NFKC.list ~~ (0xAFAA,), 'AFAA -> AFAA';
ok Uni.new(0xAFAB).NFKC.list ~~ (0xAFAB,), 'AFAB -> AFAB';
ok Uni.new(0xAFAC).NFKC.list ~~ (0xAFAC,), 'AFAC -> AFAC';
ok Uni.new(0xAFAD).NFKC.list ~~ (0xAFAD,), 'AFAD -> AFAD';
ok Uni.new(0xAFAE).NFKC.list ~~ (0xAFAE,), 'AFAE -> AFAE';
ok Uni.new(0xAFAF).NFKC.list ~~ (0xAFAF,), 'AFAF -> AFAF';
ok Uni.new(0xAFB0).NFKC.list ~~ (0xAFB0,), 'AFB0 -> AFB0';
ok Uni.new(0xAFB1).NFKC.list ~~ (0xAFB1,), 'AFB1 -> AFB1';
ok Uni.new(0xAFB2).NFKC.list ~~ (0xAFB2,), 'AFB2 -> AFB2';
ok Uni.new(0xAFB3).NFKC.list ~~ (0xAFB3,), 'AFB3 -> AFB3';
ok Uni.new(0xAFB4).NFKC.list ~~ (0xAFB4,), 'AFB4 -> AFB4';
ok Uni.new(0xAFB5).NFKC.list ~~ (0xAFB5,), 'AFB5 -> AFB5';
ok Uni.new(0xAFB6).NFKC.list ~~ (0xAFB6,), 'AFB6 -> AFB6';
ok Uni.new(0xAFB7).NFKC.list ~~ (0xAFB7,), 'AFB7 -> AFB7';
ok Uni.new(0xAFB8).NFKC.list ~~ (0xAFB8,), 'AFB8 -> AFB8';
ok Uni.new(0xAFB9).NFKC.list ~~ (0xAFB9,), 'AFB9 -> AFB9';
ok Uni.new(0xAFBA).NFKC.list ~~ (0xAFBA,), 'AFBA -> AFBA';
ok Uni.new(0xAFBB).NFKC.list ~~ (0xAFBB,), 'AFBB -> AFBB';
ok Uni.new(0xAFBC).NFKC.list ~~ (0xAFBC,), 'AFBC -> AFBC';
ok Uni.new(0xAFBD).NFKC.list ~~ (0xAFBD,), 'AFBD -> AFBD';
ok Uni.new(0xAFBE).NFKC.list ~~ (0xAFBE,), 'AFBE -> AFBE';
ok Uni.new(0xAFBF).NFKC.list ~~ (0xAFBF,), 'AFBF -> AFBF';
ok Uni.new(0xAFC0).NFKC.list ~~ (0xAFC0,), 'AFC0 -> AFC0';
ok Uni.new(0xAFC1).NFKC.list ~~ (0xAFC1,), 'AFC1 -> AFC1';
ok Uni.new(0xAFC2).NFKC.list ~~ (0xAFC2,), 'AFC2 -> AFC2';
ok Uni.new(0xAFC3).NFKC.list ~~ (0xAFC3,), 'AFC3 -> AFC3';
ok Uni.new(0xAFC4).NFKC.list ~~ (0xAFC4,), 'AFC4 -> AFC4';
ok Uni.new(0xAFC5).NFKC.list ~~ (0xAFC5,), 'AFC5 -> AFC5';
ok Uni.new(0xAFC6).NFKC.list ~~ (0xAFC6,), 'AFC6 -> AFC6';
ok Uni.new(0xAFC7).NFKC.list ~~ (0xAFC7,), 'AFC7 -> AFC7';
ok Uni.new(0xAFC8).NFKC.list ~~ (0xAFC8,), 'AFC8 -> AFC8';
ok Uni.new(0xAFC9).NFKC.list ~~ (0xAFC9,), 'AFC9 -> AFC9';
ok Uni.new(0xAFCA).NFKC.list ~~ (0xAFCA,), 'AFCA -> AFCA';
ok Uni.new(0xAFCB).NFKC.list ~~ (0xAFCB,), 'AFCB -> AFCB';
ok Uni.new(0xAFCC).NFKC.list ~~ (0xAFCC,), 'AFCC -> AFCC';
ok Uni.new(0xAFCD).NFKC.list ~~ (0xAFCD,), 'AFCD -> AFCD';
ok Uni.new(0xAFCE).NFKC.list ~~ (0xAFCE,), 'AFCE -> AFCE';
ok Uni.new(0xAFCF).NFKC.list ~~ (0xAFCF,), 'AFCF -> AFCF';
ok Uni.new(0xAFD0).NFKC.list ~~ (0xAFD0,), 'AFD0 -> AFD0';
ok Uni.new(0xAFD1).NFKC.list ~~ (0xAFD1,), 'AFD1 -> AFD1';
ok Uni.new(0xAFD2).NFKC.list ~~ (0xAFD2,), 'AFD2 -> AFD2';
ok Uni.new(0xAFD3).NFKC.list ~~ (0xAFD3,), 'AFD3 -> AFD3';
ok Uni.new(0xAFD4).NFKC.list ~~ (0xAFD4,), 'AFD4 -> AFD4';
ok Uni.new(0xAFD5).NFKC.list ~~ (0xAFD5,), 'AFD5 -> AFD5';
ok Uni.new(0xAFD6).NFKC.list ~~ (0xAFD6,), 'AFD6 -> AFD6';
ok Uni.new(0xAFD7).NFKC.list ~~ (0xAFD7,), 'AFD7 -> AFD7';
ok Uni.new(0xAFD8).NFKC.list ~~ (0xAFD8,), 'AFD8 -> AFD8';
ok Uni.new(0xAFD9).NFKC.list ~~ (0xAFD9,), 'AFD9 -> AFD9';
ok Uni.new(0xAFDA).NFKC.list ~~ (0xAFDA,), 'AFDA -> AFDA';
ok Uni.new(0xAFDB).NFKC.list ~~ (0xAFDB,), 'AFDB -> AFDB';
ok Uni.new(0xAFDC).NFKC.list ~~ (0xAFDC,), 'AFDC -> AFDC';
ok Uni.new(0xAFDD).NFKC.list ~~ (0xAFDD,), 'AFDD -> AFDD';
ok Uni.new(0xAFDE).NFKC.list ~~ (0xAFDE,), 'AFDE -> AFDE';
ok Uni.new(0xAFDF).NFKC.list ~~ (0xAFDF,), 'AFDF -> AFDF';
ok Uni.new(0xAFE0).NFKC.list ~~ (0xAFE0,), 'AFE0 -> AFE0';
ok Uni.new(0xAFE1).NFKC.list ~~ (0xAFE1,), 'AFE1 -> AFE1';
ok Uni.new(0xAFE2).NFKC.list ~~ (0xAFE2,), 'AFE2 -> AFE2';
ok Uni.new(0xAFE3).NFKC.list ~~ (0xAFE3,), 'AFE3 -> AFE3';
ok Uni.new(0xAFE4).NFKC.list ~~ (0xAFE4,), 'AFE4 -> AFE4';
ok Uni.new(0xAFE5).NFKC.list ~~ (0xAFE5,), 'AFE5 -> AFE5';
ok Uni.new(0xAFE6).NFKC.list ~~ (0xAFE6,), 'AFE6 -> AFE6';
ok Uni.new(0xAFE7).NFKC.list ~~ (0xAFE7,), 'AFE7 -> AFE7';
ok Uni.new(0xAFE8).NFKC.list ~~ (0xAFE8,), 'AFE8 -> AFE8';
ok Uni.new(0xAFE9).NFKC.list ~~ (0xAFE9,), 'AFE9 -> AFE9';
ok Uni.new(0xAFEA).NFKC.list ~~ (0xAFEA,), 'AFEA -> AFEA';
ok Uni.new(0xAFEB).NFKC.list ~~ (0xAFEB,), 'AFEB -> AFEB';
ok Uni.new(0xAFEC).NFKC.list ~~ (0xAFEC,), 'AFEC -> AFEC';
ok Uni.new(0xAFED).NFKC.list ~~ (0xAFED,), 'AFED -> AFED';
ok Uni.new(0xAFEE).NFKC.list ~~ (0xAFEE,), 'AFEE -> AFEE';
ok Uni.new(0xAFEF).NFKC.list ~~ (0xAFEF,), 'AFEF -> AFEF';
ok Uni.new(0xAFF0).NFKC.list ~~ (0xAFF0,), 'AFF0 -> AFF0';
ok Uni.new(0xAFF1).NFKC.list ~~ (0xAFF1,), 'AFF1 -> AFF1';
ok Uni.new(0xAFF2).NFKC.list ~~ (0xAFF2,), 'AFF2 -> AFF2';
ok Uni.new(0xAFF3).NFKC.list ~~ (0xAFF3,), 'AFF3 -> AFF3';
ok Uni.new(0xAFF4).NFKC.list ~~ (0xAFF4,), 'AFF4 -> AFF4';
ok Uni.new(0xAFF5).NFKC.list ~~ (0xAFF5,), 'AFF5 -> AFF5';
ok Uni.new(0xAFF6).NFKC.list ~~ (0xAFF6,), 'AFF6 -> AFF6';
ok Uni.new(0xAFF7).NFKC.list ~~ (0xAFF7,), 'AFF7 -> AFF7';
ok Uni.new(0xAFF8).NFKC.list ~~ (0xAFF8,), 'AFF8 -> AFF8';
ok Uni.new(0xAFF9).NFKC.list ~~ (0xAFF9,), 'AFF9 -> AFF9';
ok Uni.new(0xAFFA).NFKC.list ~~ (0xAFFA,), 'AFFA -> AFFA';
ok Uni.new(0xAFFB).NFKC.list ~~ (0xAFFB,), 'AFFB -> AFFB';
ok Uni.new(0xAFFC).NFKC.list ~~ (0xAFFC,), 'AFFC -> AFFC';
ok Uni.new(0xAFFD).NFKC.list ~~ (0xAFFD,), 'AFFD -> AFFD';
ok Uni.new(0xAFFE).NFKC.list ~~ (0xAFFE,), 'AFFE -> AFFE';
ok Uni.new(0xAFFF).NFKC.list ~~ (0xAFFF,), 'AFFF -> AFFF';
ok Uni.new(0xB000).NFKC.list ~~ (0xB000,), 'B000 -> B000';
ok Uni.new(0xB001).NFKC.list ~~ (0xB001,), 'B001 -> B001';
ok Uni.new(0xB002).NFKC.list ~~ (0xB002,), 'B002 -> B002';
ok Uni.new(0xB003).NFKC.list ~~ (0xB003,), 'B003 -> B003';
ok Uni.new(0xB004).NFKC.list ~~ (0xB004,), 'B004 -> B004';
ok Uni.new(0xB005).NFKC.list ~~ (0xB005,), 'B005 -> B005';
ok Uni.new(0xB006).NFKC.list ~~ (0xB006,), 'B006 -> B006';
ok Uni.new(0xB007).NFKC.list ~~ (0xB007,), 'B007 -> B007';
ok Uni.new(0xB008).NFKC.list ~~ (0xB008,), 'B008 -> B008';
ok Uni.new(0xB009).NFKC.list ~~ (0xB009,), 'B009 -> B009';
ok Uni.new(0xB00A).NFKC.list ~~ (0xB00A,), 'B00A -> B00A';
ok Uni.new(0xB00B).NFKC.list ~~ (0xB00B,), 'B00B -> B00B';
ok Uni.new(0xB00C).NFKC.list ~~ (0xB00C,), 'B00C -> B00C';
ok Uni.new(0xB00D).NFKC.list ~~ (0xB00D,), 'B00D -> B00D';
ok Uni.new(0xB00E).NFKC.list ~~ (0xB00E,), 'B00E -> B00E';
ok Uni.new(0xB00F).NFKC.list ~~ (0xB00F,), 'B00F -> B00F';
ok Uni.new(0xB010).NFKC.list ~~ (0xB010,), 'B010 -> B010';
ok Uni.new(0xB011).NFKC.list ~~ (0xB011,), 'B011 -> B011';
ok Uni.new(0xB012).NFKC.list ~~ (0xB012,), 'B012 -> B012';
ok Uni.new(0xB013).NFKC.list ~~ (0xB013,), 'B013 -> B013';
ok Uni.new(0xB014).NFKC.list ~~ (0xB014,), 'B014 -> B014';
ok Uni.new(0xB015).NFKC.list ~~ (0xB015,), 'B015 -> B015';
ok Uni.new(0xB016).NFKC.list ~~ (0xB016,), 'B016 -> B016';
ok Uni.new(0xB017).NFKC.list ~~ (0xB017,), 'B017 -> B017';
ok Uni.new(0xB018).NFKC.list ~~ (0xB018,), 'B018 -> B018';
ok Uni.new(0xB019).NFKC.list ~~ (0xB019,), 'B019 -> B019';
ok Uni.new(0xB01A).NFKC.list ~~ (0xB01A,), 'B01A -> B01A';
ok Uni.new(0xB01B).NFKC.list ~~ (0xB01B,), 'B01B -> B01B';
ok Uni.new(0xB01C).NFKC.list ~~ (0xB01C,), 'B01C -> B01C';
ok Uni.new(0xB01D).NFKC.list ~~ (0xB01D,), 'B01D -> B01D';
ok Uni.new(0xB01E).NFKC.list ~~ (0xB01E,), 'B01E -> B01E';
ok Uni.new(0xB01F).NFKC.list ~~ (0xB01F,), 'B01F -> B01F';
ok Uni.new(0xB020).NFKC.list ~~ (0xB020,), 'B020 -> B020';
ok Uni.new(0xB021).NFKC.list ~~ (0xB021,), 'B021 -> B021';
ok Uni.new(0xB022).NFKC.list ~~ (0xB022,), 'B022 -> B022';
ok Uni.new(0xB023).NFKC.list ~~ (0xB023,), 'B023 -> B023';
ok Uni.new(0xB024).NFKC.list ~~ (0xB024,), 'B024 -> B024';
ok Uni.new(0xB025).NFKC.list ~~ (0xB025,), 'B025 -> B025';
ok Uni.new(0xB026).NFKC.list ~~ (0xB026,), 'B026 -> B026';
ok Uni.new(0xB027).NFKC.list ~~ (0xB027,), 'B027 -> B027';
ok Uni.new(0xB028).NFKC.list ~~ (0xB028,), 'B028 -> B028';
ok Uni.new(0xB029).NFKC.list ~~ (0xB029,), 'B029 -> B029';
ok Uni.new(0xB02A).NFKC.list ~~ (0xB02A,), 'B02A -> B02A';
ok Uni.new(0xB02B).NFKC.list ~~ (0xB02B,), 'B02B -> B02B';
ok Uni.new(0xB02C).NFKC.list ~~ (0xB02C,), 'B02C -> B02C';
ok Uni.new(0xB02D).NFKC.list ~~ (0xB02D,), 'B02D -> B02D';
ok Uni.new(0xB02E).NFKC.list ~~ (0xB02E,), 'B02E -> B02E';
ok Uni.new(0xB02F).NFKC.list ~~ (0xB02F,), 'B02F -> B02F';
ok Uni.new(0xB030).NFKC.list ~~ (0xB030,), 'B030 -> B030';
ok Uni.new(0xB031).NFKC.list ~~ (0xB031,), 'B031 -> B031';
ok Uni.new(0xB032).NFKC.list ~~ (0xB032,), 'B032 -> B032';
ok Uni.new(0xB033).NFKC.list ~~ (0xB033,), 'B033 -> B033';
ok Uni.new(0xB034).NFKC.list ~~ (0xB034,), 'B034 -> B034';
ok Uni.new(0xB035).NFKC.list ~~ (0xB035,), 'B035 -> B035';
ok Uni.new(0xB036).NFKC.list ~~ (0xB036,), 'B036 -> B036';
ok Uni.new(0xB037).NFKC.list ~~ (0xB037,), 'B037 -> B037';
ok Uni.new(0xB038).NFKC.list ~~ (0xB038,), 'B038 -> B038';
ok Uni.new(0xB039).NFKC.list ~~ (0xB039,), 'B039 -> B039';
ok Uni.new(0xB03A).NFKC.list ~~ (0xB03A,), 'B03A -> B03A';
ok Uni.new(0xB03B).NFKC.list ~~ (0xB03B,), 'B03B -> B03B';
ok Uni.new(0xB03C).NFKC.list ~~ (0xB03C,), 'B03C -> B03C';
ok Uni.new(0xB03D).NFKC.list ~~ (0xB03D,), 'B03D -> B03D';
ok Uni.new(0xB03E).NFKC.list ~~ (0xB03E,), 'B03E -> B03E';
ok Uni.new(0xB03F).NFKC.list ~~ (0xB03F,), 'B03F -> B03F';
ok Uni.new(0xB040).NFKC.list ~~ (0xB040,), 'B040 -> B040';
ok Uni.new(0xB041).NFKC.list ~~ (0xB041,), 'B041 -> B041';
ok Uni.new(0xB042).NFKC.list ~~ (0xB042,), 'B042 -> B042';
ok Uni.new(0xB043).NFKC.list ~~ (0xB043,), 'B043 -> B043';
ok Uni.new(0xB044).NFKC.list ~~ (0xB044,), 'B044 -> B044';
ok Uni.new(0xB045).NFKC.list ~~ (0xB045,), 'B045 -> B045';
ok Uni.new(0xB046).NFKC.list ~~ (0xB046,), 'B046 -> B046';
ok Uni.new(0xB047).NFKC.list ~~ (0xB047,), 'B047 -> B047';
ok Uni.new(0xB048).NFKC.list ~~ (0xB048,), 'B048 -> B048';
ok Uni.new(0xB049).NFKC.list ~~ (0xB049,), 'B049 -> B049';
ok Uni.new(0xB04A).NFKC.list ~~ (0xB04A,), 'B04A -> B04A';
ok Uni.new(0xB04B).NFKC.list ~~ (0xB04B,), 'B04B -> B04B';
ok Uni.new(0xB04C).NFKC.list ~~ (0xB04C,), 'B04C -> B04C';
ok Uni.new(0xB04D).NFKC.list ~~ (0xB04D,), 'B04D -> B04D';
ok Uni.new(0xB04E).NFKC.list ~~ (0xB04E,), 'B04E -> B04E';
ok Uni.new(0xB04F).NFKC.list ~~ (0xB04F,), 'B04F -> B04F';
ok Uni.new(0xB050).NFKC.list ~~ (0xB050,), 'B050 -> B050';
ok Uni.new(0xB051).NFKC.list ~~ (0xB051,), 'B051 -> B051';
ok Uni.new(0xB052).NFKC.list ~~ (0xB052,), 'B052 -> B052';
ok Uni.new(0xB053).NFKC.list ~~ (0xB053,), 'B053 -> B053';
ok Uni.new(0xB054).NFKC.list ~~ (0xB054,), 'B054 -> B054';
ok Uni.new(0xB055).NFKC.list ~~ (0xB055,), 'B055 -> B055';
ok Uni.new(0xB056).NFKC.list ~~ (0xB056,), 'B056 -> B056';
ok Uni.new(0xB057).NFKC.list ~~ (0xB057,), 'B057 -> B057';
ok Uni.new(0xB058).NFKC.list ~~ (0xB058,), 'B058 -> B058';
ok Uni.new(0xB059).NFKC.list ~~ (0xB059,), 'B059 -> B059';
ok Uni.new(0xB05A).NFKC.list ~~ (0xB05A,), 'B05A -> B05A';
ok Uni.new(0xB05B).NFKC.list ~~ (0xB05B,), 'B05B -> B05B';
ok Uni.new(0xB05C).NFKC.list ~~ (0xB05C,), 'B05C -> B05C';
ok Uni.new(0xB05D).NFKC.list ~~ (0xB05D,), 'B05D -> B05D';
ok Uni.new(0xB05E).NFKC.list ~~ (0xB05E,), 'B05E -> B05E';
ok Uni.new(0xB05F).NFKC.list ~~ (0xB05F,), 'B05F -> B05F';
ok Uni.new(0xB060).NFKC.list ~~ (0xB060,), 'B060 -> B060';
ok Uni.new(0xB061).NFKC.list ~~ (0xB061,), 'B061 -> B061';
ok Uni.new(0xB062).NFKC.list ~~ (0xB062,), 'B062 -> B062';
ok Uni.new(0xB063).NFKC.list ~~ (0xB063,), 'B063 -> B063';
ok Uni.new(0xB064).NFKC.list ~~ (0xB064,), 'B064 -> B064';
ok Uni.new(0xB065).NFKC.list ~~ (0xB065,), 'B065 -> B065';
ok Uni.new(0xB066).NFKC.list ~~ (0xB066,), 'B066 -> B066';
ok Uni.new(0xB067).NFKC.list ~~ (0xB067,), 'B067 -> B067';
ok Uni.new(0xB068).NFKC.list ~~ (0xB068,), 'B068 -> B068';
ok Uni.new(0xB069).NFKC.list ~~ (0xB069,), 'B069 -> B069';
ok Uni.new(0xB06A).NFKC.list ~~ (0xB06A,), 'B06A -> B06A';
ok Uni.new(0xB06B).NFKC.list ~~ (0xB06B,), 'B06B -> B06B';
ok Uni.new(0xB06C).NFKC.list ~~ (0xB06C,), 'B06C -> B06C';
ok Uni.new(0xB06D).NFKC.list ~~ (0xB06D,), 'B06D -> B06D';
ok Uni.new(0xB06E).NFKC.list ~~ (0xB06E,), 'B06E -> B06E';
ok Uni.new(0xB06F).NFKC.list ~~ (0xB06F,), 'B06F -> B06F';
ok Uni.new(0xB070).NFKC.list ~~ (0xB070,), 'B070 -> B070';
ok Uni.new(0xB071).NFKC.list ~~ (0xB071,), 'B071 -> B071';
ok Uni.new(0xB072).NFKC.list ~~ (0xB072,), 'B072 -> B072';
ok Uni.new(0xB073).NFKC.list ~~ (0xB073,), 'B073 -> B073';
ok Uni.new(0xB074).NFKC.list ~~ (0xB074,), 'B074 -> B074';
ok Uni.new(0xB075).NFKC.list ~~ (0xB075,), 'B075 -> B075';
ok Uni.new(0xB076).NFKC.list ~~ (0xB076,), 'B076 -> B076';
ok Uni.new(0xB077).NFKC.list ~~ (0xB077,), 'B077 -> B077';
ok Uni.new(0xB078).NFKC.list ~~ (0xB078,), 'B078 -> B078';
ok Uni.new(0xB079).NFKC.list ~~ (0xB079,), 'B079 -> B079';
ok Uni.new(0xB07A).NFKC.list ~~ (0xB07A,), 'B07A -> B07A';
ok Uni.new(0xB07B).NFKC.list ~~ (0xB07B,), 'B07B -> B07B';
ok Uni.new(0xB07C).NFKC.list ~~ (0xB07C,), 'B07C -> B07C';
ok Uni.new(0xB07D).NFKC.list ~~ (0xB07D,), 'B07D -> B07D';
ok Uni.new(0xB07E).NFKC.list ~~ (0xB07E,), 'B07E -> B07E';
ok Uni.new(0xB07F).NFKC.list ~~ (0xB07F,), 'B07F -> B07F';
ok Uni.new(0xB080).NFKC.list ~~ (0xB080,), 'B080 -> B080';
ok Uni.new(0xB081).NFKC.list ~~ (0xB081,), 'B081 -> B081';
ok Uni.new(0xB082).NFKC.list ~~ (0xB082,), 'B082 -> B082';
ok Uni.new(0xB083).NFKC.list ~~ (0xB083,), 'B083 -> B083';
ok Uni.new(0xB084).NFKC.list ~~ (0xB084,), 'B084 -> B084';
ok Uni.new(0xB085).NFKC.list ~~ (0xB085,), 'B085 -> B085';
ok Uni.new(0xB086).NFKC.list ~~ (0xB086,), 'B086 -> B086';
ok Uni.new(0xB087).NFKC.list ~~ (0xB087,), 'B087 -> B087';
ok Uni.new(0xB088).NFKC.list ~~ (0xB088,), 'B088 -> B088';
ok Uni.new(0xB089).NFKC.list ~~ (0xB089,), 'B089 -> B089';
ok Uni.new(0xB08A).NFKC.list ~~ (0xB08A,), 'B08A -> B08A';
ok Uni.new(0xB08B).NFKC.list ~~ (0xB08B,), 'B08B -> B08B';
ok Uni.new(0xB08C).NFKC.list ~~ (0xB08C,), 'B08C -> B08C';
ok Uni.new(0xB08D).NFKC.list ~~ (0xB08D,), 'B08D -> B08D';
ok Uni.new(0xB08E).NFKC.list ~~ (0xB08E,), 'B08E -> B08E';
ok Uni.new(0xB08F).NFKC.list ~~ (0xB08F,), 'B08F -> B08F';
ok Uni.new(0xB090).NFKC.list ~~ (0xB090,), 'B090 -> B090';
ok Uni.new(0xB091).NFKC.list ~~ (0xB091,), 'B091 -> B091';
ok Uni.new(0xB092).NFKC.list ~~ (0xB092,), 'B092 -> B092';
ok Uni.new(0xB093).NFKC.list ~~ (0xB093,), 'B093 -> B093';
ok Uni.new(0xB094).NFKC.list ~~ (0xB094,), 'B094 -> B094';
ok Uni.new(0xB095).NFKC.list ~~ (0xB095,), 'B095 -> B095';
ok Uni.new(0xB096).NFKC.list ~~ (0xB096,), 'B096 -> B096';
ok Uni.new(0xB097).NFKC.list ~~ (0xB097,), 'B097 -> B097';
ok Uni.new(0xB098).NFKC.list ~~ (0xB098,), 'B098 -> B098';
ok Uni.new(0xB099).NFKC.list ~~ (0xB099,), 'B099 -> B099';
ok Uni.new(0xB09A).NFKC.list ~~ (0xB09A,), 'B09A -> B09A';
ok Uni.new(0xB09B).NFKC.list ~~ (0xB09B,), 'B09B -> B09B';
ok Uni.new(0xB09C).NFKC.list ~~ (0xB09C,), 'B09C -> B09C';
ok Uni.new(0xB09D).NFKC.list ~~ (0xB09D,), 'B09D -> B09D';
ok Uni.new(0xB09E).NFKC.list ~~ (0xB09E,), 'B09E -> B09E';
ok Uni.new(0xB09F).NFKC.list ~~ (0xB09F,), 'B09F -> B09F';
ok Uni.new(0xB0A0).NFKC.list ~~ (0xB0A0,), 'B0A0 -> B0A0';
ok Uni.new(0xB0A1).NFKC.list ~~ (0xB0A1,), 'B0A1 -> B0A1';
ok Uni.new(0xB0A2).NFKC.list ~~ (0xB0A2,), 'B0A2 -> B0A2';
ok Uni.new(0xB0A3).NFKC.list ~~ (0xB0A3,), 'B0A3 -> B0A3';
ok Uni.new(0xB0A4).NFKC.list ~~ (0xB0A4,), 'B0A4 -> B0A4';
ok Uni.new(0xB0A5).NFKC.list ~~ (0xB0A5,), 'B0A5 -> B0A5';
ok Uni.new(0xB0A6).NFKC.list ~~ (0xB0A6,), 'B0A6 -> B0A6';
ok Uni.new(0xB0A7).NFKC.list ~~ (0xB0A7,), 'B0A7 -> B0A7';
ok Uni.new(0xB0A8).NFKC.list ~~ (0xB0A8,), 'B0A8 -> B0A8';
ok Uni.new(0xB0A9).NFKC.list ~~ (0xB0A9,), 'B0A9 -> B0A9';
ok Uni.new(0xB0AA).NFKC.list ~~ (0xB0AA,), 'B0AA -> B0AA';
ok Uni.new(0xB0AB).NFKC.list ~~ (0xB0AB,), 'B0AB -> B0AB';
ok Uni.new(0xB0AC).NFKC.list ~~ (0xB0AC,), 'B0AC -> B0AC';
ok Uni.new(0xB0AD).NFKC.list ~~ (0xB0AD,), 'B0AD -> B0AD';
ok Uni.new(0xB0AE).NFKC.list ~~ (0xB0AE,), 'B0AE -> B0AE';
ok Uni.new(0xB0AF).NFKC.list ~~ (0xB0AF,), 'B0AF -> B0AF';
ok Uni.new(0xB0B0).NFKC.list ~~ (0xB0B0,), 'B0B0 -> B0B0';
ok Uni.new(0xB0B1).NFKC.list ~~ (0xB0B1,), 'B0B1 -> B0B1';
ok Uni.new(0xB0B2).NFKC.list ~~ (0xB0B2,), 'B0B2 -> B0B2';
ok Uni.new(0xB0B3).NFKC.list ~~ (0xB0B3,), 'B0B3 -> B0B3';
ok Uni.new(0xB0B4).NFKC.list ~~ (0xB0B4,), 'B0B4 -> B0B4';
ok Uni.new(0xB0B5).NFKC.list ~~ (0xB0B5,), 'B0B5 -> B0B5';
ok Uni.new(0xB0B6).NFKC.list ~~ (0xB0B6,), 'B0B6 -> B0B6';
ok Uni.new(0xB0B7).NFKC.list ~~ (0xB0B7,), 'B0B7 -> B0B7';
ok Uni.new(0xB0B8).NFKC.list ~~ (0xB0B8,), 'B0B8 -> B0B8';
ok Uni.new(0xB0B9).NFKC.list ~~ (0xB0B9,), 'B0B9 -> B0B9';
ok Uni.new(0xB0BA).NFKC.list ~~ (0xB0BA,), 'B0BA -> B0BA';
ok Uni.new(0xB0BB).NFKC.list ~~ (0xB0BB,), 'B0BB -> B0BB';
ok Uni.new(0xB0BC).NFKC.list ~~ (0xB0BC,), 'B0BC -> B0BC';
ok Uni.new(0xB0BD).NFKC.list ~~ (0xB0BD,), 'B0BD -> B0BD';
ok Uni.new(0xB0BE).NFKC.list ~~ (0xB0BE,), 'B0BE -> B0BE';
ok Uni.new(0xB0BF).NFKC.list ~~ (0xB0BF,), 'B0BF -> B0BF';
ok Uni.new(0xB0C0).NFKC.list ~~ (0xB0C0,), 'B0C0 -> B0C0';
ok Uni.new(0xB0C1).NFKC.list ~~ (0xB0C1,), 'B0C1 -> B0C1';
ok Uni.new(0xB0C2).NFKC.list ~~ (0xB0C2,), 'B0C2 -> B0C2';
ok Uni.new(0xB0C3).NFKC.list ~~ (0xB0C3,), 'B0C3 -> B0C3';
ok Uni.new(0xB0C4).NFKC.list ~~ (0xB0C4,), 'B0C4 -> B0C4';
ok Uni.new(0xB0C5).NFKC.list ~~ (0xB0C5,), 'B0C5 -> B0C5';
ok Uni.new(0xB0C6).NFKC.list ~~ (0xB0C6,), 'B0C6 -> B0C6';
ok Uni.new(0xB0C7).NFKC.list ~~ (0xB0C7,), 'B0C7 -> B0C7';
ok Uni.new(0xB0C8).NFKC.list ~~ (0xB0C8,), 'B0C8 -> B0C8';
ok Uni.new(0xB0C9).NFKC.list ~~ (0xB0C9,), 'B0C9 -> B0C9';
ok Uni.new(0xB0CA).NFKC.list ~~ (0xB0CA,), 'B0CA -> B0CA';
ok Uni.new(0xB0CB).NFKC.list ~~ (0xB0CB,), 'B0CB -> B0CB';
ok Uni.new(0xB0CC).NFKC.list ~~ (0xB0CC,), 'B0CC -> B0CC';
ok Uni.new(0xB0CD).NFKC.list ~~ (0xB0CD,), 'B0CD -> B0CD';
ok Uni.new(0xB0CE).NFKC.list ~~ (0xB0CE,), 'B0CE -> B0CE';
ok Uni.new(0xB0CF).NFKC.list ~~ (0xB0CF,), 'B0CF -> B0CF';
ok Uni.new(0xB0D0).NFKC.list ~~ (0xB0D0,), 'B0D0 -> B0D0';
ok Uni.new(0xB0D1).NFKC.list ~~ (0xB0D1,), 'B0D1 -> B0D1';
ok Uni.new(0xB0D2).NFKC.list ~~ (0xB0D2,), 'B0D2 -> B0D2';
ok Uni.new(0xB0D3).NFKC.list ~~ (0xB0D3,), 'B0D3 -> B0D3';
ok Uni.new(0xB0D4).NFKC.list ~~ (0xB0D4,), 'B0D4 -> B0D4';
ok Uni.new(0xB0D5).NFKC.list ~~ (0xB0D5,), 'B0D5 -> B0D5';
ok Uni.new(0xB0D6).NFKC.list ~~ (0xB0D6,), 'B0D6 -> B0D6';
ok Uni.new(0xB0D7).NFKC.list ~~ (0xB0D7,), 'B0D7 -> B0D7';
ok Uni.new(0xB0D8).NFKC.list ~~ (0xB0D8,), 'B0D8 -> B0D8';
ok Uni.new(0xB0D9).NFKC.list ~~ (0xB0D9,), 'B0D9 -> B0D9';
ok Uni.new(0xB0DA).NFKC.list ~~ (0xB0DA,), 'B0DA -> B0DA';
ok Uni.new(0xB0DB).NFKC.list ~~ (0xB0DB,), 'B0DB -> B0DB';
ok Uni.new(0xB0DC).NFKC.list ~~ (0xB0DC,), 'B0DC -> B0DC';
ok Uni.new(0xB0DD).NFKC.list ~~ (0xB0DD,), 'B0DD -> B0DD';
ok Uni.new(0xB0DE).NFKC.list ~~ (0xB0DE,), 'B0DE -> B0DE';
ok Uni.new(0xB0DF).NFKC.list ~~ (0xB0DF,), 'B0DF -> B0DF';
ok Uni.new(0xB0E0).NFKC.list ~~ (0xB0E0,), 'B0E0 -> B0E0';
ok Uni.new(0xB0E1).NFKC.list ~~ (0xB0E1,), 'B0E1 -> B0E1';
ok Uni.new(0xB0E2).NFKC.list ~~ (0xB0E2,), 'B0E2 -> B0E2';
ok Uni.new(0xB0E3).NFKC.list ~~ (0xB0E3,), 'B0E3 -> B0E3';
ok Uni.new(0xB0E4).NFKC.list ~~ (0xB0E4,), 'B0E4 -> B0E4';
ok Uni.new(0xB0E5).NFKC.list ~~ (0xB0E5,), 'B0E5 -> B0E5';
ok Uni.new(0xB0E6).NFKC.list ~~ (0xB0E6,), 'B0E6 -> B0E6';
ok Uni.new(0xB0E7).NFKC.list ~~ (0xB0E7,), 'B0E7 -> B0E7';
ok Uni.new(0xB0E8).NFKC.list ~~ (0xB0E8,), 'B0E8 -> B0E8';
ok Uni.new(0xB0E9).NFKC.list ~~ (0xB0E9,), 'B0E9 -> B0E9';
ok Uni.new(0xB0EA).NFKC.list ~~ (0xB0EA,), 'B0EA -> B0EA';
ok Uni.new(0xB0EB).NFKC.list ~~ (0xB0EB,), 'B0EB -> B0EB';
ok Uni.new(0xB0EC).NFKC.list ~~ (0xB0EC,), 'B0EC -> B0EC';
ok Uni.new(0xB0ED).NFKC.list ~~ (0xB0ED,), 'B0ED -> B0ED';
ok Uni.new(0xB0EE).NFKC.list ~~ (0xB0EE,), 'B0EE -> B0EE';
ok Uni.new(0xB0EF).NFKC.list ~~ (0xB0EF,), 'B0EF -> B0EF';
ok Uni.new(0xB0F0).NFKC.list ~~ (0xB0F0,), 'B0F0 -> B0F0';
ok Uni.new(0xB0F1).NFKC.list ~~ (0xB0F1,), 'B0F1 -> B0F1';
ok Uni.new(0xB0F2).NFKC.list ~~ (0xB0F2,), 'B0F2 -> B0F2';
ok Uni.new(0xB0F3).NFKC.list ~~ (0xB0F3,), 'B0F3 -> B0F3';
ok Uni.new(0xB0F4).NFKC.list ~~ (0xB0F4,), 'B0F4 -> B0F4';
ok Uni.new(0xB0F5).NFKC.list ~~ (0xB0F5,), 'B0F5 -> B0F5';
ok Uni.new(0xB0F6).NFKC.list ~~ (0xB0F6,), 'B0F6 -> B0F6';
ok Uni.new(0xB0F7).NFKC.list ~~ (0xB0F7,), 'B0F7 -> B0F7';
ok Uni.new(0xB0F8).NFKC.list ~~ (0xB0F8,), 'B0F8 -> B0F8';
ok Uni.new(0xB0F9).NFKC.list ~~ (0xB0F9,), 'B0F9 -> B0F9';
ok Uni.new(0xB0FA).NFKC.list ~~ (0xB0FA,), 'B0FA -> B0FA';
ok Uni.new(0xB0FB).NFKC.list ~~ (0xB0FB,), 'B0FB -> B0FB';
ok Uni.new(0xB0FC).NFKC.list ~~ (0xB0FC,), 'B0FC -> B0FC';
ok Uni.new(0xB0FD).NFKC.list ~~ (0xB0FD,), 'B0FD -> B0FD';
ok Uni.new(0xB0FE).NFKC.list ~~ (0xB0FE,), 'B0FE -> B0FE';
ok Uni.new(0xB0FF).NFKC.list ~~ (0xB0FF,), 'B0FF -> B0FF';
ok Uni.new(0xB100).NFKC.list ~~ (0xB100,), 'B100 -> B100';
ok Uni.new(0xB101).NFKC.list ~~ (0xB101,), 'B101 -> B101';
ok Uni.new(0xB102).NFKC.list ~~ (0xB102,), 'B102 -> B102';
ok Uni.new(0xB103).NFKC.list ~~ (0xB103,), 'B103 -> B103';
ok Uni.new(0xB104).NFKC.list ~~ (0xB104,), 'B104 -> B104';
ok Uni.new(0xB105).NFKC.list ~~ (0xB105,), 'B105 -> B105';
ok Uni.new(0xB106).NFKC.list ~~ (0xB106,), 'B106 -> B106';
ok Uni.new(0xB107).NFKC.list ~~ (0xB107,), 'B107 -> B107';
ok Uni.new(0xB108).NFKC.list ~~ (0xB108,), 'B108 -> B108';
ok Uni.new(0xB109).NFKC.list ~~ (0xB109,), 'B109 -> B109';
ok Uni.new(0xB10A).NFKC.list ~~ (0xB10A,), 'B10A -> B10A';
ok Uni.new(0xB10B).NFKC.list ~~ (0xB10B,), 'B10B -> B10B';
ok Uni.new(0xB10C).NFKC.list ~~ (0xB10C,), 'B10C -> B10C';
ok Uni.new(0xB10D).NFKC.list ~~ (0xB10D,), 'B10D -> B10D';
ok Uni.new(0xB10E).NFKC.list ~~ (0xB10E,), 'B10E -> B10E';
ok Uni.new(0xB10F).NFKC.list ~~ (0xB10F,), 'B10F -> B10F';
ok Uni.new(0xB110).NFKC.list ~~ (0xB110,), 'B110 -> B110';
ok Uni.new(0xB111).NFKC.list ~~ (0xB111,), 'B111 -> B111';
ok Uni.new(0xB112).NFKC.list ~~ (0xB112,), 'B112 -> B112';
ok Uni.new(0xB113).NFKC.list ~~ (0xB113,), 'B113 -> B113';
ok Uni.new(0xB114).NFKC.list ~~ (0xB114,), 'B114 -> B114';
ok Uni.new(0xB115).NFKC.list ~~ (0xB115,), 'B115 -> B115';
ok Uni.new(0xB116).NFKC.list ~~ (0xB116,), 'B116 -> B116';
ok Uni.new(0xB117).NFKC.list ~~ (0xB117,), 'B117 -> B117';
ok Uni.new(0xB118).NFKC.list ~~ (0xB118,), 'B118 -> B118';
ok Uni.new(0xB119).NFKC.list ~~ (0xB119,), 'B119 -> B119';
ok Uni.new(0xB11A).NFKC.list ~~ (0xB11A,), 'B11A -> B11A';
ok Uni.new(0xB11B).NFKC.list ~~ (0xB11B,), 'B11B -> B11B';
ok Uni.new(0xB11C).NFKC.list ~~ (0xB11C,), 'B11C -> B11C';
ok Uni.new(0xB11D).NFKC.list ~~ (0xB11D,), 'B11D -> B11D';
ok Uni.new(0xB11E).NFKC.list ~~ (0xB11E,), 'B11E -> B11E';
ok Uni.new(0xB11F).NFKC.list ~~ (0xB11F,), 'B11F -> B11F';
ok Uni.new(0xB120).NFKC.list ~~ (0xB120,), 'B120 -> B120';
ok Uni.new(0xB121).NFKC.list ~~ (0xB121,), 'B121 -> B121';
ok Uni.new(0xB122).NFKC.list ~~ (0xB122,), 'B122 -> B122';
ok Uni.new(0xB123).NFKC.list ~~ (0xB123,), 'B123 -> B123';
ok Uni.new(0xB124).NFKC.list ~~ (0xB124,), 'B124 -> B124';
ok Uni.new(0xB125).NFKC.list ~~ (0xB125,), 'B125 -> B125';
ok Uni.new(0xB126).NFKC.list ~~ (0xB126,), 'B126 -> B126';
ok Uni.new(0xB127).NFKC.list ~~ (0xB127,), 'B127 -> B127';
ok Uni.new(0xB128).NFKC.list ~~ (0xB128,), 'B128 -> B128';
ok Uni.new(0xB129).NFKC.list ~~ (0xB129,), 'B129 -> B129';
ok Uni.new(0xB12A).NFKC.list ~~ (0xB12A,), 'B12A -> B12A';
ok Uni.new(0xB12B).NFKC.list ~~ (0xB12B,), 'B12B -> B12B';
ok Uni.new(0xB12C).NFKC.list ~~ (0xB12C,), 'B12C -> B12C';
ok Uni.new(0xB12D).NFKC.list ~~ (0xB12D,), 'B12D -> B12D';
ok Uni.new(0xB12E).NFKC.list ~~ (0xB12E,), 'B12E -> B12E';
ok Uni.new(0xB12F).NFKC.list ~~ (0xB12F,), 'B12F -> B12F';
ok Uni.new(0xB130).NFKC.list ~~ (0xB130,), 'B130 -> B130';
ok Uni.new(0xB131).NFKC.list ~~ (0xB131,), 'B131 -> B131';
ok Uni.new(0xB132).NFKC.list ~~ (0xB132,), 'B132 -> B132';
ok Uni.new(0xB133).NFKC.list ~~ (0xB133,), 'B133 -> B133';
ok Uni.new(0xB134).NFKC.list ~~ (0xB134,), 'B134 -> B134';
ok Uni.new(0xB135).NFKC.list ~~ (0xB135,), 'B135 -> B135';
ok Uni.new(0xB136).NFKC.list ~~ (0xB136,), 'B136 -> B136';
ok Uni.new(0xB137).NFKC.list ~~ (0xB137,), 'B137 -> B137';
ok Uni.new(0xB138).NFKC.list ~~ (0xB138,), 'B138 -> B138';
ok Uni.new(0xB139).NFKC.list ~~ (0xB139,), 'B139 -> B139';
ok Uni.new(0xB13A).NFKC.list ~~ (0xB13A,), 'B13A -> B13A';
ok Uni.new(0xB13B).NFKC.list ~~ (0xB13B,), 'B13B -> B13B';
ok Uni.new(0xB13C).NFKC.list ~~ (0xB13C,), 'B13C -> B13C';
ok Uni.new(0xB13D).NFKC.list ~~ (0xB13D,), 'B13D -> B13D';
ok Uni.new(0xB13E).NFKC.list ~~ (0xB13E,), 'B13E -> B13E';
ok Uni.new(0xB13F).NFKC.list ~~ (0xB13F,), 'B13F -> B13F';
ok Uni.new(0xB140).NFKC.list ~~ (0xB140,), 'B140 -> B140';
ok Uni.new(0xB141).NFKC.list ~~ (0xB141,), 'B141 -> B141';
ok Uni.new(0xB142).NFKC.list ~~ (0xB142,), 'B142 -> B142';
ok Uni.new(0xB143).NFKC.list ~~ (0xB143,), 'B143 -> B143';
ok Uni.new(0xB144).NFKC.list ~~ (0xB144,), 'B144 -> B144';
ok Uni.new(0xB145).NFKC.list ~~ (0xB145,), 'B145 -> B145';
ok Uni.new(0xB146).NFKC.list ~~ (0xB146,), 'B146 -> B146';
ok Uni.new(0xB147).NFKC.list ~~ (0xB147,), 'B147 -> B147';
ok Uni.new(0xB148).NFKC.list ~~ (0xB148,), 'B148 -> B148';
ok Uni.new(0xB149).NFKC.list ~~ (0xB149,), 'B149 -> B149';
ok Uni.new(0xB14A).NFKC.list ~~ (0xB14A,), 'B14A -> B14A';
ok Uni.new(0xB14B).NFKC.list ~~ (0xB14B,), 'B14B -> B14B';
ok Uni.new(0xB14C).NFKC.list ~~ (0xB14C,), 'B14C -> B14C';
ok Uni.new(0xB14D).NFKC.list ~~ (0xB14D,), 'B14D -> B14D';
ok Uni.new(0xB14E).NFKC.list ~~ (0xB14E,), 'B14E -> B14E';
ok Uni.new(0xB14F).NFKC.list ~~ (0xB14F,), 'B14F -> B14F';
ok Uni.new(0xB150).NFKC.list ~~ (0xB150,), 'B150 -> B150';
ok Uni.new(0xB151).NFKC.list ~~ (0xB151,), 'B151 -> B151';
ok Uni.new(0xB152).NFKC.list ~~ (0xB152,), 'B152 -> B152';
ok Uni.new(0xB153).NFKC.list ~~ (0xB153,), 'B153 -> B153';
ok Uni.new(0xB154).NFKC.list ~~ (0xB154,), 'B154 -> B154';
ok Uni.new(0xB155).NFKC.list ~~ (0xB155,), 'B155 -> B155';
ok Uni.new(0xB156).NFKC.list ~~ (0xB156,), 'B156 -> B156';
ok Uni.new(0xB157).NFKC.list ~~ (0xB157,), 'B157 -> B157';
ok Uni.new(0xB158).NFKC.list ~~ (0xB158,), 'B158 -> B158';
ok Uni.new(0xB159).NFKC.list ~~ (0xB159,), 'B159 -> B159';
ok Uni.new(0xB15A).NFKC.list ~~ (0xB15A,), 'B15A -> B15A';
ok Uni.new(0xB15B).NFKC.list ~~ (0xB15B,), 'B15B -> B15B';
ok Uni.new(0xB15C).NFKC.list ~~ (0xB15C,), 'B15C -> B15C';
ok Uni.new(0xB15D).NFKC.list ~~ (0xB15D,), 'B15D -> B15D';
ok Uni.new(0xB15E).NFKC.list ~~ (0xB15E,), 'B15E -> B15E';
ok Uni.new(0xB15F).NFKC.list ~~ (0xB15F,), 'B15F -> B15F';
ok Uni.new(0xB160).NFKC.list ~~ (0xB160,), 'B160 -> B160';
ok Uni.new(0xB161).NFKC.list ~~ (0xB161,), 'B161 -> B161';
ok Uni.new(0xB162).NFKC.list ~~ (0xB162,), 'B162 -> B162';
ok Uni.new(0xB163).NFKC.list ~~ (0xB163,), 'B163 -> B163';
ok Uni.new(0xB164).NFKC.list ~~ (0xB164,), 'B164 -> B164';
ok Uni.new(0xB165).NFKC.list ~~ (0xB165,), 'B165 -> B165';
ok Uni.new(0xB166).NFKC.list ~~ (0xB166,), 'B166 -> B166';
ok Uni.new(0xB167).NFKC.list ~~ (0xB167,), 'B167 -> B167';
ok Uni.new(0xB168).NFKC.list ~~ (0xB168,), 'B168 -> B168';
ok Uni.new(0xB169).NFKC.list ~~ (0xB169,), 'B169 -> B169';
ok Uni.new(0xB16A).NFKC.list ~~ (0xB16A,), 'B16A -> B16A';
ok Uni.new(0xB16B).NFKC.list ~~ (0xB16B,), 'B16B -> B16B';
ok Uni.new(0xB16C).NFKC.list ~~ (0xB16C,), 'B16C -> B16C';
ok Uni.new(0xB16D).NFKC.list ~~ (0xB16D,), 'B16D -> B16D';
ok Uni.new(0xB16E).NFKC.list ~~ (0xB16E,), 'B16E -> B16E';
ok Uni.new(0xB16F).NFKC.list ~~ (0xB16F,), 'B16F -> B16F';
ok Uni.new(0xB170).NFKC.list ~~ (0xB170,), 'B170 -> B170';
ok Uni.new(0xB171).NFKC.list ~~ (0xB171,), 'B171 -> B171';
ok Uni.new(0xB172).NFKC.list ~~ (0xB172,), 'B172 -> B172';
ok Uni.new(0xB173).NFKC.list ~~ (0xB173,), 'B173 -> B173';
ok Uni.new(0xB174).NFKC.list ~~ (0xB174,), 'B174 -> B174';
ok Uni.new(0xB175).NFKC.list ~~ (0xB175,), 'B175 -> B175';
ok Uni.new(0xB176).NFKC.list ~~ (0xB176,), 'B176 -> B176';
ok Uni.new(0xB177).NFKC.list ~~ (0xB177,), 'B177 -> B177';
ok Uni.new(0xB178).NFKC.list ~~ (0xB178,), 'B178 -> B178';
ok Uni.new(0xB179).NFKC.list ~~ (0xB179,), 'B179 -> B179';
ok Uni.new(0xB17A).NFKC.list ~~ (0xB17A,), 'B17A -> B17A';
ok Uni.new(0xB17B).NFKC.list ~~ (0xB17B,), 'B17B -> B17B';
ok Uni.new(0xB17C).NFKC.list ~~ (0xB17C,), 'B17C -> B17C';
ok Uni.new(0xB17D).NFKC.list ~~ (0xB17D,), 'B17D -> B17D';
ok Uni.new(0xB17E).NFKC.list ~~ (0xB17E,), 'B17E -> B17E';
ok Uni.new(0xB17F).NFKC.list ~~ (0xB17F,), 'B17F -> B17F';
ok Uni.new(0xB180).NFKC.list ~~ (0xB180,), 'B180 -> B180';
ok Uni.new(0xB181).NFKC.list ~~ (0xB181,), 'B181 -> B181';
ok Uni.new(0xB182).NFKC.list ~~ (0xB182,), 'B182 -> B182';
ok Uni.new(0xB183).NFKC.list ~~ (0xB183,), 'B183 -> B183';
ok Uni.new(0xB184).NFKC.list ~~ (0xB184,), 'B184 -> B184';
ok Uni.new(0xB185).NFKC.list ~~ (0xB185,), 'B185 -> B185';
ok Uni.new(0xB186).NFKC.list ~~ (0xB186,), 'B186 -> B186';
ok Uni.new(0xB187).NFKC.list ~~ (0xB187,), 'B187 -> B187';
ok Uni.new(0xB188).NFKC.list ~~ (0xB188,), 'B188 -> B188';
ok Uni.new(0xB189).NFKC.list ~~ (0xB189,), 'B189 -> B189';
ok Uni.new(0xB18A).NFKC.list ~~ (0xB18A,), 'B18A -> B18A';
ok Uni.new(0xB18B).NFKC.list ~~ (0xB18B,), 'B18B -> B18B';
ok Uni.new(0xB18C).NFKC.list ~~ (0xB18C,), 'B18C -> B18C';
ok Uni.new(0xB18D).NFKC.list ~~ (0xB18D,), 'B18D -> B18D';
ok Uni.new(0xB18E).NFKC.list ~~ (0xB18E,), 'B18E -> B18E';
ok Uni.new(0xB18F).NFKC.list ~~ (0xB18F,), 'B18F -> B18F';
ok Uni.new(0xB190).NFKC.list ~~ (0xB190,), 'B190 -> B190';
ok Uni.new(0xB191).NFKC.list ~~ (0xB191,), 'B191 -> B191';
ok Uni.new(0xB192).NFKC.list ~~ (0xB192,), 'B192 -> B192';
ok Uni.new(0xB193).NFKC.list ~~ (0xB193,), 'B193 -> B193';
ok Uni.new(0xB194).NFKC.list ~~ (0xB194,), 'B194 -> B194';
ok Uni.new(0xB195).NFKC.list ~~ (0xB195,), 'B195 -> B195';
ok Uni.new(0xB196).NFKC.list ~~ (0xB196,), 'B196 -> B196';
ok Uni.new(0xB197).NFKC.list ~~ (0xB197,), 'B197 -> B197';
ok Uni.new(0xB198).NFKC.list ~~ (0xB198,), 'B198 -> B198';
ok Uni.new(0xB199).NFKC.list ~~ (0xB199,), 'B199 -> B199';
ok Uni.new(0xB19A).NFKC.list ~~ (0xB19A,), 'B19A -> B19A';
ok Uni.new(0xB19B).NFKC.list ~~ (0xB19B,), 'B19B -> B19B';
ok Uni.new(0xB19C).NFKC.list ~~ (0xB19C,), 'B19C -> B19C';
ok Uni.new(0xB19D).NFKC.list ~~ (0xB19D,), 'B19D -> B19D';
ok Uni.new(0xB19E).NFKC.list ~~ (0xB19E,), 'B19E -> B19E';
ok Uni.new(0xB19F).NFKC.list ~~ (0xB19F,), 'B19F -> B19F';
ok Uni.new(0xB1A0).NFKC.list ~~ (0xB1A0,), 'B1A0 -> B1A0';
ok Uni.new(0xB1A1).NFKC.list ~~ (0xB1A1,), 'B1A1 -> B1A1';
ok Uni.new(0xB1A2).NFKC.list ~~ (0xB1A2,), 'B1A2 -> B1A2';
ok Uni.new(0xB1A3).NFKC.list ~~ (0xB1A3,), 'B1A3 -> B1A3';
ok Uni.new(0xB1A4).NFKC.list ~~ (0xB1A4,), 'B1A4 -> B1A4';
ok Uni.new(0xB1A5).NFKC.list ~~ (0xB1A5,), 'B1A5 -> B1A5';
ok Uni.new(0xB1A6).NFKC.list ~~ (0xB1A6,), 'B1A6 -> B1A6';
ok Uni.new(0xB1A7).NFKC.list ~~ (0xB1A7,), 'B1A7 -> B1A7';
ok Uni.new(0xB1A8).NFKC.list ~~ (0xB1A8,), 'B1A8 -> B1A8';
ok Uni.new(0xB1A9).NFKC.list ~~ (0xB1A9,), 'B1A9 -> B1A9';
ok Uni.new(0xB1AA).NFKC.list ~~ (0xB1AA,), 'B1AA -> B1AA';
ok Uni.new(0xB1AB).NFKC.list ~~ (0xB1AB,), 'B1AB -> B1AB';
ok Uni.new(0xB1AC).NFKC.list ~~ (0xB1AC,), 'B1AC -> B1AC';
ok Uni.new(0xB1AD).NFKC.list ~~ (0xB1AD,), 'B1AD -> B1AD';
ok Uni.new(0xB1AE).NFKC.list ~~ (0xB1AE,), 'B1AE -> B1AE';
ok Uni.new(0xB1AF).NFKC.list ~~ (0xB1AF,), 'B1AF -> B1AF';
ok Uni.new(0xB1B0).NFKC.list ~~ (0xB1B0,), 'B1B0 -> B1B0';
ok Uni.new(0xB1B1).NFKC.list ~~ (0xB1B1,), 'B1B1 -> B1B1';
ok Uni.new(0xB1B2).NFKC.list ~~ (0xB1B2,), 'B1B2 -> B1B2';
ok Uni.new(0xB1B3).NFKC.list ~~ (0xB1B3,), 'B1B3 -> B1B3';
ok Uni.new(0xB1B4).NFKC.list ~~ (0xB1B4,), 'B1B4 -> B1B4';
ok Uni.new(0xB1B5).NFKC.list ~~ (0xB1B5,), 'B1B5 -> B1B5';
ok Uni.new(0xB1B6).NFKC.list ~~ (0xB1B6,), 'B1B6 -> B1B6';
ok Uni.new(0xB1B7).NFKC.list ~~ (0xB1B7,), 'B1B7 -> B1B7';
ok Uni.new(0xB1B8).NFKC.list ~~ (0xB1B8,), 'B1B8 -> B1B8';
ok Uni.new(0xB1B9).NFKC.list ~~ (0xB1B9,), 'B1B9 -> B1B9';
ok Uni.new(0xB1BA).NFKC.list ~~ (0xB1BA,), 'B1BA -> B1BA';
ok Uni.new(0xB1BB).NFKC.list ~~ (0xB1BB,), 'B1BB -> B1BB';
ok Uni.new(0xB1BC).NFKC.list ~~ (0xB1BC,), 'B1BC -> B1BC';
ok Uni.new(0xB1BD).NFKC.list ~~ (0xB1BD,), 'B1BD -> B1BD';
ok Uni.new(0xB1BE).NFKC.list ~~ (0xB1BE,), 'B1BE -> B1BE';
ok Uni.new(0xB1BF).NFKC.list ~~ (0xB1BF,), 'B1BF -> B1BF';
ok Uni.new(0xB1C0).NFKC.list ~~ (0xB1C0,), 'B1C0 -> B1C0';
ok Uni.new(0xB1C1).NFKC.list ~~ (0xB1C1,), 'B1C1 -> B1C1';
ok Uni.new(0xB1C2).NFKC.list ~~ (0xB1C2,), 'B1C2 -> B1C2';
ok Uni.new(0xB1C3).NFKC.list ~~ (0xB1C3,), 'B1C3 -> B1C3';
ok Uni.new(0xB1C4).NFKC.list ~~ (0xB1C4,), 'B1C4 -> B1C4';
ok Uni.new(0xB1C5).NFKC.list ~~ (0xB1C5,), 'B1C5 -> B1C5';
ok Uni.new(0xB1C6).NFKC.list ~~ (0xB1C6,), 'B1C6 -> B1C6';
ok Uni.new(0xB1C7).NFKC.list ~~ (0xB1C7,), 'B1C7 -> B1C7';
ok Uni.new(0xB1C8).NFKC.list ~~ (0xB1C8,), 'B1C8 -> B1C8';
ok Uni.new(0xB1C9).NFKC.list ~~ (0xB1C9,), 'B1C9 -> B1C9';
ok Uni.new(0xB1CA).NFKC.list ~~ (0xB1CA,), 'B1CA -> B1CA';
ok Uni.new(0xB1CB).NFKC.list ~~ (0xB1CB,), 'B1CB -> B1CB';
ok Uni.new(0xB1CC).NFKC.list ~~ (0xB1CC,), 'B1CC -> B1CC';
ok Uni.new(0xB1CD).NFKC.list ~~ (0xB1CD,), 'B1CD -> B1CD';
ok Uni.new(0xB1CE).NFKC.list ~~ (0xB1CE,), 'B1CE -> B1CE';
ok Uni.new(0xB1CF).NFKC.list ~~ (0xB1CF,), 'B1CF -> B1CF';
ok Uni.new(0xB1D0).NFKC.list ~~ (0xB1D0,), 'B1D0 -> B1D0';
ok Uni.new(0xB1D1).NFKC.list ~~ (0xB1D1,), 'B1D1 -> B1D1';
ok Uni.new(0xB1D2).NFKC.list ~~ (0xB1D2,), 'B1D2 -> B1D2';
ok Uni.new(0xB1D3).NFKC.list ~~ (0xB1D3,), 'B1D3 -> B1D3';
ok Uni.new(0xB1D4).NFKC.list ~~ (0xB1D4,), 'B1D4 -> B1D4';
ok Uni.new(0xB1D5).NFKC.list ~~ (0xB1D5,), 'B1D5 -> B1D5';
ok Uni.new(0xB1D6).NFKC.list ~~ (0xB1D6,), 'B1D6 -> B1D6';
ok Uni.new(0xB1D7).NFKC.list ~~ (0xB1D7,), 'B1D7 -> B1D7';
ok Uni.new(0xB1D8).NFKC.list ~~ (0xB1D8,), 'B1D8 -> B1D8';
ok Uni.new(0xB1D9).NFKC.list ~~ (0xB1D9,), 'B1D9 -> B1D9';
ok Uni.new(0xB1DA).NFKC.list ~~ (0xB1DA,), 'B1DA -> B1DA';
ok Uni.new(0xB1DB).NFKC.list ~~ (0xB1DB,), 'B1DB -> B1DB';
ok Uni.new(0xB1DC).NFKC.list ~~ (0xB1DC,), 'B1DC -> B1DC';
ok Uni.new(0xB1DD).NFKC.list ~~ (0xB1DD,), 'B1DD -> B1DD';
ok Uni.new(0xB1DE).NFKC.list ~~ (0xB1DE,), 'B1DE -> B1DE';
ok Uni.new(0xB1DF).NFKC.list ~~ (0xB1DF,), 'B1DF -> B1DF';
ok Uni.new(0xB1E0).NFKC.list ~~ (0xB1E0,), 'B1E0 -> B1E0';
ok Uni.new(0xB1E1).NFKC.list ~~ (0xB1E1,), 'B1E1 -> B1E1';
ok Uni.new(0xB1E2).NFKC.list ~~ (0xB1E2,), 'B1E2 -> B1E2';
ok Uni.new(0xB1E3).NFKC.list ~~ (0xB1E3,), 'B1E3 -> B1E3';
ok Uni.new(0xB1E4).NFKC.list ~~ (0xB1E4,), 'B1E4 -> B1E4';
ok Uni.new(0xB1E5).NFKC.list ~~ (0xB1E5,), 'B1E5 -> B1E5';
ok Uni.new(0xB1E6).NFKC.list ~~ (0xB1E6,), 'B1E6 -> B1E6';
ok Uni.new(0xB1E7).NFKC.list ~~ (0xB1E7,), 'B1E7 -> B1E7';
ok Uni.new(0xB1E8).NFKC.list ~~ (0xB1E8,), 'B1E8 -> B1E8';
ok Uni.new(0xB1E9).NFKC.list ~~ (0xB1E9,), 'B1E9 -> B1E9';
ok Uni.new(0xB1EA).NFKC.list ~~ (0xB1EA,), 'B1EA -> B1EA';
ok Uni.new(0xB1EB).NFKC.list ~~ (0xB1EB,), 'B1EB -> B1EB';
ok Uni.new(0xB1EC).NFKC.list ~~ (0xB1EC,), 'B1EC -> B1EC';
ok Uni.new(0xB1ED).NFKC.list ~~ (0xB1ED,), 'B1ED -> B1ED';
ok Uni.new(0xB1EE).NFKC.list ~~ (0xB1EE,), 'B1EE -> B1EE';
ok Uni.new(0xB1EF).NFKC.list ~~ (0xB1EF,), 'B1EF -> B1EF';
ok Uni.new(0xB1F0).NFKC.list ~~ (0xB1F0,), 'B1F0 -> B1F0';
ok Uni.new(0xB1F1).NFKC.list ~~ (0xB1F1,), 'B1F1 -> B1F1';
ok Uni.new(0xB1F2).NFKC.list ~~ (0xB1F2,), 'B1F2 -> B1F2';
ok Uni.new(0xB1F3).NFKC.list ~~ (0xB1F3,), 'B1F3 -> B1F3';
ok Uni.new(0xB1F4).NFKC.list ~~ (0xB1F4,), 'B1F4 -> B1F4';
ok Uni.new(0xB1F5).NFKC.list ~~ (0xB1F5,), 'B1F5 -> B1F5';
ok Uni.new(0xB1F6).NFKC.list ~~ (0xB1F6,), 'B1F6 -> B1F6';
ok Uni.new(0xB1F7).NFKC.list ~~ (0xB1F7,), 'B1F7 -> B1F7';
ok Uni.new(0xB1F8).NFKC.list ~~ (0xB1F8,), 'B1F8 -> B1F8';
ok Uni.new(0xB1F9).NFKC.list ~~ (0xB1F9,), 'B1F9 -> B1F9';
ok Uni.new(0xB1FA).NFKC.list ~~ (0xB1FA,), 'B1FA -> B1FA';
ok Uni.new(0xB1FB).NFKC.list ~~ (0xB1FB,), 'B1FB -> B1FB';
ok Uni.new(0xB1FC).NFKC.list ~~ (0xB1FC,), 'B1FC -> B1FC';
ok Uni.new(0xB1FD).NFKC.list ~~ (0xB1FD,), 'B1FD -> B1FD';
ok Uni.new(0xB1FE).NFKC.list ~~ (0xB1FE,), 'B1FE -> B1FE';
ok Uni.new(0xB1FF).NFKC.list ~~ (0xB1FF,), 'B1FF -> B1FF';
ok Uni.new(0xB200).NFKC.list ~~ (0xB200,), 'B200 -> B200';
ok Uni.new(0xB201).NFKC.list ~~ (0xB201,), 'B201 -> B201';
ok Uni.new(0xB202).NFKC.list ~~ (0xB202,), 'B202 -> B202';
ok Uni.new(0xB203).NFKC.list ~~ (0xB203,), 'B203 -> B203';
ok Uni.new(0xB204).NFKC.list ~~ (0xB204,), 'B204 -> B204';
ok Uni.new(0xB205).NFKC.list ~~ (0xB205,), 'B205 -> B205';
ok Uni.new(0xB206).NFKC.list ~~ (0xB206,), 'B206 -> B206';
ok Uni.new(0xB207).NFKC.list ~~ (0xB207,), 'B207 -> B207';
ok Uni.new(0xB208).NFKC.list ~~ (0xB208,), 'B208 -> B208';
ok Uni.new(0xB209).NFKC.list ~~ (0xB209,), 'B209 -> B209';
ok Uni.new(0xB20A).NFKC.list ~~ (0xB20A,), 'B20A -> B20A';
ok Uni.new(0xB20B).NFKC.list ~~ (0xB20B,), 'B20B -> B20B';
ok Uni.new(0xB20C).NFKC.list ~~ (0xB20C,), 'B20C -> B20C';
ok Uni.new(0xB20D).NFKC.list ~~ (0xB20D,), 'B20D -> B20D';
ok Uni.new(0xB20E).NFKC.list ~~ (0xB20E,), 'B20E -> B20E';
ok Uni.new(0xB20F).NFKC.list ~~ (0xB20F,), 'B20F -> B20F';
ok Uni.new(0xB210).NFKC.list ~~ (0xB210,), 'B210 -> B210';
ok Uni.new(0xB211).NFKC.list ~~ (0xB211,), 'B211 -> B211';
ok Uni.new(0xB212).NFKC.list ~~ (0xB212,), 'B212 -> B212';
ok Uni.new(0xB213).NFKC.list ~~ (0xB213,), 'B213 -> B213';
ok Uni.new(0xB214).NFKC.list ~~ (0xB214,), 'B214 -> B214';
ok Uni.new(0xB215).NFKC.list ~~ (0xB215,), 'B215 -> B215';
ok Uni.new(0xB216).NFKC.list ~~ (0xB216,), 'B216 -> B216';
ok Uni.new(0xB217).NFKC.list ~~ (0xB217,), 'B217 -> B217';
ok Uni.new(0xB218).NFKC.list ~~ (0xB218,), 'B218 -> B218';
ok Uni.new(0xB219).NFKC.list ~~ (0xB219,), 'B219 -> B219';
ok Uni.new(0xB21A).NFKC.list ~~ (0xB21A,), 'B21A -> B21A';
ok Uni.new(0xB21B).NFKC.list ~~ (0xB21B,), 'B21B -> B21B';
ok Uni.new(0xB21C).NFKC.list ~~ (0xB21C,), 'B21C -> B21C';
ok Uni.new(0xB21D).NFKC.list ~~ (0xB21D,), 'B21D -> B21D';
ok Uni.new(0xB21E).NFKC.list ~~ (0xB21E,), 'B21E -> B21E';
ok Uni.new(0xB21F).NFKC.list ~~ (0xB21F,), 'B21F -> B21F';
ok Uni.new(0xB220).NFKC.list ~~ (0xB220,), 'B220 -> B220';
ok Uni.new(0xB221).NFKC.list ~~ (0xB221,), 'B221 -> B221';
ok Uni.new(0xB222).NFKC.list ~~ (0xB222,), 'B222 -> B222';
ok Uni.new(0xB223).NFKC.list ~~ (0xB223,), 'B223 -> B223';
ok Uni.new(0xB224).NFKC.list ~~ (0xB224,), 'B224 -> B224';
ok Uni.new(0xB225).NFKC.list ~~ (0xB225,), 'B225 -> B225';
ok Uni.new(0xB226).NFKC.list ~~ (0xB226,), 'B226 -> B226';
ok Uni.new(0xB227).NFKC.list ~~ (0xB227,), 'B227 -> B227';
ok Uni.new(0xB228).NFKC.list ~~ (0xB228,), 'B228 -> B228';
ok Uni.new(0xB229).NFKC.list ~~ (0xB229,), 'B229 -> B229';
ok Uni.new(0xB22A).NFKC.list ~~ (0xB22A,), 'B22A -> B22A';
ok Uni.new(0xB22B).NFKC.list ~~ (0xB22B,), 'B22B -> B22B';
ok Uni.new(0xB22C).NFKC.list ~~ (0xB22C,), 'B22C -> B22C';
ok Uni.new(0xB22D).NFKC.list ~~ (0xB22D,), 'B22D -> B22D';
ok Uni.new(0xB22E).NFKC.list ~~ (0xB22E,), 'B22E -> B22E';
ok Uni.new(0xB22F).NFKC.list ~~ (0xB22F,), 'B22F -> B22F';
ok Uni.new(0xB230).NFKC.list ~~ (0xB230,), 'B230 -> B230';
ok Uni.new(0xB231).NFKC.list ~~ (0xB231,), 'B231 -> B231';
ok Uni.new(0xB232).NFKC.list ~~ (0xB232,), 'B232 -> B232';
ok Uni.new(0xB233).NFKC.list ~~ (0xB233,), 'B233 -> B233';
ok Uni.new(0xB234).NFKC.list ~~ (0xB234,), 'B234 -> B234';
ok Uni.new(0xB235).NFKC.list ~~ (0xB235,), 'B235 -> B235';
ok Uni.new(0xB236).NFKC.list ~~ (0xB236,), 'B236 -> B236';
ok Uni.new(0xB237).NFKC.list ~~ (0xB237,), 'B237 -> B237';
ok Uni.new(0xB238).NFKC.list ~~ (0xB238,), 'B238 -> B238';
ok Uni.new(0xB239).NFKC.list ~~ (0xB239,), 'B239 -> B239';
ok Uni.new(0xB23A).NFKC.list ~~ (0xB23A,), 'B23A -> B23A';
ok Uni.new(0xB23B).NFKC.list ~~ (0xB23B,), 'B23B -> B23B';
ok Uni.new(0xB23C).NFKC.list ~~ (0xB23C,), 'B23C -> B23C';
ok Uni.new(0xB23D).NFKC.list ~~ (0xB23D,), 'B23D -> B23D';
ok Uni.new(0xB23E).NFKC.list ~~ (0xB23E,), 'B23E -> B23E';
ok Uni.new(0xB23F).NFKC.list ~~ (0xB23F,), 'B23F -> B23F';
ok Uni.new(0xB240).NFKC.list ~~ (0xB240,), 'B240 -> B240';
ok Uni.new(0xB241).NFKC.list ~~ (0xB241,), 'B241 -> B241';
ok Uni.new(0xB242).NFKC.list ~~ (0xB242,), 'B242 -> B242';
ok Uni.new(0xB243).NFKC.list ~~ (0xB243,), 'B243 -> B243';
ok Uni.new(0xB244).NFKC.list ~~ (0xB244,), 'B244 -> B244';
ok Uni.new(0xB245).NFKC.list ~~ (0xB245,), 'B245 -> B245';
ok Uni.new(0xB246).NFKC.list ~~ (0xB246,), 'B246 -> B246';
ok Uni.new(0xB247).NFKC.list ~~ (0xB247,), 'B247 -> B247';
ok Uni.new(0xB248).NFKC.list ~~ (0xB248,), 'B248 -> B248';
ok Uni.new(0xB249).NFKC.list ~~ (0xB249,), 'B249 -> B249';
ok Uni.new(0xB24A).NFKC.list ~~ (0xB24A,), 'B24A -> B24A';
ok Uni.new(0xB24B).NFKC.list ~~ (0xB24B,), 'B24B -> B24B';
ok Uni.new(0xB24C).NFKC.list ~~ (0xB24C,), 'B24C -> B24C';
ok Uni.new(0xB24D).NFKC.list ~~ (0xB24D,), 'B24D -> B24D';
ok Uni.new(0xB24E).NFKC.list ~~ (0xB24E,), 'B24E -> B24E';
ok Uni.new(0xB24F).NFKC.list ~~ (0xB24F,), 'B24F -> B24F';
ok Uni.new(0xB250).NFKC.list ~~ (0xB250,), 'B250 -> B250';
ok Uni.new(0xB251).NFKC.list ~~ (0xB251,), 'B251 -> B251';
ok Uni.new(0xB252).NFKC.list ~~ (0xB252,), 'B252 -> B252';
ok Uni.new(0xB253).NFKC.list ~~ (0xB253,), 'B253 -> B253';
ok Uni.new(0xB254).NFKC.list ~~ (0xB254,), 'B254 -> B254';
ok Uni.new(0xB255).NFKC.list ~~ (0xB255,), 'B255 -> B255';
ok Uni.new(0xB256).NFKC.list ~~ (0xB256,), 'B256 -> B256';
ok Uni.new(0xB257).NFKC.list ~~ (0xB257,), 'B257 -> B257';
ok Uni.new(0xB258).NFKC.list ~~ (0xB258,), 'B258 -> B258';
ok Uni.new(0xB259).NFKC.list ~~ (0xB259,), 'B259 -> B259';
