dnl
dnl AM_LIB_MAITRETAROT(major,minor,micro,glib_inc_path,glib_lib_path)
dnl
AC_DEFUN([AM_LIB_MAITRETAROT],
[AC_CHECK_HEADERS(stdio.h stdlib.h sys/socket.h sys/types.h unistd.h netdb.h string.h netinet/in.h)
 AC_CHECK_FUNCS(alarm)
 LIBMT_LIBS=" -lmaitretarot "
 AC_ARG_WITH(libmaitretarot, \
  --with-libmaitretarot   path to libmaitretarot libraries,
      [ 
      	LIBMT_CFLAGS="-I${withval}/include"
      	LIBMT_LIBS="-L${withval}/lib -lmaitretarot"
	 ],[ 
      	LIBMT_CFLAGS="-I/usr/local/include -I/usr/include"
      	LIBMT_LIBS="-L/usr/local/lib -L/usr/lib -lmaitretarot"
	 ])
 ac_save_CPPFLAGS="$CPPFLAGS"
 ac_save_CFLAGS="$CFLAGS"
 ac_save_LIBS="$LIBS"
 CFLAGS="$CFLAGS $LIBMT_CFLAGS $4"
 CPPFLAGS="$CPPFLAGS $LIBMT_CFLAGS $4"
 LIBS="$LIBS $LIBMT_LIBS $5"
 AC_MSG_CHECKING([for maitretarot.h])
 AC_TRY_CPP([#include <maitretarot.h>],[
   AC_MSG_RESULT(yes)
   AC_CACHE_CHECK([for libmaitretarot], am_cv_lib_maitretarot,
    [
    AC_TRY_RUN(
changequote(<<, >>)dnl
<</* Test program from Yves Mettier (ymettier@libertysurf.fr).  */

#include <maitretarot.h>

int
main ()
{
  if (libmt_check_version ($1, $2, $3))
    exit (0);
  exit (1);
}
>>,
changequote([, ])
	     am_cv_lib_maitretarot=yes, am_cv_lib_maitretarot=no,
	     am_cv_lib_maitretarot=no)
    ])],
    [
      am_cv_lib_maitretarot=no
      AC_MSG_RESULT(no)
      AC_MSG_ERROR([Could not find maitretarot.h. This file comes with libmaitretarot])
    ]
  )
  if test "x${am_cv_lib_maitretarot}" = "xno"; then
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
       AC_MSG_ERROR([Could not find libmaitretarot])
  fi
  CPPFLAGS="$ac_save_CPPFLAGS"
  PKG_CHECK_MODULES(GLIB, glib-2.0 >= 1.3.1 gthread-2.0 >= 2.0 libxml-2.0 >= 2.0)
])
