/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import com.google.common.base.Objects;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class MapSerializer<U, V>
extends AbstractSerializer<Map<U, V>> {
    private final Serializer<U> keySerializer;
    private final Serializer<V> valueSerializer;

    public MapSerializer(Serializer<U> keySerializer, Serializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public Map<U, V> read(Decoder decoder) throws Exception {
        int size = decoder.readInt();
        LinkedHashMap<U, V> valueMap = new LinkedHashMap<U, V>(size);
        for (int i = 0; i < size; ++i) {
            U key = this.keySerializer.read(decoder);
            V value = this.valueSerializer.read(decoder);
            valueMap.put(key, value);
        }
        return valueMap;
    }

    @Override
    public void write(Encoder encoder, Map<U, V> value) throws Exception {
        encoder.writeInt(value.size());
        for (Map.Entry<U, V> entry : value.entrySet()) {
            this.keySerializer.write(encoder, entry.getKey());
            this.valueSerializer.write(encoder, entry.getValue());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MapSerializer rhs = (MapSerializer)obj;
        return Objects.equal(this.keySerializer, rhs.keySerializer) && Objects.equal(this.valueSerializer, rhs.valueSerializer);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.keySerializer, this.valueSerializer});
    }
}

