// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Title_screen.h"




const std::string FS::Title_screen::selection_names[] = 
        { "Play", "Tutorial", "Settings", "High Scores", "Quit" };
const int FS::Title_screen::selection_ys[] = { 180, 250, 320, 390, 460 };




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Title_screen::Title_screen() : current_selection(0)
{
    // nothing
  
} // FS::Title_screen::Title_screen    
 
// ******************
// *** DESTRUCTOR ***
// ******************
FS::Title_screen::~Title_screen()
{
    // nothing
    
} // FS::Title_screen::~Title_screen()    




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::Title_screen::draw()
{
    gfx_ptr->draw_background(FS_gfx::INTRO_SCREEN);

    for (int i = 0; i < num_selections; ++i)
    {   
        if (i == current_selection)
        {
            gfx_ptr->draw_text(FS_gfx::LARGE_FONT, selection_x, selection_ys[i],
                    selection_names[i]);
        }
        else 
        {
            gfx_ptr->draw_text(FS_gfx::LARGE_FONT_FAINT, selection_x, selection_ys[i],
                    selection_names[i]);
        } // if ... else
    } // for    

    SDL_GL_SwapBuffers();

} // FS::Title_screen::draw

// **************************************************

FS::Title_screen::Selection FS::Title_screen::update()
{
    bool changed = false;
    Selection sel = none;
    User_input::Keyboard_Event ke;
    
    while ( input_ptr->next_event(ke) )
    {
        if ( ke == User_input::ESCAPE_PRESSED )
        {
            sel = quit;
            break;
        } 
        else if ( ke == User_input::JUMP_KEY_PRESSED )
        {
            // See header file for why 'current_selection' is type int.
            sel = static_cast<Selection> (current_selection);
            break;
        }
        else if ( ke == User_input::DOWN_KEY_PRESSED )
        {
            ++current_selection;
            current_selection %= num_selections;
            changed = true;
        }
        else if ( ke == User_input::UP_KEY_PRESSED )
        {
            --current_selection;
            if (current_selection < 0)
            {
                current_selection = (num_selections - 1);
            } // if
            changed = true;
        } // if ... else
    } // while
    
    if (changed)
    {
        draw();
    } // if
    
    return sel;

} // FS::Title_screen::update 

// **************************************************

