// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Sprite.h"




// *******************
// *** CONSTRUCTOR ***
// *******************
Sprite::Sprite() {}

// ******************
// *** DESTRUCTOR ***
// ******************
Sprite::~Sprite() {}




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

int Sprite::max(int a, int b) const
{
    if (a >= b)
    {
        return a;
    }
    else
    {
        return b;
    } // if ... else

} // Sprite::max

// **************************************************

int Sprite::min(int a, int b) const
{
    if (a <= b)
    {
        return a;
    }
    else
    {
        return b;
    } // if ... else

} // Sprite::min

// **************************************************

const SDL_Rect& Sprite::get_coll_box()
{
    coll_box.x = x + coll_box_x_offset;
    coll_box.y = y + coll_box_y_offset;
    
    return coll_box;
    
} // Sprite::get_coll_box

// **************************************************
        
const SDL_Rect& Sprite::get_bounding_box()
{
    bounding_box.x = x;
    bounding_box.y = y;
    
    return bounding_box;
    
} // Sprite::get_bounding_box

// **************************************************

void Sprite::minmax(int a, int b, int& min, int& max) const
{
    if (a <= b)
    {
        min = a;
        max = b;
    }
    else
    {
        min = b;
        max = a;
    } // if ... else
    
} // Sprite::minmax

// **************************************************

void Sprite::clip_update_rect_xy(int screen_width, int screen_height)
{   
    if ( update_rect.x < 0 )
    {
        update_rect.w += update_rect.x;
        update_rect.x = 0;
    }
    else if ( (update_rect.x + update_rect.w) > screen_width )
    {
        update_rect.w = screen_width - update_rect.x;
    } // if ... else
    
    if ( update_rect.y < 0 )
    {
        update_rect.h += update_rect.y;
        update_rect.y = 0;
    }
    else if ( (update_rect.y + update_rect.h) > screen_height )
    {
        update_rect.h = screen_height - update_rect.y;
    } // if ... else    

} // Sprite::clip_update_rect_xy

// **************************************************

void Sprite::clip_update_rect_x(int screen_width)
{
    if ( update_rect.x < 0 )
    {
        update_rect.w += update_rect.x;
        update_rect.x = 0;
    }
    else if ( (update_rect.x + update_rect.w) > screen_width )
    {
        update_rect.w = screen_width - update_rect.x;
    } // if ... else
    
} // Sprite::clip_update_rect_x  
  
// **************************************************

void Sprite::clip_update_rect_y(int screen_height)
{
    if ( update_rect.y < 0 )
    {
        update_rect.h += update_rect.y;
        update_rect.y = 0;
    }
    else if ( (update_rect.y + update_rect.h) > screen_height )
    {
        update_rect.h = screen_height - update_rect.y;
    } // if ... else    

} // Sprite::clip_update_rect_y    

// **************************************************

void print_SDL_Rect(const SDL_Rect& r, const char* name)
{
    std::cout << name << ": x=" << r.x << ";y=" << r.y << ";w=" << r.w <<
            ";h=" << r.h << std::endl;
    
} // print_SDL_Rect

