// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Soundengine_h
#define Soundengine_h




#include "SDL_mixer.h"




extern bool sound_available;

namespace FS
{

class Sound_engine
{
    public:
        // These values double as channels on which sounds are played.
        enum SoundIDs { MIAOW, SPLASH, RIVER, PING };
        
        Sound_engine();
        ~Sound_engine();
        
        void turn_on(bool b) { on = b; }
        
        void play_sound(SoundIDs sid, int loops = 0, int volume = 128);
        void stop_sound(int channel);
        void stop_all_sounds();
        void pause_all_sounds();
        void resume_all_sounds();
        
    private:
        static const int NUM_SOUNDS = 4;
    
        Mix_Chunk* sounds[NUM_SOUNDS];

        bool on;
        
}; // class Sound_engine

} // namespace FS




#endif
            
