// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Scrolling_sprite.h"




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::Scrolling_sprite::scroll_x( const ScrollingData& sd )
{
    // y-coord never changes because we're only scrolling horizontally
    
    if ( sd.current_directions[my_row] == LEFT_TO_RIGHT )
    {
        x += sd.dxs[my_row];
        if ( x >= sd.row_lengths_in_pixels[my_row] )
        {
            x -= sd.row_lengths_in_pixels[my_row];
        } // if
    }
    else    // RIGHT_TO_LEFT
    {
        x -= sd.dxs[my_row];
        if ( x < 0 )
        {
            x += sd.row_lengths_in_pixels[my_row];
        } // if
    } // if ... else
    
} // FS::Scrolling_sprite::scroll_x
        
// **************************************************
// **************************************************
 
