// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Scroller_h
#define Scroller_h




#include "constants.h"
#include "enums.h"
#include <fstream>
#include <string>
#include "Crystal.h"




namespace FS
{

class Scroller
{
    public:

        struct Cell
        {
            LogColor lc;
            Crystal::Color cc;
            BonusType bt;
        }; // struct Cell

        Scroller();
        ~Scroller();
        
        void load_data(std::ifstream& fin);
        void halve_velocity(int row) { my_data.current_velocities[row] /= 2; }
        void double_velocity(int row) { my_data.current_velocities[row] *= 2; }
        void change_direction(int row);
        void restore_original_directions_and_velocities();
        void update(int t);
        const Cell* get_row_of_cells(int row) const { return my_cells[row]; }
        const ScrollingData& get_data() const { return my_data; }

    private:
            
        ScrollingData my_data;
        Cell my_cells[NUM_ROWS][MAX_COLS];

        void reset_cells();
        
}; // class Scroller

} // namespace FS




#endif
