// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Log.h"
#include <iostream>




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Log::Log( int x_, int y_, int width_, int my_row_, LogColor color )
{
    x = x_;
    y = y_;
    width = width_;
    image_offset = (width / CELL_WIDTH) - 1;
    height = CELL_HEIGHT;
    
    my_row = my_row_;
    original_color = current_color = color;
    
    coll_box_x_offset = 0;
    coll_box_y_offset = 0;
    coll_box.w = width;
    coll_box.h = height;

    virtual_x = 0;
    //virtual_old_x = 0;
    
} // FS::Log::Log
    
// ******************
// *** DESTRUCTOR ***
// ******************
FS::Log::~Log()
{
    // NYI
    
} // FS::Log::~Log




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

void FS::Log::update( const ScrollingData& sd )
{
    scroll_x(sd);   // see MapSprite::scroll_x
    
    if ( calc_x_pos(sd) )
    {
        FS_gfx::Image_name base_image = FS_gfx::LOG_RED_1;
        switch (current_color)
        {
            case L_RED:
                base_image = static_cast<FS_gfx::Image_name> (FS_gfx::LOG_RED_1 + image_offset);
                break;
            case L_YELLOW:
                base_image = static_cast<FS_gfx::Image_name> (FS_gfx::LOG_YELLOW_1 + image_offset);
                break;
            case L_BLUE:
                base_image = static_cast<FS_gfx::Image_name> (FS_gfx::LOG_BLUE_1 + image_offset);
                break;
            case L_ORANGE:
                base_image = static_cast<FS_gfx::Image_name> (FS_gfx::LOG_ORANGE_1 + image_offset);
                break;
            case L_GREEN:
                base_image = static_cast<FS_gfx::Image_name> (FS_gfx::LOG_GREEN_1 + image_offset);
                break;
            case L_PURPLE:
                base_image = static_cast<FS_gfx::Image_name> (FS_gfx::LOG_PURPLE_1 + image_offset);
                break;
            case L_BROWN:
                base_image = static_cast<FS_gfx::Image_name> (FS_gfx::LOG_BROWN_1 + image_offset);
                break;
            case L_BACKGROUND:
                // Shouldn't happen - not sure why it's in the enum, actually!
                break;
        } // switch
                     
        gfx_ptr->draw_texture( base_image, virtual_x, y );
    } // if
    
    // Albert needs to know these for when he's travelling on a log.
    num_pixels_moved = sd.dxs[my_row];
    my_direction = sd.current_directions[my_row];
    
} // FS::Log::update
    
// **************************************************
    
bool FS::Log::calc_x_pos( const ScrollingData & sd )
{
    // For the purposes of the following code, all x-coord should
    // be < SCREEN_WIDTH. For want of a better name, we'll call this
    // value virtual_x, because it's the 'onscreen' value as used by SDL.
    if ( x >= SCREEN_WIDTH )
    {
        virtual_x = -(sd.row_lengths_in_pixels[my_row] - x);
    }
    else
    {
        virtual_x = x;
    } // if ... else
    
    return ( virtual_x + width >= 0 );

} // FS::Log::calc_x_pos

// **************************************************

// Override Sprite::get_coll_box so we can use 'virtual' x-coord for 
// calculating collision box. Otherwise, for logs moving r-to-l, it looks
// as though the log goes entirely offscreen as soon as x < 0, because then
// x is recorded as a +ve value at far right of row length in pixels.(?!)
// N.B. virtual_x is updated on every call to Log::update, so we can be sure
// it is always valid.
const SDL_Rect& FS::Log::get_coll_box()
{
    coll_box.x = virtual_x + coll_box_x_offset;
    coll_box.y = y + coll_box_y_offset;
    
    return coll_box;    
    
} // FS::Log::get_coll_box

