// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Get_ready_screen.h"
#include "SDL_image.h"
#include <cstdio>
#include <iostream>
#include <string>




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Get_ready_screen::Get_ready_screen()
{
    // nothing
    
} // FS::Get_ready_screen::Get_ready_screen()

// ******************
// *** DESTRUCTOR ***
// ******************
FS::Get_ready_screen::~Get_ready_screen()
{
    // nothing
    
} // FS::Get_ready_screen::~Get_ready_screen() 




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::Get_ready_screen::init_level_select(int furthest_lev)
{
    current_start_level = furthest_level = furthest_lev;
    draw_level_select();

} // FS::Get_ready_screen::init_level_select

// **************************************************

void FS::Get_ready_screen::draw_level_select()
{
    char lev_string[4];
    sprintf(lev_string, "%d", current_start_level);
    
    gfx_ptr->draw_background(FS_gfx::GET_READY);
    gfx_ptr->draw_text( FS_gfx::SMALL_FONT, 0, 50, "Please select start level . . .",
            true, FS::SCREEN_WIDTH );
    gfx_ptr->draw_text( FS_gfx::SMALL_FONT, 0, 90, lev_string, true, FS::SCREEN_WIDTH );

    FS_gfx::Image_name limit;
    if ( current_start_level == 1 )
    {
        limit = FS_gfx::LOWER_LIMIT;
    }
    else if ( current_start_level == furthest_level )
    {
        limit = FS_gfx::UPPER_LIMIT;
    }
    else
    {
        limit = FS_gfx::MIDDLE;
    } // if ... else
    gfx_ptr->draw_texture( limit, 355, 90 );

    SDL_GL_SwapBuffers();

} // FS::Get_ready_screen::draw_level_select

// **************************************************

int FS::Get_ready_screen::update_level_select()
{
    bool changed = false;
    int selection = 0;
    User_input::Keyboard_Event ke;
    
    while ( input_ptr->next_event(ke) )
    {
        if ( ke == User_input::JUMP_KEY_PRESSED )
        {
            selection = current_start_level;
            break;
        }
        else if ( ke == User_input::LEFT_KEY_PRESSED )
        {
            if ( current_start_level > 1 )
            {
                --current_start_level;
                changed = true;
            } // if
        }
        else if ( ke == User_input::RIGHT_KEY_PRESSED )
        {
            if ( current_start_level < furthest_level )
            {
                ++current_start_level;
                changed = true;
            } // if
        } // if ... else
    } // while
    
    if (changed)
    {
        draw_level_select();
    } // if
    
    return selection;

} // FS::Get_ready_screen::update_level_select

// **************************************************

void FS::Get_ready_screen::init_countdown(int t, int lev)
{
    start_time = t;
    draw_countdown(10, lev);

} // FS::Get_ready_screen::init_countdown

// **************************************************

void FS::Get_ready_screen::draw_countdown(int seconds, int lev)
{
    //std::cout << "draw_countdown1\n";
    //std::cout << "seconds=" << seconds << "; lev=" << lev << "\n";

    gfx_ptr->draw_background(FS_gfx::GET_READY);
    
    // FIXME: create this string once then re-use?!
    std::string message;
    char level_digits[4];
    char secs_digits[3];
    sprintf(level_digits, "%d", lev);
    sprintf(secs_digits, "%d", seconds);
    message = "About to start level ";
    message += level_digits;
    message += " . . .";

    gfx_ptr->draw_text( FS_gfx::SMALL_FONT, 0, 50, message, true, FS::SCREEN_WIDTH );
    gfx_ptr->draw_text( FS_gfx::SMALL_FONT, 0, 90, "Get Ready!", true, FS::SCREEN_WIDTH );
    gfx_ptr->draw_text( FS_gfx::SMALL_FONT, 0, 130, secs_digits, true, FS::SCREEN_WIDTH );

    SDL_GL_SwapBuffers();
    
    //std::cout << "draw_countdown2\n";

} // FS::Get_ready_screen::draw_countdown

// **************************************************

bool FS::Get_ready_screen::update_countdown(int t, int lev)
{
    int seconds_passed = (t - start_time) / 1000;
    bool jump_pressed = false;
    User_input::Keyboard_Event ke;
    
    while ( input_ptr->next_event(ke) )
    {
        if ( ke == User_input::JUMP_KEY_PRESSED )
        {
            jump_pressed = true;
            break;
        } // if
    } // while
    
    if ( (seconds_passed == SECONDS_TO_WAIT) || jump_pressed )
    {
        return true;
    } // if
    
    draw_countdown( SECONDS_TO_WAIT - seconds_passed, lev );

    return false;

} // FS::Get_ready_screen::update_countdown
    
    

