// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Game_timer_h
#define Game_timer_h




#include "SDL.h"




class GameTimer
{
    public:
        GameTimer();
        ~GameTimer();

        // Returns true if timer running after 'pause', else false.
        bool pause();        
        bool is_running() const { return running; }        
        int get_time() const;
        
        // Simply forces timer to run if it's paused.
        void resume();
        
    private:
        int start_time;    
        int num_ticks_on_pause;        
        bool running;

}; // class GameTimer




#endif

