// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Collectable_sprite_h
#define Collectable_sprite_h




#include "Scrolling_sprite.h"




namespace FS
{
    
class Collectable_sprite : public Scrolling_sprite
{
    public:
        
        enum CS_ID { CRYSTAL, BONUS };
    
        Collectable_sprite();
        virtual ~Collectable_sprite();
        
        CS_ID get_id() const { return my_id; }
        
        bool calc_virtual_x( const ScrollingData& sd, int row );
        
        // FIXME: make Sprite::deactivate virtual and redefine here to add extra?
        void set_must_deactivate() { must_deactivate = true; } 
        void deactivate() { active = false; must_deactivate = true; }
                
        virtual void reset() = 0;
        
    protected:
            
        CS_ID my_id;
        bool must_deactivate;
        int virtual_x;

        bool animated;
        double animation_frames_per_ms;

}; // Collectable_sprite

} // namespace FS




#endif

        
