// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Background_image_h
#define Background_image_h




#include <SDL/SDL.h>
#include <SDL/SDL_opengl.h>
#include <iostream>
#include <cstdlib>
#include <SDL/SDL_image.h>
#include <string>
#include <vector>
#include "Useful_gl.h"




namespace Mafferyew
{
    
class Background_image
{
    
    public:
            
        Background_image(const std::string& image_file);
        ~Background_image();
        
        void draw() const;
        
    private:
            
        std::vector<GLuint> textures;
        std::vector<SDL_Rect> rects;
        
}; // class Background_image

} // namespace Mafferyew
    



#endif
