---
layout: default
permalink: /getting-started/
title: Getting Started
redirect_from:
  - /docs/getting-started.md/
  - /docs/getting-started/
---

# Getting Started

* TOC
{:toc}

This is how you'll get started with Kompose!

There are three different guides depending on your container orchestrator as well as operating system.

For beginners and the most compatibility, follow the _Minikube and Kompose_ guide.

## Minikube and Kompose

In this guide, we'll deploy a sample `compose.yaml` file to a Kubernetes cluster.

Requirements:

- [minikube](https://github.com/kubernetes/minikube)
- [kompose](https://github.com/kubernetes/kompose)

**Start `minikube`:**

If you don't already have a Kubernetes cluster running, [minikube](https://github.com/kubernetes/minikube) is the best way to get started.

```sh
$ minikube start
Starting local Kubernetes v1.7.5 cluster...
Starting VM...
Getting VM IP address...
Moving files into cluster...
Setting up certs...
Connecting to cluster...
Setting up kubeconfig...
Starting cluster components...
Kubectl is now configured to use the cluster
```

**Download an [example Compose file](https://raw.githubusercontent.com/kubernetes/kompose/main/examples/compose.yaml), or use your own:**

```sh
wget https://raw.githubusercontent.com/kubernetes/kompose/main/examples/compose.yaml
```

**Convert your Compose file to Kubernetes:**

Run `kompose convert` in the same directory as your `compose.yaml` file.

```sh
$ kompose convert
INFO Kubernetes file "frontend-service.yaml" created
INFO Kubernetes file "redis-leader-service.yaml" created
INFO Kubernetes file "redis-replica-service.yaml" created
INFO Kubernetes file "frontend-deployment.yaml" created
INFO Kubernetes file "redis-leader-deployment.yaml" created
INFO Kubernetes file "redis-replica-deployment.yaml" created
```

Then you can use `kubectl apply` to create these resources in Kubernetes.

**Access the newly deployed service:**

Now that your service has been deployed, let's access it.

If you're using `minikube` you may access it via the `minikube service` command.

```sh
$ minikube service frontend
```

Otherwise, use `kubectl` to see what IP the service is using:

```sh
$ kubectl describe svc frontend
Name:                   frontend
Namespace:              default
Labels:                 service=frontend
Selector:               service=frontend
Type:                   LoadBalancer
IP:                     10.0.0.183
LoadBalancer Ingress:   123.45.67.89
Port:                   80      80/TCP
NodePort:               80      31144/TCP
Endpoints:              172.17.0.4:80
Session Affinity:       None
No events.
```

Note: If you're using a cloud provider, your IP will be listed next to `LoadBalancer Ingress`.

If you have yet to expose your service (for example, within GCE), use the command:

```sh
kubectl expose deployment frontend --type="LoadBalancer"
```

To check functionality, you may also `curl` the URL.

```sh
$ curl http://123.45.67.89
```

## Minishift and Kompose

In this guide, we'll deploy a sample `compose.yaml` file to an OpenShift cluster.

Requirements:

- [minishift](https://github.com/minishift/minishift)
- [kompose](https://github.com/kubernetes/kompose)
- An OpenShift route created

**Note:** The service will NOT be accessible until you create an OpenShift route with `oc expose`. You must also have a virtualization environment setup. By default, `minishift` uses KVM.

**Start `minishift`:**

[Minishift](https://github.com/minishift/minishift) is a tool that helps run OpenShift locally using a single-node cluster inside a VM. Similar to [minikube](https://github.com/kubernetes/minikube).

```sh
$ minishift start
Starting local OpenShift cluster using 'kvm' hypervisor...
-- Checking OpenShift client ... OK
-- Checking Docker client ... OK
-- Checking Docker version ... OK
-- Checking for existing OpenShift container ... OK
...
```

**Download an [example Compose file](https://raw.githubusercontent.com/kubernetes/kompose/main/examples/compose.yaml), or use your own:**

```sh
wget https://raw.githubusercontent.com/kubernetes/kompose/main/examples/compose.yaml
```

**Convert your Compose file to OpenShift:**

Run `kompose convert --provider=openshift` in the same directory as your `compose.yaml` file.

```sh
$ kompose convert --provider=openshift
INFO OpenShift file "frontend-service.yaml" created
INFO OpenShift file "redis-leader-service.yaml" created
INFO OpenShift file "redis-replica-service.yaml" created
INFO OpenShift file "frontend-deploymentconfig.yaml" created
INFO OpenShift file "frontend-imagestream.yaml" created
INFO OpenShift file "redis-leader-deploymentconfig.yaml" created
INFO OpenShift file "redis-leader-imagestream.yaml" created
INFO OpenShift file "redis-replica-deploymentconfig.yaml" created
INFO OpenShift file "redis-replica-imagestream.yaml" created
```

Then you can use `kubectl apply` to create these resources in OpenShift cluster.

**Access the newly deployed service:**

After deployment, you must create an OpenShift route in order to access the service.

If you're using `minishift`, you'll use a combination of `oc` and `minishift` commands to access the service.

Create a route for the `frontend` service using `oc`:

```sh
$ oc expose service/frontend
route "frontend" exposed
```

Access the `frontend` service with `minishift`:

```sh
$ minishift openshift service frontend --namespace=myproject
Opening the service myproject/frontend in the default browser...
```

You can also access the GUI interface of OpenShift for an overview of the deployed containers:

```sh
$ minishift console
Opening the OpenShift Web console in the default browser...
```

## RHEL and Kompose

In this guide, we'll deploy a sample `compose.yaml` file using both RHEL (Red Hat Enterprise Linux) and OpenShift.

Requirements:

- Red Hat Enterprise Linux 7.4
- [Red Hat Development Suite](https://developers.redhat.com/products/devsuite/overview/)
  - Which includes:
  - [minishift](https://github.com/minishift/minishift)
  - [kompose](https://github.com/kubernetes/kompose)

**Note:** A KVM hypervisor must be setup in order to correctly use `minishift` on RHEL. You can set it up via the [CDK Documentation](https://access.redhat.com/documentation/en-us/red_hat_container_development_kit/3.1/html-single/getting_started_guide/index#setup-virtualization) under "Set up your virtualization environment".

**Install Red Hat Development Suite:**

Before we are able to use both `minishift` and `kompose`, DevSuite must be installed. A more concise [installation document is available](https://developers.redhat.com/products/cdk/hello-world#fndtn-rhel).

Change to root.

```sh
$ su -
```

Enable the Red Hat Developer Tools software repository.

```sh
$ subscription-manager repos --enable rhel-7-server-devtools-rpms
$ subscription-manager repos --enable rhel-server-rhscl-7-rpms
```

Add the Red Hat Developer Tools key to your system.

```sh
$ cd /etc/pki/rpm-gpg
$ wget -O RPM-GPG-KEY-redhat-devel https://www.redhat.com/security/data/a5787476.txt
$ rpm --import RPM-GPG-KEY-redhat-devel
```

Install Red Hat Development Suite and Kompose.

```sh
$ yum install rh-devsuite kompose -y
```

**Start `minishift`:**

Before we begin, we must do a few preliminary steps setting up `minishift`.

```sh
$ su -
$ ln -s /var/lib/cdk-minishift-3.0.0/minishift /usr/bin/minishift
$ minishift setup-cdk --force --default-vm-driver="kvm"
$ ln -s /home/$(whoami)/.minishift/cache/oc/v3.5.5.8/oc /usr/bin/oc
```

Now we may start `minishift`.

```sh
$ minishift start
Starting local OpenShift cluster using 'kvm' hypervisor...
-- Checking OpenShift client ... OK
-- Checking Docker client ... OK
-- Checking Docker version ... OK
-- Checking for existing OpenShift container ... OK
...
```

**Download an [example Compose file](https://raw.githubusercontent.com/kubernetes/kompose/main/examples/compose.yaml), or use your own:**

```sh
wget https://raw.githubusercontent.com/kubernetes/kompose/main/examples/compose.yaml
```

**Convert your Compose file to OpenShift:**

Run `kompose convert --provider=openshift` in the same directory as your `compose.yaml` file.

```sh
$ kompose convert --provider=openshift
INFO OpenShift file "frontend-service.yaml" created
INFO OpenShift file "redis-leader-service.yaml" created
INFO OpenShift file "redis-replica-service.yaml" created
INFO OpenShift file "frontend-deploymentconfig.yaml" created
INFO OpenShift file "frontend-imagestream.yaml" created
INFO OpenShift file "redis-leader-deploymentconfig.yaml" created
INFO OpenShift file "redis-leader-imagestream.yaml" created
INFO OpenShift file "redis-replica-deploymentconfig.yaml" created
INFO OpenShift file "redis-replica-imagestream.yaml" created
```

Then you can use `kubectl apply` to create these resources in OpenShift.

**Access the newly deployed service:**

After deployment, you must create an OpenShift route in order to access the service.

If you're using `minishift`, you'll use a combination of `oc` and `minishift` commands to access the service.

Create a route for the `frontend` service using `oc`:

```sh
$ oc expose service/frontend
route "frontend" exposed
```

Access the `frontend` service with `minishift`:

```sh
$ minishift openshift service frontend --namespace=myproject
Opening the service myproject/frontend in the default browser...
```

You can also access the GUI interface of OpenShift for an overview of the deployed containers:

```sh
$ minishift console
Opening the OpenShift Web console in the default browser...
```
