/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2ddl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.tool.hbm2ddl.TableMetadata;

public class DatabaseMetadata {
    private final Map tables = new HashMap();
    private final Set sequences = new HashSet();
    private DatabaseMetaData meta;

    public DatabaseMetadata(Connection connection, Dialect dialect) throws SQLException {
        this.meta = connection.getMetaData();
        this.initSequences(connection, dialect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TableMetadata getTableMetadata(String name) throws HibernateException {
        TableMetadata table = null;
        if (name == null || (table = (TableMetadata)this.tables.get(name.toUpperCase())) != null) return table;
        String[] types = new String[]{"TABLE"};
        ResultSet rs = null;
        try {
            try {
                rs = this.meta.getTables(null, "%", name.toUpperCase(), types);
                while (rs.next()) {
                    if (!name.equalsIgnoreCase(rs.getString("TABLE_NAME"))) continue;
                    table = new TableMetadata(rs, this.meta);
                    this.tables.put(name.toUpperCase(), table);
                    break;
                }
                Object var6_5 = null;
                if (rs == null) return table;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (rs == null) throw throwable;
                rs.close();
                throw throwable;
            }
            rs.close();
            return table;
        }
        catch (SQLException e) {
            throw new HibernateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSequences(Connection connection, Dialect dialect) throws SQLException {
        String sql = dialect.getQuerySequencesString();
        if (sql == null) {
            return;
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                this.sequences.add(rs.getString(1).toUpperCase());
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public boolean isSequence(Object key) {
        return key instanceof String && this.sequences.contains(((String)key).toUpperCase());
    }

    public boolean isTable(Object key) throws HibernateException {
        return key instanceof String && this.getTableMetadata((String)key) != null;
    }
}

