/*
 * Decompiled with CFR 0.152.
 */
package net.eyde.personalblog.struts.action;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.eyde.personalblog.beans.Comment;
import net.eyde.personalblog.beans.Post;
import net.eyde.personalblog.service.Email;
import net.eyde.personalblog.service.PersonalBlogService;
import net.eyde.personalblog.struts.action.BlogGeneralAction;
import net.eyde.personalblog.struts.form.CommentForm;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public final class CommentAction
extends BlogGeneralAction {
    private static Log log = LogFactory.getLog(CommentAction.class);

    public ActionForward executeFinish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionErrors errors = new ActionErrors();
        PersonalBlogService pblog = PersonalBlogService.getInstance();
        Post y = pblog.getPost(request.getParameter("postId"));
        if (y != null) {
            CommentForm newCommentForm = (CommentForm)form;
            Comment newComment = new Comment();
            BeanUtils.copyProperties((Object)newComment, (Object)((Object)newCommentForm));
            newComment.setPost(y);
            newComment.setCreated(new Date());
            y.addComment(newComment);
            pblog.updatePost(y);
            log.debug((Object)("Send email notification:" + y.getEmailComments()));
            if (y.getEmailComments().booleanValue()) {
                String toAddress = pblog.getPropertyManager().getProperty("weblog.email");
                String mailHost = pblog.getPropertyManager().getProperty("mail.smtp.host");
                Email.sendMessage("Reply to post " + y.getTitle(), newComment.getContent(), toAddress, mailHost);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to extract parent post");
            }
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("post.missing"));
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return this.forwardInput(mapping);
        }
        this.removeFormBean(mapping, request);
        return this.forwardSuccess(mapping);
    }

    public ActionForward executeStart(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.getSession();
        ActionErrors errors = new ActionErrors();
        PersonalBlogService pblog = PersonalBlogService.getInstance();
        String postId = request.getParameter("postId");
        request.setAttribute("post", (Object)pblog.getPost(postId));
        request.setAttribute("postId", (Object)postId);
        this.checkEmoticonsLoaded();
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return this.forwardFailure(mapping);
        }
        return this.forwardSuccess(mapping);
    }

    public ActionForward executeRecent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionErrors errors = new ActionErrors();
        this.checkEmoticonsLoaded();
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return this.forwardFailure(mapping);
        }
        return this.forwardSuccess(mapping);
    }
}

